/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import se.sjobeck.datastructures.AmakodFactory;
import se.sjobeck.datastructures.ByggdelFactory;
import se.sjobeck.datastructures.DimStruct;
import se.sjobeck.datastructures.FonsterDim;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.TillaggFactory;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.Byggdel;
import se.sjobeck.datastructures.kalkylering.RadHanterare;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.AliasesListModel;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;

public class EditableRadTable
implements TableModel,
Observer {
    private static final String[] defaultColumns = new String[]{"Id", "Byggdel", "Dimension", "AMA-kod", "Till\u00e4gg", "F\u00e4rg/Tapet", "Kul\u00f6r", "Antal", "\u00e1 pris", "Total", "Tid", "F\u00f6r", "Under", "F\u00e4rdig", "Ackgr", "Tot Ackgr", "Mtrl", "Tot Mtrl"};
    private static final String[] reducedColumns = new String[]{"Id", "Byggdel", "Dimension", "AMA-kod", "Till\u00e4gg", "Produktf\u00f6rkortning", "Kul\u00f6r", "Antalsformel"};
    private static final ExecutorService recalculator = Executors.newSingleThreadExecutor();
    private Future<?> lastTask;
    private static AliasesListModel aliasMap;
    private boolean editable = true;
    private String[] columns;
    private KalkylNod currentNode;
    private List<RadStruct> rader = Collections.emptyList();
    private List<TableModelListener> listeners = new Vector<TableModelListener>();
    private int sortingColumn = -1;
    private boolean reverseSort = false;
    private Comparator<RadStruct> metaSorter = new Comparator<RadStruct>(){

        private int byggdelValue(String s) {
            switch (s.charAt(0)) {
                case 'G': {
                    return -4;
                }
                case 'S': {
                    return -3;
                }
                case 'V': {
                    return -2;
                }
                case 'T': {
                    return -1;
                }
            }
            return s.charAt(0);
        }

        @Override
        public int compare(RadStruct rad1, RadStruct rad2) {
            int byggdel2;
            int byggdel1;
            if (EditableRadTable.this.sortingColumn == -1) {
                return 0;
            }
            int ret = 0;
            ret = EditableRadTable.this.sortingColumn == 0 ? ((byggdel1 = this.byggdelValue(EditableRadTable.this.getStringValueAt(rad1, 1))) * (byggdel2 = this.byggdelValue(EditableRadTable.this.getStringValueAt(rad2, 1))) > 0 ? byggdel1 - byggdel2 : (EditableRadTable.this.reverseSort ? byggdel2 : byggdel1)) : (EditableRadTable.this.sortingColumn == 7 ? Double.compare(rad1.getAntalEnh(), rad2.getAntalEnh()) : (EditableRadTable.this.sortingColumn == 8 ? Double.compare(EditableRadTable.this.getCurrentNode().getProject().getRadHanterare().getPrisPerEnh(rad1), EditableRadTable.this.getCurrentNode().getProject().getRadHanterare().getPrisPerEnh(rad2)) : (EditableRadTable.this.sortingColumn == 9 ? Double.compare(EditableRadTable.this.getCurrentNode().getProject().getRadHanterare().getPrisPerEnh(rad1) * rad1.getAntalEnh(), EditableRadTable.this.getCurrentNode().getProject().getRadHanterare().getPrisPerEnh(rad2) * rad2.getAntalEnh()) : (EditableRadTable.this.sortingColumn == 10 ? Double.compare(EditableRadTable.this.getCurrentNode().getProject().getRadHanterare().getTidPerEnh(rad1) * rad1.getAntalEnh(), EditableRadTable.this.getCurrentNode().getProject().getRadHanterare().getTidPerEnh(rad2) * rad2.getAntalEnh()) : EditableRadTable.this.getStringValueAt(rad1, EditableRadTable.this.sortingColumn).compareTo(EditableRadTable.this.getStringValueAt(rad2, EditableRadTable.this.sortingColumn))))));
            if (EditableRadTable.this.reverseSort) {
                ret *= -1;
            }
            return ret;
        }
    };

    public EditableRadTable(KalkylNod initialNode) {
        this(true, initialNode);
    }

    public EditableRadTable(boolean reduced, KalkylNod initialNode) {
        this.columns = reduced ? reducedColumns : defaultColumns;
        this.currentNode = initialNode;
    }

    public boolean isReduced() {
        return this.columns.equals(reducedColumns);
    }

    @Override
    public void update(Observable o, Object arg) {
        KalkylNod nod = (KalkylNod)arg;
        if (nod.equals(this.getCurrentNode())) {
            this.rader = this.getCurrentNode().getRader();
            this.performSort();
            this.tableChanged(new TableModelEvent(this, 0, this.rader.size(), -1));
        }
    }

    public boolean isSumRow(int rowIndex) {
        return rowIndex == this.rader.size();
    }

    public static void setAliasMap(AliasesListModel newMapping) {
        aliasMap = newMapping;
    }

    public void setCurrentNode(KalkylNod node) {
        this.currentNode = node;
        this.updateCurrentNode();
    }

    public KalkylNod getCurrentNode() {
        return this.currentNode;
    }

    private void updateCurrentNode() {
        this.rader = this.getCurrentNode().getRader();
        this.performSort();
        this.tableChanged(new TableModelEvent(this));
    }

    public boolean hasErrors(int row, int column) {
        try {
            RadStruct rad = this.rader.get(row);
            return EditableRadTable.hasErrors(rad, column, this.getCurrentNode());
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static boolean hasErrors(RadStruct rad, int column, KalkylNod nod) {
        if (rad == null || nod == null) {
            Logger.getLogger("se.sjobeck.datastructures.EditableRadTable").warning("NULL-pekare i hasErrors(), det h\ufffdr borde inte kunna h\ufffdnda!");
            return true;
        }
        switch (column) {
            case 0: 
            case 1: {
                return ByggdelFactory.hasError(rad);
            }
            case 2: {
                DimStruct d = rad.getDim();
                if (d instanceof FonsterDim) {
                    return ((FonsterDim)d).isInomhus() ^ rad.getInomhus();
                }
                return false;
            }
            case 3: {
                if (rad.getBehKod() != null) {
                    Projekt p = nod.getProject();
                    if (p != null) {
                        return p.invalidCustomAma(rad.getBehKod());
                    }
                    return true;
                }
                return rad.getF\u00f6rbehandlingID() == null || rad.getUnderbehandlingID() == null || rad.getF\u00e4rdigbehandlingID() == null;
            }
            case 4: {
                for (TlgStruct t : rad.getTillagg()) {
                    if (TillaggFactory.isValid(t, rad, nod.getProject())) continue;
                    return true;
                }
                return false;
            }
            case 7: {
                double antal;
                if (nod instanceof RumNod) {
                    antal = Function.getValue((String)rad.getAntalFormel(), (List[])new List[]{((RumNod)nod).getVariabler(), nod.getProject().getKonstanter()});
                    if (Double.isNaN(antal)) {
                        return true;
                    }
                } else {
                    antal = rad.getAntalEnh();
                }
                return antal <= 0.0;
            }
            case 8: {
                return nod.getProject().getRadHanterare().getPrisPerEnh(rad) <= 0.0;
            }
            case 9: {
                return nod.getProject().getRadHanterare().getPrisPerEnh(rad) * rad.getAntalEnh() <= 0.0;
            }
            case 10: {
                return nod.getProject().getRadHanterare().getTidPerEnh(rad) * rad.getAntalEnh() <= 0.0;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
        }
        return false;
    }

    public boolean understrike(int row, int column) {
        switch (column) {
            case 3: {
                String kod = this.rader.get(row).getBehKod();
                Projekt p = this.getCurrentNode().getProject();
                if (p != null) {
                    return kod != null && (p.getCustomAckpris(kod) > 0.0 || p.getCustomMatpris(kod) > 0.0);
                }
                return true;
            }
            case 10: {
                return this.getCurrentNode().getProject().getEgenTid(this.rader.get(row)) > 0.0;
            }
        }
        return false;
    }

    public boolean isRootNode() {
        return this.getCurrentNode().equals(this.getCurrentNode().getProject().getRader());
    }

    public boolean isLeafNode() {
        return this.getCurrentNode().isLeaf();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    public Class getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.isReduced()) {
            return this.rader.size();
        }
        return this.rader.size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0) {
            return null;
        }
        if (rowIndex >= this.rader.size()) {
            switch (columnIndex) {
                case 8: {
                    return "Totalt:";
                }
                case 9: {
                    if (this.lastTask != null && !this.lastTask.isDone()) {
                        return "R\u00e4knar om...";
                    }
                    return StaticHelpers.format2Dec((double)this.totalKostnad());
                }
                case 10: {
                    if (this.lastTask != null && !this.lastTask.isDone()) {
                        return "";
                    }
                    return StaticHelpers.tidFormat((double)this.totalTid());
                }
                case 15: {
                    return StaticHelpers.format2Dec((double)this.totalAckgr());
                }
                case 17: {
                    return StaticHelpers.format2Dec((double)this.TotMtrl());
                }
            }
            return null;
        }
        if (columnIndex >= 11 && columnIndex <= 17) {
            return this.getStringValueAt(rowIndex, columnIndex);
        }
        return this.rader.get(rowIndex);
    }

    public String getStringValueAt(int row, int column) {
        if (row < 0 || row >= this.rader.size()) {
            return "";
        }
        return this.getStringValueAt(this.rader.get(row), column);
    }

    public String getEnhet(RadStruct struct) {
        return this.getCurrentNode().getEnhet(struct);
    }

    public String getStringValueAt(RadStruct struct, int column) {
        try {
            switch (column) {
                case 0: {
                    if (struct.getByggdel() != null) {
                        return struct.getByggdel().getId();
                    }
                    return "#";
                }
                case 1: {
                    return struct.getDescription();
                }
                case 2: {
                    return struct.getDim().toString();
                }
                case 3: {
                    return RadHanterare.getAmaKod((RadStruct)struct);
                }
                case 4: {
                    return EditableRadTable.formatTlgList(struct.getTillagg());
                }
                case 5: {
                    if (this.isReduced()) {
                        return struct.getProduktKod();
                    }
                    return this.getCurrentNode().getProject().getRadHanterare().getProduktNamn(struct);
                }
                case 6: {
                    if (struct.getKulor() == null) {
                        return "";
                    }
                    return struct.getKulor();
                }
                case 7: {
                    if (this.isReduced()) {
                        return struct.getAntalFormel();
                    }
                    double antal = this.getCurrentNode() instanceof RumNod ? Function.getValue((String)struct.getAntalFormel(), (List[])new List[]{((RumNod)this.getCurrentNode()).getVariabler(), this.getCurrentNode().getProject().getKonstanter()}) : struct.getAntalEnh();
                    return StaticHelpers.format2Dec((double)antal) + " " + this.getEnhet(struct);
                }
                case 8: {
                    return StaticHelpers.format2Dec((double)this.getCurrentNode().getProject().getRadHanterare().getPrisPerEnh(struct));
                }
                case 9: {
                    return StaticHelpers.format2Dec((double)(this.getCurrentNode().getProject().getRadHanterare().getPrisPerEnh(struct) * struct.getAntalEnh()));
                }
                case 10: {
                    return StaticHelpers.tidFormat((double)(this.getCurrentNode().getProject().getRadHanterare().getTidPerEnh(struct) * struct.getAntalEnh()));
                }
                case 11: {
                    Behandling behandling = this.getCurrentNode().getProject().getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, struct);
                    return StaticHelpers.format2Dec((double)behandling.getAckpris());
                }
                case 12: {
                    Behandling behandling = this.getCurrentNode().getProject().getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, struct);
                    return StaticHelpers.format2Dec((double)behandling.getAckpris());
                }
                case 13: {
                    Behandling behandling = this.getCurrentNode().getProject().getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, struct);
                    return StaticHelpers.format2Dec((double)behandling.getAckpris());
                }
                case 14: {
                    return StaticHelpers.format2Dec((double)this.currentNode.getProject().getAckgrundl\u00f6nInklTill\u00e4gg(struct));
                }
                case 15: {
                    return StaticHelpers.format2Dec((double)(this.currentNode.getProject().getAckgrundl\u00f6nInklTill\u00e4gg(struct) * struct.getAntalEnh()));
                }
                case 16: {
                    return StaticHelpers.format2Dec((double)this.currentNode.getProject().getRadHanterare().getMaterialPerEnh(struct));
                }
                case 17: {
                    return StaticHelpers.format2Dec((double)(this.currentNode.getProject().getRadHanterare().getMaterialPerEnh(struct) * struct.getAntalEnh()));
                }
            }
            return "Error!";
        }
        catch (NullPointerException e) {
            return "<Fel>";
        }
    }

    public String getToolTipText(int row, int column) {
        if (row < 0 || row >= this.rader.size()) {
            return "";
        }
        return this.getToolTipText(this.rader.get(row), column);
    }

    public String getToolTipText(RadStruct rad, int column) {
        switch (column) {
            case 0: 
            case 1: {
                return "<html>Byggdel:<br>" + rad.getByggdel().getId() + " - " + rad.getDescription() + "</html>";
            }
            case 2: {
                return rad.getDim().getText();
            }
            case 3: {
                return "Ama-kod";
            }
            case 4: {
                return "Valda till\u00e4gg";
            }
            case 5: {
                return "Ytprodukt";
            }
            case 6: {
                return "Ytproduktens kul\u00f6r";
            }
            case 7: {
                return "Antal " + this.getEnhet(rad);
            }
            case 8: 
            case 9: {
                String ret = "<html>Pris per " + this.getEnhet(rad) + ":<br>";
                ret = ret + "Arbetskostnad " + StaticHelpers.format2Dec((double)this.currentNode.getProject().getRadHanterare().getArbetskostnadPerEnh(rad)) + "<br>";
                ret = ret + "Materialkostnad " + StaticHelpers.format2Dec((double)this.currentNode.getProject().getRadHanterare().getMaterialPerEnh(rad)) + "<br>";
                ret = ret + "Fasta kostnader " + StaticHelpers.format2Dec((double)this.currentNode.getProject().getRadHanterare().getFastaKostnaderPerEnh(rad)) + "<br>";
                ret = ret + "Vinst " + StaticHelpers.format2Dec((double)this.currentNode.getProject().getRadHanterare().getVinstPerEnh(rad)) + "<br>";
                Map materialLista = this.currentNode.getProject().getRadHanterare().getMaterialLista(rad);
                ret = ret + materialLista.size() + " material registrerade: <br>";
                for (Map.Entry e : materialLista.entrySet()) {
                    double dimMod = 1.0;
                    if (rad.getDim() != null) {
                        dimMod = rad.getDim().getMtrlMod();
                    }
                    ret = ret + StaticHelpers.format2Dec((double)((Double)e.getValue() * dimMod));
                    ret = ret + " ";
                    ret = ret + this.currentNode.getProject().getDatabaseInstance().getProduktEnhet(this.currentNode.getProject().getFabrikat(), (String)e.getKey());
                    ret = ret + " ";
                    ret = ret + this.currentNode.getProject().getDatabaseInstance().getProduktNamn(this.currentNode.getProject().getFabrikat(), (String)e.getKey()) + "<br>";
                }
                return ret + "</html>";
            }
            case 10: {
                return "Totalt tids\u00e5tg\u00e5ng";
            }
            case 11: {
                return "Ackordsgrundl\u00f6n f\u00f6rbehandling";
            }
            case 12: {
                return "Ackordsgrundl\u00f6n underbehandling";
            }
            case 13: {
                return "Ackordsgrundl\u00f6n f\u00e4rdigbehandling";
            }
            case 14: {
                return "Ackordsgrundl\u00f6n sammanr\u00e4knad med till\u00e4gg";
            }
            case 15: {
                return "Total Ackordsgrundl\u00f6n * antal ";
            }
            case 16: {
                return "Materialpris per enhet";
            }
            case 17: {
                return "Materialpris * antal";
            }
        }
        return null;
    }

    public static String formatTlgList(TlgStruct[] list) {
        String ret = "";
        for (int i = 0; i < list.length; ++i) {
            ret = ret + list[i].getAckpunkt() + (i < list.length - 1 ? ", " : "");
        }
        return ret;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isEditable()) {
            return false;
        }
        if (rowIndex > this.rader.size() || rowIndex < 0) {
            return false;
        }
        if (this.isLeafNode()) {
            return columnIndex == 0 || rowIndex != this.rader.size() && columnIndex < this.columns.length - 10;
        }
        if (this.isRootNode()) {
            return rowIndex != this.rader.size() && (columnIndex < this.columns.length - 11 || columnIndex == this.columns.length - 8);
        }
        return rowIndex != this.rader.size() && columnIndex < this.columns.length - 11;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
        this.lastTask = recalculator.submit(new Runnable(){

            @Override
            public void run() {
                Logger.getLogger("se.sjobeck").entering("EditableRadTable", "setValueAt", new Object[]{aValue, rowIndex, columnIndex});
                if (rowIndex < 0 || rowIndex > EditableRadTable.this.rader.size()) {
                    throw new IllegalArgumentException("Invalid row " + rowIndex + "!");
                }
                TableModelEvent event = null;
                if (columnIndex == 0) {
                    event = EditableRadTable.insertAlias(rowIndex, (String)aValue, EditableRadTable.this.currentNode, EditableRadTable.this);
                }
                if (event == null) {
                    RadStruct struct;
                    event = new TableModelEvent(EditableRadTable.this, rowIndex, rowIndex, -1, 0);
                    if (rowIndex == EditableRadTable.this.rader.size()) {
                        try {
                            struct = (RadStruct)EditableRadTable.this.getCurrentNode().getProject().getDefaultRow().clone();
                        }
                        catch (CloneNotSupportedException e) {
                            struct = new RadStruct();
                            RadHanterare.setDefaults((RadStruct)struct);
                        }
                        EditableRadTable.this.rader.add(struct);
                        event = new TableModelEvent(EditableRadTable.this, rowIndex, rowIndex, -1, 1);
                    } else {
                        struct = (RadStruct)EditableRadTable.this.rader.get(rowIndex);
                    }
                    if (EditableRadTable.this.isLeafNode()) {
                        EditableRadTable.this.internalSetValueAt(aValue, struct, columnIndex, EditableRadTable.this.getCurrentNode());
                    } else if (columnIndex == 10) {
                        if ("".equals(aValue)) {
                            EditableRadTable.this.getCurrentNode().getProject().removeEgenTid(struct);
                        } else {
                            EditableRadTable.this.getCurrentNode().getProject().putEgenTid(struct, Function.getValue((String)(aValue.toString() + "/" + struct.getAntalEnh())));
                        }
                        EditableRadTable.this.getCurrentNode().getProject().getRadHanterare().forceRecalculate(struct);
                    } else {
                        EditableRadTable.this.recursiveSetValueAt(EditableRadTable.this.getCurrentNode(), aValue, struct, columnIndex);
                        EditableRadTable.this.rader = EditableRadTable.this.getCurrentNode().getRader();
                    }
                }
                EditableRadTable.this.sortByColumn(-1);
                EditableRadTable.this.getCurrentNode().update();
                EditableRadTable.this.tableChanged(event);
                EditableRadTable.this.tableChanged(new TableModelEvent(EditableRadTable.this, EditableRadTable.this.rader.size(), EditableRadTable.this.rader.size(), -1, 0));
                Logger.getLogger("se.sjobeck").exiting("EditableRadTable", "setValueAt");
            }
        });
    }

    private static TableModelEvent insertAlias(int rowIndex, String aliasStr, KalkylNod node, EditableRadTable source) {
        if (node instanceof GrenNod) {
            return null;
        }
        if (node instanceof RumNod) {
            RadStruct[] rs = aliasMap.getRows(aliasStr.toUpperCase());
            if (rs != null) {
                List<RadStruct> rader = node.getRader();
                if (rowIndex < rader.size()) {
                    rader.remove(rowIndex);
                }
                ArrayList<RadStruct> newRows = new ArrayList<RadStruct>(rs.length);
                for (RadStruct r : rs) {
                    RadStruct re = r.copy();
                    re.setAntalEnh(Function.getValue((String)re.getAntalFormel(), (List[])new List[]{((RumNod)node).getVariabler(), node.getProject().getKonstanter()}));
                    newRows.add(re);
                }
                rader.addAll(rowIndex, newRows);
                return new TableModelEvent(source, rowIndex, rowIndex + rs.length, -1, 1);
            }
            return null;
        }
        return null;
    }

    private void recursiveSetValueAt(KalkylNod nod, Object value, RadStruct struct, int column) {
        block3: {
            block2: {
                Logger.getLogger("se.sjobeck.datastructures").entering("EditableRadTable", "recursiveSetValueAt", nod);
                if (!(nod instanceof RumNod)) break block2;
                for (RadStruct r : ((RumNod)nod).getRader()) {
                    if (!r.equals((Object)struct)) continue;
                    this.internalSetValueAt(value, r, column, nod);
                    ((RumNod)nod).invalidate();
                }
                break block3;
            }
            if (!(nod instanceof GrenNod)) break block3;
            for (int i = 0; i < nod.getChildCount(); ++i) {
                this.recursiveSetValueAt((KalkylNod)nod.getChildAt(i), value, struct, column);
            }
        }
    }

    private void internalSetValueAt(Object aValue, RadStruct struct, int columnIndex, KalkylNod currentNode) {
        Logger.getLogger("se.sjobeck").entering("EditableRadTable", "internalSetValueAt2", new Object[]{aValue, struct, columnIndex, currentNode});
        switch (columnIndex) {
            case -1: {
                if (!(aValue instanceof DimStruct)) break;
                struct.setDim((DimStruct)aValue);
                break;
            }
            case 0: {
                Byggdel newByggdel = ByggdelFactory.parseByggdelID((String)aValue);
                if (newByggdel == null) {
                    struct.setByggdel(null);
                    struct.setDescription("Fel EditableRadTable.class");
                    break;
                }
                if (newByggdel == struct.getByggdel()) break;
                struct.setByggdel(newByggdel);
                struct.setDescription(newByggdel.getDefaultBeskrivning());
                String var = newByggdel.getDefaultVariabel();
                if (var != null) {
                    struct.setAntalFormel(var);
                    struct.setAntalEnh(Function.getValue((String)struct.getAntalFormel(), (List[])new List[]{((RumNod)currentNode).getVariabler(), this.getCurrentNode().getProject().getKonstanter()}));
                }
                this.updateTapet(struct);
                break;
            }
            case 1: {
                struct.setDescription((String)aValue);
                break;
            }
            case 2: {
                if (aValue == null) break;
                struct.setDim((DimStruct)aValue);
                break;
            }
            case 3: {
                String amakod = (String)aValue;
                amakod = amakod.replaceAll("\\s", "");
                amakod = amakod.replaceAll("-", "");
                try {
                    struct.setUnderlagID(AmakodFactory.parseUnderlagID(amakod, struct, this.getCurrentNode().getProject()));
                    struct.setYtmaterialID(AmakodFactory.parseMaterialID(amakod, struct, this.getCurrentNode().getProject()));
                    struct.setF\u00f6rbehandlingID(AmakodFactory.parseF\u00f6rbehandlingID(amakod, struct, this.getCurrentNode().getProject()));
                    struct.setUnderbehandlingID(AmakodFactory.parseUnderbehandlingID(amakod, struct, this.getCurrentNode().getProject()));
                    struct.setF\u00e4rdigbehandlingID(AmakodFactory.parseF\u00e4rdigbehandlingID(amakod, struct, this.getCurrentNode().getProject()));
                    struct.setBehKod(null);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    struct.setBehKod(((String)aValue).trim());
                }
                this.updateTapet(struct);
                break;
            }
            case 4: {
                struct.setTillagg(TillaggFactory.parseTillagg((String)aValue, struct, currentNode.getProject()));
                break;
            }
            case 5: {
                struct.setProduktKod((String)aValue);
                break;
            }
            case 6: {
                struct.setKulor((String)aValue);
                if (!"".equals(struct.getKulor())) break;
                struct.setKulor(null);
                break;
            }
            case 7: {
                if (currentNode instanceof RumNod) {
                    struct.setAntalFormel((String)aValue);
                    struct.setAntalEnh(Function.getValue((String)struct.getAntalFormel(), (List[])new List[]{((RumNod)currentNode).getVariabler(), this.getCurrentNode().getProject().getKonstanter()}));
                    break;
                }
                throw new IllegalArgumentException("Should only be able to change rows on a leaf node!");
            }
            default: {
                throw new IllegalArgumentException("Column " + columnIndex + " should not be editable!");
            }
        }
        this.getCurrentNode().getProject().getRadHanterare().forceRecalculate(struct);
    }

    private void updateTapet(RadStruct struct) {
        Logger.getLogger("se.sjobeck").finer("struct.produktKod = '" + struct.getProduktKod() + "'");
        if (struct.getBehKod() != null) {
            struct.setProduktKod(null);
        } else if (struct.getProduktKod() != null && !this.getCurrentNode().getProject().getDatabaseInstance().validYtprodukt(struct, this.getCurrentNode().getProject().getFabrikat())) {
            struct.setProduktKod(null);
        }
    }

    public RadStruct getRad(int i) {
        return this.rader.get(i);
    }

    public void deleteRow(int row) {
        this.rader.remove(row);
        this.tableChanged(new TableModelEvent(this, row, row, -1, -1));
        this.getCurrentNode().update();
        this.sortByColumn(-1);
    }

    public void addRowAt(RadStruct struct, int index) {
        if (index > this.rader.size()) {
            index = this.rader.size();
        }
        try {
            RadStruct newStruct = (RadStruct)struct.clone();
            newStruct.setAntalEnh(Function.getValue((String)newStruct.getAntalFormel(), (List[])new List[]{((RumNod)this.getCurrentNode()).getVariabler(), this.getCurrentNode().getProject().getKonstanter()}));
            this.rader.add(index, newStruct);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.sortByColumn(-1);
        this.tableChanged(new TableModelEvent(this, index, index, -1, 1));
        this.getCurrentNode().update();
    }

    public void addRow(RadStruct struct) {
        this.addRowAt(struct, this.rader.size());
    }

    public void appendRows(RadStruct[] newRows) {
        if (newRows.length != 0) {
            TableModelEvent event = new TableModelEvent(this, this.rader.size(), this.rader.size() + newRows.length, -1, 1);
            for (RadStruct newRow : newRows) {
                this.rader.add(newRow);
            }
            this.tableChanged(event);
        }
    }

    public void tableChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    public double totalTid() {
        double ret = 0.0;
        for (RadStruct struct : this.rader) {
            ret += this.getCurrentNode().getProject().getRadHanterare().getTidPerEnh(struct) * struct.getAntalEnh();
        }
        return ret;
    }

    public double totalKostnad() {
        double ret = 0.0;
        for (RadStruct struct : this.rader) {
            ret += this.getCurrentNode().getProject().getRadHanterare().getPrisPerEnh(struct) * struct.getAntalEnh();
        }
        return ret;
    }

    public void reorder(int from, int to) {
        if (from >= 0 && from < this.rader.size() && to >= 0 && to < this.rader.size()) {
            RadStruct bs = this.rader.get(from);
            this.rader.remove(from);
            this.rader.add(to, bs);
            if (from > to) {
                this.tableChanged(new TableModelEvent(this, to, from));
            } else {
                this.tableChanged(new TableModelEvent(this, from, to));
            }
            this.sortByColumn(-1);
        }
    }

    public void sortByColumn(int column) {
        if (this.sortingColumn == column) {
            this.reverseSort = !this.reverseSort;
        }
        this.sortingColumn = column;
        if (this.performSort()) {
            this.tableChanged(new TableModelEvent(this));
        }
    }

    private boolean performSort() {
        if (this.rader == null || this.sortingColumn == -1) {
            return false;
        }
        Collections.sort(this.rader, this.metaSorter);
        return true;
    }

    public int getSortingColumn() {
        return this.sortingColumn;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    private double totalAckgr() {
        double ret = 0.0;
        for (RadStruct struct : this.rader) {
            if (struct == null) continue;
            ret += this.currentNode.getProject().getAckgrundl\u00f6nInklTill\u00e4gg(struct) * struct.getAntalEnh();
        }
        return ret;
    }

    private double TotMtrl() {
        double ret = 0.0;
        for (RadStruct struct : this.rader) {
            if (struct == null) continue;
            ret += this.currentNode.getProject().getRadHanterare().getMaterialPerEnh(struct) * struct.getAntalEnh();
        }
        return ret;
    }
}

