/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.util.List;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.Underlag;
import se.sjobeck.datastructures.kalkylering.Ytmaterial;

public class AmakodFactory {
    public static String parseUnderlagID(String amakod, RadStruct struct, Projekt proj) {
        String ret = null;
        for (Underlag u : proj.getDatabaseInstance().getUnderlag(struct)) {
            if (!amakod.startsWith(u.getId())) continue;
            ret = u.getId();
        }
        if (ret == null) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    public static String parseMaterialID(String amakod, RadStruct struct, Projekt proj) {
        int offset = struct.getUnderlagID().length();
        String ret = null;
        for (Ytmaterial material : proj.getDatabaseInstance().getYtmaterial(struct)) {
            if (!amakod.startsWith(material.getId(), offset)) continue;
            ret = material.getId();
        }
        if (ret == null) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    public static String parseF\u00f6rbehandlingID(String amakod, RadStruct struct, Projekt proj) {
        int offset = struct.getUnderlagID().length() + struct.getYtmaterialID().length();
        return AmakodFactory.parseBehandlingID(amakod, offset, BehandlingsTyp.F\u00f6rbehandling, struct, proj);
    }

    public static String parseUnderbehandlingID(String amakod, RadStruct struct, Projekt proj) {
        int offset = struct.getUnderlagID().length() + struct.getYtmaterialID().length() + struct.getF\u00f6rbehandlingID().length();
        return AmakodFactory.parseBehandlingID(amakod, offset, BehandlingsTyp.Underbehandling, struct, proj);
    }

    public static String parseF\u00e4rdigbehandlingID(String amakod, RadStruct struct, Projekt proj) {
        int offset = struct.getUnderlagID().length() + struct.getYtmaterialID().length() + struct.getF\u00f6rbehandlingID().length() + struct.getUnderbehandlingID().length();
        return AmakodFactory.parseBehandlingID(amakod, offset, BehandlingsTyp.F\u00e4rdigbehandling, struct, proj);
    }

    private static String parseBehandlingID(String amakod, int offset, BehandlingsTyp bt, RadStruct struct, Projekt proj) {
        if (amakod.startsWith("##", offset)) {
            return null;
        }
        List list = proj.getDatabaseInstance().getBehandlingar(bt, struct);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!amakod.startsWith(((Behandling)list.get(i)).getId(), offset)) continue;
            return ((Behandling)list.get(i)).getId();
        }
        throw new IllegalArgumentException();
    }
}

