
#include <windows.h>
#include <stdio.h>
#include <jni.h>
#include "se_sjobeck_comm_usb_TestUSB.h"
#include "hid.h"

/*
 * Class:     se_sjobeck_comm_usb_TestUSB
 * Method:    init
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_se_sjobeck_comm_usb_TestUSB_init
  (JNIEnv *env, jobject obj) {

  printf("init()\n");

}

/*
 * Class:     se_sjobeck_comm_usb_TestUSB
 * Method:    getNumberOfDevices
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_se_sjobeck_comm_usb_TestUSB_getNumberOfDevices
  (JNIEnv *env, jobject obj) {
	/* PHID_DEVICE devices;
	   ULONG numberOfDevices;
	   ULONG i;
	   HID_DEVICE readDevice;
         */
	HANDLE dllHandle;

	/* if ( FindKnownHidDevices(&devices, &numberOfDevices) ) {
		printf("Number of devices found: %d\n", numberOfDevices);

        	for ( i = 0; i < numberOfDevices; i++ ) {
                	printf("Device %d:\n", i);
                	printf("  Vendor id: 0x%x\n", devices[i].Attributes.VendorID);
                	printf("  Product id: 0x%x\n", devices[i].Attributes.ProductID);
                	printf("  Version: 0x%x\n", devices[i].Attributes.VersionNumber);
        	}
	} */

	dllHandle = LoadLibrary("HID.DLL");

	numberOfDevices = (int) GetProcAddress(dllHandle, "HidD_GetInputReport");

	FreeLibrary(dllHandle);
	return numberOfDevices;
}

/*
 * Class:     se_sjobeck_comm_usb_TestUSB
 * Method:    getVendorID
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_se_sjobeck_comm_usb_TestUSB_getVendorID
  (JNIEnv *env, jobject obj, jint i) {
    jbyteArray jb;

    jbyte bytes[] = {0x10, 0x20};

    jb=(*env)->NewByteArray(env, 2);
    (*env)->SetByteArrayRegion(env, jb, 0, 
	2, (jbyte *) bytes );

    return (jb);
}

/*
 * Class:     se_sjobeck_comm_usb_TestUSB
 * Method:    getProductID
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_se_sjobeck_comm_usb_TestUSB_getProductID
  (JNIEnv *env, jobject obj, jint i) {
    jbyteArray jb;

    jbyte bytes[] = {0x30, 0x40};

    jb=(*env)->NewByteArray(env, 2);
    (*env)->SetByteArrayRegion(env, jb, 0, 
	2, (jbyte *) bytes );

    return (jb);
}

/*
 * Class:     se_sjobeck_comm_usb_TestUSB
 * Method:    getProductVersion
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_se_sjobeck_comm_usb_TestUSB_getProductVersion
  (JNIEnv *env, jobject obj, jint i) {
      jbyteArray jb;

    jbyte bytes[] = {0x50, 0x60};

    jb=(*env)->NewByteArray(env, 2);
    (*env)->SetByteArrayRegion(env, jb, 0, 
	2, (jbyte *) bytes );

    return (jb);

}

