/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocListener;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfATtfUnicodeWriter;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.PdfXConformanceException;
import com.itextpdf.text.pdf.TtfUnicodeWriter;
import com.itextpdf.text.pdf.interfaces.PdfAConformance;
import com.itextpdf.text.pdf.interfaces.PdfIsoConformance;
import com.itextpdf.text.pdf.internal.PdfAConformanceImp;
import com.itextpdf.text.xml.xmp.PdfAXmpWriter;
import com.itextpdf.text.xml.xmp.XmpWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PdfAWriter
extends PdfWriter {
    public static PdfAWriter getInstance(Document document, OutputStream os, PdfAConformanceLevel conformanceLevel) throws DocumentException {
        PdfDocument pdf = new PdfDocument();
        document.addDocListener((DocListener)pdf);
        PdfAWriter writer = new PdfAWriter(pdf, os, conformanceLevel);
        pdf.addWriter((PdfWriter)writer);
        return writer;
    }

    public static PdfAWriter getInstance(Document document, OutputStream os, DocListener listener, PdfAConformanceLevel conformanceLevel) throws DocumentException {
        PdfDocument pdf = new PdfDocument();
        pdf.addDocListener(listener);
        document.addDocListener((DocListener)pdf);
        PdfAWriter writer = new PdfAWriter(pdf, os, conformanceLevel);
        pdf.addWriter((PdfWriter)writer);
        return writer;
    }

    public static void setPdfVersion(PdfWriter writer, PdfAConformanceLevel conformanceLevel) {
        switch (conformanceLevel) {
            case PDF_A_1A: 
            case PDF_A_1B: {
                writer.setPdfVersion('4');
                break;
            }
            case PDF_A_2A: 
            case PDF_A_2B: 
            case PDF_A_2U: {
                writer.setPdfVersion('7');
                break;
            }
            case PDF_A_3A: 
            case PDF_A_3B: 
            case PDF_A_3U: {
                writer.setPdfVersion('7');
                break;
            }
            default: {
                writer.setPdfVersion('4');
            }
        }
    }

    public void setOutputIntents(String outputConditionIdentifier, String outputCondition, String registryName, String info, ICC_Profile colorProfile) throws IOException {
        PdfDictionary d;
        super.setOutputIntents(outputConditionIdentifier, outputCondition, registryName, info, colorProfile);
        PdfArray a = this.extraCatalog.getAsArray(PdfName.OUTPUTINTENTS);
        if (a != null && (d = a.getAsDict(0)) != null) {
            d.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
        }
    }

    public void setPDFXConformance(int pdfx) {
        throw new PdfXConformanceException(MessageLocalization.getComposedMessage((String)"pdfx.conformance.cannot.be.set.for.PdfAWriter.instance", (Object[])new Object[0]));
    }

    public boolean isPdfIso() {
        return this.pdfIsoConformance.isPdfIso();
    }

    protected PdfAWriter(PdfAConformanceLevel conformanceLevel) {
        ((PdfAConformance)this.pdfIsoConformance).setConformanceLevel(conformanceLevel);
        PdfAWriter.setPdfVersion(this, conformanceLevel);
    }

    protected PdfAWriter(PdfDocument document, OutputStream os, PdfAConformanceLevel conformanceLevel) {
        super(document, os);
        ((PdfAConformance)this.pdfIsoConformance).setConformanceLevel(conformanceLevel);
        PdfAWriter.setPdfVersion(this, conformanceLevel);
    }

    protected TtfUnicodeWriter getTtfUnicodeWriter() {
        if (this.ttfUnicodeWriter == null) {
            this.ttfUnicodeWriter = new PdfATtfUnicodeWriter(this);
        }
        return this.ttfUnicodeWriter;
    }

    protected XmpWriter getXmpWriter(ByteArrayOutputStream baos, PdfDocument.PdfInfo info) throws IOException {
        if (this.xmpWriter == null) {
            this.xmpWriter = new PdfAXmpWriter((OutputStream)baos, (PdfDictionary)info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel());
        }
        return this.xmpWriter;
    }

    protected void checkPdfIsoConformance(int key, Object obj1) {
        PdfAConformanceImp.checkPdfAConformance(this, key, obj1);
    }

    protected PdfIsoConformance getPdfIsoConformance() {
        return new PdfAConformanceImp();
    }
}

