/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.datastructures.ByggdelFactory;
import se.sjobeck.datastructures.ConstantsNode;
import se.sjobeck.datastructures.CustomAMANod;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.EditableRadTable;
import se.sjobeck.datastructures.FabrikatNod;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.KommentarNod;
import se.sjobeck.datastructures.Point2DDrawingWithHoleDrawing;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.RemarkFactory;
import se.sjobeck.datastructures.RemarksNod;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.TimprisNod;
import se.sjobeck.datastructures.XLNod;
import se.sjobeck.datastructures.drawings.FromGeometraDrawing;
import se.sjobeck.datastructures.kalkylering.ProjektInfo;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.eKalkyl;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.export.StructuredExport;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.gui.AliasesListModel;
import se.sjobeck.gui.AliasesPanel;
import se.sjobeck.gui.CommentPane;
import se.sjobeck.gui.ConstantsPanel;
import se.sjobeck.gui.CustomAMA;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.gui.EgenKontrollInput;
import se.sjobeck.gui.FilePanel;
import se.sjobeck.gui.FileTreeCellRenderer;
import se.sjobeck.gui.FileTreeTransferHandler;
import se.sjobeck.gui.FilterJtree;
import se.sjobeck.gui.GrenPanel;
import se.sjobeck.gui.JLabelHandler;
import se.sjobeck.gui.ListSelectListener;
import se.sjobeck.gui.NodeTreeTransferHandler;
import se.sjobeck.gui.OrderedMouseListener;
import se.sjobeck.gui.PopupMouseListener;
import se.sjobeck.gui.PrintDialog;
import se.sjobeck.gui.ProjectTreeCellRenderer;
import se.sjobeck.gui.Projektforutsattningar;
import se.sjobeck.gui.RemarksTable;
import se.sjobeck.gui.RumPanel;
import se.sjobeck.gui.SelectingEditor;
import se.sjobeck.gui.SettingsDialog;
import se.sjobeck.gui.TimprisKalkyl;
import se.sjobeck.gui.TreeSelectListener;
import se.sjobeck.gui.XLPanel;
import se.sjobeck.gui.dndtree.DNDTree;
import se.sjobeck.gui.file_network_tracking.ShowingProgress;
import se.sjobeck.gui.file_network_tracking.ShowingProgressFactory;
import se.sjobeck.gui.outlookbar.JOutlookBarTabbed;
import se.sjobeck.gui.outlookbar.TreeSplitEditor;
import se.sjobeck.images.IconFactory;
import se.sjobeck.images.IconLoader;
import se.sjobeck.network.VirtualFile;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;
import se.sjobeck.network2.NetWorkCommunicator;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.util.pdf.EgenKontroll;
import se.sjobeck.util.pdf.EgenKontroll_Avancerad;
import se.sjobeck.util.pdf.OutputGenerator;
import se.sjobeck.util.pdf.PDFRenderer;
import se.sjobeck.util.pdf.file_network_tracking.EkalkylPDFConfiguration;

public class KalkylGUI
extends JFrame
implements ExportListener {
    public static final String DESCRIPTIONS_FILE = ".descriptions";
    public static final String CREATED_FILE = ".created";
    public static final String ALIAS_FILE = ".aliases";
    public static final String SUMMARIES_FILE = ".summaries";
    public static KalkylGUI kalkylgui = null;
    private Map<Projekt, UndoManager> undoMapping = new WeakHashMap<Projekt, UndoManager>();
    private JFrame geometraFrame = null;
    private XStream xstream;
    private KalkylNod clipboardOb;
    private HashMap<String, String> fileDescriptions;
    private HashMap<String, Date> fileCreated;
    private HashMap<String, RadStruct[]> aliasMap;
    private HashMap<String, ProjektInfo> fileSummaries;
    private AliasesListModel aliasList;
    private ProjectManager projectManager;
    private TreeCellRenderer treeRenderer;
    private MouseListener treeMouseListener;
    private ExecutorService loadQueue;
    private JTree currentNodeTree;
    private JTextField treeEditorTextField;
    private final Action nodeTreeCopyAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            KalkylGUI.this.treeCopyActionPerformed(ev);
        }
    };
    private final Action nodeTreePasteAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            KalkylGUI.this.treePasteActionPerformed(ev);
        }
    };
    private final Action nodeTreeCutAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            KalkylGUI.this.treeCutActionPerformed(ev);
        }
    };
    private final Action nodeTreeNewBranch = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            KalkylGUI.this.treeInsertBranchActionPerformed(ev);
        }
    };
    private final Action nodeTreeNewLeaf = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            KalkylGUI.this.treeInsertLeafActionPerformed(ev);
        }
    };
    private final Thread shutdownThread = new Thread("ShutdownThread"){

        @Override
        public void run() {
            JDialog shutdownDialog = new JDialog(KalkylGUI.this);
            JProgressBar shutdownProgressBar = new JProgressBar();
            shutdownProgressBar.setBorderPainted(false);
            shutdownProgressBar.setMinimum(0);
            shutdownProgressBar.setMaximum(6);
            shutdownProgressBar.setIndeterminate(false);
            shutdownProgressBar.setStringPainted(true);
            shutdownDialog.setDefaultCloseOperation(0);
            shutdownDialog.setTitle(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("shutdownDialog_title"));
            shutdownDialog.getContentPane().add((Component)shutdownProgressBar, "Center");
            shutdownDialog.pack();
            shutdownProgressBar.setString(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("shutdownProgressbar_start"));
            StaticHelpers.center(shutdownDialog);
            shutdownDialog.setVisible(true);
            shutdownProgressBar.setValue(1);
            for (Projekt p : KalkylGUI.this.projectManager.getOpenProjects()) {
                shutdownProgressBar.setString(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("saving_open_project") + p.getFileReference().getName() + ")");
                shutdownDialog.pack();
                KalkylGUI.this.saveProject(p);
            }
            shutdownProgressBar.setValue(2);
            shutdownProgressBar.setString(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("saving_settings"));
            try {
                NetWorkCommunicator.writeFile(KalkylGUI.DESCRIPTIONS_FILE, KalkylGUI.this.fileDescriptions);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                NetWorkCommunicator.writeFile(KalkylGUI.CREATED_FILE, KalkylGUI.this.fileCreated);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                NetWorkCommunicator.writeFile(KalkylGUI.ALIAS_FILE, KalkylGUI.this.xstream.toXML(KalkylGUI.this.aliasMap));
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                NetWorkCommunicator.writeFile(KalkylGUI.SUMMARIES_FILE, KalkylGUI.this.xstream.toXML(KalkylGUI.this.fileSummaries));
            }
            catch (IOException e) {
                // empty catch block
            }
            shutdownProgressBar.setValue(3);
            shutdownProgressBar.setString(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("closing_socket"));
            shutdownProgressBar.setValue(4);
            shutdownProgressBar.setString(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("saving_local_settings"));
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            if (KalkylGUI.super.getExtendedState() == 6) {
                preferences.putBoolean("eKalkyl.startMaximized", true);
            } else {
                preferences.putBoolean("eKalkyl.startMaximized", false);
                Rectangle r = KalkylGUI.this.getBounds();
                preferences.putInt("eKalkyl.x", r.x);
                preferences.putInt("eKalkyl.y", r.y);
                preferences.putInt("eKalkyl.width", r.width);
                preferences.putInt("eKalkyl.height", r.height);
            }
            preferences.put("eKalkyl.screenID", KalkylGUI.this.getGraphicsConfiguration().getDevice().getIDstring());
            eKalkyl.shutdown();
            shutdownProgressBar.setValue(5);
            shutdownProgressBar.setString(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("closing_socket"));
            ClientThread.closeConnection();
            shutdownProgressBar.setValue(6);
            shutdownProgressBar.setString(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("done"));
            System.exit(0);
        }
    };
    private final ListCellRenderer aliasesListCellRenderer = new DefaultListCellRenderer(){
        private Icon icon = new ImageIcon(this.getClass().getResource("/org/tangoProject/small/format-indent-more.png"));

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int row, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, row, isSelected, cellHasFocus);
            this.setIcon(this.icon);
            return this;
        }
    };
    private final TreeSelectionListener fileTreeSelectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            KalkylGUI.this.renderFileTree();
        }
    };
    Comparator<JMenuItem> menuItemSorter = new Comparator<JMenuItem>(){

        @Override
        public int compare(JMenuItem o1, JMenuItem o2) {
            return o1.getText().compareTo(o2.getText());
        }
    };
    private JMenu utskrifter;
    private static Comparator<File> fileComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o2.getName().compareTo(o1.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return obj == fileComparator;
        }

        public int hashCode() {
            int hash = 3;
            return hash;
        }
    };
    private SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
    final Logger log = Logger.getLogger("se.sjobeck.gui");
    private SettingsDialog settingsDialog = null;
    private JPopupMenu aliasPopup;
    private JList aliasesList;
    private JPanel aliasesPanel;
    private JScrollPane aliasesScrollPane;
    private JMenuItem changeName;
    private JPanel constants;
    private JButton copy;
    private JMenuItem copyProject;
    private JPanel customAMA;
    private JButton cut;
    private JMenuItem deleteProject;
    private JButton deleteRow;
    private JPanel editors;
    private JPanel fabrikat;
    private JButton fetchRow;
    private JPanel filPanel;
    private JPopupMenu filePopup;
    private JScrollPane fileScrollPane;
    private JTree fileTree;
    private JMenuItem findProject;
    private JPanel gren;
    private JButton insertRow;
    private JButton jButton1;
    private JDialog jDialog1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JTextArea jTextArea1;
    private JPanel kommentar;
    private JMenuItem newFolder;
    private JMenuItem newProject;
    private JButton next;
    private JPopupMenu nodePopup;
    private JMenuItem openProject;
    private JOutlookBarTabbed outlookBar;
    private JButton paste;
    private JButton previous;
    private JButton print;
    private JFileChooser printDialogFileChooser;
    private JButton redo;
    private JPanel remarks;
    private JMenuItem removeAlias;
    private JMenuItem renameAlias;
    private JMenuItem reverseDeletion;
    private JPanel rum;
    private JMenuItem sendProject;
    private JButton settings;
    private JButton showHelp;
    private JButton startaGeometra;
    private JLabel statusLabel;
    private JPanel timpris;
    private JToolBar toolBar;
    private JMenuItem treeChangeName1;
    private JMenuItem treeCopy;
    private JMenuItem treeCut;
    private JMenuItem treeDelete;
    private JMenuItem treeExpandAll;
    private JMenuItem treeInsertBranch;
    private JMenuItem treeInsertComment;
    private JMenuItem treeInsertLeaf;
    private JMenuItem treePaste;
    private JButton undo;
    private JTextPane welcomeDocument;
    private JScrollPane welcomePanel;
    private JPanel xl;

    private File getTempFile() {
        String directoryPath = EkalkylPDFConfiguration.getSavePath();
        File dir = new File(directoryPath);
        dir.mkdirs();
        File file = new File(EkalkylPDFConfiguration.getSavePath() + File.separator + "PreViewFile.pdf");
        boolean delete = file.delete();
        file = new File(EkalkylPDFConfiguration.getSavePath() + File.separator + "PreViewFile.pdf");
        return file;
    }

    public KalkylGUI() {
        Object o;
        Logger.getLogger("se.sjobeck").entering("KalkylGUI", "[constructor]");
        Logger.getLogger("se.sjobeck.gui.KalkylGUI").info(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("building_interface"));
        this.xstream = new XStream(new DomDriver());
        this.xstream.alias("projekt", Projekt.class);
        this.xstream.alias("function", Function.class);
        this.xstream.alias("custom", se.sjobeck.datastructures.CustomAMA.class);
        this.xstream.alias("gren", GrenNod.class);
        this.xstream.alias("kalkylNod", KalkylNod.class);
        this.xstream.alias("rum", RumNod.class);
        this.xstream.alias("kommentar", KommentarNod.class);
        this.xstream.alias("DefaultMutableTreeNode", DefaultMutableTreeNode.class);
        this.xstream.alias("se.sjobeck.datastructures.RadStruct", RadStruct.class);
        this.projectManager = new ProjectManager();
        this.loadQueue = Executors.newSingleThreadExecutor();
        Logger.getLogger("se.sjobeck.gui.KalkylGUI").info(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("fetching_settings"));
        try {
            Logger.getLogger("se.sjobeck").entering("ClientFileSystemView", "read [descriptions]");
            o = NetWorkCommunicator.readFile(DESCRIPTIONS_FILE);
            Logger.getLogger("se.sjobeck").entering("ClientFileSystemView", "read");
            this.fileDescriptions = (HashMap)o;
        }
        catch (ClassCastException e) {
            this.fileDescriptions = new HashMap();
        }
        catch (IOException e) {
            this.fileDescriptions = new HashMap();
        }
        catch (NullPointerException e) {
            this.fileDescriptions = new HashMap();
        }
        catch (ClassNotFoundException e) {
            this.fileDescriptions = new HashMap();
        }
        try {
            Logger.getLogger("se.sjobeck").entering("ClientFileSystemView", "read [file created]");
            o = NetWorkCommunicator.readFile(CREATED_FILE);
            Logger.getLogger("se.sjobeck").exiting("ClientFileSystemView", "read");
            this.fileCreated = (HashMap)o;
        }
        catch (ClassCastException e) {
            this.fileCreated = new HashMap();
        }
        catch (IOException e) {
            this.fileCreated = new HashMap();
        }
        catch (NullPointerException e) {
            this.fileCreated = new HashMap();
        }
        catch (ClassNotFoundException e) {
            this.fileCreated = new HashMap();
        }
        try {
            Logger.getLogger("se.sjobeck").entering("ClientFileSystemView", "read [descriptions]");
            o = NetWorkCommunicator.readFile(SUMMARIES_FILE);
            Logger.getLogger("se.sjobeck").entering("ClientFileSystemView", "read");
            this.fileSummaries = (HashMap)o;
        }
        catch (ClassCastException e) {
            this.fileSummaries = new HashMap();
        }
        catch (IOException e) {
            this.fileSummaries = new HashMap();
        }
        catch (NullPointerException e) {
            this.fileSummaries = new HashMap();
        }
        catch (ClassNotFoundException e) {
            this.fileSummaries = new HashMap();
        }
        try {
            Logger.getLogger("se.sjobeck").entering("ClientFileSystemView", "read [file created]");
            o = NetWorkCommunicator.readFile(ALIAS_FILE);
            Logger.getLogger("se.sjobeck").exiting("ClientFileSystemView", "read");
            this.aliasMap = (HashMap)this.xstream.fromXML((String)o);
        }
        catch (ClassCastException e) {
            this.aliasMap = new HashMap();
        }
        catch (IOException e) {
            this.aliasMap = new HashMap();
        }
        catch (NullPointerException e) {
            this.aliasMap = new HashMap();
        }
        catch (ConversionException e) {
            this.aliasMap = new HashMap();
        }
        catch (ClassNotFoundException e) {
            this.aliasMap = new HashMap();
        }
        this.aliasList = new AliasesListModel(this.aliasMap);
        Logger.getLogger("se.sjobeck.gui.KalkylGUI").info(ResourceBundle.getBundle("se/sjobeck/eKalkyl").getString("building_interface"));
        Logger.getLogger("se.sjobeck").entering("KalkylGUI", "initComponents()");
        this.initComponents();
        Logger.getLogger("se.sjobeck").exiting("KalkylGUI", "initComponents()");
        Logger.getLogger("se.sjobeck").finest("KalkylGUI: initialization of custom components");
        try {
            this.welcomeDocument.setPage(KalkylGUI.class.getResource("/se/sjobeck/index.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.treeEditorTextField = new JTextField();
        this.treeRenderer = new ProjectTreeCellRenderer();
        this.treeMouseListener = new OrderedMouseListener(new TreeSelectListener(), new PopupMouseListener(this.nodePopup));
        JOutlookBarTabbed oBar = this.outlookBar;
        FilterJtree fjt = new FilterJtree(this.fileScrollPane, (DNDTree)this.fileTree, this);
        oBar.addBar("Recept", new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/image-missing.png")), new TreeSplitEditor(this.aliasesScrollPane, this.editors));
        oBar.addBar("Projekt", new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/user-home.png")), new TreeSplitEditor(fjt, this.editors));
        oBar.addSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KalkylGUI.this.cancelAllEditors(KalkylGUI.this.editors);
                ((TreeSplitEditor)KalkylGUI.this.outlookBar.getVisibleComponent()).setRightComponent(KalkylGUI.this.editors);
                switch (KalkylGUI.this.outlookBar.getVisibleBar()) {
                    case 0: {
                        KalkylGUI.this.renderAliasList();
                        KalkylGUI.this.projectManager.setCurrentProject(null);
                        KalkylGUI.this.setTitle(null);
                        KalkylGUI.this.previous.setEnabled(true);
                        KalkylGUI.this.next.setEnabled(true);
                        KalkylGUI.this.cut.setEnabled(true);
                        KalkylGUI.this.copy.setEnabled(true);
                        KalkylGUI.this.paste.setEnabled(true);
                        KalkylGUI.this.insertRow.setEnabled(true);
                        KalkylGUI.this.deleteRow.setEnabled(true);
                        KalkylGUI.this.fetchRow.setEnabled(false);
                        KalkylGUI.this.print.setEnabled(false);
                        KalkylGUI.this.showHelp.setEnabled(true);
                        break;
                    }
                    case 1: {
                        KalkylGUI.this.renderFileTree();
                        KalkylGUI.this.projectManager.setCurrentProject(null);
                        KalkylGUI.this.setTitle(null);
                        KalkylGUI.this.previous.setEnabled(false);
                        KalkylGUI.this.next.setEnabled(false);
                        KalkylGUI.this.cut.setEnabled(false);
                        KalkylGUI.this.copy.setEnabled(false);
                        KalkylGUI.this.paste.setEnabled(false);
                        KalkylGUI.this.insertRow.setEnabled(false);
                        KalkylGUI.this.deleteRow.setEnabled(false);
                        KalkylGUI.this.fetchRow.setEnabled(false);
                        KalkylGUI.this.print.setEnabled(false);
                        KalkylGUI.this.showHelp.setEnabled(true);
                        break;
                    }
                    default: {
                        JScrollPane tempPane = (JScrollPane)((TreeSplitEditor)KalkylGUI.this.outlookBar.getVisibleComponent()).getLeftComponent();
                        JTree nodeTree = (JTree)tempPane.getViewport().getView();
                        KalkylGUI.this.renderNodeTree(nodeTree);
                        KalkylGUI.this.setTitle(KalkylGUI.this.outlookBar.getVisibleBarName());
                        KalkylGUI.this.previous.setEnabled(true);
                        KalkylGUI.this.next.setEnabled(true);
                        KalkylGUI.this.cut.setEnabled(true);
                        KalkylGUI.this.copy.setEnabled(true);
                        KalkylGUI.this.paste.setEnabled(true);
                        KalkylGUI.this.insertRow.setEnabled(true);
                        KalkylGUI.this.deleteRow.setEnabled(true);
                        KalkylGUI.this.fetchRow.setEnabled(true);
                        KalkylGUI.this.print.setEnabled(true);
                        KalkylGUI.this.showHelp.setEnabled(true);
                    }
                }
                KalkylGUI.this.updateUndoRedo();
            }
        });
        oBar.setVisibleBar(1);
        this.aliasesList.setModel(this.getAliasList());
        this.aliasesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                KalkylGUI.this.renderAliasList();
            }
        });
        this.aliasesList.setCellRenderer(this.aliasesListCellRenderer);
        this.aliasesList.addMouseListener(new OrderedMouseListener(new ListSelectListener(), new PopupMouseListener(this.aliasPopup)));
        this.updateFileList();
        this.fileTree.setCellRenderer(new FileTreeCellRenderer());
        this.fileTree.getSelectionModel().addTreeSelectionListener(this.fileTreeSelectionListener);
        new FileTreeTransferHandler((DNDTree)this.fileTree);
        final AbstractAction openFileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = KalkylGUI.this.getSelectedFile();
                if (!StaticHelpers.inTrash(f)) {
                    KalkylGUI.this.openFile(f);
                }
            }
        };
        this.fileTree.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "openFile");
        this.fileTree.getActionMap().put("openFile", openFileAction);
        this.fileTree.addMouseListener(new OrderedMouseListener(new TreeSelectListener(), new PopupMouseListener(this.filePopup), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    openFileAction.actionPerformed(null);
                }
            }
        }));
        EditableRadTable.setAliasMap(this.aliasList);
        Logger.getLogger("se.sjobeck").finest("KalkylGUI: custom components initialized");
        Logger.getLogger("se.sjobeck.gui.KalkylGUI").info("Bygger gr\u00e4nssnitt... Applicerar inst\u00e4llningar");
        this.pack();
        StaticHelpers.center(this);
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsDevice device = null;
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            if (gd.getIDstring().equals(preferences.get("eKalkyl.screenID", null))) {
                device = gd;
            }
            for (int i = 0; i < gc.length; ++i) {
                virtualBounds = virtualBounds.union(gc[i].getBounds());
            }
        }
        if (device == null) {
            device = gs[0];
        }
        if (preferences.getBoolean("eKalkyl.startMaximized", false)) {
            this.setBounds(device.getDefaultConfiguration().getBounds());
            this.setExtendedState(6);
        } else {
            Rectangle r = super.getBounds();
            r.x = preferences.getInt("eKalkyl.x", r.x);
            r.y = preferences.getInt("eKalkyl.y", r.y);
            r.height = preferences.getInt("eKalkyl.height", r.height);
            r.width = preferences.getInt("eKalkyl.width", r.width);
            if (virtualBounds.contains(r)) {
                super.setBounds(r);
            } else {
                this.setBounds(device.getDefaultConfiguration().getBounds());
                this.setExtendedState(6);
            }
        }
        Timer autoSave = new Timer("Autosave", true);
        TimerTask autoSaveTask = new TimerTask(){

            @Override
            public void run() {
                Logger.getLogger("se.sjobeck.gui").info("Autosparar \u00f6ppna projekt...");
                for (Projekt p : KalkylGUI.this.projectManager.getOpenProjects()) {
                    KalkylGUI.this.saveProject(p);
                }
                Logger.getLogger("se.sjobeck.gui").info("Klar.");
            }
        };
        autoSave.scheduleAtFixedRate(autoSaveTask, 0L, 30000L);
        HashMap<String, String> utskriftMapping = new HashMap<String, String>();
        utskriftMapping.put("AMA-koder i klartext", "/se/sjobeck/util/pdf/standard/klartext-utf8.txt");
        utskriftMapping.put("Arbetsbeskrivning", "/se/sjobeck/util/pdf/standard/arbetsbeskrivning.txt");
        utskriftMapping.put("Rumsvis kalkylrader", "/se/sjobeck/util/pdf/standard/rader_rumsvis-utf8.txt");
        utskriftMapping.put("Rumsvis kalkylrader - utan tid", "/se/sjobeck/util/pdf/standard/rader_rumsvis-utantid-utf8.txt");
        utskriftMapping.put("Sammanr\u00e4knade kalkylrader", "/se/sjobeck/util/pdf/standard/rader_samman-utf8.txt");
        utskriftMapping.put("Sammanr\u00e4knade kalkylrader - tid", "/se/sjobeck/util/pdf/standard/rader_samman_utan_P_T.txt");
        utskriftMapping.put("Sammanr\u00e4knade kalkylrader - utan tid", "/se/sjobeck/util/pdf/standard/rader_samman_utan_tid.txt");
        utskriftMapping.put("Materialspecifikation", "/se/sjobeck/util/pdf/standard/material-utf8.txt");
        utskriftMapping.put("Materialspecifikation utan pris", "/se/sjobeck/util/pdf/standard/material-utan-pris.txt");
        utskriftMapping.put("Rumsvis ytbeskrivning", "/se/sjobeck/util/pdf/standard/yta_rumsvis-utf8.txt");
        utskriftMapping.put("Sammanr\u00e4knade kalkylrader +7 kolumner A3", "/se/sjobeck/util/pdf/standard/rader_samman_plus7.txt");
        ActionListener utskriftsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String buttontext = "-" + ((JMenuItem)event.getSource()).getText();
                PrintDialog pd = new PrintDialog(KalkylGUI.this);
                pd.showPrintDialog(KalkylGUI.this.projectManager.getCurrentProject());
                try {
                    PDFRenderer renderer;
                    Class<?> handlerClass;
                    String handler;
                    File exportFile = KalkylGUI.this.getTempFile();
                    if (!exportFile.getName().endsWith(".pdf")) {
                        exportFile = new File(exportFile.getAbsolutePath().trim() + ".pdf");
                    }
                    if (!exportFile.exists() || JOptionPane.showConfirmDialog(KalkylGUI.this, "Filen finns redan, vill du skriva \u00f6ver den?", "Varning", 0) == 0) {
                        Logger.getLogger("se.sjobeck.gui").info("Skriver ut till " + exportFile.getAbsolutePath() + " ...");
                        handler = event.getActionCommand();
                        if (handler.endsWith(".txt")) {
                            OutputGenerator.generatePdf(this.getClass().getResourceAsStream(event.getActionCommand()), KalkylGUI.this.projectManager.getCurrentProject(), exportFile, pd.printFolders());
                        } else {
                            handlerClass = Class.forName(handler);
                            assert (PDFRenderer.class.isAssignableFrom(handlerClass));
                            renderer = (PDFRenderer)handlerClass.newInstance();
                            renderer.renderProject(KalkylGUI.this.projectManager.getCurrentProject(), exportFile, pd.printFolders());
                        }
                        KalkylGUI.this.desktopOpenFile(exportFile);
                    }
                    KalkylGUI.this.printDialogFileChooser.setSelectedFile(new File(KalkylGUI.this.projectManager.getCurrentProject().getFileReference().getName().trim() + buttontext + ".pdf"));
                    if (KalkylGUI.this.printDialogFileChooser.showSaveDialog(KalkylGUI.this) == 0) {
                        exportFile = KalkylGUI.this.printDialogFileChooser.getSelectedFile();
                        if (!exportFile.getName().endsWith(".pdf")) {
                            exportFile = new File(exportFile.getAbsolutePath().trim() + ".pdf");
                        }
                        if (!exportFile.exists() || JOptionPane.showConfirmDialog(KalkylGUI.this, "Filen finns redan, vill du skriva \u00f6ver den?", "Varning", 0) == 0) {
                            Logger.getLogger("se.sjobeck.gui").info("Skriver ut till " + exportFile.getAbsolutePath() + " ...");
                            handler = event.getActionCommand();
                            if (handler.endsWith(".txt")) {
                                OutputGenerator.generatePdf(this.getClass().getResourceAsStream(event.getActionCommand()), KalkylGUI.this.projectManager.getCurrentProject(), exportFile, pd.printFolders());
                            } else {
                                handlerClass = Class.forName(handler);
                                assert (PDFRenderer.class.isAssignableFrom(handlerClass));
                                renderer = (PDFRenderer)handlerClass.newInstance();
                                renderer.renderProject(KalkylGUI.this.projectManager.getCurrentProject(), exportFile, pd.printFolders());
                            }
                            KalkylGUI.this.desktopOpenFile(exportFile);
                            Logger.getLogger("se.sjobeck.gui").info("Klar.");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        ArrayList<JMenuItem> utskriftItems = new ArrayList<JMenuItem>();
        for (Map.Entry entry : utskriftMapping.entrySet()) {
            JMenuItem it = new JMenuItem((String)entry.getKey());
            it.setActionCommand((String)entry.getValue());
            it.addActionListener(utskriftsListener);
            utskriftItems.add(it);
        }
        this.utskrifter = new JMenu();
        Collections.sort(utskriftItems, this.menuItemSorter);
        for (JMenuItem it : utskriftItems) {
            this.utskrifter.add(it);
        }
        JMenuItem ps_jmi = new JMenuItem("Projektsammanst\u00e4llning");
        ps_jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FilePanel)KalkylGUI.this.filPanel).printSammanst\u00e4llning();
            }
        });
        this.utskrifter.add(ps_jmi);
        JMenuItem ek_jmi = new JMenuItem("Egenkontroll");
        ek_jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Projekt currentProject = KalkylGUI.this.projectManager.getCurrentProject();
                PrintDialog pd = new PrintDialog(KalkylGUI.this);
                pd.showPrintDialog(currentProject);
                EgenKontroll ek = new EgenKontroll(currentProject);
                EgenKontrollInput eki = new EgenKontrollInput((Frame)kalkylgui, true);
                eki.setVisible(true);
                ek.setPlats(eki.getPlats());
                ek.setKund(eki.getKund());
                ek.setKontakt(eki.getKontakt());
                ek.setAnsvarig(eki.getAnsvarig());
                ek.setF\u00f6retag(eki.getF\u00f6retag());
                File file = KalkylGUI.this.chooseOutputFile(currentProject);
                if (file != null) {
                    OutputGenerator.genereatePdf(ek, file);
                    KalkylGUI.this.desktopOpenFile(file);
                }
            }
        });
        this.utskrifter.add(ek_jmi);
        JMenuItem eka_jmi = new JMenuItem("Egenkontroll Avancerad");
        eka_jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Projekt currentProject = KalkylGUI.this.projectManager.getCurrentProject();
                PrintDialog pd = new PrintDialog(KalkylGUI.this);
                pd.showPrintDialog(currentProject);
                EgenKontroll_Avancerad ek = new EgenKontroll_Avancerad(currentProject);
                EgenKontrollInput eki = new EgenKontrollInput((Frame)kalkylgui, true);
                eki.setVisible(true);
                ek.setPlats(eki.getPlats());
                ek.setKund(eki.getKund());
                ek.setKontakt(eki.getKontakt());
                ek.setAnsvarig(eki.getAnsvarig());
                ek.setF\u00f6retag(eki.getF\u00f6retag());
                File file = KalkylGUI.this.chooseOutputFile(currentProject);
                if (file != null) {
                    OutputGenerator.genereatePdf(ek, file);
                    KalkylGUI.this.desktopOpenFile(file);
                }
            }
        });
        this.utskrifter.add(eka_jmi);
        JLabelHandler handler = new JLabelHandler(this.statusLabel);
        Logger.getLogger("se.sjobeck").addHandler(handler);
        Logger.getLogger("se.sjobeck.gui").addHandler(handler);
        Logger.getLogger("se.sjobeck.database").addHandler(handler);
        Logger.getLogger("se.sjobeck").exiting("KalkylGUI", "[constructor]");
        this.redo.setVisible(false);
        this.undo.setVisible(false);
        this.outlookBar.setVisibleBar(0);
        this.outlookBar.setVisibleBar(1);
        InputMap im = this.toolBar.getInputMap(2);
        ActionMap am = this.toolBar.getActionMap();
        im.put(KeyStroke.getKeyStroke("pressed F1"), "pushHelpButton");
        AbstractAction pushHelpButton = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KalkylGUI.this.showHelpActionPerformed(null);
            }
        };
        am.put("pushHelpButton", pushHelpButton);
        kalkylgui = this;
        this.sendProject.setVisible(false);
        this.newFolder.setVisible(false);
        this.jSeparator4.setVisible(false);
        this.findProject.setVisible(false);
        this.startaGeometra.setEnabled(false);
        this.checkGeometraLicense();
    }

    private void desktopOpenFile(File exportFile) {
        try {
            Desktop.getDesktop().open(exportFile);
        }
        catch (IOException e) {
            System.out.println("Du har inget program accosierat med filer av typen: " + exportFile);
            e.printStackTrace();
        }
    }

    public File chooseOutputFile(Projekt project) {
        Vector<String> fodu = new Vector<String>();
        fodu.add("PDF-filter");
        fodu.add("pdf");
        File showFileChooser = DialogCreator.showFileChooser("Spara", fodu, project.getFileReference().getName() + " - egenkontroll.pdf");
        if (showFileChooser != null && !showFileChooser.getName().endsWith(".pdf")) {
            try {
                showFileChooser = new File(showFileChooser.getCanonicalPath() + ".pdf");
            }
            catch (IOException ex) {
                Logger.getLogger(FilePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return showFileChooser;
    }

    private void updateFileList() {
        ((DefaultTreeModel)this.fileTree.getModel()).setRoot(KalkylGUI.buildFileNodes());
    }

    private void renderNodeTree(JTree nodeTree) {
        TreePath path = nodeTree.getSelectionPath();
        if (path == null) {
            path = new TreePath(nodeTree.getModel().getRoot());
            nodeTree.setSelectionPath(path);
        } else {
            this.cancelAllEditors(this.editors);
            this.setCurrentNodeTree(nodeTree);
            KalkylNod n = (KalkylNod)nodeTree.getSelectionPath().getLastPathComponent();
            this.projectManager.setCurrentProject(n.getProject());
            this.projectManager.setCurrentNode(n);
            if (n.isRoot()) {
                ((FilePanel)this.filPanel).setFile(n.getProject().getFileReference());
                this.setVisibleCard("filPanel");
                ((FilePanel)this.filPanel).enableAll();
            } else if (n instanceof ConstantsNode) {
                ((ConstantsPanel)this.constants).updatePanel();
                this.setVisibleCard("constants");
            } else if (n instanceof CustomAMANod) {
                ((CustomAMA)this.customAMA).updatePanel();
                this.setVisibleCard("customAMA");
            } else if (n instanceof FabrikatNod) {
                ((Projektforutsattningar)this.fabrikat).updatePanel();
                this.setVisibleCard("fabrikat");
            } else if (n instanceof GrenNod) {
                ((GrenPanel)this.gren).setKalkylNod(n);
                this.setVisibleCard("gren");
            } else if (n instanceof KommentarNod) {
                ((CommentPane)this.kommentar).setKommentar((KommentarNod)n);
                this.setVisibleCard("kommentar");
            } else if (n instanceof RumNod) {
                ((RumPanel)this.rum).updatePanel();
                this.setVisibleCard("rum");
            } else if (n instanceof TimprisNod) {
                ((TimprisKalkyl)this.timpris).setCurrentProject(n.getProject());
                this.setVisibleCard("timpris");
            } else if (n instanceof XLNod) {
                ((XLPanel)this.xl).setNode((XLNod)n);
                this.setVisibleCard("XL");
            } else if (n instanceof RemarksNod) {
                ((RemarksTable)this.remarks).setRemarks(RemarkFactory.checkProject(n.getProject()));
                this.setVisibleCard("remarks");
            }
        }
    }

    private void renderAliasList() {
        ((AliasesPanel)this.aliasesPanel).setAlias((String)this.aliasesList.getSelectedValue());
        this.setVisibleCard("alias");
    }

    private void renderFileTree() {
        TreePath path = this.fileTree.getSelectionPath();
        if (path == null || path == this.fileTree.getPathForRow(0)) {
            this.setVisibleCard("welcome");
        } else {
            this.fileTree.scrollPathToVisible(path);
            File file = (File)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            ((FilePanel)this.filPanel).setFile(file);
            this.setVisibleCard("filPanel");
            ((FilePanel)this.filPanel).disableAll();
        }
    }

    private void setVisibleCard(String cardName) {
        ((CardLayout)this.editors.getLayout()).show(this.editors, cardName);
    }

    private static DefaultMutableTreeNode buildFileNodes() {
        VirtualFile base = ((FromServerMessage)ClientThread.sendMessage(Message.GetVirtualFile, new Object[0])).getVirtualFile();
        return KalkylGUI.buildFileNodes(null, base);
    }

    private static DefaultMutableTreeNode buildFileNodes(DefaultMutableTreeNode curTop, File dir) {
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(dir);
        curDir.setAllowsChildren(true);
        if (curTop != null) {
            curTop.add(curDir);
        }
        Vector<File> ol = new Vector<File>();
        File[] tmp = dir.listFiles();
        for (int i = 0; i < tmp.length; ++i) {
            ol.addElement(tmp[i]);
        }
        Collections.sort(ol, fileComparator);
        Vector files = new Vector();
        for (int i = 0; i < ol.size(); ++i) {
            if (((File)ol.get(i)).isDirectory() && !((File)ol.get(i)).getName().equals(StaticHelpers.getExtraResourcesDirectoryName()) && !((File)ol.get(i)).getName().equals(StaticHelpers.getXML_DatabasName())) {
                KalkylGUI.buildFileNodes(curDir, (File)ol.get(i));
                continue;
            }
            if (((File)ol.get(i)).isHidden() || ((File)ol.get(i)).getAbsolutePath().endsWith(StaticHelpers.getBakFileExtensioin())) continue;
            files.addElement(ol.get(i));
        }
        for (int fnum = 0; fnum < files.size(); ++fnum) {
            DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(files.elementAt(fnum));
            fileNode.setAllowsChildren(false);
            curDir.add(fileNode);
        }
        return curDir;
    }

    public AliasesListModel getAliasList() {
        return this.aliasList;
    }

    public Map<String, String> getFileDescriptionMap() {
        return this.fileDescriptions;
    }

    public Map<String, Date> getFileCreatedMap() {
        return this.fileCreated;
    }

    public XStream getXStream() {
        return this.xstream;
    }

    public KalkylNod getClipboardObject() {
        return this.clipboardOb;
    }

    public void setClipboardObject(KalkylNod newClip) {
        this.clipboardOb = newClip;
    }

    @Override
    public void setTitle(String s) {
        s = s == null ? "" : " - " + s;
        super.setTitle("eKalkyl\u2122 " + eKalkyl.VERSION + s + " - " + ClientThread.getUserFullName() + " [" + ClientThread.getLicenseExpiryDate() + "]");
    }

    private void initComponents() {
        this.aliasesScrollPane = new JScrollPane();
        this.aliasesList = new JList();
        this.fileScrollPane = new JScrollPane();
        this.fileTree = new DNDTree(null, false);
        this.filePopup = new JPopupMenu();
        this.openProject = new JMenuItem();
        this.copyProject = new JMenuItem();
        this.sendProject = new JMenuItem();
        this.deleteProject = new JMenuItem();
        this.reverseDeletion = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.newProject = new JMenuItem();
        this.newFolder = new JMenuItem();
        this.changeName = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.findProject = new JMenuItem();
        this.nodePopup = new JPopupMenu();
        this.treeChangeName1 = new JMenuItem();
        this.treeInsertBranch = new JMenuItem();
        this.treeInsertLeaf = new JMenuItem();
        this.treeInsertComment = new JMenuItem();
        this.treeDelete = new JMenuItem();
        this.treeExpandAll = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.treeCopy = new JMenuItem();
        this.treePaste = new JMenuItem();
        this.treeCut = new JMenuItem();
        this.aliasPopup = new JPopupMenu();
        this.renameAlias = new JMenuItem();
        this.removeAlias = new JMenuItem();
        this.jDialog1 = new JDialog(this);
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.printDialogFileChooser = new JFileChooser();
        this.editors = new JPanel();
        this.welcomePanel = new JScrollPane();
        this.welcomeDocument = new JTextPane();
        this.filPanel = new FilePanel(this.fileSummaries, this.fileDescriptions, this.projectManager);
        this.aliasesPanel = new AliasesPanel(this, this.projectManager, this.getAliasList());
        this.constants = new ConstantsPanel(this, this.projectManager);
        this.customAMA = new CustomAMA(this.projectManager);
        this.fabrikat = new Projektforutsattningar(this.projectManager);
        this.timpris = new TimprisKalkyl();
        this.rum = new RumPanel(this, this.projectManager);
        this.gren = new GrenPanel(this, this.projectManager);
        this.kommentar = new CommentPane();
        this.xl = new XLPanel();
        this.remarks = new RemarksTable(this);
        this.outlookBar = new JOutlookBarTabbed();
        this.statusLabel = new JLabel();
        this.toolBar = new JToolBar();
        this.undo = new JButton();
        this.redo = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.previous = new JButton();
        this.next = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.cut = new JButton();
        this.copy = new JButton();
        this.paste = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.insertRow = new JButton();
        this.deleteRow = new JButton();
        this.fetchRow = new JButton();
        this.jSeparator8 = new JToolBar.Separator();
        this.startaGeometra = new JButton();
        this.print = new JButton();
        this.settings = new JButton();
        this.showHelp = new JButton();
        this.aliasesScrollPane.setViewportView(this.aliasesList);
        this.fileScrollPane.setViewportView(this.fileTree);
        this.filePopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                KalkylGUI.this.filePopupPopupMenuWillBecomeVisible(evt);
            }
        });
        this.openProject.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/document-open.png")));
        this.openProject.setText("\u00d6ppna");
        this.openProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.openProjectActionPerformed(evt);
            }
        });
        this.filePopup.add(this.openProject);
        this.copyProject.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-copy.png")));
        this.copyProject.setText("Kopiera");
        this.copyProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.copyProjectActionPerformed(evt);
            }
        });
        this.filePopup.add(this.copyProject);
        this.sendProject.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/mail-message-new.png")));
        this.sendProject.setText("Skicka");
        this.sendProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.sendProjectActionPerformed(evt);
            }
        });
        this.filePopup.add(this.sendProject);
        this.deleteProject.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/x-directory-trash.png")));
        this.deleteProject.setText("Ta bort");
        this.deleteProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.deleteProjectActionPerformed(evt);
            }
        });
        this.filePopup.add(this.deleteProject);
        this.reverseDeletion.setText("\u00c5terst\u00e4ll");
        this.reverseDeletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.reverseDeletionActionPerformed(evt);
            }
        });
        this.filePopup.add(this.reverseDeletion);
        this.filePopup.add(this.jSeparator3);
        this.newProject.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/go-home.png")));
        this.newProject.setText("Nytt projekt");
        this.newProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.newProjectActionPerformed(evt);
            }
        });
        this.filePopup.add(this.newProject);
        this.newFolder.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/x-directory-normal.png")));
        this.newFolder.setText("Ny mapp");
        this.newFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.newFolderActionPerformed(evt);
            }
        });
        this.filePopup.add(this.newFolder);
        this.changeName.setText("Byt namn");
        this.changeName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.changeNameActionPerformed(evt);
            }
        });
        this.filePopup.add(this.changeName);
        this.filePopup.add(this.jSeparator4);
        this.findProject.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-find.png")));
        this.findProject.setText("S\u00f6k");
        this.findProject.setEnabled(false);
        this.findProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.findProjectActionPerformed(evt);
            }
        });
        this.filePopup.add(this.findProject);
        this.treeChangeName1.setText("Byt namn");
        this.treeChangeName1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeChangeName1ActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeChangeName1);
        this.treeInsertBranch.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.treeInsertBranch.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/x-directory-normal.png")));
        this.treeInsertBranch.setText("Ny gren");
        this.treeInsertBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeInsertBranchActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeInsertBranch);
        this.treeInsertLeaf.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.treeInsertLeaf.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/x-office-spreadsheet.png")));
        this.treeInsertLeaf.setText("Ny del");
        this.treeInsertLeaf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeInsertLeafActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeInsertLeaf);
        this.treeInsertComment.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/emblem-important.png")));
        this.treeInsertComment.setText("L\u00e4gg till kommentar");
        this.treeInsertComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeInsertCommenttopMenuInsertCommentActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeInsertComment);
        this.treeDelete.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/x-directory-trash.png")));
        this.treeDelete.setText("Ta bort");
        this.treeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeDeleteActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeDelete);
        this.treeExpandAll.setText("Expandera/Kollapsa");
        this.treeExpandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeExpandAllActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeExpandAll);
        this.nodePopup.add(this.jSeparator1);
        this.treeCopy.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.treeCopy.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-copy.png")));
        this.treeCopy.setText("Kopiera");
        this.treeCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeCopyActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeCopy);
        this.treePaste.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.treePaste.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-paste.png")));
        this.treePaste.setText("Klistra in");
        this.treePaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treePasteActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treePaste);
        this.treeCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.treeCut.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-cut.png")));
        this.treeCut.setText(" Klipp ut");
        this.treeCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.treeCutActionPerformed(evt);
            }
        });
        this.nodePopup.add(this.treeCut);
        this.renameAlias.setText("Byt namn");
        this.renameAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.renameAliasActionPerformed(evt);
            }
        });
        this.aliasPopup.add(this.renameAlias);
        this.removeAlias.setText("Ta bort recept");
        this.removeAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.removeAliasActionPerformed(evt);
            }
        });
        this.aliasPopup.add(this.removeAlias);
        this.jDialog1.setMinimumSize(new Dimension(200, 300));
        this.jDialog1.setModal(true);
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jDialog1.getContentPane().add((Component)this.jButton1, "South");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jDialog1.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.printDialogFileChooser.setApproveButtonText("Skriv ut");
        this.editors.setLayout(new CardLayout());
        this.welcomeDocument.setEditable(false);
        this.welcomePanel.setViewportView(this.welcomeDocument);
        this.editors.add((Component)this.welcomePanel, "welcome");
        this.filPanel.setName("filPanel");
        this.editors.add((Component)this.filPanel, "filPanel");
        this.aliasesPanel.setName("aliases");
        this.editors.add((Component)this.aliasesPanel, "alias");
        this.editors.add((Component)this.constants, "constants");
        this.editors.add((Component)this.customAMA, "customAMA");
        this.editors.add((Component)this.fabrikat, "fabrikat");
        this.editors.add((Component)this.timpris, "timpris");
        this.editors.add((Component)this.rum, "rum");
        this.editors.add((Component)this.gren, "gren");
        this.editors.add((Component)this.kommentar, "kommentar");
        this.editors.add((Component)this.xl, "XL");
        this.editors.add((Component)this.remarks, "remarks");
        this.setDefaultCloseOperation(0);
        this.setTitle(null);
        this.setIconImage(IconFactory.getImage(Color.red));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                KalkylGUI.this.windowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                KalkylGUI.this.formWindowClosing(evt);
            }
        });
        this.outlookBar.setPreferredSize(new Dimension(200, 300));
        this.getContentPane().add((Component)this.outlookBar, "Center");
        this.statusLabel.setText("Test");
        this.statusLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.statusLabel.setFocusable(false);
        this.getContentPane().add((Component)this.statusLabel, "South");
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setDoubleBuffered(true);
        this.undo.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-undo.png")));
        this.undo.setEnabled(false);
        this.undo.setFocusable(false);
        this.undo.setHorizontalTextPosition(0);
        this.undo.setVerticalTextPosition(3);
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.undoActionPerformed(evt);
            }
        });
        this.toolBar.add(this.undo);
        this.redo.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/small/edit-redo.png")));
        this.redo.setEnabled(false);
        this.redo.setFocusable(false);
        this.redo.setHorizontalTextPosition(0);
        this.redo.setVerticalTextPosition(3);
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.redoActionPerformed(evt);
            }
        });
        this.toolBar.add(this.redo);
        this.toolBar.add(this.jSeparator5);
        this.previous.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/go-up.png")));
        this.previous.setMnemonic(38);
        this.previous.setToolTipText("F\u00f6reg\u00e5ende del (Alt-Pil upp)");
        this.previous.setEnabled(false);
        this.previous.setFocusable(false);
        this.previous.setHorizontalTextPosition(0);
        this.previous.setVerticalTextPosition(3);
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.previousActionPerformed(evt);
            }
        });
        this.toolBar.add(this.previous);
        this.next.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/go-down.png")));
        this.next.setMnemonic(40);
        this.next.setToolTipText("N\u00e4sta del (Alt-Pil ner)");
        this.next.setEnabled(false);
        this.next.setFocusable(false);
        this.next.setHorizontalTextPosition(0);
        this.next.setVerticalTextPosition(3);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.nextActionPerformed(evt);
            }
        });
        this.toolBar.add(this.next);
        this.toolBar.add(this.jSeparator6);
        this.cut.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/edit-cut.png")));
        this.cut.setToolTipText("Klipp ut rad (Ctrl-X)");
        this.cut.setEnabled(false);
        this.cut.setFocusable(false);
        this.cut.setHorizontalTextPosition(0);
        this.cut.setVerticalTextPosition(3);
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.cutActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cut);
        this.copy.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/edit-copy.png")));
        this.copy.setToolTipText("Kopiera rad (Ctrl-C)");
        this.copy.setEnabled(false);
        this.copy.setFocusable(false);
        this.copy.setHorizontalTextPosition(0);
        this.copy.setVerticalTextPosition(3);
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.copyActionPerformed(evt);
            }
        });
        this.toolBar.add(this.copy);
        this.paste.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/edit-paste.png")));
        this.paste.setToolTipText("Klistra in rad (Ctrl-V)");
        this.paste.setEnabled(false);
        this.paste.setFocusable(false);
        this.paste.setHorizontalTextPosition(0);
        this.paste.setVerticalTextPosition(3);
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.pasteActionPerformed(evt);
            }
        });
        this.toolBar.add(this.paste);
        this.toolBar.add(this.jSeparator7);
        this.insertRow.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/RowInsertBefore22.gif")));
        this.insertRow.setToolTipText("Infoga ny rad (Insert)");
        this.insertRow.setEnabled(false);
        this.insertRow.setFocusable(false);
        this.insertRow.setHorizontalTextPosition(0);
        this.insertRow.setVerticalTextPosition(3);
        this.insertRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.insertRowActionPerformed(evt);
            }
        });
        this.toolBar.add(this.insertRow);
        this.deleteRow.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/RowDelete22.gif")));
        this.deleteRow.setToolTipText("Ta bort rad(er) (Skift-Delete)");
        this.deleteRow.setEnabled(false);
        this.deleteRow.setFocusable(false);
        this.deleteRow.setHorizontalTextPosition(0);
        this.deleteRow.setVerticalTextPosition(3);
        this.deleteRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.deleteRowActionPerformed(evt);
            }
        });
        this.toolBar.add(this.deleteRow);
        this.fetchRow.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/go-jump.png")));
        this.fetchRow.setToolTipText("H\u00e4mta rad (Ctrl-H)");
        this.fetchRow.setEnabled(false);
        this.fetchRow.setFocusable(false);
        this.fetchRow.setHorizontalTextPosition(0);
        this.fetchRow.setVerticalTextPosition(3);
        this.fetchRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.fetchRowActionPerformed(evt);
            }
        });
        this.toolBar.add(this.fetchRow);
        this.toolBar.add(this.jSeparator8);
        this.startaGeometra.setIcon(IconFactory.getIcon(Color.green, 22, 22));
        this.startaGeometra.setToolTipText("Starta Geometra");
        this.startaGeometra.setFocusable(false);
        this.startaGeometra.setHorizontalTextPosition(0);
        this.startaGeometra.setVerticalTextPosition(3);
        this.startaGeometra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.startGeometra(evt);
            }
        });
        this.toolBar.add(this.startaGeometra);
        this.print.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/document-print.png")));
        this.print.setToolTipText("Skriv ut till PDF");
        this.print.setEnabled(false);
        this.print.setFocusable(false);
        this.print.setHorizontalTextPosition(0);
        this.print.setVerticalTextPosition(3);
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.printActionPerformed(evt);
            }
        });
        this.toolBar.add(this.print);
        this.settings.setIcon(IconLoader.getIcon("/org/tangoProject/medium/emblem-system.png"));
        this.settings.setToolTipText("Inst\u00e4llningar");
        this.settings.setFocusable(false);
        this.settings.setHorizontalTextPosition(0);
        this.settings.setVerticalTextPosition(3);
        this.settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.settingsActionPerformed(evt);
            }
        });
        this.toolBar.add(this.settings);
        this.showHelp.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/help-browser.png")));
        this.showHelp.setToolTipText("Visa hj\u00e4lp (F1)");
        this.showHelp.setFocusable(false);
        this.showHelp.setHorizontalTextPosition(0);
        this.showHelp.setVerticalTextPosition(3);
        this.showHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KalkylGUI.this.showHelpActionPerformed(evt);
            }
        });
        this.toolBar.add(this.showHelp);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jDialog1.setVisible(false);
    }

    private void removeAliasActionPerformed(ActionEvent evt) {
        String selected = (String)this.aliasesList.getSelectedValue();
        this.getAliasList().removeEntry(selected);
        this.aliasesList.invalidate();
        this.aliasesList.clearSelection();
    }

    private void renameAliasActionPerformed(ActionEvent evt) {
        String selected = (String)this.aliasesList.getSelectedValue();
        String renamed = "";
        while (KalkylGUI.invalidAlias(renamed, this.getAliasList(), this.aliasesList)) {
            renamed = (String)JOptionPane.showInputDialog(this, "Ange namn", "Nytt namn p\u00e5 '" + selected + "'", -1, null, null, selected);
            if (renamed == null) {
                return;
            }
            renamed = renamed.toUpperCase();
        }
        if (renamed != null) {
            this.getAliasList().addEntry(renamed, this.getAliasList().getRows(selected));
            this.getAliasList().removeEntry(selected);
            this.aliasesList.invalidate();
            this.aliasesList.clearSelection();
        }
    }

    public static boolean invalidAlias(String candidate, AliasesListModel aliasList, JComponent asker) {
        if (candidate.equals("")) {
            return true;
        }
        if (ByggdelFactory.isByggdelID(candidate)) {
            JOptionPane.showMessageDialog(asker, "Ett recept f\u00e5r inte ha samma ben\u00e4mning som ett byggdels-id!");
            return true;
        }
        if (aliasList.containsKey(candidate)) {
            return JOptionPane.showConfirmDialog(asker, "Receptet '" + candidate + "' finns redan, vill du ers\u00e4tta det?", "Bekr\u00e4fta ers\u00e4ttning", 0, 3) == 1;
        }
        return false;
    }

    @Override
    public void export(List<GeometraDrawing> values, StructuredExport export) {
        Projekt p = this.projectManager.getCurrentProject();
        for (GeometraDrawing gd : values) {
            if (!(gd instanceof SquareDrawing)) continue;
            RumNod nyNod = new RumNod(gd.getDescription());
            double scaleFactor = gd.getParent().scaleToReal(1.0);
            AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
            ArrayList<Point2D> scaledPoints = new ArrayList<Point2D>();
            for (Point2D point : gd.getPoints()) {
                scaledPoints.add(scaleTransform.transform(point, null));
            }
            ArrayList<List<Point2D>> holedrawingVerticesList = new ArrayList<List<Point2D>>();
            SquareDrawing sq = (SquareDrawing)gd;
            for (HoleDrawing hd : sq.getChildren()) {
                ArrayList<Point2D> scaledPoints2 = new ArrayList<Point2D>();
                for (Point2D point : hd.getPoints()) {
                    scaledPoints2.add(scaleTransform.transform(point, null));
                }
                holedrawingVerticesList.add(scaledPoints2);
            }
            Point2DDrawingWithHoleDrawing d = new Point2DDrawingWithHoleDrawing(scaledPoints, gd.getDescription(), holedrawingVerticesList);
            ((Drawing)d).getVariables().add(new Function("H", String.valueOf(gd.getHeight()), "H\u00f6jd"));
            String projectName2 = this.outlookBar.getProjectName();
            if (projectName2.equals("")) continue;
            FromGeometraDrawing fgd = new FromGeometraDrawing(d, (SquareDrawing)gd, projectName2);
            nyNod.setDrawing(fgd);
            this.insertNew(nyNod);
        }
        ((RumPanel)this.rum).tableGrabFocus();
    }

    @Override
    public String toString() {
        return "Exportera till eKalkyl";
    }

    void pushButton(String string) {
        JScrollPane jsp;
        Component[] components;
        TreeSplitEditor tse;
        Component leftComponent;
        JComponent visibleComponent;
        if (string.equals("fetchRowButton") && (visibleComponent = this.outlookBar.getVisibleComponent()) instanceof TreeSplitEditor && (leftComponent = (tse = (TreeSplitEditor)visibleComponent).getLeftComponent()) instanceof JScrollPane && (components = (jsp = (JScrollPane)leftComponent).getComponents()) != null) {
            for (Component comp : components) {
                Component[] components1;
                if (!(comp instanceof JViewport)) continue;
                JViewport jv = (JViewport)comp;
                for (Component c : components1 = jv.getComponents()) {
                    JTree jt;
                    TreePath selectionPath;
                    Object lastPathComponent;
                    if (!(c instanceof JTree) || !((lastPathComponent = (selectionPath = (jt = (JTree)c).getSelectionPath()).getLastPathComponent()) instanceof RumNod)) continue;
                    this.fetchRowActionPerformed(null);
                }
            }
        }
    }

    private void treeCutActionPerformed(ActionEvent evt) {
        KalkylNod nod = this.projectManager.getCurrentKalkylNod();
        if (nod.deletable()) {
            this.addUndoable(this.projectManager.getCurrentProject(), new DeleteNodeCommand(nod));
            this.deleteNode(nod);
        }
        this.setClipboardObject(nod);
    }

    private void treePasteActionPerformed(ActionEvent evt) {
        KalkylNod ny;
        if (this.getClipboardObject() != null && (ny = this.getClipboardObject().copy()) != null) {
            this.insertNew(ny);
        }
    }

    private void treeCopyActionPerformed(ActionEvent evt) {
        this.setClipboardObject(this.projectManager.getCurrentKalkylNod());
    }

    private void treeExpandAllActionPerformed(ActionEvent evt) {
        TreePath path = this.getCurrentNodeTree().getSelectionPath();
        TreeSelectListener.expandAll(this.getCurrentNodeTree(), path, !this.getCurrentNodeTree().isExpanded(path));
    }

    private void treeDeleteActionPerformed(ActionEvent evt) {
        KalkylNod nod = this.projectManager.getCurrentKalkylNod();
        if (nod.deletable()) {
            this.addUndoable(this.projectManager.getCurrentProject(), new DeleteNodeCommand(nod));
            this.deleteNode(nod);
        }
    }

    private void treeInsertCommenttopMenuInsertCommentActionPerformed(ActionEvent evt) {
        this.insertNew(new KommentarNod());
    }

    private void treeInsertLeafActionPerformed(ActionEvent evt) {
        RumNod ny = new RumNod();
        RadStruct rs = this.projectManager.getCurrentProject().getDefaultRow().copy();
        ny.CHANGE_THIS_ROW_SO_ITS_LINKED_TO_THIS_ROOM_WHEN_AND_WHERE_IT_NEED_TO_BE_SO_AND_ALSO_ADD_IT_TO_THE_ROOM(rs);
        this.insertNew(ny);
    }

    private void treeInsertBranchActionPerformed(ActionEvent evt) {
        this.insertNew(new GrenNod());
    }

    private void treeChangeName1ActionPerformed(ActionEvent evt) {
        this.getCurrentNodeTree().startEditingAtPath(this.getCurrentNodeTree().getSelectionPath());
    }

    private void insertNew(KalkylNod ny) {
        try {
            int i;
            DefaultTreeModel model = (DefaultTreeModel)this.getCurrentNodeTree().getModel();
            TreePath parentPath = this.getCurrentNodeTree().getSelectionPath();
            KalkylNod parent = parentPath == null ? (KalkylNod)model.getRoot() : (KalkylNod)parentPath.getLastPathComponent();
            if (parent.isLeaf() || parent.equals(this.getClipboardObject())) {
                parent = (KalkylNod)parent.getParent();
            }
            if (parent == model.getRoot()) {
                KalkylNod kn = (KalkylNod)model.getRoot();
                for (i = 0; i < kn.getChildCount(); ++i) {
                    if (!((KalkylNod)kn.getChildAt(i)).getBeskrivning().equals("Total")) continue;
                    parent = (KalkylNod)kn.getChildAt(i);
                }
            }
            int largestIndex = 0;
            for (i = 0; i < parent.getChildCount(); ++i) {
                KalkylNod n = (KalkylNod)parent.getChildAt(i);
                if (!n.getBeskrivning().startsWith(ny.getBeskrivning())) continue;
                if (n.getBeskrivning().equals(ny.getBeskrivning()) && largestIndex == 0) {
                    largestIndex = 1;
                    continue;
                }
                try {
                    String num = n.getBeskrivning().substring(ny.getBeskrivning().length());
                    num = num.trim();
                    num = num.substring(1);
                    num = num.substring(0, num.length() - 1);
                    int number = Integer.parseInt(num);
                    if (number <= largestIndex) continue;
                    largestIndex = number;
                    continue;
                }
                catch (StringIndexOutOfBoundsException ex) {
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            model.insertNodeInto(ny, parent, parent.getChildCount());
            ((GrenNod)parent).invalidate();
            if (largestIndex > 0) {
                ny.setBeskrivning(ny.getBeskrivning() + " (" + (largestIndex + 1) + ")");
            }
            TreePath path = new TreePath(model.getPathToRoot(ny));
            this.getCurrentNodeTree().setSelectionPath(path);
            this.getCurrentNodeTree().scrollPathToVisible(path);
            this.getCurrentNodeTree().startEditingAtPath(path);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(this, "No project open yet, please open a project");
        }
    }

    private void deleteNode(KalkylNod nod) {
        TreePath newPath = nod.getPreviousSibling() != null ? new TreePath(nod.getPreviousSibling().getPath()) : (nod.getNextSibling() != null ? new TreePath(nod.getNextSibling().getPath()) : new TreePath(((DefaultMutableTreeNode)nod.getParent()).getPath()));
        ((GrenNod)nod.getParent()).invalidate();
        ((DefaultTreeModel)this.getCurrentNodeTree().getModel()).removeNodeFromParent(nod);
        this.getCurrentNodeTree().setSelectionPath(newPath);
    }

    private File getSelectedFile() {
        Logger.getLogger("se.sjobeck").finest("FileTree selection count: " + this.fileTree.getSelectionCount());
        TreePath path = this.fileTree.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return (File)node.getUserObject();
    }

    private boolean validFileName(String s) {
        if (s == null) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fileTree.getModel().getRoot();
        return this.validFileName(s, node);
    }

    private boolean validFileName(String s, DefaultMutableTreeNode n) {
        if (((File)n.getUserObject()).getName().equals(s)) {
            StaticHelpers.warn("Det finns redan en fil som heter '" + s + "'");
            return false;
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)n.getChildAt(i);
            if (this.validFileName(s, child)) continue;
            return false;
        }
        return true;
    }

    private void filePopupPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        File selectedFile = this.getSelectedFile();
        boolean inTrash = StaticHelpers.inTrash(selectedFile);
        this.openProject.setEnabled(!inTrash && !selectedFile.isDirectory());
        this.copyProject.setEnabled(!inTrash && !selectedFile.isDirectory());
        this.sendProject.setEnabled(!inTrash && !selectedFile.isDirectory());
        this.newProject.setEnabled(!inTrash);
        this.newFolder.setEnabled(!inTrash);
        this.changeName.setEnabled(!inTrash);
        this.reverseDeletion.setEnabled(inTrash && !selectedFile.isDirectory());
    }

    private void findProjectActionPerformed(ActionEvent evt) {
        StaticHelpers.warn("Inte implementerat \u00e4n!", this);
    }

    private void changeNameActionPerformed(ActionEvent evt) {
        TreePath selectionPath = this.fileTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() == 1) {
            return;
        }
        File f = (File)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
        String fname = f.getName();
        while (fname != null && (fname.equals("") || fname.equals(f.getName()))) {
            fname = (String)JOptionPane.showInputDialog(this, "Byt namn p\u00e5 " + (f.isDirectory() ? "mapp" : "fil") + "en '" + f.getName() + "' till:", "Byt namn", -1, null, null, fname);
        }
        if (this.validFileName(fname)) {
            boolean fnurr = false;
            try {
                fnurr = ((FromServerMessage)ClientThread.sendMessage(Message.RenameFile, this.getSelectedFile(), fname)).getBoolean();
            }
            catch (Exception e) {
                fnurr = false;
            }
            if (!fnurr) {
                DialogCreator.showError("byta namn p\u00e5 fil gick fel, ring support " + this.getSelectedFile().getName(), "byta namn p\u00e5 fil fel");
                this.updateFileList();
                return;
            }
            this.alsoChangeDescription(this.getSelectedFile().getName(), fname);
        }
        this.updateFileList();
    }

    private void alsoChangeDescription(String oldFile, String newFile) {
        if (this.fileDescriptions.containsKey(oldFile)) {
            String text = this.fileDescriptions.get(oldFile);
            this.fileDescriptions.remove(oldFile);
            this.fileDescriptions.put(newFile, text);
        }
    }

    private void newFolderActionPerformed(ActionEvent evt) {
        DialogCreator.showInformation(this, "Tillf\u00e4lligt borttagen funktionalitet", "Avst\u00e4ngd funktion");
    }

    private void newProjectActionPerformed(ActionEvent evt) {
        String fname = "";
        while (fname == null || !StaticHelpers.approveStringAsFileOrDirectorySafe(fname)) {
            fname = (String)JOptionPane.showInputDialog(this, "Ange projektnamn", "Ange projektnamn", -1, null, null, this.dayFormat.format(new Date()) + " ");
            if (StaticHelpers.approveStringAsFileOrDirectorySafe(fname)) continue;
            StringBuffer g = new StringBuffer();
            for (char c : StaticHelpers.unsafe) {
                g.append(c);
            }
            DialogCreator.showInformation("<html>Dessa tecken \u00e4r inte till\u00e5tna i Projektnamn " + g.toString() + "<br> var" + " sn\u00e4ll och v\u00e4lj ett nytt projektnamn utan n\u00e5got" + " av<br> de ej till\u00e5tna tecknen</html>", "Ej till\u00e5tna tecken i projektnamn");
        }
        if (this.validFileName(fname = fname.trim())) {
            System.out.println(Thread.currentThread().getName() + " nytt projekt 1, skickar till server skapa projekt fil ");
            VirtualFile f = ((FromServerMessage)ClientThread.sendMessage(Message.GetVirtualFile, fname)).getVirtualFile();
            System.out.println(Thread.currentThread().getName() + "nytt projekt 2, g\u00f6r lite mer p\u00e5 klientsidan");
            this.newFile(f);
        }
    }

    public void dpap(ActionEvent evt) {
        this.deleteProjectActionPerformed(evt);
    }

    private void deleteProjectActionPerformed(ActionEvent evt) {
        File file = (File)((DefaultMutableTreeNode)this.fileTree.getSelectionPath().getLastPathComponent()).getUserObject();
        List<Projekt> openProjects = this.projectManager.getOpenProjects();
        Projekt currentProject = this.projectManager.getProjectByFile(file);
        System.out.println(" currentProject " + currentProject);
        for (Projekt proj : openProjects) {
            if (currentProject == null || !currentProject.equals(proj)) continue;
            DialogCreator.showInformation(this, "<html> Var sn\u00e4ll st\u00e4ng projekt " + file.getName() + "<br> innan det kan tas bort</html>", "St\u00e4ng projekt");
            return;
        }
        if (DialogCreator.showConfirm(this, "Vill du ta bort " + file.getName(), "Ta bort projekt")) {
            boolean fnurr = false;
            try {
                fnurr = ((FromServerMessage)ClientThread.sendMessage(Message.DeleteFile, file)).getBoolean();
            }
            catch (Exception e) {
                fnurr = false;
            }
            if (!fnurr) {
                DialogCreator.showError("kunde inte ta bort fil " + file.getName() + ", ring support", "Ta bort fil fel");
            }
            this.updateFileList();
        }
    }

    private void sendProjectActionPerformed(ActionEvent evt) {
        StaticHelpers.warn("Skicka filer \u00e4r inte implementerat f\u00f6r det nya serversystemet!", this);
    }

    private void copyProjectActionPerformed(ActionEvent evt) {
        File oldFile = this.getSelectedFile();
        String copyName = "Kopia av " + oldFile.getName();
        copyName = (String)JOptionPane.showInputDialog(this, "Kopiera '" + oldFile.getName() + "' till:", "Ange nytt filnamn", -1, null, null, copyName);
        if (this.validFileName(copyName)) {
            FromServerMessage fsm = (FromServerMessage)ClientThread.sendMessage(Message.CopyFile, oldFile, copyName);
            boolean fnurr = false;
            try {
                fnurr = fsm.getBoolean();
            }
            catch (Exception e) {
                fnurr = false;
            }
            if (!fnurr) {
                DialogCreator.showError("Kopiering av fil gick fel, " + oldFile.getName() + ", ring support", "Kopieringsfel");
                this.updateFileList();
                return;
            }
            this.alsoCopyDescription(oldFile, copyName);
        }
        this.updateFileList();
    }

    private void alsoCopyDescription(File oldFile, String newFileName) {
        if (this.fileDescriptions.containsKey(oldFile.getName())) {
            String text = this.fileDescriptions.get(oldFile.getName());
            this.fileDescriptions.put(newFileName, text);
        }
    }

    public void opap(ActionEvent evt) {
        this.openProjectActionPerformed(evt);
    }

    private void openProjectActionPerformed(ActionEvent evt) {
        File f;
        DefaultMutableTreeNode dmtn;
        TreePath path = this.fileTree.getSelectionPath();
        if (path != null && (dmtn = (DefaultMutableTreeNode)path.getLastPathComponent()) != null && (f = (File)dmtn.getUserObject()) != null) {
            this.openFile(f);
        }
    }

    private void checkGeometraLicense() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean giltiglicens = false;
                giltiglicens = ((FromServerMessage)ClientThread.sendMessage(Message.HasActiveGeometraLisence, new Object[0])).getBoolean();
                giltiglicens = ((FromServerMessage)ClientThread.sendMessage(Message.HasActiveGeometraLisence, new Object[0])).getBoolean();
                KalkylGUI.this.startaGeometra.setEnabled(giltiglicens);
            }
        };
        new Thread(runnable).start();
    }

    public void startGeometra() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean giltiglicens = false;
                ShowingProgressFactory spf = ShowingProgressFactory.getShowingProgressFactory();
                ShowingProgress aOnScreenDevice = spf.getAOnScreenDevice();
                aOnScreenDevice.setMessage("Kontrollerar din licens f\u00f6r Geometra");
                aOnScreenDevice.setTitle("Geometra licenskontroll");
                aOnScreenDevice.startShowing();
                JDialog jd = (JDialog)((Object)aOnScreenDevice);
                jd.pack();
                giltiglicens = ((FromServerMessage)ClientThread.sendMessage(Message.HasActiveGeometraLisence, new Object[0])).getBoolean();
                if (giltiglicens) {
                    System.out.println("startgeometra");
                    if (KalkylGUI.this.geometraFrame == null) {
                        KalkylGUI.this.geometraFrame = new JFrame("Geometra (eKalkyl)");
                        KalkylGUI.this.geometraFrame.setExtendedState(6);
                        LinkedList<ExportListener> newListeners = new LinkedList<ExportListener>();
                        newListeners.add(kalkylgui);
                        final Geometra geometra = new Geometra(KalkylGUI.this.geometraFrame, newListeners);
                        Geometra.updateSettings();
                        KalkylGUI.this.geometraFrame.removeWindowListener(geometra.getWA());
                        KalkylGUI.this.geometraFrame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                KalkylGUI.this.geometraFrame.setVisible(false);
                                geometra.closeProject();
                            }
                        });
                    }
                    KalkylGUI.this.geometraFrame.setVisible(true);
                } else {
                    DialogCreator.showInformation("Din licens f\u00f6r Geometra har g\u00e5tt ut, kontakta kundsupport", "Licens utg\u00e5ngen");
                }
                aOnScreenDevice.finishedShowing();
            }
        };
        new Thread(runnable).start();
    }

    public boolean geometraStarted() {
        return this.geometraFrame != null;
    }

    public void openFile(File f) {
        if (f != null && !f.isDirectory()) {
            this.loadQueue.submit(new OpenFile(f));
        }
    }

    public void newFile(final File f) {
        if (f != null && !f.isDirectory()) {
            this.loadQueue.submit(new Runnable(){

                @Override
                public void run() {
                    System.out.println(Thread.currentThread().getName() + "lite mer grejerna som k\u00f6rs i en annan tr\u00e5d 1");
                    Projekt projekt = new Projekt();
                    System.out.println(Thread.currentThread().getName() + "lite mer grejerna som k\u00f6rs i en annan tr\u00e5d " + "2, addproj");
                    KalkylGUI.this.addProject(f, projekt);
                    System.out.println(Thread.currentThread().getName() + "lite mer grejerna som k\u00f6rs i en annan tr\u00e5d " + "3, saveproj");
                    KalkylGUI.this.saveProject(projekt);
                    System.out.println(Thread.currentThread().getName() + "lite mer grejerna som k\u00f6rs i en annan tr\u00e5d " + "4, update filelist");
                    KalkylGUI.this.updateFileList();
                }
            });
        }
    }

    public void addProject(File f, Projekt p) {
        p.setFileReference(f);
        this.projectManager.add(p);
        JTree nodeTree = this.buildNodeTree(p);
        this.outlookBar.addBar(f.getName(), new ImageIcon(this.getClass().getResource("/org/tangoProject/medium/go-home.png")), new TreeSplitEditor(new JScrollPane(nodeTree), this.editors), this.getCloseAction(nodeTree, p));
        this.outlookBar.setVisibleBar(this.outlookBar.getBarCount() - 1);
    }

    private Runnable getCloseAction(JTree nodeTree, final Projekt p) {
        return new Runnable(){

            @Override
            public void run() {
                KalkylGUI.this.cancelAllEditors(KalkylGUI.this.editors);
                KalkylGUI.this.projectManager.remove(p);
                KalkylGUI.this.saveProject(p);
            }
        };
    }

    private void cancelAllEditors(Container container) {
        for (Component child : container.getComponents()) {
            if (child instanceof JTable && ((JTable)child).isEditing()) {
                ((JTable)child).getCellEditor().cancelCellEditing();
                continue;
            }
            if (!(child instanceof Container) || !child.isVisible()) continue;
            this.cancelAllEditors((Container)child);
        }
    }

    public void nextLeaf() {
        if (this.getCurrentNodeTree() != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getCurrentNodeTree().getSelectionPath().getLastPathComponent();
            if ((node = node.getNextLeaf()) != null) {
                this.getCurrentNodeTree().setSelectionPath(new TreePath(node.getPath()));
            }
        }
    }

    public void previousLeaf() {
        if (this.getCurrentNodeTree() != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getCurrentNodeTree().getSelectionPath().getLastPathComponent();
            if ((node = node.getPreviousLeaf()) != null) {
                this.getCurrentNodeTree().setSelectionPath(new TreePath(node.getPath()));
            }
        }
    }

    private JTree buildNodeTree(Projekt p) {
        final DNDTree nodeTree = new DNDTree(p.getRootNode(), false);
        TreeSelectionListener treeSelectionListener = this.buildNodeTreeSelectionListener(nodeTree);
        new NodeTreeTransferHandler(nodeTree, treeSelectionListener);
        nodeTree.addMouseListener(this.treeMouseListener);
        nodeTree.addTreeSelectionListener(treeSelectionListener);
        nodeTree.setCellRenderer(this.treeRenderer);
        nodeTree.setEditable(true);
        nodeTree.setCellEditor(this.buildNodeTreeEditor());
        nodeTree.setShowsRootHandles(false);
        nodeTree.setRootVisible(true);
        nodeTree.getInputMap(0).put(KeyStroke.getKeyStroke("ctrl pressed D"), "newLeaf");
        nodeTree.getInputMap(0).put(KeyStroke.getKeyStroke("ctrl pressed G"), "newBranch");
        nodeTree.getActionMap().put("newLeaf", this.nodeTreeNewLeaf);
        nodeTree.getActionMap().put("newBranch", this.nodeTreeNewBranch);
        nodeTree.getInputMap(0).put(KeyStroke.getKeyStroke("pressed F5"), "copy");
        nodeTree.getInputMap(0).put(KeyStroke.getKeyStroke("pressed F6"), "paste");
        nodeTree.getActionMap().put("copy", this.nodeTreeCopyAction);
        nodeTree.getActionMap().put("cut", this.nodeTreeCutAction);
        nodeTree.getActionMap().put("paste", this.nodeTreePasteAction);
        p.addTreeObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                nodeTree.repaint();
            }
        });
        return nodeTree;
    }

    private TreeCellEditor buildNodeTreeEditor() {
        SelectingEditor editor = new SelectingEditor(this.treeEditorTextField, true){

            @Override
            public boolean isCellEditable(EventObject e) {
                KalkylNod n = KalkylGUI.this.projectManager.getCurrentKalkylNod();
                return (e == null || e instanceof MouseEvent && ((MouseEvent)e).getClickCount() >= 3) && n.deletable();
            }
        };
        return editor;
    }

    public void setCurrentNodeTree(JTree newTree) {
        this.currentNodeTree = newTree;
    }

    public JTree getCurrentNodeTree() {
        return this.currentNodeTree;
    }

    private TreeSelectionListener buildNodeTreeSelectionListener(final JTree nodeTree) {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KalkylGUI.this.renderNodeTree(nodeTree);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProject(Projekt p) {
        ByteArrayOutputStream baos = null;
        DeflaterOutputStream dos = null;
        try {
            byte[] output;
            block32: {
                Logger.getLogger("se.sjobeck").fine("Deflating data...");
                String data = this.xstream.toXML(p);
                byte[] input = data.getBytes("UTF-8");
                baos = new ByteArrayOutputStream();
                dos = new GZIPOutputStream(baos);
                dos.write(input);
                ((GZIPOutputStream)dos).finish();
                output = baos.toByteArray();
                System.out.println("byte array output stream length: " + output.length);
                Logger.getLogger("se.sjobeck").fine("Data deflated, " + (float)output.length / (float)input.length * 100.0f + " percent of original size");
                File localFile = null;
                FileOutputStream foutMain = null;
                try {
                    Date now = new Date(System.currentTimeMillis());
                    String savePath = EkalkylPDFConfiguration.getSavePath();
                    System.out.println("SAVE PATH" + savePath);
                    File folderPath = new File(savePath + File.separator + p.getFileReference().getName());
                    if (!folderPath.exists()) {
                        folderPath.mkdirs();
                    }
                    localFile = new File(savePath + File.separator + p.getFileReference().getName() + File.separator + System.currentTimeMillis() + "_" + p.getFileReference().getName() + ".bak");
                    foutMain = new FileOutputStream(localFile);
                    foutMain.write(output);
                }
                catch (IOException ex) {
                    System.out.println("write file did not work" + localFile);
                    System.out.println("write file did not work" + ex);
                    JFileChooser jfc = new JFileChooser();
                    jfc.setFileSelectionMode(1);
                    int showDialog = jfc.showDialog(this, "V\u00e4lj plats f\u00f6r att spara backup av kalkyl");
                    if (showDialog != 0) break block32;
                    FileOutputStream fout = null;
                    try {
                        String newSavePath = jfc.getSelectedFile().getCanonicalPath();
                        File filePath = new File(newSavePath + File.separator + p.getFileReference().getName() + File.separator + System.currentTimeMillis() + "_" + p.getFileReference().getName() + ".bak");
                        File folderPath = new File(newSavePath + File.separator + p.getFileReference().getName());
                        folderPath.mkdirs();
                        EkalkylPDFConfiguration.putSavePath(newSavePath);
                        System.out.println("filePath: " + filePath);
                        System.out.println("folderPath: " + folderPath);
                        fout = new FileOutputStream(filePath);
                        fout.write(output);
                    }
                    catch (IOException err) {
                        Logger.getLogger(SettingsDialog.class.getName()).log(Level.SEVERE, null, err);
                    }
                    finally {
                        if (fout != null) {
                            System.out.println("closingf file stream");
                            fout.close();
                        }
                    }
                }
                finally {
                    if (foutMain != null) {
                        System.out.println("Closing main file stream");
                        foutMain.close();
                    }
                }
            }
            NetWorkCommunicator.writeFile(p.getFileReference().getName(), output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(KalkylGUI.class.getName()).log(Level.SEVERE, null, ex);
                    System.out.println(ex.getMessage() + " kalklgui dos.close fail");
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(KalkylGUI.class.getName()).log(Level.SEVERE, null, ex);
                    System.out.println(ex.getMessage() + " kalklgui baos.close fail");
                }
            }
        }
    }

    private void windowClosed(WindowEvent evt) {
        this.shutdown();
    }

    private void undoActionPerformed(ActionEvent evt) {
        UndoManager manager = this.undoMapping.get(this.projectManager.getCurrentProject());
        assert (manager != null && manager.canUndo());
        manager.undo();
        this.updateUndoRedo();
    }

    private void redoActionPerformed(ActionEvent evt) {
        UndoManager manager = this.undoMapping.get(this.projectManager.getCurrentProject());
        assert (manager != null && manager.canRedo());
        manager.redo();
        this.updateUndoRedo();
    }

    private void previousActionPerformed(ActionEvent evt) {
        this.jumpToLeaf(-1);
    }

    private void nextActionPerformed(ActionEvent evt) {
        this.jumpToLeaf(1);
    }

    private void cutActionPerformed(ActionEvent evt) {
        ((RumPanel)this.rum).cutRow();
    }

    private void copyActionPerformed(ActionEvent evt) {
        ((RumPanel)this.rum).copyRow();
    }

    private void pasteActionPerformed(ActionEvent evt) {
        ((RumPanel)this.rum).pasteRow();
    }

    private void insertRowActionPerformed(ActionEvent evt) {
        ((RumPanel)this.rum).insertRow();
    }

    private void deleteRowActionPerformed(ActionEvent evt) {
        ((RumPanel)this.rum).deleteRow();
    }

    private void fetchRowActionPerformed(ActionEvent evt) {
        ((RumPanel)this.rum).fetchRow();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.geometraFrame != null) {
            this.geometraFrame.toFront();
            this.geometraFrame.dispatchEvent(new WindowEvent(this.geometraFrame, 201));
            if (this.geometraFrame.isDisplayable()) {
                return;
            }
        }
        this.dispose();
    }

    private void printActionPerformed(ActionEvent evt) {
        JPopupMenu popup = this.utskrifter.getPopupMenu();
        if (popup.isVisible()) {
            popup.setVisible(false);
        } else {
            popup.show(this.print, 0, this.print.getHeight());
        }
    }

    private void startGeometra(ActionEvent evt) {
        this.startGeometra();
    }

    private void showHelpActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("https://ekalkyl.se/guide/"));
        }
        catch (Exception e) {
            System.out.println("hj\u00e4lpknappen klarar inte av att \u00f6pnna en browser");
        }
    }

    private void settingsActionPerformed(ActionEvent evt) {
        if (this.settingsDialog == null) {
            this.settingsDialog = new SettingsDialog((Frame)this, true);
        }
        this.settingsDialog.setVisible(true);
    }

    private void reverseDeletionActionPerformed(ActionEvent evt) {
        File file = (File)((DefaultMutableTreeNode)this.fileTree.getSelectionPath().getLastPathComponent()).getUserObject();
        List<Projekt> list = this.projectManager.getOpenProjects();
        Projekt p = this.projectManager.getProjectByFile(file);
        for (Projekt proj : list) {
            if (!p.equals(proj)) continue;
            this.saveProject(p);
        }
        boolean fnurr = false;
        try {
            fnurr = ((FromServerMessage)ClientThread.sendMessage(Message.ReverseDeleteFile, file)).getBoolean();
        }
        catch (Exception e) {
            fnurr = false;
        }
        if (!fnurr) {
            DialogCreator.showError("kunde inte \u00e5terst\u00e4lla fil " + file.getName() + ", ring support", "\u00c5terst\u00e4ll fil fel");
        }
        this.updateFileList();
    }

    private void jumpToLeaf(int jump) {
        Component c = this.outlookBar.getSelected();
        if (c instanceof TreeSplitEditor && (c = ((TreeSplitEditor)c).getLeftComponent()) instanceof JScrollPane && (c = ((JScrollPane)c).getComponent(0).getComponentAt(3, 3)) instanceof JTree) {
            int[] rows = ((JTree)c).getSelectionRows();
            int row = 0;
            if (rows != null && rows.length >= 1) {
                row = rows[0];
            }
            if ((row += jump) < 0) {
                row = 0;
            }
            if (row > ((JTree)c).getRowCount()) {
                row = ((JTree)c).getRowCount() - 1;
            }
            ((JTree)c).setSelectionRow(row);
        }
    }

    private void shutdown() {
        this.shutdownThread.start();
    }

    public String getDescription() {
        return "eKalkyl";
    }

    private UndoManager getUndoManager(Projekt target) {
        UndoManager manager = this.undoMapping.get(target);
        if (manager == null) {
            manager = new UndoManager();
            this.undoMapping.put(target, manager);
        }
        return manager;
    }

    public void addUndoable(Projekt target, UndoableEdit edit) {
        UndoManager manager = this.getUndoManager(target);
        manager.addEdit(edit);
        this.updateUndoRedo();
    }

    private void updateUndoRedo() {
        if (this.projectManager.getCurrentProject() != null) {
            UndoManager manager = this.getUndoManager(this.projectManager.getCurrentProject());
            if (manager.canUndo()) {
                this.undo.setToolTipText(manager.getUndoPresentationName());
                this.undo.setEnabled(true);
            } else {
                this.undo.setToolTipText(null);
                this.undo.setEnabled(false);
            }
            if (manager.canRedo()) {
                this.redo.setToolTipText(manager.getRedoPresentationName());
                this.redo.setEnabled(true);
            } else {
                this.redo.setToolTipText(null);
                this.redo.setEnabled(false);
            }
        } else {
            this.undo.setEnabled(false);
            this.redo.setEnabled(false);
        }
    }

    private class OpenFile
    implements Runnable {
        final File file;

        OpenFile(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block36: {
                Projekt proj = KalkylGUI.this.projectManager.getProjectByFile(this.file);
                if (proj != null) {
                    KalkylGUI.this.outlookBar.setVisibleBar(KalkylGUI.this.projectManager.getIndex(proj) + 2);
                } else {
                    Object o = null;
                    boolean error = false;
                    try {
                        KalkylGUI.this.log.info("\u00d6ppnar projekt...");
                        o = NetWorkCommunicator.readFile(this.file.getName());
                        KalkylGUI.this.statusLabel.repaint();
                    }
                    catch (Exception e) {
                        KalkylGUI.this.log.throwing("KalkylGUI", "openAction", e);
                        KalkylGUI.this.log.warning("Kunde inte \u00f6ppna projekt!");
                        KalkylGUI.this.statusLabel.repaint();
                        error = true;
                    }
                    finally {
                        if (error) {
                            KalkylGUI.this.log.info(" >>= `-\u00b4 =<< ");
                            KalkylGUI.this.statusLabel.repaint();
                        }
                    }
                    if (o != null) {
                        boolean lyckadesL\u00e4saIn = true;
                        try {
                            if (o instanceof byte[]) {
                                ByteArrayInputStream bais = null;
                                GZIPInputStream gzip = null;
                                try {
                                    byte[] data = (byte[])o;
                                    bais = new ByteArrayInputStream(data);
                                    gzip = new GZIPInputStream(bais);
                                    Projekt p = (Projekt)KalkylGUI.this.xstream.fromXML(gzip);
                                    KalkylGUI.this.addProject(this.file, p);
                                    KalkylGUI.this.log.info("Klar.");
                                    KalkylGUI.this.statusLabel.repaint();
                                    break block36;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    KalkylGUI.this.log.warning("Kunde inte \u00f6ppna projekt: " + this.file.getName());
                                    KalkylGUI.this.statusLabel.repaint();
                                    break block36;
                                }
                                finally {
                                    if (bais != null) {
                                        try {
                                            bais.close();
                                        }
                                        catch (IOException ex) {
                                            KalkylGUI.this.log.log(Level.SEVERE, null, ex);
                                            KalkylGUI.this.statusLabel.repaint();
                                        }
                                    }
                                    if (gzip != null) {
                                        try {
                                            gzip.close();
                                        }
                                        catch (IOException ex) {
                                            KalkylGUI.this.log.log(Level.SEVERE, null, ex);
                                            KalkylGUI.this.statusLabel.repaint();
                                        }
                                    }
                                }
                            }
                            KalkylGUI.this.log.warning("Kunde inte \u00f6ppna projekt!");
                            KalkylGUI.this.statusLabel.repaint();
                            throw new IllegalArgumentException();
                        }
                        catch (ClassCastException e) {
                            StaticHelpers.warn("Kunde inte \u00f6ppna filen.", KalkylGUI.this);
                            KalkylGUI.this.log.warning("Kunde inte \u00f6ppna projekt!");
                            KalkylGUI.this.statusLabel.repaint();
                            lyckadesL\u00e4saIn = false;
                        }
                        finally {
                            if (lyckadesL\u00e4saIn) {
                                KalkylGUI.this.log.info("Inl\u00e4sning klar: " + this.file.getName());
                                KalkylGUI.this.statusLabel.repaint();
                            }
                        }
                    }
                }
            }
        }
    }

    private class DeleteNodeCommand
    implements UndoableEdit {
        KalkylNod toDelete;

        public DeleteNodeCommand(KalkylNod toDelete) {
            this.toDelete = toDelete;
        }

        @Override
        public void undo() throws CannotUndoException {
            Logger.getLogger(this.getClass().getCanonicalName()).info("Undoing");
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void redo() throws CannotRedoException {
            Logger.getLogger(this.getClass().getCanonicalName()).info("Redoing");
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public void die() {
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            return false;
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Ta bort noden '" + this.toDelete.getBeskrivning() + "'";
        }

        @Override
        public String getUndoPresentationName() {
            return "\u00c5ngra borttagning av '" + this.toDelete.getBeskrivning() + "'";
        }

        @Override
        public String getRedoPresentationName() {
            return "G\u00f6r om borttagning av '" + this.toDelete.getBeskrivning() + "'";
        }
    }
}

