/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import se.sjobeck.gui.FunctionTableModel;
import se.sjobeck.parser2.Function;

public class FunctionEditor
extends JTextField
implements TableCellEditor {
    private Vector<CellEditorListener> listeners = new Vector();
    private FunctionTableModel model;

    FunctionEditor(FunctionTableModel model) {
        this.model = model;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Function f = this.model.getFunction(row, column);
        this.setText(f.getValueStr());
        this.selectAll();
        return this;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        Vector<CellEditorListener> list = new Vector<CellEditorListener>(this.listeners);
        for (CellEditorListener listener : list) {
            listener.editingCanceled(e);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        Vector<CellEditorListener> list = new Vector<CellEditorListener>(this.listeners);
        for (CellEditorListener listener : list) {
            listener.editingStopped(e);
        }
        return true;
    }
}

