/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import se.sjobeck.gui.KalkylGUI;
import se.sjobeck.network2.ClientThread;

public class FileTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon branchIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/x-directory-normal.png"));
    private Icon openBranchIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/x-directory-normal-open.png"));
    private Icon leafIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/go-home.png"));
    private Icon rootIcon = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/user-home.png"));
    private Icon trashIconFull = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/user-trash-full.png"));
    private Icon trashIconEmpty = new ImageIcon(KalkylGUI.class.getResource("/org/tangoProject/medium/user-trash.png"));

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon;
        String description;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.isRoot()) {
            description = ClientThread.getUserFullName();
            icon = this.rootIcon;
        } else {
            File fValue = (File)node.getUserObject();
            description = fValue.getName();
            if (fValue.getName().equals(".trash")) {
                description = "Papperskorgen";
                icon = node.getChildCount() > 0 ? this.trashIconFull : this.trashIconEmpty;
            } else {
                icon = !fValue.isDirectory() ? this.leafIcon : (expanded ? this.openBranchIcon : this.branchIcon);
            }
        }
        Component c = super.getTreeCellRendererComponent(tree, description, selected, expanded, leaf, row, hasFocus);
        ((JLabel)c).setIcon(icon);
        return c;
    }
}

