/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.kalkylering.Byggdel;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.parser2.Function;

public class RumNod
extends KalkylNod {
    private Vector<RadStruct> rader;
    private volatile Vector<Function> variabler;
    private Drawing myDrawing;
    private String statistikFormel;

    private static Vector<Function> standardVariabler() {
        Vector<Function> standardVariabler = new Vector<Function>();
        standardVariabler.add(new Function("H", "0", "H\u00f6jd"));
        standardVariabler.add(new Function("T", "B*L", "Takyta"));
        standardVariabler.add(new Function("L", "0", "L\u00e4ngd"));
        standardVariabler.add(new Function("V", "(B+L)*2*H", "V\u00e4ggyta"));
        standardVariabler.add(new Function("B", "0", "Bredd"));
        standardVariabler.add(new Function("O", "(B+L)*2", "Omkrets"));
        standardVariabler.add(new Function("G", "B*L", "Golvyta"));
        return standardVariabler;
    }

    public RumNod() {
        this("Ny del");
    }

    public RumNod(String beskrivning) {
        this.beskrivning = beskrivning;
        this.antalFormel = "1";
        this.allowsChildren = false;
        this.rader = new Vector();
        this.statistikFormel = "G";
        this.myDrawing = Drawing.standard[1].copy();
    }

    public RumNod(RumNod old) {
        super(old);
        this.myDrawing = old.myDrawing.copy();
        this.rader = new Vector();
        for (RadStruct b : old.rader) {
            RadStruct copy = b.copy();
            this.rader.add(copy);
        }
        this.statistikFormel = old.statistikFormel;
    }

    public void invalidate() {
        ((GrenNod)this.parent).invalidate();
    }

    public String getStatistikFormel() {
        return this.statistikFormel;
    }

    public void setStatistikFormel(String s) {
        this.statistikFormel = s;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean deletable() {
        return true;
    }

    public Vector<RadStruct> getRader() {
        return this.rader;
    }

    @Override
    public void update(KalkylNod n) {
        this.invalidate();
        super.update(n);
    }

    public Vector<Function> getVariabler() {
        if (this.myDrawing == null) {
            return new Vector<Function>();
        }
        return this.myDrawing.getVariables();
    }

    @Override
    public KalkylNod copy() {
        return new RumNod(this);
    }

    @Override
    public double golvYta() {
        if (this.myDrawing == null) {
            return 0.0;
        }
        for (Function f : this.myDrawing.getVariables()) {
            if (!f.getIdentifier().equals("G")) continue;
            return f.getValue(this.myDrawing.getVariables());
        }
        return 0.0;
    }

    public double takYtaPlussV\u00e4ggyta() {
        if (this.myDrawing == null) {
            return 0.0;
        }
        double fun_pito = 0.0;
        for (RadStruct r : this.rader) {
            String enhet;
            if (r.getByggdel() != Byggdel.Tak && r.getByggdel() != Byggdel.V\u00e4gg || !(enhet = this.getEnhet(r)).equals("m\u00b2")) continue;
            fun_pito += r.getAntalEnh();
        }
        return fun_pito;
    }

    @Override
    public double getAntal() {
        return Function.getValue(this.antalFormel, this.getKonstanter());
    }

    public Drawing getDrawing() {
        return this.myDrawing;
    }

    public void setDrawing(Drawing newDrawing) {
        this.myDrawing = newDrawing;
    }

    @Override
    public List<RadStruct> getPrintableRader() {
        List<RadStruct> megatom = Collections.emptyList();
        return this.okToPrint ? this.rader : megatom;
    }

    public void CHANGE_THIS_ROW_SO_ITS_LINKED_TO_THIS_ROOM_WHEN_AND_WHERE_IT_NEED_TO_BE_SO_AND_ALSO_ADD_IT_TO_THE_ROOM(RadStruct rs) {
        this.rader.add(rs);
    }
}

