/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.DrawingLine;
import se.sjobeck.datastructures.VertexDrawing;
import se.sjobeck.parser2.Function;

public class PolygonDrawing
extends VertexDrawing {
    private Polygon poly;
    private String[] label;
    private Vector<Function> variables;

    public PolygonDrawing() {
    }

    public PolygonDrawing(String desc, int[] xpoints, int[] ypoints, String[] label, Vector<Function> variables) {
        this.description = desc;
        if (xpoints.length != ypoints.length || xpoints.length != label.length) {
            throw new IllegalArgumentException("Error instatiating PolygonDrawing");
        }
        this.poly = new Polygon(xpoints, ypoints, xpoints.length);
        this.label = label;
        this.variables = variables;
    }

    @Override
    public Shape getShape() {
        return this.poly;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.poly.getBounds2D();
    }

    @Override
    public Vector<Function> getVariables() {
        return this.variables;
    }

    @Override
    public int getLabelCount() {
        return this.label.length;
    }

    @Override
    public String getLabel(int which) {
        return this.label[which];
    }

    @Override
    public Point2D getLabelPosition(int i) {
        return new Point2D.Double((double)this.poly.xpoints[i] + (double)(this.poly.xpoints[(i + 1) % this.poly.npoints] - this.poly.xpoints[i]) / 2.0, (double)this.poly.ypoints[i] + (double)(this.poly.ypoints[(i + 1) % this.poly.npoints] - this.poly.ypoints[i]) / 2.0);
    }

    @Override
    public Drawing copy() {
        Vector<Function> newVector = new Vector<Function>();
        for (Function f : this.variables) {
            newVector.add(new Function(f.getIdentifier(), f.getValueStr(), f.getDescription(), f.isPredefined()));
        }
        return new PolygonDrawing(this.description, this.poly.xpoints, this.poly.ypoints, this.label, newVector);
    }

    @Override
    public DrawingLine getLine(Point2D p, AffineTransform transform) {
        DrawingLine line = new DrawingLine();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        for (int i = 0; i < this.poly.npoints; ++i) {
            ((Point2D)p1).setLocation(this.poly.xpoints[i], this.poly.ypoints[i]);
            transform.transform(p1, p1);
            ((Point2D)p2).setLocation(this.poly.xpoints[(i + 1) % this.poly.npoints], this.poly.ypoints[(i + 1) % this.poly.npoints]);
            transform.transform(p2, p2);
            line.setLine(p1, p2);
            if (!(line.ptSegDist(p) < 5.0)) continue;
            line.variable = "V" + (i + 1);
            return line;
        }
        return null;
    }
}

