/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.parser;

import se.sjobeck.geometra.parser.ExpressionTokenizer;
import se.sjobeck.geometra.parser.Value;

public class Evaluator {
    private final ExpressionTokenizer tokenizer;
    private boolean isNegative = false;

    public Evaluator(String expr) {
        this.isNegative = expr.startsWith("-");
        if (this.isNegative) {
            expr = expr.substring(1);
        }
        expr = expr.replaceAll(",", ".");
        this.tokenizer = new ExpressionTokenizer(expr);
    }

    public Value getExprValue() {
        Value value = this.getTermValue();
        boolean done = false;
        while (!done) {
            String next = this.tokenizer.peekToken();
            if ("+".equals(next) || "-".equals(next)) {
                this.tokenizer.nextToken();
                Value value2 = this.getTermValue();
                if ("+".equals(next) && !this.isNegative || "-".equals(next) && this.isNegative) {
                    value.setValue(value.getValue() + value2.getValue());
                    continue;
                }
                value.setValue(value.getValue() - value2.getValue());
                continue;
            }
            done = true;
        }
        if (this.isNegative) {
            double newValue = value.getValue() * -1.0;
            value.setValue(newValue);
        }
        return value;
    }

    private Value getFactorValue() {
        Value value;
        String next = this.tokenizer.peekToken();
        if ("(".equals(next)) {
            this.tokenizer.nextToken();
            value = this.getExprValue();
            this.tokenizer.nextToken();
        } else {
            try {
                value = new Value(new Double(this.tokenizer.nextToken().replace(',', '.')));
            }
            catch (NullPointerException e) {
                value = new Value(0.0);
            }
        }
        return value;
    }

    private Value getTermValue() {
        Value value = this.getFactorValue();
        boolean done = false;
        while (!done) {
            String next = this.tokenizer.peekToken();
            if ("*".equals(next) || "/".equals(next)) {
                this.tokenizer.nextToken();
                Value value2 = this.getFactorValue();
                if ("*".equals(next)) {
                    value.setValue(value.getValue() * value2.getValue());
                    continue;
                }
                value.setValue(value.getValue() / value2.getValue());
                continue;
            }
            done = true;
        }
        return value;
    }
}

