/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;

public class HoleDrawing
extends GeometraDrawingImpl {
    private transient SquareDrawing owner;
    private static transient int counter = 0;
    private transient BasicStroke normalStroke = this.getStroke();

    @Override
    public Object clone() throws CloneNotSupportedException {
        HoleDrawing hd = (HoleDrawing)super.clone();
        return hd;
    }

    private BasicStroke getStroke() {
        BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{4.0f, 2.0f}, 0.0f);
        return stroke;
    }

    public SquareDrawing getOwner() {
        return this.owner;
    }

    @Override
    public void init() {
    }

    public HoleDrawing() {
    }

    public HoleDrawing(HoleDrawing hd, Point2D startPoint) {
        Point2D point = (Point2D)hd.points.get(0);
        double xDifference = startPoint.getX() - point.getX();
        double yDifference = startPoint.getY() - point.getY();
        for (Point2D p2d : hd.points) {
            double newX = p2d.getX() + xDifference;
            double newY = p2d.getY() + yDifference;
            Point2D.Double newPoint = new Point2D.Double(newX, newY);
            this.points.add(newPoint);
        }
        this.owner = hd.getOwner();
        this.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_HOLE_SHORT") + ++counter);
        this.setParent(hd.getParent());
        this.setClosed(true);
        this.setColor(Color.BLACK);
        this.buildPath();
    }

    public HoleDrawing(BlueprintPage page, SquareDrawing owner) {
        this.owner = owner;
        this.setColor(Color.BLACK);
        this.setParent(page);
        this.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_HOLE_SHORT") + ++counter);
    }

    public HoleDrawing(HoleDrawing currentDrawing, BlueprintPage page) {
        this.owner = currentDrawing.getOwner();
        this.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_HOLE_SHORT") + ++counter);
        this.setColor(Color.BLACK);
        this.setParent(page);
        this.setClosed(false);
    }

    @Override
    public void addPoint(Point2D point) {
        if (!this.isClosed) {
            this.points.add(this.componentToBlueprint(point));
            this.buildPath();
        }
    }

    @Override
    public void buildPath() {
        this.path.reset();
        if (this.points.size() > 0) {
            this.path.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
            for (Point2D point : this.points) {
                this.path.lineTo((float)point.getX(), (float)point.getY());
            }
            if (this.isClosed()) {
                this.path.closePath();
            }
        }
        this.altPath.reset();
        if (this.points.size() == 2) {
            this.altPath.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(this.points.size() - 1)).getX(), (float)((Point2D)this.points.get(0)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(this.points.size() - 1)).getX(), (float)((Point2D)this.points.get(this.points.size() - 1)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(this.points.size() - 1)).getY());
            this.altPath.closePath();
        } else if (!this.isClosed()) {
            this.altPath.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
            this.altPath.lineTo((float)((Point2D)this.points.get(this.points.size() - 1)).getX(), (float)((Point2D)this.points.get(this.points.size() - 1)).getY());
        }
        this.setCenterPoint(this.createCenterPoint());
    }

    @Override
    public void setStrokeWidth(float arg0) {
    }

    @Override
    public double getArea() {
        double sum = 0.0;
        if (this.points.size() == 2) {
            Point2D startPoint = (Point2D)this.points.get(0);
            Point2D endPoint = (Point2D)this.points.get(1);
            double drawingWidth = Math.abs(startPoint.getX() - endPoint.getX());
            double drawingHeight = Math.abs(startPoint.getY() - endPoint.getY());
            double drawingArea = drawingWidth * drawingHeight;
            return this.getParent().scaleToRealArea(Math.abs(drawingArea));
        }
        if (this.points.size() > 2) {
            for (int i = 0; i < this.points.size() - 1; ++i) {
                sum = sum + ((Point2D)this.points.get(i)).getX() * ((Point2D)this.points.get(i + 1)).getY() - ((Point2D)this.points.get(i)).getY() * ((Point2D)this.points.get(i + 1)).getX();
            }
            double lastX = ((Point2D)this.points.get(this.points.size() - 1)).getX() * ((Point2D)this.points.get(0)).getY();
            double lastY = ((Point2D)this.points.get(0)).getX() * ((Point2D)this.points.get(this.points.size() - 1)).getY();
            sum = sum + lastX - lastY;
            return this.getParent().scaleToRealArea(Math.abs(0.5 * sum));
        }
        return 0.0;
    }

    @Override
    public double getDistance() {
        double distanceSum = 0.0;
        if (!this.points.isEmpty()) {
            Point2D last = (Point2D)this.points.get(this.points.size() - 1);
            for (Point2D current : this.points) {
                distanceSum += this.getParent().scaleToReal(current.distance(last));
                last = current;
            }
        }
        return distanceSum;
    }

    @Override
    public void setParent(BlueprintPage page) {
    }

    @Override
    public BlueprintPage getParent() {
        return this.owner.getParent();
    }

    @Override
    public Line2D getLine(Point2D arg0) {
        return null;
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D arg0, BlueprintPage arg1, Rectangle arg2) {
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setColor(this.getColor());
        this.paintTheDrawing(g, base, clip);
    }

    private void paintTheDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        Stroke oldStroke = g.getStroke();
        g.setRenderingHints(GEOMETRA_RENDER_HINTS);
        g.setStroke(this.normalStroke);
        if (this.path == null) {
            this.path = new GeneralPath();
            this.altPath = new GeneralPath();
            this.buildPath();
        }
        GeneralPath p = (GeneralPath)this.path.clone();
        p.transform(base.getAffineTransform());
        if (this.isFilled) {
            g.fill(p);
        } else {
            g.draw(p);
        }
        p = (GeneralPath)this.altPath.clone();
        p.transform(base.getAffineTransform());
        g.draw(p);
        g.setStroke(oldStroke);
    }

    private Point createCenterPoint() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (Point2D point : this.points) {
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
            }
            if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        double xDistance = maxX - minX;
        double yDistance = maxY - minY;
        Double xCor = new Double(minX + xDistance / 2.0);
        Double yCor = new Double(minY + yDistance / 2.0);
        return new Point(xCor.intValue(), yCor.intValue());
    }

    @Override
    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    public void init(SquareDrawing sq) {
        this.normalStroke = this.getStroke();
        this.owner = sq;
        if (this.path == null) {
            this.path = new GeneralPath();
            this.altPath = new GeneralPath();
        }
        this.buildPath();
    }

    @Override
    public void setClosed(boolean b) {
        this.isClosed = b;
        if (this.isClosed) {
            if (this.points.size() == 2) {
                Point2D start = (Point2D)this.points.get(0);
                Point2D end = (Point2D)this.points.get(1);
                this.points.add(1, new Point2D.Double(start.getX(), end.getY()));
                this.points.add(new Point2D.Double(end.getX(), start.getY()));
            }
            this.buildPath();
        }
    }

    @Override
    public double getVolume() {
        return this.getHeight() * this.getArea();
    }

    @Override
    public double getWallSurface() {
        return this.getDistance() * this.getHeight();
    }
}

