/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.observer;

import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.blueprint.SoundManager;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.drawings.ContainerDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.gui.DialogCreator;

public class GeometraSubject {
    private static BlueprintSubject subject = BlueprintSubject.getInstance();
    private static GeometraSubject instance = new GeometraSubject();

    private GeometraSubject() {
        SoundManager manager = new SoundManager(this.getClass().getResource("/se/sjobeck/sound/MsgType.wav"));
        this.addObserver(manager);
    }

    public static GeometraSubject getInstance() {
        return instance;
    }

    public void addPoint(GeometraDrawing gd, Object source) {
        subject.callAction(BlueprintSubject.Action.ADD_POINT, gd, source);
    }

    public void addMainObserver(Observer ob) {
        subject.addMainObserver(ob);
    }

    public void addObserver(Observer ob) {
        subject.addObserver(ob);
    }

    public void add(Object ob, Object source) {
        BlueprintSubject.Action action = ob instanceof SmartDrawing ? BlueprintSubject.Action.ADD_SMART_DRAWING : BlueprintSubject.Action.ADD;
        subject.callAction(action, ob, source);
    }

    public void addPoint(Point2D point, Object source) {
        subject.callAction(BlueprintSubject.Action.ADD_POINT, point, source);
    }

    public void updateScaleDrawing(String result, Object source) {
        subject.callAction(BlueprintSubject.Action.SCALEDRAWING_UPDATE, result, source);
    }

    public void update(GeometraDrawing gd, Object source) {
        subject.callAction(BlueprintSubject.Action.UPDATE, gd, source);
    }

    public void update(GeometraCollection coll, Object source) {
        subject.callAction(BlueprintSubject.Action.UPDATE, coll, source);
    }

    public void remove(Object ob, Object source) {
        subject.callAction(BlueprintSubject.Action.REMOVE, ob, source);
    }

    public void select(Object selectedObject, Object source) {
        subject.callAction(BlueprintSubject.Action.SELECT, selectedObject, source);
    }

    public void close(GeometraDrawing gd, boolean shouldRename) {
        subject.callAction(BlueprintSubject.Action.CLOSE, gd, shouldRename);
    }

    public void disposeAll(Object source) {
        subject.callAction(BlueprintSubject.Action.DISPOSE_ALL, null, source);
    }

    public void updateRealDistance(Double realDistance, Object source) {
        subject.callAction(BlueprintSubject.Action.REAL_DISTANCE, realDistance, source);
    }

    public void dragReplace(String dragFrom, String dragTo) {
        subject.callAction(BlueprintSubject.Action.REPLACE, dragFrom, dragTo);
    }

    public void addToSmart(Object ob, SmartDrawing sd) {
        GeometraCollection<GeometraDrawing> toBeAdded = new GeometraCollection<GeometraDrawing>();
        GeometraCollection<GeometraDrawing> toSend = null;
        if (ob instanceof GeometraCollection) {
            GeometraCollection<GeometraDrawing> coll = ob;
            for (GeometraDrawing geometraDrawing : coll) {
                if (sd.contains(geometraDrawing)) continue;
                toBeAdded.add(geometraDrawing);
            }
            if (toBeAdded.size() == 0) {
                Geometra.showErrorDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_MARKED_DRAWINGS_ALREADY_EXIST_IN") + " " + sd.getDescription());
                return;
            }
            toSend = toBeAdded;
        } else if (ob instanceof GeometraDrawing) {
            if (sd.contains((GeometraDrawing)((Object)ob))) {
                Geometra.showErrorDialog(ob.toString() + " " + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_ALREADY_CONTAINS") + " " + sd.getDescription());
                return;
            }
            toSend = ob;
        }
        if (toSend instanceof GeometraDrawing) {
            if (sd.nestedContains((GeometraDrawing)((Object)toSend))) {
                return;
            }
        } else {
            GeometraCollection<GeometraDrawing> tba2 = new GeometraCollection<GeometraDrawing>();
            for (GeometraDrawing geometraDrawing : toBeAdded) {
                if (geometraDrawing instanceof ContainerDrawing) {
                    ContainerDrawing cd = (ContainerDrawing)geometraDrawing;
                    if (cd.nestedContains(sd)) {
                        String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MESSAGE_ALLREADY_CONTAINS");
                        String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TITLE_ALLREADY_CONTAINS");
                        DialogCreator.showInformation(message, title);
                        continue;
                    }
                    tba2.add(geometraDrawing);
                    continue;
                }
                tba2.add(geometraDrawing);
            }
            toSend = tba2;
        }
        subject.callAction(BlueprintSubject.Action.ADD_TO_SMART, toSend, sd);
    }

    public void removeFromSmart(GeometraDrawing gd, SmartDrawing sd) {
        subject.callAction(BlueprintSubject.Action.REMOVE_FROM_SMART, gd, sd);
    }

    public void prepareSwitch(Object ob, Object source) {
        if (ob instanceof Blueprint) {
            Blueprint bp = (Blueprint)ob;
            subject.callAction(BlueprintSubject.Action.PREPARE_SWITCH, bp, source);
        } else if (ob instanceof BlueprintPage) {
            BlueprintPage page = (BlueprintPage)ob;
            subject.callAction(BlueprintSubject.Action.PREPARE_SWITCH, page, source);
        }
    }

    public void pageSwitch(Object object, Object source) {
        if (object instanceof Blueprint) {
            Blueprint bp = (Blueprint)object;
            subject.callAction(BlueprintSubject.Action.PAGE_SWITCH, bp, source);
        } else if (object instanceof BlueprintPage) {
            BlueprintPage page = (BlueprintPage)object;
            subject.callAction(BlueprintSubject.Action.PAGE_SWITCH, page, source);
        } else if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            subject.callAction(BlueprintSubject.Action.PAGE_SWITCH, gd, source);
        }
    }

    public void listenerSwitch(PaintingStateMachine.Session listenerSession, Object source) {
        subject.callAction(BlueprintSubject.Action.LISTENER_SWITCH, (Object)listenerSession, source);
    }

    public void undo() {
        subject.callAction(BlueprintSubject.Action.UNDO, null, this);
    }

    public void redo() {
        subject.callAction(BlueprintSubject.Action.REDO, null, this);
    }

    public void zoomUpdate(float userZoom, Object source) {
        subject.callAction(BlueprintSubject.Action.ZOOM_UPDATE, Float.valueOf(userZoom), source);
    }

    public void addToTotal(GeometraCollection<GeometraDrawing> coll, TotalDrawing totalDrawing) {
        GeometraCollection<GeometraDrawing> toBeAdded = new GeometraCollection<GeometraDrawing>();
        for (GeometraDrawing gd : coll) {
            if (gd instanceof ContainerDrawing) {
                ContainerDrawing cd = (ContainerDrawing)gd;
                if (cd.nestedContains(totalDrawing)) {
                    String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MESSAGE_ALLREADY_CONTAINS");
                    String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TITLE_ALLREADY_CONTAINS");
                    DialogCreator.showInformation(message, title);
                    continue;
                }
                toBeAdded.add(gd);
                continue;
            }
            toBeAdded.add(gd);
        }
        if (toBeAdded.size() == 0) {
            Geometra.showErrorDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_MARKED_DRAWINGS_ALREADY_EXIST_IN") + " " + totalDrawing.getDescription());
            return;
        }
        subject.callAction(BlueprintSubject.Action.ADD_TO_TOTAL, toBeAdded, totalDrawing);
    }

    public void removeFromTotal(GeometraDrawing gd, TotalDrawing td) {
        subject.callAction(BlueprintSubject.Action.REMOVE_FROM_TOTAL, gd, td);
    }

    public void sort(int sortBy, Object ob) {
        subject.callAction(BlueprintSubject.Action.SORT, new Integer(sortBy), ob);
    }
}

