/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures;

import java.awt.event.MouseAdapter;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.datastructures.blueprint.listeners.ClickSelectListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.DotDrawingListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.FreeMoveListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.HoleDrawingListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.LineDrawingListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.SquareDrawingListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.TextDrawingListener;
import se.sjobeck.geometra.datastructures.blueprint.listeners.ZoomListener;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;

public class PaintingStateMachine {
    private static PaintingStateMachine instance = new PaintingStateMachine();
    private final TabManager manager = TabManager.getInstance();
    private Session currentSession = Session.SELECT;
    private MouseAdapter lastListener;
    private final GeometraSubject geoSubject = GeometraSubject.getInstance();
    private DotDrawing.DotState currentDotState = DotDrawing.DotState.SQUARE;
    private final Object syncObjectCurrentDotState = new Object();

    public static PaintingStateMachine getInstance() {
        return instance;
    }

    private PaintingStateMachine() {
    }

    public void startSession(Session session) {
        if (session != null && this.manager.getActiveController() != null) {
            switch (session) {
                case DOT: {
                    this.startDotDrawingSession();
                    break;
                }
                case SQUARE: {
                    this.startSquareDrawingSession();
                    break;
                }
                case FREE: {
                    this.startFreeMoveSession();
                    break;
                }
                case LINE: {
                    this.startLineDrawingSession();
                    break;
                }
                case SELECT: {
                    this.startSelectSession();
                    break;
                }
                case ZOOM: {
                    this.startZoomSession();
                    break;
                }
                case HOLE: {
                    this.startHoleSession();
                    break;
                }
                case RESET: {
                    this.resetSession();
                    break;
                }
                case TEXT: {
                    this.startTextSession();
                }
            }
        }
    }

    private void startTextSession() {
        System.out.println("TextSession");
        PDFController controller = this.manager.getActiveController();
        controller.enableMenu();
        TextDrawingListener listener = new TextDrawingListener(controller.getBlueprint());
        controller.removePaintingListeners();
        controller.addPaintingListener(listener, listener);
        this.currentSession = Session.TEXT;
        this.lastListener = listener;
        this.geoSubject.listenerSwitch(Session.TEXT, this);
        controller.setViewCursor(1929);
    }

    private void resetSession() {
        PDFController controller = this.manager.getActiveController();
        controller.removePaintingListeners();
        controller.setViewCursor(8);
    }

    private void startDotDrawingSession() {
        PDFController controller = this.manager.getActiveController();
        controller.enableMenu();
        DotDrawingListener listener = new DotDrawingListener(controller.getBlueprint());
        controller.removePaintingListeners();
        controller.addPaintingListener(listener, listener);
        controller.setViewCursor(1929);
        this.currentSession = Session.DOT;
        this.lastListener = listener;
        this.geoSubject.listenerSwitch(Session.DOT, this);
    }

    public FreeMoveListener startFreeMoveSession() {
        PDFController controller = this.manager.getActiveController();
        controller.disableMenu();
        FreeMoveListener listener = new FreeMoveListener(controller);
        controller.removePaintingListeners();
        controller.addPaintingListener(listener, listener);
        controller.setViewCursor(1);
        this.currentSession = Session.FREE;
        this.lastListener = listener;
        this.geoSubject.listenerSwitch(Session.FREE, this);
        return listener;
    }

    public void setViewCursor(int cursor) {
        this.manager.setViewCursor(cursor);
    }

    private void startLineDrawingSession() {
        PDFController controller = this.manager.getActiveController();
        controller.enableMenu();
        LineDrawingListener listener = new LineDrawingListener(controller.getBlueprint());
        controller.removePaintingListeners();
        controller.addPaintingListener(listener, listener);
        controller.setViewCursor(1929);
        this.currentSession = Session.LINE;
        this.lastListener = listener;
        this.geoSubject.listenerSwitch(Session.LINE, this);
    }

    private void startSelectSession() {
        PDFController controller = this.manager.getActiveController();
        if (controller != null) {
            controller.enableMenu();
            ClickSelectListener listener = new ClickSelectListener(controller.getBlueprint());
            controller.removePaintingListeners();
            controller.addPaintingListener(listener, listener);
            controller.setViewCursor(8);
            this.currentSession = Session.SELECT;
            this.lastListener = listener;
            this.geoSubject.listenerSwitch(Session.SELECT, this);
        }
    }

    public void switchPage() {
        if (this.manager.getActiveController() != null) {
            if (this.lastListener instanceof SquareDrawingListener) {
                this.startSquareDrawingSession();
            } else if (this.lastListener instanceof ZoomListener) {
                this.startZoomSession();
            } else if (this.lastListener instanceof HoleDrawingListener) {
                this.startHoleSession();
            } else if (this.lastListener instanceof ClickSelectListener) {
                this.startSelectSession();
            } else if (this.lastListener instanceof LineDrawingListener) {
                this.startLineDrawingSession();
            } else if (this.lastListener instanceof FreeMoveListener) {
                this.startFreeMoveSession();
            } else if (this.lastListener instanceof DotDrawingListener) {
                this.startDotDrawingSession();
            } else if (this.lastListener instanceof TextDrawingListener) {
                this.startTextSession();
            }
        }
    }

    private void startSquareDrawingSession() {
        PDFController controller = this.manager.getActiveController();
        controller.enableMenu();
        SquareDrawingListener listener = new SquareDrawingListener(controller.getBlueprint());
        controller.removePaintingListeners();
        controller.addPaintingListener(listener, listener);
        this.currentSession = Session.SQUARE;
        this.lastListener = listener;
        this.geoSubject.listenerSwitch(Session.SQUARE, this);
        controller.setViewCursor(1929);
    }

    private void startZoomSession() {
        PDFController controller = this.manager.getActiveController();
        controller.disableMenu();
        ZoomListener listener = new ZoomListener(controller);
        controller.removePaintingListeners();
        controller.addPaintingListener(listener, listener);
        controller.setViewCursor(3);
        this.currentSession = Session.ZOOM;
        this.lastListener = listener;
        this.geoSubject.listenerSwitch(Session.ZOOM, this);
    }

    private void startHoleSession() {
        PDFController controller = this.manager.getActiveController();
        controller.enableMenu();
        HoleDrawingListener listener = new HoleDrawingListener(controller.getBlueprint());
        controller.removePaintingListeners();
        controller.addPaintingListener(listener, listener);
        controller.setViewCursor(1929);
        this.currentSession = Session.HOLE;
        this.lastListener = listener;
        this.geoSubject.listenerSwitch(Session.HOLE, this);
    }

    public Session getSession() {
        return this.currentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DotDrawing.DotState getDotState() {
        Object object = this.syncObjectCurrentDotState;
        synchronized (object) {
            return this.currentDotState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDotState(DotDrawing.DotState ds) {
        Object object = this.syncObjectCurrentDotState;
        synchronized (object) {
            this.currentDotState = ds;
        }
    }

    public static enum Session {
        DOT,
        SQUARE,
        FREE,
        LINE,
        SELECT,
        ZOOM,
        HOLE,
        RESET,
        TEXT;

    }
}

