/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.icepdf.core.pobjects.fonts.nfont.CMap;
import org.icepdf.core.pobjects.fonts.nfont.Encoding;
import org.icepdf.core.pobjects.fonts.nfont.NFont;
import org.icepdf.core.pobjects.fonts.nfont.b.c;
import org.icepdf.core.pobjects.fonts.nfont.b.d;
import org.icepdf.core.pobjects.fonts.nfont.b.f;
import org.icepdf.core.pobjects.fonts.nfont.c.a;
import org.icepdf.core.pobjects.fonts.nfont.c.b;
import org.icepdf.core.pobjects.fonts.nfont.c.i;
import org.icepdf.core.pobjects.fonts.nfont.k;

public class NFontType1
extends k
implements Cloneable {
    private static final boolean DEBUG = false;
    public static final String FORMAT = "Type1";
    public static final String FORMAT_CFF = "CFF";
    public static final String SUBFORMAT_PFA = "PFA";
    public static final String SUBFORMAT_PFB_IBM = "PFB/IBM";
    public static final String SUBFORMAT_PFB = "PFB";
    public static final String SUBFORMAT_DECRYPTED = "decrypted";
    public static final String SUBFORMAT_CFF_CID = "CFF/CID";
    private boolean isCFF;
    public static final int PFB_00_LENGTH = 520 + "cleartomark\n".length();
    private static final int PFB_ASCII = 1;
    private static final int PFB_BINARY = 2;
    private static final int PFB_EOF = 3;
    private static final AffineTransform MATRIX_DEFAULT = new AffineTransform(0.001, 0.0, 0.0, -0.001, 0.0, 0.0);
    private static final GeneralPath GLYPH_ZERO_CONTOUR = new GeneralPath(0, 1);
    private static final int CS_HSTEM = 1;
    private static final int CS_VSTEM = 3;
    private static final int CS_VMOVETO = 4;
    private static final int CS_RLINETO = 5;
    private static final int CS_HLINETO = 6;
    private static final int CS_VLINETO = 7;
    private static final int CS_RRCURVETO = 8;
    private static final int CS_CLOSEPATH = 9;
    private static final int CS_CALLSUBR = 10;
    private static final int CS_RETURN = 11;
    private static final int CS_ESCAPE = 12;
    private static final int CS_HSBW = 13;
    private static final int CS_ENDCHAR = 14;
    private static final int CS_HSTEMHM = 18;
    private static final int CS_HINTMASK = 19;
    private static final int CS_CNTRMASK = 20;
    private static final int CS_RMOVETO = 21;
    private static final int CS_HMOVETO = 22;
    private static final int CS_VSTEMHM = 23;
    private static final int CS_RCURVELINE = 24;
    private static final int CS_RLINECURVE = 25;
    private static final int CS_VVCURVETO = 26;
    private static final int CS_HHCURVETO = 27;
    private static final int CS_SHORTINT = 28;
    private static final int CS_CALLGSUBR = 29;
    private static final int CS_VHCURVETO = 30;
    private static final int CS_HVCURVETO = 31;
    private static final int CS_ESC_DX = 32;
    private static final int CS_DIV = 44;
    private static final int CS_DOTSECTION = 32;
    private static final int CS_VSTEM3 = 33;
    private static final int CS_HSTEM3 = 34;
    private static final int CS_SEAC = 38;
    private static final int CS_SBW = 39;
    private static final int CS_CALLOTHERSUBR = 48;
    private static final int CS_POP = 49;
    private static final int CS_SETCURRENTPOINT = 65;
    private static final int CS_AND = 35;
    private static final int CS_OR = 36;
    private static final int CS_NOT = 37;
    private static final int CS_ABS = 41;
    private static final int CS_ADD = 42;
    private static final int CS_SUB = 43;
    private static final int CS_NEG = 46;
    private static final int CS_EQ = 47;
    private static final int CS_DROP = 50;
    private static final int CS_PUT = 52;
    private static final int CS_GET = 53;
    private static final int CS_IFELSE = 54;
    private static final int CS_RANDOM = 55;
    private static final int CS_MUL = 56;
    private static final int CS_SQRT = 58;
    private static final int CS_DUP = 59;
    private static final int CS_EXCH = 60;
    private static final int CS_INDEX = 61;
    private static final int CS_ROLL = 62;
    private static final int CS_HFLEX = 66;
    private static final int CS_FLEX = 67;
    private static final int CS_HFLEX1 = 68;
    private static final int CS_FLEX1 = 69;
    private static final String[] CS_NAME = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "closepath", "callsubr", "return", "escape", "hsbw", "endchar", "-Reserved-", "-Reserved-", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto", "dotsection", "vstem3", "hstem3", "and", "or", "not", "seac", "sbw", "-Reserved-", "abs", "add", "sub", "div", "-Reserved-", "neg", "eq", "callothersubr", "pop", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "setcurrentpoint", "hflex", "flex", "hflex1", "flex1"};
    private static final int R_EEXEC = 55665;
    private static final int R_CHARSTRING = 4330;
    private static final int C1 = 52845;
    private static final int C2 = 22719;
    private static final String[] CFF_SID = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    private static final int[] CHARSET_EXPERT = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    private static final int[] CHARSET_EXPERT_SUBSET = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    private static final String[] CFF_EXPERT_MAP = new String[]{".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "space", "exclamsmall", "Hungarumlautsmall", ".notdef", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "comma", "hyphen", "period", "fraction", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "colon", "semicolon", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", ".notdef", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", ".notdef", ".notdef", ".notdef", "isuperior", ".notdef", ".notdef", "lsuperior", "msuperior", "nsuperior", "osuperior", ".notdef", ".notdef", "rsuperior", "ssuperior", "tsuperior", ".notdef", "ff", "fi", "fl", "ffi", "ffl", "parenleftinferior", ".notdef", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "exclamdownsmall", "centoldstyle", "Lslashsmall", ".notdef", ".notdef", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", ".notdef", "Dotaccentsmall", ".notdef", ".notdef", "Macronsmall", ".notdef", ".notdef", "figuredash", "hypheninferior", ".notdef", ".notdef", "Ogoneksmall", "Ringsmall", "Cedillasmall", ".notdef", ".notdef", ".notdef", "onequarter", "onehalf", "threequarters", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", ".notdef", ".notdef", "zerosuperior", "onesuperior", "twosuperior", "threesuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall"};
    private static final Encoding CFF_ENCODING_STANDARD = new Encoding("CFF_Standard", a.a(CFF_SID, 0, 229));
    private static final Encoding CFF_ENCODING_EXPERT = new Encoding("CFF_Expert", CFF_EXPERT_MAP);
    private static final String[] CFF_FLOAT = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "E", "E-", null, "-"};
    private static final String[] CFF_KEYS = new String[]{"version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "escape", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX", "Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", null, null, "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", null, null, null, null, null, null, "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"};
    private static final String[] FONTINFO_KEYS = new String[]{"version", "Notice", "Copyright", "FullName", "FamilyName", "Weight", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "BaseFontName"};
    private static final Object TYPE_DELTA = new Object();
    private static final Object[] CFF_TOP_NORM = new Object[]{"", "", "", "", "", new Object[]{org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a}, null, null, null, null, null, null, null, null, null, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a, null, null, null, null, null, null, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a(100), org.icepdf.core.pobjects.fonts.nfont.c.d.a(50), org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.c, new Object[]{new Float(0.001f), org.icepdf.core.pobjects.fonts.nfont.c.c.a, org.icepdf.core.pobjects.fonts.nfont.c.c.a, new Float(0.001f), org.icepdf.core.pobjects.fonts.nfont.c.c.a, org.icepdf.core.pobjects.fonts.nfont.c.c.a}, org.icepdf.core.pobjects.fonts.nfont.c.d.b, null, null, null, null, null, null, null, null, null, null, null, null, "", "", TYPE_DELTA, null, null, null, null, null, null, null, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a(8720), null, null, null, ""};
    private static final Object[] CFF_PRIVATE_NORM = new Object[]{null, null, null, null, null, null, TYPE_DELTA, TYPE_DELTA, TYPE_DELTA, TYPE_DELTA, null, null, null, null, null, null, null, null, null, null, org.icepdf.core.pobjects.fonts.nfont.c.d.a, org.icepdf.core.pobjects.fonts.nfont.c.d.a, null, null, null, null, null, null, null, null, null, new Float(0.039625f), org.icepdf.core.pobjects.fonts.nfont.c.d.a(7), org.icepdf.core.pobjects.fonts.nfont.c.d.b, TYPE_DELTA, TYPE_DELTA, org.icepdf.core.pobjects.fonts.nfont.c.d.a, null, null, org.icepdf.core.pobjects.fonts.nfont.c.d.a, new Float(0.06), org.icepdf.core.pobjects.fonts.nfont.c.d.a};
    private static final Rectangle2D BBOX_MISSING;
    private static final float WIDTH_INVALID = Float.MIN_VALUE;
    private static final Random rand_;
    private NFontType1 ur_;
    private d ra_;
    private long raoff_;
    private org.icepdf.core.pobjects.fonts.nfont.a.a dict_;
    private byte[][][] subrs_ = null;
    private byte[][] gsubrs_ = null;
    private int gbias_ = 0;
    private byte[][] charstrings_ = null;
    private int[] charstringsoff_ = null;
    private String format_;
    private String subformat_;
    private int rights_;
    private int hint_ = -1;
    private int charstringType_;
    private int lenIV_ = 4;
    private int glyphcnt_;
    private CMap c2g_;
    private SoftReference[] paths_;
    float[] widths_ = null;
    private org.icepdf.core.pobjects.fonts.nfont.a.a[] fd_;
    private int[] fds_ = null;
    private Shape notdef_;
    private int spacech_ = Integer.MIN_VALUE;
    private int flags_;
    private int weight_;
    private AffineTransform u_;

    public NFontType1(URL uRL) {
        super(uRL);
        this.parse(c.a(uRL.openStream(), 102400L));
    }

    NFontType1(d d2, int n2, int n3) {
        super(null);
        this.ra_ = d2;
        this.ur_ = this;
        this.raoff_ = n2;
        if (n2 < 0) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        this.format_ = "OpenType";
        this.subformat_ = "none";
        try {
            this.getRA();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if ((long)n3 < 102400L) {
            this.ra_.seek(this.raoff_);
            byte[] byArray = new byte[n3];
            this.ra_.readFully(byArray);
            this.ra_.close();
            this.releaseRA();
            this.ra_ = new f(byArray, "r");
            this.raoff_ = 0L;
        }
        this.parseCFF();
        if (this.ra_ instanceof f) {
            this.ra_ = null;
        } else {
            this.releaseRA();
        }
    }

    public NFontType1(byte[] byArray) {
        super(null);
        this.parse(byArray);
    }

    private void parse(byte[] byArray) {
        if (byArray == null || byArray.length < 10) {
            throw new IllegalArgumentException("Data can not be null or have length < 10");
        }
        this.ur_ = this;
        this.format_ = FORMAT;
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[3] & 0xFF;
        if (0 <= n2 && n2 <= 10 && 0 <= n3 && n3 <= 4) {
            this.format_ = FORMAT_CFF;
            this.subformat_ = "none";
        } else if (byArray[0] == -128) {
            this.subformat_ = SUBFORMAT_PFB_IBM;
        } else {
            int n4 = NFontType1.getClen(byArray);
            if (n4 == -1) {
                throw new FontFormatException("not genuine PFB or PFA (maybe Type 3)");
            }
            if (byArray[n4] == 32) {
                this.subformat_ = SUBFORMAT_DECRYPTED;
            } else {
                this.subformat_ = SUBFORMAT_PFA;
                int n5 = n4 + 50;
                for (int i2 = n4; i2 < n5; ++i2) {
                    if (b.a((char)byArray[i2] & 0xFF)) continue;
                    this.subformat_ = SUBFORMAT_PFB;
                    break;
                }
            }
        }
        if (FORMAT_CFF == this.format_) {
            this.ra_ = new f(byArray, "r");
            this.raoff_ = 0L;
            this.parseCFF();
            this.isCFF = true;
            this.ra_ = null;
        } else if ((byArray = NFontType1.normalize(byArray))[0] == 37 && byArray[1] == 33) {
            try {
                this.parsePFB(byArray);
            }
            catch (IOException iOException) {}
        } else {
            throw new FontFormatException("no valid Type 1 nfont header (%! or 0x80)");
        }
    }

    public NFont deriveFont(float f2) {
        NFontType1 nFontType1 = (NFontType1)super.deriveFont(f2);
        nFontType1.u_ = new AffineTransform(this.m_);
        nFontType1.u_.concatenate(nFontType1.at_);
        nFontType1.u_.scale(f2, f2);
        return nFontType1;
    }

    public NFont deriveFont(AffineTransform affineTransform) {
        NFontType1 nFontType1 = (NFontType1)super.deriveFont(affineTransform);
        nFontType1.u_ = new AffineTransform(this.m_);
        nFontType1.u_.concatenate(affineTransform);
        nFontType1.u_.scale(nFontType1.size_, nFontType1.size_);
        return nFontType1;
    }

    public k deriveFont(Encoding encoding, CMap cMap) {
        if (encoding == null) {
            encoding = this.ur_.encoding_;
        }
        NFontType1 nFontType1 = (NFontType1)super.deriveFont(encoding, cMap);
        nFontType1.setEncoding(encoding);
        return nFontType1;
    }

    private void setEncoding(Encoding encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding can not be null");
        }
        this.encoding_ = encoding;
        CMap cMap = Encoding.IDENTITY == encoding ? CMap.IDENTITY : this.encoding_.mapTo(this.intrinsic_);
        this.setCID(cMap);
    }

    private void setCID(CMap cMap) {
        this.c2g_ = cMap;
        this.spacech_ = Integer.MIN_VALUE;
    }

    private void getRA() {
        if (this.ra_ == null) {
            URL uRL = this.getSource();
            if (uRL == null) {
                throw new IllegalArgumentException("null URL source");
            }
            this.ra_ = NFontType1.getMultiplex().a(this, uRL);
        }
    }

    void releaseRA() {
        if (this.ra_ != null) {
            NFontType1.getMultiplex().a(this.ra_);
            this.ra_ = null;
        }
    }

    public static int getClen(byte[] byArray) {
        byte by2;
        int n2 = a.a(byArray, i.a("eexec"));
        if (n2 == -1) {
            return -1;
        }
        n2 += 5;
        while ((by2 = byArray[n2]) == 13 || by2 == 10) {
            ++n2;
        }
        if (n2 <= 0 || byArray.length - n2 <= 0) {
            throw new IllegalStateException(n2 + ", " + byArray.length);
        }
        return n2;
    }

    private void parsePFB(byte[] byArray) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(byteArrayInputStream, 5);
        Object[] objectArray = new Object[100];
        int n2 = 0;
        org.icepdf.core.pobjects.fonts.nfont.a.a a2 = null;
        org.icepdf.core.pobjects.fonts.nfont.a.a[] aArray = new org.icepdf.core.pobjects.fonts.nfont.a.a[20];
        int n3 = 0;
        org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream);
        this.subrs_ = new byte[1][][];
        Encoding encoding = Encoding.IDENTITY;
        this.intrinsic_ = Encoding.IDENTITY;
        boolean bl2 = true;
        while ((object = org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)) != null) {
            Object[] objectArray2;
            Class<?> clazz = object.getClass();
            if (org.icepdf.core.pobjects.fonts.nfont.a.b.i == clazz) continue;
            if (org.icepdf.core.pobjects.fonts.nfont.a.b.b != clazz) {
                objectArray[n2++] = object;
                continue;
            }
            if (((String)object).startsWith("/")) {
                if ("/Encoding".equals(object)) {
                    object = org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream);
                    if ("StandardEncoding".equals(object)) {
                        org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream);
                        encoding = Encoding.ADOBE_STANDARD;
                    } else {
                        objectArray2 = new String[256];
                        Arrays.fill(objectArray2, ".notdef");
                        while ((object = org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)) != null && !"def".equals(object) && !"readonly".equals(object)) {
                            if (!"dup".equals(object) || org.icepdf.core.pobjects.fonts.nfont.a.b.e != (object = org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)).getClass()) continue;
                            int n4 = ((Number)object).intValue();
                            objectArray2[n4] = i.a(((String)org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)).substring(1));
                        }
                        encoding = new Encoding("embedded", (String[])objectArray2);
                        if (Encoding.ADOBE_STANDARD.equals(encoding)) {
                            encoding = Encoding.ADOBE_STANDARD;
                        }
                    }
                    n2 = 0;
                    continue;
                }
                if ("/Subrs".equals(object)) {
                    int n5 = ((Number)org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)).intValue();
                    this.subrs_[0] = new byte[n5][];
                    int n6 = 0;
                    while (n6 < n5) {
                        object = org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream);
                        if ("dup".equals(object)) {
                            int n7 = ((Number)org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)).intValue();
                            this.subrs_[0][n7] = this.RD(pushbackInputStream);
                            ++n6;
                            continue;
                        }
                        if (!"ND".equals(object) && !"|-".equals(object) && !"def".equals(object)) continue;
                    }
                    n2 = 0;
                    bl2 = false;
                    continue;
                }
                if ("/CharStrings".equals(object)) {
                    if (this.charstrings_ != null) {
                        throw new IllegalStateException();
                    }
                    int n8 = ((Number)org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)).intValue();
                    this.charstrings_ = new byte[n8 + 1][];
                    Object[] objectArray3 = new String[n8 + 1];
                    Arrays.fill(objectArray3, ".notdef");
                    this.glyphcnt_ = n8;
                    int n9 = 1;
                    while (n9 <= n8) {
                        object = org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream);
                        if (object == null) {
                            throw new FontFormatException("insufficient data -- probably corrupt");
                        }
                        if (org.icepdf.core.pobjects.fonts.nfont.a.b.b == object.getClass() && ((String)object).startsWith("/")) {
                            String string = ((String)object).substring(1);
                            objectArray3[n9] = string;
                            this.charstrings_[n9] = this.RD(pushbackInputStream);
                            ++n9;
                            continue;
                        }
                        if (!"end".equals(object)) continue;
                        this.glyphcnt_ = n9 - 1;
                        break;
                    }
                    this.intrinsic_ = new Encoding("induced", (String[])objectArray3);
                    n2 = 0;
                    bl2 = false;
                    continue;
                }
                objectArray[n2++] = ((String)object).substring(1);
                continue;
            }
            objectArray2 = (Object[])object;
            int n10 = 0;
            if ("definefont".equals(objectArray2)) break;
            if ("readonly".equals(objectArray2)) {
                n10 = n2;
            } else if ("[".equals(objectArray2)) {
                ArrayList<Object> arrayList = new ArrayList<Object>(10);
                int n11 = 1;
                while (n11 > 0) {
                    object = org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream);
                    if (object == null || "]".equals(object)) {
                        if (--n11 <= 0) continue;
                        arrayList.add(object);
                        continue;
                    }
                    arrayList.add(object);
                }
                objectArray[n2++] = arrayList;
                n10 = n2;
            } else if (bl2) {
                if ("dict".equals(objectArray2)) {
                    int n12 = ((Number)objectArray[n2 - 1]).intValue();
                    org.icepdf.core.pobjects.fonts.nfont.a.a a3 = new org.icepdf.core.pobjects.fonts.nfont.a.a(n12);
                    if (this.dict_ == null) {
                        this.dict_ = a3;
                    } else if (n2 >= 2) {
                        a2.put(objectArray[n2 - 2], a3);
                    }
                    a2 = a3;
                } else if ("end".equals(objectArray2)) {
                    a2 = --n3 > 0 ? aArray[n3 - 1] : this.dict_;
                } else if ("def".equals(objectArray2) && n2 >= 2) {
                    a2.put(objectArray[n2 - 2], objectArray[n2 - 1]);
                    if ("lenIV".equals(objectArray[n2 - 2])) {
                        this.lenIV_ = ((Number)objectArray[n2 - 1]).intValue();
                    }
                }
            }
            n2 = n10;
        }
        pushbackInputStream.close();
        this.charstringType_ = 1;
        if (this.charstrings_ == null) {
            this.charstrings_ = new byte[0][0];
        }
        this.setEncoding(encoding);
        this.touni_ = encoding.guessToUnicode();
        this.setup();
    }

    private byte[] RD(PushbackInputStream pushbackInputStream) {
        int n2 = pushbackInputStream.read();
        if (48 > n2 || n2 > 57) {
            throw new FontFormatException("damaged nfont: expected number (0x30..0x39) in /CharStrings RD but saw 0x" + Integer.toHexString(n2));
        }
        pushbackInputStream.unread(n2);
        int n3 = ((Number)org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream)).intValue() - this.lenIV_;
        if (n3 > 65535) {
            throw new IllegalStateException(n3 + "");
        }
        n2 = pushbackInputStream.read();
        while (n2 != 32 && n2 != 9 && n2 != 10 && n2 != 13) {
            n2 = pushbackInputStream.read();
        }
        for (int i2 = 0; i2 < this.lenIV_; ++i2) {
            pushbackInputStream.read();
        }
        byte[] byArray = new byte[n3];
        c.a((InputStream)pushbackInputStream, byArray);
        org.icepdf.core.pobjects.fonts.nfont.a.b.a(pushbackInputStream);
        return byArray;
    }

    private static void decrypt(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (byArray == null || byArray.length <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException(byArray + " " + n2 + " " + n3);
        }
        byte[] byArray2 = byArray;
        boolean bl2 = true;
        for (n5 = 0; n5 < 4; ++n5) {
            if (byArray2[n5 + n2] == 32) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return;
        }
        NFontType1.decrypt(55665, byArray2, n2, n3);
        n5 = 4;
        int n6 = a.a(byArray2, i.a("lenIV"));
        if (n6 >= 0) {
            n6 += "lenIV".length();
            while (Character.isWhitespace((char)byArray2[n6])) {
                ++n6;
            }
            n5 = 0;
            while (Character.isDigit((char)byArray2[n6])) {
                n5 = n5 * 10 + byArray2[n6] - 48;
                ++n6;
            }
        }
        for (n4 = 0; n4 < 4; ++n4) {
            byArray2[n2 + n4] = 32;
        }
        int n7 = n4 + n3 - 1;
        byte by2 = 0;
        for (n4 = n2; n4 < n7; ++n4) {
            if ((byArray2[n4] != 82 || byArray2[n4 + 1] != 68) && (byArray2[n4] != 45 || byArray2[n4 + 1] != 124) || byArray2[n4 - 1] != 32 || (by2 = byArray2[n4 - 2]) < 48 || by2 > 57) continue;
            int n8 = by2 - 48;
            int n9 = n4 - 3;
            int n10 = 10;
            while ((by2 = byArray2[n9]) >= 48 && by2 <= 57) {
                n8 += (by2 - 48) * n10;
                --n9;
                n10 *= 10;
            }
            NFontType1.decrypt(4330, byArray2, n4 += 3, n8);
            for (n9 = 0; n9 < n5; ++n9) {
                byArray2[n4 + n9] = 88;
            }
            n4 += n8;
        }
    }

    private static void encrypt(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null || byArray.length < n2 + n3 || n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException(byArray.length + "");
        }
        byte[] byArray2 = byArray;
        int n5 = n4 + n3 - 1;
        byte by2 = 0;
        for (n4 = n2; n4 < n5; ++n4) {
            if ((byArray2[n4] != 82 || byArray2[n4 + 1] != 68) && (byArray2[n4] != 45 || byArray2[n4 + 1] != 124) || byArray2[n4 - 1] != 32 || (by2 = byArray2[n4 - 2]) < 48 || by2 > 57) continue;
            int n6 = by2 - 48;
            int n7 = n4 - 3;
            int n8 = 10;
            while ((by2 = byArray2[n7]) >= 48 && by2 <= 57) {
                n6 += (by2 - 48) * n8;
                --n7;
                n8 *= 10;
            }
            NFontType1.encrypt(4330, byArray2, n4 += 3, n6);
            n4 += n6;
        }
        while (true) {
            NFontType1.encrypt(55665, byArray2, n2, n3);
            n4 = byArray2[n2] & 0xFF;
            if (n4 != 32 || n4 != 9 || n4 != 10 || n4 != 13) break;
            NFontType1.encrypt(55665, byArray2, n2, n3);
            int n9 = n2;
            byArray2[n9] = (byte)(byArray2[n9] + 1);
        }
    }

    private static void decrypt(int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3 + n4;
        for (int i2 = n3; i2 < n5; ++i2) {
            int n6 = byArray[i2] & 0xFF;
            byArray[i2] = (byte)(n6 ^ n2 >> 8);
            n2 = (n6 + n2) * 52845 + 22719 & 0xFFFF;
        }
    }

    private static void encrypt(int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3 + n4;
        for (int i2 = n3; i2 < n5; ++i2) {
            int n6 = byArray[i2] & 0xFF;
            int n7 = (n6 ^ n2 >> 8) & 0xFF;
            byArray[i2] = (byte)n7;
            n2 = (n7 + n2) * 52845 + 22719 & 0xFFFF;
        }
    }

    private void parseCFF() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        d d2 = this.ra_;
        d2.seek(this.raoff_);
        int n7 = d2.read();
        int n8 = d2.read();
        int n9 = d2.read();
        int n10 = d2.read();
        d2.seek(this.raoff_ + (long)n9);
        int[] nArray = this.readINDEX(d2);
        int n11 = nArray.length - 1;
        byte[] byArray = new byte[nArray[n11] - nArray[0]];
        d2.readFully(byArray);
        String[] stringArray = new String[n11];
        int n12 = nArray[0];
        for (int i2 = 0; i2 < n11; ++i2) {
            if (nArray[i2] - n12 <= 0 || byArray[nArray[i2] - n12] == 0) {
                stringArray[i2] = "";
                continue;
            }
            try {
                stringArray[i2] = new String(byArray, nArray[i2] - n12, nArray[i2 + 1] - nArray[i2], "US-ASCII");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (n11 != 1) {
            throw new IllegalStateException(n11 + "");
        }
        nArray = this.readINDEX(d2);
        if (nArray.length != 2) {
            throw new IllegalStateException();
        }
        this.dict_ = this.readDICT(d2, nArray[0], nArray[1] - nArray[0], new org.icepdf.core.pobjects.fonts.nfont.a.a(n11 * 4 / 3));
        org.icepdf.core.pobjects.fonts.nfont.a.a a2 = this.dict_;
        Object object = a2.a("CharstringType");
        this.charstringType_ = object != null ? ((Number)object).intValue() : 2;
        nArray = this.readINDEX(d2);
        n11 = nArray.length - 1;
        byArray = new byte[nArray[n11] - nArray[0]];
        d2.readFully(byArray);
        String[] stringArray2 = new String[n11];
        int n13 = nArray[0];
        for (n6 = 0; n6 < n11; ++n6) {
            try {
                stringArray2[n6] = new String(byArray, nArray[n6] - n13, nArray[n6 + 1] - nArray[n6], "US-ASCII");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        nArray = this.readINDEX(d2);
        n11 = nArray.length - 1;
        this.gsubrs_ = new byte[n11][];
        this.gbias_ = this.charstringType_ == 1 ? 0 : (n11 < 1240 ? 107 : (n11 < 33900 ? 1131 : 32768));
        for (n6 = 0; n6 < n11; ++n6) {
            this.gsubrs_[n6] = new byte[nArray[n6 + 1] - nArray[n6]];
            d2.readFully(this.gsubrs_[n6]);
        }
        n6 = ((Number)a2.a("CharStrings")).intValue();
        d2.seek((long)n6 + this.raoff_);
        nArray = this.readINDEX(d2);
        n13 = n11 = nArray.length - 1;
        if (d2 instanceof f) {
            this.charstrings_ = new byte[n11][];
            this.charstringsoff_ = null;
            for (int i3 = 0; i3 < n13; ++i3) {
                this.charstrings_[i3] = new byte[nArray[i3 + 1] - nArray[i3]];
                d2.readFully(this.charstrings_[i3]);
            }
        } else {
            this.charstrings_ = null;
            this.charstringsoff_ = nArray;
            d2.seek((long)nArray[n11] + this.raoff_);
        }
        this.glyphcnt_ = 0;
        for (int i4 = 0; i4 < n13; ++i4) {
            if (nArray[i4] >= nArray[i4 + 1]) continue;
            ++this.glyphcnt_;
        }
        object = a2.a("charset");
        int[] nArray2 = new int[n13];
        if (object == null || (n6 = ((Number)object).intValue()) == 0) {
            nArray2 = null;
        } else if (n6 == 1) {
            nArray2 = CHARSET_EXPERT;
        } else if (n6 == 2) {
            nArray2 = CHARSET_EXPERT_SUBSET;
        } else {
            d2.seek((long)n6 + this.raoff_);
            n5 = d2.read();
            if (n5 == 0) {
                n4 = 1;
                while (n4 < n13) {
                    nArray2[n4] = d2.read() << 8 | d2.read();
                    ++n4;
                    n6 += 2;
                }
            } else {
                if (n5 != 1 && n5 != 2) {
                    throw new IllegalStateException(n5 + "");
                }
                n4 = 1;
                while (n4 < n13) {
                    n3 = d2.read() << 8 | d2.read();
                    int n14 = n5 == 1 ? d2.read() : d2.read() << 8 | d2.read();
                    for (n2 = 0; n2 <= n14; ++n2) {
                        nArray2[n4++] = n3 + n2;
                    }
                }
            }
        }
        if (a2.a("ROS") != null) {
            this.subformat_ = SUBFORMAT_CFF_CID;
            this.parseCFF_CID(d2, a2, nArray2, stringArray2);
        } else {
            this.parseCFF_CFF(d2, a2, nArray2, stringArray2);
        }
        if (SUBFORMAT_CFF_CID != this.subformat_) {
            if (this.fd_ != null) {
                throw new IllegalStateException();
            }
            this.fd_ = new org.icepdf.core.pobjects.fonts.nfont.a.a[1];
            this.fd_[0] = this.dict_;
        }
        n5 = this.fd_.length;
        this.subrs_ = new byte[n5][][];
        n3 = n5;
        for (n4 = 0; n4 < n5; ++n4) {
            org.icepdf.core.pobjects.fonts.nfont.a.a a3 = (org.icepdf.core.pobjects.fonts.nfont.a.a)this.fd_[n4].a("Private");
            object = a3.a("Subrs");
            if (object == null) continue;
            d2.seek((long)((Number)object).intValue() + this.raoff_);
            nArray = this.readINDEX(d2);
            n11 = nArray.length - 1;
            this.subrs_[n4] = new byte[n11][];
            for (n2 = 0; n2 < n11; ++n2) {
                byte[] byArray2 = new byte[nArray[n2 + 1] - nArray[n2]];
                this.subrs_[n4][n2] = byArray2;
                d2.readFully(byArray2);
            }
        }
        this.normalizeDict(a2, CFF_KEYS, CFF_TOP_NORM, stringArray2);
        org.icepdf.core.pobjects.fonts.nfont.a.a a4 = new org.icepdf.core.pobjects.fonts.nfont.a.a(13);
        for (n3 = FONTINFO_KEYS.length - 1; n3 >= 0; --n3) {
            Object object2 = a2.b(FONTINFO_KEYS[n3]);
            if (object2 == null) continue;
            a4.put(FONTINFO_KEYS[n3], object2);
        }
        if (a4.size() > 0) {
            a2.put("FontInfo", a4);
        }
        if (SUBFORMAT_CFF_CID == this.subformat_) {
            int n15 = this.fd_.length;
            for (n3 = 0; n3 < n15; ++n3) {
                if (this.fd_[n3].a("FontName") != null) continue;
                this.fd_[n3].put("FontName", stringArray[n3]);
            }
        } else {
            if (this.dict_.a("FontName") != null) {
                throw new IllegalStateException();
            }
            this.dict_.put("FontName", stringArray[0]);
        }
        this.setup();
    }

    private void parseCFF_CFF(d d2, org.icepdf.core.pobjects.fonts.nfont.a.a a2, int[] nArray, String[] stringArray) {
        int n2;
        Encoding encoding;
        int n3;
        Object object;
        if (nArray == null) {
            this.intrinsic_ = CFF_ENCODING_STANDARD;
        } else {
            object = new String[nArray.length];
            n3 = nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                object[i2] = this.getSID(nArray[i2], stringArray);
            }
            this.intrinsic_ = new Encoding("intrinsic", (String[])object);
        }
        object = a2.a("Encoding");
        if (object == null) {
            encoding = Encoding.ADOBE_STANDARD;
        } else {
            n3 = ((Number)object).intValue();
            if (n3 == 0) {
                encoding = Encoding.ADOBE_STANDARD;
            } else if (n3 == 1) {
                encoding = CFF_ENCODING_EXPERT;
            } else {
                int n4;
                int n5;
                d2.seek((long)n3 + this.raoff_);
                n2 = d2.read();
                boolean bl2 = (n2 & 0x80) != 0;
                String[] stringArray2 = new String[256];
                boolean bl3 = false;
                if ((n2 &= 0x7F) == 0) {
                    n5 = d2.read();
                    for (n4 = 1; n4 <= n5; ++n4) {
                        stringArray2[d2.read()] = nArray != null ? this.getSID(nArray[n4], stringArray) : CFF_SID[n4];
                    }
                } else {
                    if (n2 != 1) {
                        throw new IllegalStateException();
                    }
                    n5 = d2.read();
                    int n6 = 1;
                    for (n4 = 0; n4 < n5; ++n4) {
                        int n7 = d2.read();
                        int n8 = d2.read();
                        int n9 = 0;
                        while (n9 <= n8) {
                            stringArray2[n7 + n9] = nArray != null ? this.getSID(nArray[n6], stringArray) : CFF_SID[n6];
                            ++n9;
                            ++n6;
                        }
                    }
                }
                if (bl2) {
                    n5 = d2.read();
                    n4 = 0;
                    while (n4 < n5) {
                        stringArray2[d2.read()] = this.getSID(d2.read() << 8 | d2.read(), stringArray);
                        ++n4;
                        n3 += 3;
                    }
                }
                stringArray2[0] = ".notdef";
                encoding = new Encoding("custom", stringArray2);
            }
        }
        Object[] objectArray = (Object[])a2.a("Private");
        n2 = ((Number)objectArray[1]).intValue();
        org.icepdf.core.pobjects.fonts.nfont.a.a a3 = this.readDICT(d2, n2, ((Number)objectArray[0]).intValue(), new org.icepdf.core.pobjects.fonts.nfont.a.a(13));
        this.normalizeDict(a3, CFF_KEYS, CFF_PRIVATE_NORM, stringArray);
        object = a3.a("Subrs");
        if (object != null) {
            a3.put("Subrs", org.icepdf.core.pobjects.fonts.nfont.c.d.a(((Number)object).intValue() + n2));
        }
        a2.put("Private", a3);
        this.setEncoding(encoding);
        this.touni_ = encoding.guessToUnicode();
    }

    private void parseCFF_CID(d d2, org.icepdf.core.pobjects.fonts.nfont.a.a a2, int[] nArray, String[] stringArray) {
        int n2;
        int n3;
        Object object;
        int n4;
        this.intrinsic_ = Encoding.IDENTITY;
        int n5 = ((Number)a2.a("FDArray")).intValue();
        d2.seek((long)n5 + this.raoff_);
        int[] nArray2 = this.readINDEX(d2);
        int n6 = nArray2.length - 1;
        this.fd_ = new org.icepdf.core.pobjects.fonts.nfont.a.a[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            object = this.readDICT(d2, nArray2[n4], nArray2[n4 + 1] - nArray2[n4], new org.icepdf.core.pobjects.fonts.nfont.a.a(13));
            this.normalizeDict((org.icepdf.core.pobjects.fonts.nfont.a.a)object, CFF_KEYS, CFF_TOP_NORM, stringArray);
            Object[] objectArray = (Object[])((org.icepdf.core.pobjects.fonts.nfont.a.a)object).a("Private");
            n5 = ((Number)objectArray[1]).intValue();
            n3 = ((Number)objectArray[0]).intValue();
            n2 = n5;
            org.icepdf.core.pobjects.fonts.nfont.a.a a3 = this.readDICT(d2, n5, n3, new org.icepdf.core.pobjects.fonts.nfont.a.a(13));
            this.normalizeDict(a3, CFF_KEYS, CFF_PRIVATE_NORM, stringArray);
            Object object2 = a3.a("Subrs");
            if (object2 != null) {
                a3.put("Subrs", org.icepdf.core.pobjects.fonts.nfont.c.d.a(((Number)object2).intValue() + n2));
            }
            ((org.icepdf.core.pobjects.fonts.nfont.a.a)object).put("Private", a3);
            this.fd_[n4] = object;
        }
        n4 = nArray.length;
        object = new char[n4];
        int n7 = Integer.MAX_VALUE;
        n3 = Integer.MIN_VALUE;
        for (n2 = 0; n2 < n4; ++n2) {
            int n8 = nArray[n2];
            object[n2] = (char)n8;
            if (n8 < n7) {
                n7 = n8;
                continue;
            }
            if (n8 <= n3) continue;
            n3 = n8;
        }
        this.firstch_ = n7;
        this.lastch_ = n3;
        n5 = ((Number)a2.a("FDSelect")).intValue();
        d2.seek((long)n5 + this.raoff_);
        n2 = d2.read();
        int[] nArray3 = new int[n4];
        if (n2 == 0) {
            for (int i2 = 0; i2 < n4; ++i2) {
                nArray3[i2] = d2.read();
            }
        } else {
            if (n2 != 3) {
                throw new IllegalStateException(n2 + "");
            }
            int n9 = d2.read() << 8 | d2.read();
            int n10 = d2.read() << 8 | d2.read();
            for (int i3 = 0; i3 < n9; ++i3) {
                int n11 = d2.read();
                int n12 = d2.read() << 8 | d2.read();
                for (int i4 = n10; i4 < n12; ++i4) {
                    nArray3[i4] = n11;
                }
                n10 = n12;
            }
        }
        this.fds_ = nArray3;
        this.setCID(new CMap((char[])object).reverse());
    }

    private org.icepdf.core.pobjects.fonts.nfont.a.a readDICT(d d2, int n2, int n3, org.icepdf.core.pobjects.fonts.nfont.a.a a2) {
        Object[] objectArray = new Object[256];
        int n4 = 0;
        d2.seek((long)n2 + this.raoff_);
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object;
            int n5 = d2.read();
            if (n5 <= 27) {
                String string;
                if (n4 < 1 || n5 > 21) {
                    throw new IllegalStateException();
                }
                Object object2 = object = n4 == 1 ? objectArray[0] : a.a(objectArray, 0, n4);
                if (n5 != 12) {
                    string = CFF_KEYS[n5];
                } else {
                    string = CFF_KEYS[22 + d2.read()];
                    ++i2;
                }
                if (string != null) {
                    a2.put(string, object);
                }
                n4 = 0;
                continue;
            }
            if (n5 == 28) {
                objectArray[n4++] = org.icepdf.core.pobjects.fonts.nfont.c.d.a((byte)d2.read() << 8 | d2.read());
                i2 += 2;
                continue;
            }
            if (n5 == 29) {
                objectArray[n4++] = org.icepdf.core.pobjects.fonts.nfont.c.d.a((byte)d2.read() << 24 | d2.read() << 16 | d2.read() << 8 | d2.read());
                i2 += 4;
                continue;
            }
            if (n5 == 30) {
                object = new StringBuilder(10);
                while (true) {
                    n5 = d2.read();
                    ++i2;
                    int n6 = n5 >> 4;
                    if (0 > n6 || n6 > 15) {
                        throw new IllegalStateException(Integer.toHexString(n5) + " / " + n6);
                    }
                    if (n6 == 15) break;
                    ((StringBuilder)object).append(CFF_FLOAT[n6]);
                    n6 = n5 & 0xF;
                    if (n6 == 15) break;
                    ((StringBuilder)object).append(CFF_FLOAT[n6]);
                }
                float f2 = ((StringBuilder)object).length() > 0 ? Float.parseFloat(((StringBuilder)object).toString()) : 0.0f;
                objectArray[n4++] = new Float(f2);
                continue;
            }
            if (n5 == 31) {
                throw new IllegalStateException(n5 + "");
            }
            if (n5 <= 246) {
                objectArray[n4++] = org.icepdf.core.pobjects.fonts.nfont.c.d.a(n5 - 139);
                continue;
            }
            if (n5 <= 250) {
                objectArray[n4++] = org.icepdf.core.pobjects.fonts.nfont.c.d.a((n5 - 247 << 8) + d2.read() + 108);
                ++i2;
                continue;
            }
            if (n5 <= 254) {
                objectArray[n4++] = org.icepdf.core.pobjects.fonts.nfont.c.d.a(-(n5 - 251 << 8) - d2.read() - 108);
                ++i2;
                continue;
            }
            throw new IllegalStateException(n5 + "");
        }
        return a2;
    }

    private int[] readINDEX(d d2) {
        int n2 = (int)(d2.getFilePointer() - this.raoff_);
        int n3 = d2.read() << 8 | d2.read();
        int[] nArray = new int[n3 + 1];
        if (n3 == 0) {
            return nArray;
        }
        int n4 = d2.read();
        int n5 = nArray.length;
        int n6 = n2 + 3 + (n3 + 1) * n4 - 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                n7 = n7 << 8 | d2.read();
            }
            nArray[i2] = n7 + n6;
            if (i2 == 0 || nArray[i2] >= nArray[i2 - 1]) continue;
            throw new IllegalStateException();
        }
        d2.seek((long)nArray[0] + this.raoff_);
        return nArray;
    }

    private String getSID(int n2, String[] stringArray) {
        return n2 < CFF_SID.length ? CFF_SID[n2] : stringArray[n2 - CFF_SID.length];
    }

    private void normalizeDict(org.icepdf.core.pobjects.fonts.nfont.a.a a2, String[] stringArray, Object[] objectArray, String[] stringArray2) {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            Object object = objectArray[i2];
            if (string == null || null == object) continue;
            Object object2 = a2.a(string);
            if (object2 != null) {
                Object[] objectArray2;
                if ("" == object) {
                    a2.put(string, this.getSID(((Number)object2).intValue(), stringArray2));
                    continue;
                }
                if (TYPE_DELTA != object) continue;
                if (object2 instanceof Object[]) {
                    objectArray2 = (Object[])object2;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray2 = objectArray3;
                    objectArray3[0] = object2;
                }
                Object[] objectArray4 = objectArray2;
                float f2 = 0.0f;
                int n3 = objectArray4.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    objectArray4[i3] = org.icepdf.core.pobjects.fonts.nfont.c.c.a(f2 += ((Number)objectArray4[i3]).floatValue());
                }
                continue;
            }
            if ("" == object || TYPE_DELTA == null) continue;
            a2.put(string, object);
        }
    }

    private void setup() {
        String string;
        int n2;
        int n3;
        Object object;
        Object object2;
        float[] fArray = this.getFloats(this.dict_.a("FontMatrix"));
        this.u_ = this.m_ = fArray != null ? new AffineTransform(fArray[0], fArray[1], fArray[2], -fArray[3], fArray[4], fArray[5]) : MATRIX_DEFAULT;
        Object object3 = this.dict_.a("FontBBox");
        if (object3 != null) {
            float[] fArray2 = this.getFloats(object3);
            this.bbox_ = new Rectangle2D.Double(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
        }
        if (object3 == null || this.bbox_.getWidth() < 10.0 && this.bbox_.getHeight() > 2000.0 || this.bbox_.getWidth() == 0.0 && this.bbox_.getHeight() == 0.0) {
            this.bbox_ = BBOX_MISSING;
        }
        int n4 = this.getMaxGlyphNum();
        this.paths_ = new SoftReference[n4];
        if ("OpenType" != this.getFormat()) {
            boolean bl2;
            this.widths_ = new float[n4];
            object2 = null;
            object = null;
            boolean bl3 = bl2 = FORMAT_CFF == this.getFormat();
            if (bl2) {
                n3 = this.fd_.length;
                object2 = new float[n3];
                object = new float[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    org.icepdf.core.pobjects.fonts.nfont.a.a a2 = (org.icepdf.core.pobjects.fonts.nfont.a.a)(SUBFORMAT_CFF_CID == this.subformat_ ? this.fd_[n2] : this.dict_).a("Private");
                    if (a2 == null) {
                        throw new IllegalStateException();
                    }
                    object3 = a2.a("defaultWidthX");
                    object2[n2] = object3 != null ? ((Number)object3).floatValue() : 0.0f;
                    object3 = a2.a("nominalWidthX");
                    object[n2] = object3 != null ? ((Number)object3).floatValue() : 0.0f;
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int n5;
                byte[] byArray = this.charstrings_[n3];
                if (byArray == null) continue;
                Object object4 = this.buildChar(n3, null);
                int n6 = n5 = this.fds_ == null ? 0 : this.fds_[n3];
                if (bl2) {
                    object4 = Float.MIN_VALUE == object4 ? object2[n5] : (Object)(object4 + object[n5]);
                } else if (Float.MIN_VALUE == object4) {
                    throw new IllegalStateException();
                }
                this.widths_[n3] = object4;
            }
        }
        this.flags_ = Integer.MIN_VALUE;
        this.weight_ = 400;
        this.rights_ = 131073;
        object2 = (org.icepdf.core.pobjects.fonts.nfont.a.a)this.dict_.a("FontInfo");
        if (object2 != null) {
            this.rights_ = org.icepdf.core.pobjects.fonts.nfont.i.b(((org.icepdf.core.pobjects.fonts.nfont.a.a)object2).a("Copyright") + " || " + ((org.icepdf.core.pobjects.fonts.nfont.a.a)object2).a("Notice"));
            object3 = ((org.icepdf.core.pobjects.fonts.nfont.a.a)object2).a("isFixedPitch");
            if (object3 == Boolean.TRUE || object3 instanceof Number && ((Number)object3).intValue() != 0) {
                this.flags_ |= 1;
            }
            if ((object3 = ((org.icepdf.core.pobjects.fonts.nfont.a.a)object2).a("ItalicAngle")) instanceof Number && ((Number)object3).doubleValue() != 0.0) {
                this.flags_ |= 0x40;
            }
            int n7 = this.weight_ = (object3 = ((org.icepdf.core.pobjects.fonts.nfont.a.a)object2).a("Weight")) != null ? org.icepdf.core.pobjects.fonts.nfont.i.a("name-" + object3.toString()) : 400;
        }
        if ((object = (org.icepdf.core.pobjects.fonts.nfont.a.a)this.dict_.a("Private")) != null && ((object3 = ((org.icepdf.core.pobjects.fonts.nfont.a.a)object).a("ForceBold")) == Boolean.TRUE || object3 instanceof Number && ((Number)object3).intValue() != 0)) {
            this.flags_ |= 0x40000;
        }
        if ((string = this.getFamily()).startsWith("Helvetica") || string.startsWith("Arial") || string.startsWith("URW Gothic L") || string.indexOf("Sans") > 0) {
            this.flags_ |= 2;
        }
        if (string.indexOf("Script") > 0 || string.indexOf("Handwr") > 0) {
            this.flags_ |= 8;
        }
        this.flags_ = string.startsWith("Symbol") || string.startsWith("Standard Symbols L") || string.startsWith("ZapfDingbats") || string.startsWith("Dingbats") || string.startsWith("Wingdings") || string.startsWith("Webdings") || string.indexOf("Bats") > 0 ? (this.flags_ |= 4) : (this.flags_ |= 0x20);
        n3 = 1;
        int n8 = n2 + 26;
        for (n2 = a.a((Object[])CFF_SID, "Asmall"); n2 < n8; ++n2) {
            if (this.intrinsic_.getChar(CFF_SID[n2]) != '\u0000') continue;
            n3 = 0;
            break;
        }
        if (n3 != 0) {
            this.flags_ |= 0x20000;
        }
        if (this.getName().indexOf("Condens") > 0) {
            this.flags_ |= 0x10000000;
        }
        this.notdef_ = this.canDisplayGID(0) ? this.getGlyph(0) : GLYPH_ZERO_CONTOUR;
    }

    private float[] getFloats(Object object) {
        float[] fArray;
        block5: {
            fArray = null;
            if (object == null) break block5;
            if (org.icepdf.core.pobjects.fonts.nfont.a.b.a == object.getClass()) {
                List list = (List)object;
                int n2 = list.size();
                fArray = new float[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    fArray[i2] = ((Number)list.get(i2)).floatValue();
                }
            } else {
                if (org.icepdf.core.pobjects.fonts.nfont.a.b.g != object.getClass()) {
                    throw new IllegalStateException();
                }
                Object[] objectArray = (Object[])object;
                int n3 = objectArray.length;
                fArray = new float[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    fArray[i3] = ((Number)objectArray[i3]).floatValue();
                }
            }
        }
        return fArray;
    }

    Shape getGlyph(int n2) {
        Shape shape;
        if (!this.canDisplayGID(n2)) {
            return this.notdef_;
        }
        SoftReference softReference = this.paths_[n2];
        Shape shape2 = shape = softReference != null ? (Shape)softReference.get() : null;
        if (shape == null) {
            shape = new GeneralPath(0);
            this.buildChar(n2, (GeneralPath)shape);
            this.paths_[n2] = new SoftReference<Shape>(shape);
        }
        return shape;
    }

    private float buildChar(int n2, GeneralPath generalPath) {
        return this.buildChar(n2, generalPath, null, null, 0.0f, 0.0f);
    }

    private float buildChar(int n2, GeneralPath generalPath, boolean[] blArray, boolean[] blArray2, float f2, float f3) {
        int n3;
        byte[] byArray = null;
        if (this.charstrings_ != null) {
            byArray = this.charstrings_[n2];
        } else {
            try {
                this.getRA();
                this.ra_.seek((long)this.charstringsoff_[n2] + this.raoff_);
                byArray = new byte[this.charstringsoff_[n2 + 1] - this.charstringsoff_[n2]];
                this.ra_.readFully(byArray);
            }
            catch (IOException iOException) {
                return 0.0f;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (byArray == null) {
            throw new IllegalStateException(n2 + "");
        }
        byte[][] byArray2 = this.subrs_[this.fds_ == null ? 0 : this.fds_[n2]];
        int n4 = n3 = byArray2 != null ? byArray2.length : 0;
        int n5 = this.charstringType_ == 1 ? 0 : (n3 < 1240 ? 107 : (n3 < 33900 ? 1131 : 32768));
        float f4 = Float.MIN_VALUE;
        byte[][] byArrayArray = new byte[10][];
        int[] nArray = new int[10];
        int n6 = 0;
        byArrayArray[0] = byArray;
        byte[] byArray3 = byArray;
        float[] fArray = new float[48];
        int n7 = 0;
        float[] fArray2 = new float[32];
        float[] fArray3 = new float[20];
        int n8 = 0;
        float[] fArray4 = new float[14];
        int n9 = 0;
        boolean bl2 = false;
        int n10 = 0;
        boolean bl3 = this.charstringType_ == 2;
        int n11 = 0;
        int n12 = byArray3.length;
        block53: while (n11 < n12) {
            float f5;
            int n13;
            if ((n13 = byArray3[n11++] & 0xFF) <= 31) {
                int n14;
                if (12 == n13) {
                    n13 = (byArray3[n11++] & 0xFF) + 32;
                }
                if (bl3) {
                    if (f4 != Float.MIN_VALUE) {
                        throw new IllegalStateException();
                    }
                    n14 = 0;
                    if (1 == n13 || 18 == n13 || 3 == n13 || 23 == n13 || 20 == n13 || 19 == n13 || 21 == n13 || 9 == n13) {
                        bl3 = false;
                        int n15 = n14 = (n7 & 1) == 1 ? 1 : 0;
                        if (n14 != 0) {
                            f4 = fArray[0];
                        }
                    } else if (22 == n13 || 4 == n13) {
                        bl3 = false;
                        int n16 = n14 = (n7 & 1) == 0 ? 1 : 0;
                        if (n14 != 0) {
                            f4 = fArray[0];
                        }
                    } else if (14 == n13) {
                        bl3 = false;
                        int n17 = n14 = n7 > 0 && n7 != 4 ? 1 : 0;
                        if (n14 != 0) {
                            f4 = fArray[n7 - 1];
                        }
                    }
                    if (!bl3) {
                        if (generalPath == null) {
                            n11 = n12;
                            break;
                        }
                        if (n14 != 0) {
                            System.arraycopy(fArray, 1, fArray, 0, --n7);
                        }
                    }
                }
                switch (n13) {
                    case 22: {
                        fArray[1] = 0.0f;
                    }
                    case 4: {
                        if (4 == n13) {
                            fArray[1] = fArray[0];
                            fArray[0] = 0.0f;
                            ++n7;
                        }
                    }
                    case 21: {
                        f2 += fArray[0];
                        f3 += fArray[1];
                        if (bl2) {
                            fArray4[n9++] = f2;
                            fArray4[n9++] = f3;
                        } else {
                            generalPath.moveTo(f2, f3);
                        }
                        n7 = 0;
                        break;
                    }
                    case 5: {
                        for (n14 = 0; n14 < n7; n14 += 2) {
                            generalPath.lineTo(f2 += fArray[n14], f3 += fArray[n14 + 1]);
                        }
                        n7 = 0;
                        break;
                    }
                    case 6: {
                        n14 = 0;
                        while (n14 + 2 <= n7) {
                            generalPath.lineTo(f2 += fArray[n14], f3);
                            generalPath.lineTo(f2, f3 += fArray[n14 + 1]);
                            n14 += 2;
                        }
                        if ((n7 & 1) == 1) {
                            generalPath.lineTo(f2 += fArray[n7 - 1], f3);
                        }
                        n7 = 0;
                        break;
                    }
                    case 7: {
                        n14 = 0;
                        while (n14 + 2 <= n7) {
                            generalPath.lineTo(f2, f3 += fArray[n14]);
                            generalPath.lineTo(f2 += fArray[n14 + 1], f3);
                            n14 += 2;
                        }
                        if ((n7 & 1) == 1) {
                            generalPath.lineTo(f2, f3 += fArray[n7 - 1]);
                        }
                        n7 = 0;
                        break;
                    }
                    case 8: 
                    case 24: 
                    case 25: 
                    case 67: 
                    case 69: {
                        float f6;
                        float f7;
                        float f8;
                        float f9;
                        int n18 = 0;
                        if (69 == n13) {
                            float f10 = fArray[0] + fArray[2] + fArray[4] + fArray[6] + fArray[8];
                            f5 = fArray[1] + fArray[3] + fArray[5] + fArray[7] + fArray[9];
                            if (Math.abs(f10) > Math.abs(f5)) {
                                fArray[n7++] = f5;
                            } else {
                                fArray[n7] = fArray[n7 - 1];
                                fArray[n7 - 1] = -f10;
                                ++n7;
                            }
                        }
                        if (25 == n13) {
                            int n19 = 0;
                            int n20 = n7 - 6;
                            while (n19 + 2 <= n20) {
                                generalPath.lineTo(f2 += fArray[n19], f3 += fArray[n19 + 1]);
                                n19 += 2;
                                n18 += 2;
                            }
                        }
                        int n21 = n18;
                        while (n21 + 6 <= n7) {
                            f9 = f2 + fArray[n21];
                            f8 = f3 + fArray[n21 + 1];
                            f7 = f9 + fArray[n21 + 2];
                            f6 = f8 + fArray[n21 + 3];
                            f2 = f7 + fArray[n21 + 4];
                            f3 = f6 + fArray[n21 + 5];
                            generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                            n21 += 6;
                        }
                        if (24 == n13) {
                            generalPath.lineTo(f2 += fArray[n7 - 2], f3 += fArray[n7 - 1]);
                        }
                        n7 = 0;
                        break;
                    }
                    case 27: {
                        float f6;
                        float f7;
                        float f8;
                        float f9;
                        if ((n7 & 1) == 1) {
                            f3 += fArray[0];
                        }
                        for (n14 = 0 + (n7 & 1); n14 < n7; n14 += 4) {
                            f9 = f2 + fArray[n14];
                            f8 = f3;
                            f7 = f9 + fArray[n14 + 1];
                            f6 = f8 + fArray[n14 + 2];
                            f2 = f7 + fArray[n14 + 3];
                            f3 = f6;
                            generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                        }
                        n7 = 0;
                        break;
                    }
                    case 31: {
                        float f9 = f2 + fArray[0];
                        float f8 = f3;
                        float f7 = f9 + fArray[1];
                        float f6 = f8 + fArray[2];
                        f2 = n7 == 5 ? f7 + fArray[4] : f7;
                        f3 = f6 + fArray[3];
                        generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                    }
                    case 30: {
                        float f6;
                        float f7;
                        float f8;
                        float f9;
                        int n22 = n14 = 31 == n13 ? 4 : 0;
                        while (n14 + 4 <= n7) {
                            f9 = f2;
                            f8 = f3 + fArray[n14];
                            f7 = f9 + fArray[n14 + 1];
                            f6 = f8 + fArray[n14 + 2];
                            f2 = f7 + fArray[n14 + 3];
                            f3 = n14 + 5 == n7 ? f6 + fArray[n14 + 4] : f6;
                            generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                            if ((n14 += 4) + 4 <= n7) {
                                f9 = f2 + fArray[n14];
                                f8 = f3;
                                f7 = f9 + fArray[n14 + 1];
                                f6 = f8 + fArray[n14 + 2];
                                f2 = n14 + 5 == n7 ? f7 + fArray[n14 + 4] : f7;
                                f3 = f6 + fArray[n14 + 3];
                                generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                            }
                            n14 += 4;
                        }
                        n7 = 0;
                        break;
                    }
                    case 26: {
                        float f6;
                        float f7;
                        float f8;
                        float f9;
                        if ((n7 & 1) == 1) {
                            f2 += fArray[0];
                        }
                        for (n14 = 0 + (n7 & 1); n14 < n7; n14 += 4) {
                            f9 = f2;
                            f8 = f3 + fArray[n14];
                            f7 = f9 + fArray[n14 + 1];
                            f6 = f8 + fArray[n14 + 2];
                            f2 = f7;
                            f3 = f6 + fArray[n14 + 3];
                            generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                        }
                        n7 = 0;
                        break;
                    }
                    case 66: {
                        float f11 = f3;
                        float f9 = f2 + fArray[0];
                        float f8 = f3;
                        float f7 = f9 + fArray[1];
                        float f6 = f8 + fArray[2];
                        f2 = f7 + fArray[3];
                        f3 = f6;
                        generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                        f9 = f2 + fArray[4];
                        f8 = f3;
                        f7 = f9 + fArray[5];
                        f6 = f11;
                        f2 = f7 + fArray[6];
                        f3 = f11;
                        generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                        n7 = 0;
                        break;
                    }
                    case 68: {
                        float f11 = f3;
                        float f9 = f2 + fArray[0];
                        float f8 = f3 + fArray[1];
                        float f7 = f9 + fArray[2];
                        float f6 = f8 + fArray[3];
                        f2 = f7 + fArray[4];
                        f3 = f6;
                        generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                        f9 = f2 + fArray[5];
                        f8 = f3;
                        f7 = f9 + fArray[6];
                        f6 = f8 + fArray[7];
                        f2 = f7 + fArray[8];
                        f3 = f11;
                        generalPath.curveTo(f9, f8, f7, f6, f2, f3);
                        n7 = 0;
                        break;
                    }
                    case 14: {
                        if (n7 == 4) {
                            this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[2])), generalPath, blArray, blArray2, 0.0f, 0.0f);
                            this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[3])), generalPath, blArray, blArray2, fArray[0], fArray[1]);
                        }
                        n11 = n12;
                        n7 = 0;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 18: 
                    case 23: {
                        if (n7 % 2 != 0) {
                            throw new IllegalStateException();
                        }
                        n10 += n7 / 2;
                        n7 = 0;
                        break;
                    }
                    case 19: 
                    case 20: {
                        if (n7 > 0) {
                            n10 += n7 / 2;
                        }
                        n11 += (n10 + 7) / 8;
                        n7 = 0;
                        break;
                    }
                    case 41: {
                        if (!((double)fArray[n7 - 1] < 0.0)) continue block53;
                        fArray[n7 - 1] = -fArray[n7 - 1];
                        break;
                    }
                    case 42: {
                        int n23 = n7 - 2;
                        fArray[n23] = fArray[n23] + fArray[n7 - 1];
                        --n7;
                        break;
                    }
                    case 43: {
                        int n24 = n7 - 2;
                        fArray[n24] = fArray[n24] - fArray[n7 - 1];
                        --n7;
                        break;
                    }
                    case 44: {
                        int n25 = n7 - 2;
                        fArray[n25] = fArray[n25] / fArray[n7 - 1];
                        --n7;
                        break;
                    }
                    case 46: {
                        fArray[n7 - 1] = -fArray[n7 - 1];
                        break;
                    }
                    case 55: {
                        float f11 = rand_.nextFloat();
                        fArray[n7++] = f11 > 0.0f ? f11 : 1.0E-6f;
                        break;
                    }
                    case 56: {
                        int n26 = n7 - 2;
                        fArray[n26] = fArray[n26] * fArray[n7 - 1];
                        --n7;
                        break;
                    }
                    case 58: {
                        fArray[n7 - 1] = (float)Math.sqrt(fArray[n7 - 1]);
                        break;
                    }
                    case 50: {
                        --n7;
                        break;
                    }
                    case 60: {
                        float f11 = fArray[n7 - 2];
                        fArray[n7 - 2] = fArray[n7 - 1];
                        fArray[n7 - 1] = f11;
                        break;
                    }
                    case 61: {
                        int n27 = (int)fArray[n7 - 1];
                        fArray[n7 - 1] = n27 >= 0 ? fArray[n7 - 1 - 1 - n27] : fArray[n7 - 1 - 1];
                        break;
                    }
                    case 62: {
                        int n28;
                        float f11;
                        n14 = (int)fArray[n7 - 2];
                        int n29 = (int)fArray[n7 - 1];
                        if (n14 <= 0 || n29 <= 0) continue block53;
                        int n30 = n7 - 2;
                        int n31 = n28;
                        int n32 = n31 + n29 % n14;
                        for (n28 = n7 - 2 - n14; n28 < n30; ++n28) {
                            f11 = fArray[n28];
                            fArray[n28] = fArray[n32];
                            fArray[n32] = f11;
                            if (++n32 != n30) continue;
                            n32 = n31;
                        }
                        continue block53;
                    }
                    case 59: {
                        fArray[n7] = fArray[n7 - 1];
                        ++n7;
                        break;
                    }
                    case 52: {
                        fArray2[(int)fArray[n7 - 1]] = fArray[n7 - 2];
                        n7 -= 2;
                        break;
                    }
                    case 53: {
                        fArray[n7 - 1] = fArray2[(int)fArray[n7 - 1]];
                        break;
                    }
                    case 35: {
                        fArray[n7 - 2] = fArray[n7 - 2] != 0.0f && fArray[n7 - 1] != 0.0f ? 1.0f : 0.0f;
                        --n7;
                        break;
                    }
                    case 36: {
                        fArray[n7 - 2] = fArray[n7 - 2] != 0.0f || fArray[n7 - 1] != 0.0f ? 1.0f : 0.0f;
                        --n7;
                        break;
                    }
                    case 37: {
                        fArray[n7 - 1] = fArray[n7 - 1] == 0.0f ? 1.0f : 0.0f;
                        break;
                    }
                    case 47: {
                        fArray[n7 - 2] = fArray[n7 - 2] == fArray[n7 - 1] ? 1.0f : 0.0f;
                        --n7;
                        break;
                    }
                    case 54: {
                        if (fArray[n7 - 2] > fArray[n7 - 1]) {
                            fArray[n7 - 4] = fArray[n7 - 3];
                        }
                        n7 -= 3;
                        break;
                    }
                    case 10: {
                        if (n7 < 1) {
                            throw new IllegalStateException(n7 + "");
                        }
                        int n27 = (int)fArray[n7 - 1];
                        --n7;
                        byArrayArray[n6] = byArray3;
                        nArray[n6] = n11;
                        ++n6;
                        if (blArray != null) {
                            blArray[n27 + n5] = true;
                        }
                        byArray3 = byArray2[n27 + n5];
                        n11 = 0;
                        n12 = byArray3.length;
                        break;
                    }
                    case 29: {
                        byArrayArray[n6] = byArray3;
                        nArray[n6] = n11;
                        ++n6;
                        int n27 = (int)fArray[n7 - 1];
                        --n7;
                        if (blArray2 != null) {
                            blArray2[n27 + this.gbias_] = true;
                        }
                        byArray3 = this.gsubrs_[n27 + this.gbias_];
                        n11 = 0;
                        n12 = byArray3.length;
                        break;
                    }
                    case 11: {
                        byArray3 = byArrayArray[--n6];
                        n11 = nArray[n6];
                        n12 = byArray3.length;
                        break;
                    }
                    case 13: {
                        f2 += fArray[0];
                        f4 = fArray[1];
                        if (generalPath == null) {
                            n11 = n12;
                        }
                        n7 = 0;
                        break;
                    }
                    case 39: {
                        if (n7 != 4) {
                            throw new IllegalStateException(n7 + "");
                        }
                        f2 += fArray[0];
                        f3 = fArray[1];
                        f4 = fArray[2];
                        if (generalPath == null) {
                            n11 = n12;
                        }
                        n7 = 0;
                        break;
                    }
                    case 9: {
                        if (generalPath.getCurrentPoint() != null) {
                            generalPath.closePath();
                        }
                        n7 = 0;
                        break;
                    }
                    case 32: 
                    case 33: 
                    case 34: {
                        n7 = 0;
                        break;
                    }
                    case 48: {
                        int n28;
                        float f11 = fArray[n7 - 1];
                        int n27 = n7 - 2 - (int)fArray[n7 - 2];
                        n8 = 0;
                        for (n28 = n7 - 3; n28 >= n27; --n28) {
                            fArray3[n8++] = fArray[n28];
                        }
                        n7 = n27;
                        n27 = (int)f11;
                        if (n27 == 0) {
                            --n8;
                            if (!bl2) continue block53;
                            if (n9 != 14) {
                                throw new IllegalStateException(n9 + "");
                            }
                            generalPath.curveTo(fArray4[2], fArray4[3], fArray4[4], fArray4[5], fArray4[6], fArray4[7]);
                            generalPath.curveTo(fArray4[8], fArray4[9], fArray4[10], fArray4[11], fArray4[12], fArray4[13]);
                            bl2 = false;
                            break;
                        }
                        if (n27 == 1) {
                            if (bl2) {
                                throw new IllegalStateException();
                            }
                            n9 = 0;
                            bl2 = true;
                            break;
                        }
                        if (n27 != 2 && n27 != 3) continue block53;
                        break;
                    }
                    case 49: {
                        fArray[n7++] = fArray3[--n8];
                        break;
                    }
                    case 65: {
                        if (n7 != 2) {
                            throw new IllegalStateException();
                        }
                        f2 = fArray[0];
                        f3 = fArray[1];
                        n7 = 0;
                        break;
                    }
                    case 38: {
                        if (n7 != 5) {
                            throw new IllegalStateException();
                        }
                        this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[3])), generalPath, blArray, blArray2, 0.0f, 0.0f);
                        this.buildChar(this.intrinsic_.getChar(Encoding.ADOBE_STANDARD.getName((char)fArray[4])), generalPath, blArray, blArray2, fArray[1] - fArray[0], fArray[2]);
                        n7 = 0;
                        break;
                    }
                    case 28: {
                        fArray[n7++] = byArray3[n11] << 8 | byArray3[n11 + 1] & 0xFF;
                        n11 += 2;
                        break;
                    }
                    default: {
                        n7 = 0;
                    }
                }
                continue;
            }
            if (n13 <= 246) {
                fArray[n7++] = n13 - 139;
                continue;
            }
            if (n13 <= 250) {
                fArray[n7++] = (n13 - 247 << 8) + (byArray3[n11++] & 0xFF) + 108;
                continue;
            }
            if (n13 <= 254) {
                fArray[n7++] = -(n13 - 251 << 8) - (byArray3[n11++] & 0xFF) - 108;
                continue;
            }
            if (this.charstringType_ == 2) {
                float f12 = byArray3[n11] << 8 | byArray3[n11 + 1] & 0xFF;
                f5 = (float)((byArray3[n11 + 2] & 0xFF) << 8 | byArray3[n11 + 3] & 0xFF) / 65536.0f;
                fArray[n7++] = f12 + (f12 >= 0.0f ? f5 : -f5);
            } else {
                fArray[n7++] = (byArray3[n11] & 0xFF) << 24 | (byArray3[n11 + 1] & 0xFF) << 16 | (byArray3[n11 + 2] & 0xFF) << 8 | byArray3[n11 + 3] & 0xFF;
            }
            n11 += 4;
        }
        if (n10 > 0) {
            this.hint_ = 1;
        }
        if (generalPath != null && generalPath.getCurrentPoint() == null) {
            generalPath.moveTo(f4, 0.0f);
        }
        return f4;
    }

    public String getName() {
        Object object = (SUBFORMAT_CFF_CID == this.getFormat() ? this.fd_[0] : this.dict_).a("FontName");
        org.icepdf.core.pobjects.fonts.nfont.a.a a2 = (org.icepdf.core.pobjects.fonts.nfont.a.a)this.dict_.a("FontInfo");
        if (object == null) {
            object = a2.a("FullName");
        }
        if (object == null) {
            object = a2.a("BaseFontName");
        }
        return object != null ? object.toString() : "[no name]";
    }

    public String getFamily() {
        Object object = null;
        org.icepdf.core.pobjects.fonts.nfont.a.a a2 = (org.icepdf.core.pobjects.fonts.nfont.a.a)this.dict_.a("FontInfo");
        if (a2 != null) {
            object = a2.a("FamilyName");
        }
        return object != null ? object.toString() : "[no family]";
    }

    public String getCopyright() {
        Object object = null;
        org.icepdf.core.pobjects.fonts.nfont.a.a a2 = (org.icepdf.core.pobjects.fonts.nfont.a.a)this.dict_.a("FontInfo");
        if (a2 != null && (object = a2.a("Copyright")) == null) {
            object = a2.a("Notice");
        }
        return object != null ? object.toString() : null;
    }

    public String getVersion() {
        org.icepdf.core.pobjects.fonts.nfont.a.a a2 = (org.icepdf.core.pobjects.fonts.nfont.a.a)this.dict_.a("FontInfo");
        Object object = a2 != null ? a2.a("version") : null;
        return object != null ? object.toString() : super.getVersion();
    }

    public String getFormat() {
        return this.format_;
    }

    public String getSubformat() {
        return this.subformat_;
    }

    public int getRights() {
        return this.rights_;
    }

    public int getFlags() {
        return this.flags_;
    }

    public int getWeight() {
        return this.weight_;
    }

    public boolean isHinted() {
        if (this.hint_ == -1) {
            this.hint_ = 0;
            int n2 = this.getMaxGlyphNum();
            for (int i2 = 1; i2 < n2 && this.hint_ != 1; ++i2) {
                this.getGlyph(i2);
            }
            this.releaseRA();
        }
        return this.hint_ == 1;
    }

    public int getPaintType() {
        Object object = this.dict_.a("PaintType");
        return object instanceof Number ? ((Number)object).intValue() : 0;
    }

    public int getCharstringType() {
        return this.charstringType_;
    }

    public int getNumGlyphs() {
        return this.glyphcnt_;
    }

    public int getMaxGlyphNum() {
        return this.charstrings_ != null ? this.charstrings_.length : this.charstringsoff_.length - 1;
    }

    public boolean canDisplayEchar(char c2) {
        return this.canDisplayGID(this.c2g_.toSelector(c2, this.isCFF));
    }

    private boolean canDisplayGID(int n2) {
        return n2 < this.getMaxGlyphNum() && (this.charstrings_ == null || this.charstrings_[n2] != null);
    }

    public char getSpaceEchar() {
        if (this.spacech_ == Integer.MIN_VALUE) {
            char c2;
            char c3;
            this.spacech_ = this.encoding_ != null && "space".equals(this.encoding_.getName(32)) && this.canDisplayEchar(' ') ? 32 : (this.touni_ != null ? (int)this.touni_.fromSelector(' ') : (this.encoding_ != null && (c3 = this.encoding_.getChar("space")) != '\u0000' && this.canDisplayEchar(c3) ? (int)c3 : ((c2 = this.c2g_.toSelector(' ')) != '\u0000' && this.canDisplayGID(c2) && ((GeneralPath)this.getGlyph(c2)).getPathIterator(new AffineTransform()).isDone() ? 32 : 65534)));
        }
        return (char)this.spacech_;
    }

    public Point2D echarAdvance(char c2) {
        char c3 = this.c2g_.toSelector(c2);
        double d2 = 0.0;
        if (this.newwidths_ != null && this.firstch_ <= c2 && c2 <= this.lastch_) {
            d2 = (double)this.newwidths_[c2 - this.firstch_] * 0.001;
        } else if (this.widths_ != null && c3 >= '\u0000' && c3 < this.widths_.length) {
            d2 = (double)this.widths_[c3] * this.m_.getScaleX();
        }
        double d3 = d2 * (double)this.size_ * this.at_.getScaleX();
        double d4 = d2 * (double)this.size_ * this.at_.getShearY();
        return new Point2D.Double(d3, d4);
    }

    public Rectangle2D getEstringBounds(String string, int n2, int n3) {
        Cloneable cloneable;
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0000' || c2 >= this.getMaxGlyphNum()) continue;
            cloneable = this.getGlyph(c2).getBounds2D();
            ((Rectangle2D)cloneable).setRect(d2 + ((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight());
            rectangle2D = rectangle2D.createUnion((Rectangle2D)cloneable);
            d2 += (double)this.widths_[c2];
        }
        this.releaseRA();
        AffineTransform affineTransform = new AffineTransform(this.m_);
        affineTransform.concatenate(this.at_);
        affineTransform.scale(this.size_, -this.size_);
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        cloneable = new Point2D.Double(rectangle2D.getWidth(), rectangle2D.getHeight());
        affineTransform.transform(double_, double_);
        affineTransform.transform((Point2D)cloneable, (Point2D)cloneable);
        rectangle2D.setRect(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)cloneable).getX(), ((Point2D)cloneable).getY());
        return rectangle2D;
    }

    public void drawString(Graphics2D graphics2D, String string, float f2, float f3) {
        this.drawEstring(graphics2D, this.fromUnicode(string), f2, f3, 1056L, this.getPaintType(), null);
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f2, float f3, long l2, int n2, Color color) {
        if (string == null) {
            throw new IllegalStateException();
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(f2, f3);
        graphics2D.transform(this.u_);
        Color color2 = graphics2D.getColor();
        BasicStroke basicStroke = null;
        if (1 == n2 || 2 == n2 || 5 == n2 || 6 == n2) {
            basicStroke = (BasicStroke)graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke((float)((double)basicStroke.getLineWidth() / Math.sqrt(Math.abs(this.u_.getDeterminant()))), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
        }
        boolean bl2 = 0 == n2 && this.newwidths_ == null;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            double d2;
            char c2 = string.charAt(i2);
            char c3 = this.c2g_.toSelector(c2);
            Shape shape = this.getGlyph(c3);
            if (shape == this.notdef_) {
                c3 = '\u0000';
            }
            double d3 = this.widths_[Math.min(c3, this.widths_.length - 1)];
            if (bl2) {
                graphics2D.fill(shape);
                graphics2D.translate(d3, 0.0);
                continue;
            }
            int n4 = c2 - this.firstch_;
            double d4 = this.newwidths_ != null && 0 <= n4 && n4 < this.newwidths_.length && this.newwidths_[n4] > 1.0f ? (double)this.newwidths_[n4] * 0.001 / this.m_.getScaleX() : 0.0;
            double d5 = d2 = d4 <= 1.0 || Math.abs(d3 - d4) <= 2.0 || this.pdfbad_[n4] ? 1.0 : d4 / d3;
            if (d2 != 1.0) {
                graphics2D.scale(d2, 1.0);
            }
            if (0 == n2 || 2 == n2 || 4 == n2 || 6 == n2) {
                graphics2D.fill(shape);
            }
            if (1 == n2 || 2 == n2 || 5 == n2 || 6 == n2) {
                if (color == null || color.equals(color2)) {
                    graphics2D.draw(shape);
                } else {
                    graphics2D.setColor(color);
                    graphics2D.draw(shape);
                    graphics2D.setColor(color2);
                }
            }
            if (d2 != 1.0) {
                graphics2D.scale(1.0 / d2, 1.0);
            }
            graphics2D.translate(d4 != 0.0 ? d4 : d3, 0.0);
        }
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        graphics2D.setTransform(affineTransform);
        this.releaseRA();
    }

    public static byte[] normalize(byte[] byArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        byArray = (byte[])byArray.clone();
        int n9 = byArray.length;
        if ((byArray[0] & 0xFF) == 128) {
            n8 = 0;
            n7 = 0;
            n6 = byArray.length;
            while (n8 < n6) {
                if ((byArray[n8] & 0xFF) != 128) {
                    throw new IllegalStateException(byArray[n8] + " @ " + n8 + " of " + byArray.length);
                }
                if ((byArray[n8] & 0xFF) != 128) break;
                n5 = byArray[n8 + 1] & 0xFF;
                if (3 == n5) {
                    n9 = n7;
                    break;
                }
                n4 = byArray[n8 + 2] & 0xFF | (byArray[n8 + 3] & 0xFF) << 8 | (byArray[n8 + 4] & 0xFF) << 16 | (byArray[n8 + 5] & 0xFF) << 24;
                if (1 != n5 && 2 != n5) {
                    throw new FontFormatException("invalid type in IBM segment: " + n5);
                }
                System.arraycopy(byArray, n8 += 6, byArray, n7, n4);
                n8 += n4;
                n7 += n4;
            }
        }
        n8 = NFontType1.getClen(byArray);
        n7 = a.b(byArray, i.a("cleartomark"));
        n6 = n7 > n8 ? n7 : n9;
        --n6;
        n5 = 0;
        while (n5 < 512 && n6 > n8) {
            n4 = byArray[n6] & 0xFF;
            if (n4 == 48) {
                ++n5;
            } else if (n4 != 32 && n4 != 9 && n4 != 10 && n4 != 13) break;
            --n6;
        }
        if (++n6 < n9 && Character.isWhitespace((char)(byArray[n6] & 0xFF))) {
            ++n6;
        }
        n9 = n6;
        n5 = n9 - n8;
        n4 = 1;
        int n10 = 0;
        for (n3 = n8; n3 < n9; ++n3) {
            n2 = byArray[n3] & 0xFF;
            if (b.a(n2)) {
                ++n10;
                continue;
            }
            if (Character.isWhitespace((char)n2)) continue;
            n4 = 0;
            break;
        }
        if (n4 != 0) {
            if (n10 % 2 != 0) {
                throw new IllegalStateException(n10 + "");
            }
            n3 = 0;
            n2 = n8;
            int n11 = n8;
            while (n3 < n10) {
                while (Character.isWhitespace((char)(byArray[n11] & 0xFF))) {
                    ++n11;
                }
                byArray[n2] = (byte)org.icepdf.core.pobjects.fonts.nfont.c.d.a(byArray[n11], (int)byArray[n11 + 1]);
                n3 += 2;
                ++n2;
                n11 += 2;
            }
            n5 = n10 / 2;
            n9 = n8 + n5;
        }
        NFontType1.decrypt(byArray, n8, n5);
        if (n9 < byArray.length) {
            byArray = a.a(byArray, 0, n9);
        }
        return byArray;
    }

    public Rectangle2D getCharBounds(char c2) {
        return this.getEstringBounds(String.valueOf(c2), 0, 1);
    }

    public boolean isOneByteEncoding() {
        return this.c2g_.isOneByte(32);
    }

    public Shape getEstringOutline(String string, float f2, float f3) {
        char c2 = this.c2g_.toSelector(string.charAt(0));
        Area area = new Area(this.getGlyph(c2));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f2, f3);
        affineTransform.concatenate(this.u_);
        area = area.createTransformedArea(affineTransform);
        return area;
    }

    static {
        if (CFF_SID[229] != "exclamsmall" || CFF_SID[274] != "Asmall" || CFF_SID[378] != "Ydieresissmall") {
            throw new IllegalComponentStateException("Illegal Table State");
        }
        if (CHARSET_EXPERT.length != 166) {
            throw new IllegalComponentStateException("Illegal Table State");
        }
        if (CHARSET_EXPERT_SUBSET.length != 88) {
            throw new IllegalComponentStateException("Illegal Table State " + CHARSET_EXPERT_SUBSET);
        }
        if (CFF_EXPERT_MAP[53] != "fiveoldstyle") {
            throw new IllegalComponentStateException("Illegal Table State");
        }
        if (CFF_EXPERT_MAP[126] != "Tildesmall") {
            throw new IllegalComponentStateException("Illegal Table State");
        }
        if (CFF_EXPERT_MAP[219] != "nineinferior") {
            throw new IllegalComponentStateException("Illegal Table State");
        }
        if (CFF_EXPERT_MAP[254] != "Thornsmall") {
            throw new IllegalComponentStateException("Illegal Table State");
        }
        BBOX_MISSING = new Rectangle2D.Double(-100.0, -250.0, 900.0, 750.0);
        rand_ = new Random();
    }
}

