/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.versiontracker;

import java.io.Serializable;
import se.sjobeck.versiontracker.NeedToBeReloadedException;

public class VersionTracker
implements Serializable {
    private static final long serialVersionUID = 7L;
    private int version = 0;
    private boolean keepSynchronized = false;
    private transient boolean thereIsANewVersionOnDiskAndINeedToBeReloaded = false;
    private transient boolean locked = false;

    public synchronized void getLock() {
        while (this.locked) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.locked = true;
    }

    public synchronized void relaseLock() {
        this.locked = false;
        this.notifyAll();
    }

    public boolean isSynchronized() throws NeedToBeReloadedException {
        this.checkIfNeedToBeReloaded();
        return this.keepSynchronized;
    }

    public void setSynchronized(boolean keepSynchronized) throws NeedToBeReloadedException {
        this.checkIfNeedToBeReloaded();
        this.keepSynchronized = keepSynchronized;
    }

    public int getVersion() throws NeedToBeReloadedException {
        this.checkIfNeedToBeReloaded();
        return this.version;
    }

    public void setVersion(int version) throws NeedToBeReloadedException {
        this.checkIfNeedToBeReloaded();
        this.version = version;
    }

    private void checkIfNeedToBeReloaded() throws NeedToBeReloadedException {
        if (this.thereIsANewVersionOnDiskAndINeedToBeReloaded) {
            throw new NeedToBeReloadedException(this);
        }
    }

    protected boolean needReload() {
        return this.thereIsANewVersionOnDiskAndINeedToBeReloaded;
    }

    public void setNeedToBeReloaded() {
        this.thereIsANewVersionOnDiskAndINeedToBeReloaded = true;
    }
}

