/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.rmi.encoded;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import se.sjobeck.rmi.encoded.EncodedInputStream;
import se.sjobeck.rmi.encoded.EncodedOutputStream;
import se.sjobeck.rmi.encoded.EncodedSocket;
import se.sjobeck.rmi.encoded.SharedSecretCalculator;

class ServerEncodedSocket
extends EncodedSocket {
    private SharedSecretCalculator ssc;

    ServerEncodedSocket(SharedSecretCalculator ssc) {
        this.ssc = ssc;
    }

    @Override
    protected synchronized void performHandshake() throws IOException {
        OutputStream unencodedOut = super.getRawOutputStream();
        InputStream unencodedIn = super.getRawInputStream();
        int id_length = unencodedIn.read();
        byte[] id = new byte[id_length];
        unencodedIn.read(id);
        byte[] sharedSecret = this.ssc.computeSharedSecret(id);
        byte[] myKey = new byte[sharedSecret.length];
        generator.nextBytes(myKey);
        byte[] keyBytes = new byte[sharedSecret.length];
        for (int i = 0; i < sharedSecret.length; ++i) {
            keyBytes[i] = (byte)(sharedSecret[i] ^ myKey[i]);
        }
        unencodedOut.write(keyBytes);
        this.encodedIn = new EncodedInputStream(unencodedIn, myKey);
        byte[] peerKey = new byte[sharedSecret.length];
        for (int read = this.encodedIn.read(peerKey); read != sharedSecret.length; read += this.encodedIn.read(peerKey, read, peerKey.length - read)) {
        }
        this.encodedOut = new EncodedOutputStream(unencodedOut, peerKey);
    }
}

