/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import se.sjobeck.datastructures.FonsterDim2011;
import se.sjobeck.datastructures.FormelDim;
import se.sjobeck.gui.FormelProvider;
import se.sjobeck.gui.GenericComboBoxModel;
import se.sjobeck.gui.ShapeIcon;
import se.sjobeck.util.StaticHelpers;

public class Fonster2011
extends JPanel
implements FormelProvider {
    private static final long serialVersionUID = 1L;
    private static final double materialFaktorF\u00f6nster = 0.2;
    private static final double materialB\u00e5gFaktor = 0.1;
    private static final double materialSpr\u00f6jsFaktor = 0.05;
    private static final double materialD\u00f6rrFaktor = 1.0;
    private Kategori f\u00f6nsterTyp;
    private String formula;
    private double ackYta;
    private double matYta;
    private GenericComboBoxModel<Ber\u00e4kna> model;
    private List<Ber\u00e4kna> insida = new ArrayList<Ber\u00e4kna>();
    private List<Ber\u00e4kna> utsida = new ArrayList<Ber\u00e4kna>();
    private List<Ber\u00e4kna> dorrModel = new ArrayList<Ber\u00e4kna>();
    private List<Ber\u00e4kna> defaultModel = new ArrayList<Ber\u00e4kna>();
    private JTextField bredd;
    private ButtonGroup buttonGroup1;
    private JTextField djup;
    private JToggleButton f1;
    private JToggleButton f1a;
    private JToggleButton f2;
    private JToggleButton f2a;
    private JToggleButton f2b;
    private JToggleButton f3;
    private JToggleButton f3a;
    private JToggleButton f4;
    private JToggleButton f4a;
    private JToggleButton f6;
    private JToggleButton fd1;
    private JToggleButton fd2;
    private JTextField hojd;
    private JToggleButton id1;
    private JToggleButton id2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JCheckBox kant;
    private JComboBox liggande;
    private JComboBox liggandeO;
    private JCheckBox list;
    private JComboBox staende;
    private JComboBox staendeO;
    private JToggleButton yd1;

    private double getValue(JTextField jt) {
        double value = StaticHelpers.parseDouble(jt.getText());
        if (Double.isNaN(value)) {
            StaticHelpers.warn("Felaktig inmatning: '" + jt.getText().toString() + "'");
            jt.setText("1");
            value = 1.0;
        }
        return value;
    }

    private int getValueFromGui(JComboBox jcb) {
        int value = 0;
        try {
            value = Integer.valueOf(jcb.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            StaticHelpers.warn("Felaktig inmatning: '" + jcb.getSelectedItem().toString() + "'");
            jcb.setSelectedItem("1");
            value = 100;
        }
        return value;
    }

    public static void main(String[] args) {
        double p;
        double h = 2.1;
        double b = 1.2;
        double d = 0.3;
        int ssn = 2;
        int lsn = 2;
        int ss\u00f6 = 2;
        int ls\u00f6 = 2;
        double pris = 19.71;
        for (Kategori kat : Kategori.values()) {
            for (INSIDA iNSIDA : INSIDA.values()) {
                p = pris * iNSIDA.getAckYta(kat, h, b, d, ssn, lsn, ss\u00f6, ls\u00f6);
                System.out.println((Object)((Object)kat) + " ; " + iNSIDA + " ; " + p);
            }
        }
        for (Kategori kat : Kategori.values()) {
            for (Enum enum_ : UTSIDA.values()) {
                p = pris * enum_.getAckYta(kat, h, b, d, ssn, lsn, ss\u00f6, ls\u00f6);
                System.out.println((Object)((Object)kat) + " ; " + enum_ + " ; " + p);
            }
        }
        for (Kategori kat : Kategori.values()) {
            for (Enum enum_ : D\u00d6RR.values()) {
                p = pris * enum_.getAckYta(kat, h, b, d, ssn, lsn, ss\u00f6, ls\u00f6);
                System.out.println((Object)((Object)kat) + " ; " + enum_ + " ; " + p);
            }
        }
        for (Kategori kat : Kategori.values()) {
            for (Enum enum_ : INSIDA.values()) {
                p = pris * enum_.get4eb\u00e5gkant(kat, h, b);
                System.out.println("4b\u00e5gkant " + (Object)((Object)kat) + " ; " + enum_ + " ; " + p);
            }
        }
        for (Kategori kat : Kategori.values()) {
            for (Enum enum_ : UTSIDA.values()) {
                p = pris * enum_.get4eb\u00e5gkant(kat, h, b);
                System.out.println("4b\u00e5gkant " + (Object)((Object)kat) + " ; " + enum_ + " ; " + p);
            }
        }
        for (Kategori kat : Kategori.values()) {
            double p2 = pris * 0.4 * kat.karmlist(h, b);
            System.out.println("karmlist " + (Object)((Object)kat) + " " + p2);
        }
    }

    private void setFormula() {
        int sta = 0;
        int stao = 0;
        int lig = 0;
        int ligo = 0;
        double d = 0.0;
        double b = 0.0;
        double h = 0.0;
        b = this.getValue(this.bredd);
        h = this.getValue(this.hojd);
        d = this.getValue(this.djup);
        sta = this.getValueFromGui(this.staende);
        stao = this.getValueFromGui(this.staendeO);
        lig = this.getValueFromGui(this.liggande);
        ligo = this.getValueFromGui(this.liggandeO);
        Ber\u00e4kna ber = (Ber\u00e4kna)this.jComboBox1.getSelectedItem();
        boolean _4eb\u00e5gkant = this.kant.isSelected();
        double _4b\u00e5gkantTill\u00e4gg = 0.0;
        String _4b\u00e5gkantVar = "-";
        if (_4eb\u00e5gkant) {
            _4b\u00e5gkantTill\u00e4gg = ber.get4eb\u00e5gkant(this.f\u00f6nsterTyp, h, b);
            _4b\u00e5gkantVar = "4B";
        }
        double karmlistTill\u00e4gg = 0.0;
        String karmListVar = "-";
        if (this.list.isSelected()) {
            System.out.println("List was selected");
            karmlistTill\u00e4gg = this.f\u00f6nsterTyp.karmlist(h, b);
            karmListVar = "10K";
        }
        this.ackYta = 0.4 * karmlistTill\u00e4gg + _4b\u00e5gkantTill\u00e4gg + ber.getAckYta(this.f\u00f6nsterTyp, h, b, d, sta, lig, stao, ligo);
        this.matYta = 0.2 * karmlistTill\u00e4gg + 0.2 * _4b\u00e5gkantTill\u00e4gg + ber.getMatYta(this.f\u00f6nsterTyp, h, b, d, sta, lig, stao, ligo);
        this.formula = (Object)((Object)this.f\u00f6nsterTyp) + " " + ber.f\u00f6rkortning() + " " + b + "x" + h + "x" + d + ", " + sta + ", " + lig + ", " + stao + ", " + ligo + ", " + _4b\u00e5gkantVar + ", " + karmListVar;
    }

    private static Icon buildIcon(Kategori kat) {
        switch (kat) {
            case F1: {
                return new ShapeIcon(new Rectangle(0, 0, 4, 6), 50, 50, false);
            }
            case F1A: {
                return new ShapeIcon(new Ellipse2D.Float(0.0f, 0.0f, 1.0f, 1.0f), 50, 50, false);
            }
            case F2: {
                GeneralPath f2 = new GeneralPath();
                f2.append(new Rectangle(0, 0, 4, 6), true);
                f2.moveTo(2.0f, 0.0f);
                f2.lineTo(2.0f, 6.0f);
                return new ShapeIcon(f2, 50, 50, false);
            }
            case F2A: {
                GeneralPath f2a = new GeneralPath();
                f2a.append(new Rectangle(0, 0, 4, 6), true);
                f2a.moveTo(0.0f, 2.0f);
                f2a.lineTo(4.0f, 2.0f);
                return new ShapeIcon(f2a, 50, 50, false);
            }
            case F2B: {
                GeneralPath f2b = new GeneralPath();
                f2b.append(new Ellipse2D.Float(0.0f, 0.0f, 2.0f, 2.0f), true);
                f2b.moveTo(0.0f, 1.0f);
                f2b.lineTo(2.0f, 1.0f);
                return new ShapeIcon(f2b, 50, 50, false);
            }
            case F3: {
                GeneralPath f3 = new GeneralPath();
                f3.append(new Rectangle(0, 0, 4, 6), true);
                f3.moveTo(0.0f, 2.0f);
                f3.lineTo(4.0f, 2.0f);
                f3.moveTo(2.0f, 2.0f);
                f3.lineTo(2.0f, 6.0f);
                return new ShapeIcon(f3, 50, 50, false);
            }
            case F3A: {
                GeneralPath f3a = new GeneralPath();
                f3a.append(new Rectangle(0, 0, 4, 6), true);
                f3a.append(new Rectangle(4, 0, 4, 6), true);
                f3a.append(new Rectangle(8, 0, 4, 6), true);
                return new ShapeIcon(f3a, 50, 50, false);
            }
            case F4: {
                GeneralPath f4 = new GeneralPath();
                f4.append(new Rectangle(0, 0, 4, 6), true);
                f4.moveTo(2.0f, 0.0f);
                f4.lineTo(2.0f, 6.0f);
                f4.moveTo(0.0f, 2.0f);
                f4.lineTo(4.0f, 2.0f);
                return new ShapeIcon(f4, 50, 50, false);
            }
            case F4A: {
                GeneralPath f4a = new GeneralPath();
                f4a.append(new Rectangle(0, 0, 12, 6), true);
                f4a.moveTo(0.0f, 2.0f);
                f4a.lineTo(12.0f, 2.0f);
                f4a.moveTo(4.0f, 2.0f);
                f4a.lineTo(4.0f, 6.0f);
                f4a.moveTo(8.0f, 2.0f);
                f4a.lineTo(8.0f, 6.0f);
                return new ShapeIcon(f4a, 50, 50, false);
            }
            case F6: {
                GeneralPath f6 = new GeneralPath();
                f6.append(new Rectangle(0, 0, 4, 6), true);
                f6.append(new Rectangle(4, 0, 4, 6), true);
                f6.append(new Rectangle(8, 0, 4, 6), true);
                f6.moveTo(0.0f, 2.0f);
                f6.lineTo(12.0f, 2.0f);
                return new ShapeIcon(f6, 50, 50, false);
            }
            case FD1: {
                GeneralPath fd1 = new GeneralPath();
                fd1.append(new Rectangle(0, 0, 90, 210), true);
                fd1.append(new Rectangle(10, 10, 70, 120), false);
                return new ShapeIcon(fd1, 50, 50, false);
            }
            case FD2: {
                GeneralPath fd2 = new GeneralPath();
                fd2.append(new Rectangle(0, 0, 90, 210), true);
                fd2.append(new Rectangle(10, 10, 70, 120), false);
                fd2.append(new Rectangle(90, 0, 90, 210), false);
                fd2.append(new Rectangle(100, 10, 70, 120), false);
                return new ShapeIcon(fd2, 50, 50, false);
            }
            case ID1: 
            case YD1: {
                GeneralPath id1 = new GeneralPath();
                id1.append(new Rectangle(0, 0, 90, 210), true);
                id1.append(new Rectangle(8, 10, 74, 200), false);
                return new ShapeIcon(id1, 50, 50, false);
            }
            case ID2: {
                GeneralPath id2 = new GeneralPath();
                id2.append(new Rectangle(0, 0, 180, 210), true);
                id2.append(new Rectangle(8, 10, 164, 200), false);
                id2.moveTo(90.0f, 10.0f);
                id2.lineTo(90.0f, 210.0f);
                return new ShapeIcon(id2, 50, 50, false);
            }
        }
        throw new IllegalArgumentException("Fel kategori");
    }

    public Fonster2011() {
        this.initComponents();
        for (INSIDA iNSIDA : INSIDA.values()) {
            this.insida.add(iNSIDA);
        }
        for (Enum enum_ : UTSIDA.values()) {
            this.utsida.add((Ber\u00e4kna)((Object)enum_));
        }
        for (Enum enum_ : D\u00d6RR.values()) {
            this.dorrModel.add((Ber\u00e4kna)((Object)enum_));
        }
        this.model = new GenericComboBoxModel(new ArrayList(), true);
        this.model.setListData(this.utsida);
        this.jComboBox1.setModel(this.model);
        this.jComboBox1.setSelectedIndex(0);
        this.ackYta = 0.0;
        this.defaultModel = this.utsida;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.f1 = new JToggleButton();
        this.f1a = new JToggleButton();
        this.f2 = new JToggleButton();
        this.f2a = new JToggleButton();
        this.f2b = new JToggleButton();
        this.f3 = new JToggleButton();
        this.f3a = new JToggleButton();
        this.f4 = new JToggleButton();
        this.f4a = new JToggleButton();
        this.f6 = new JToggleButton();
        this.fd1 = new JToggleButton();
        this.fd2 = new JToggleButton();
        this.id1 = new JToggleButton();
        this.id2 = new JToggleButton();
        this.yd1 = new JToggleButton();
        this.jPanel8 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.bredd = new JTextField();
        this.jLabel1 = new JLabel();
        this.hojd = new JTextField();
        this.jLabel3 = new JLabel();
        this.djup = new JTextField();
        this.jPanel10 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.staende = new JComboBox();
        this.staendeO = new JComboBox();
        this.jLabel8 = new JLabel();
        this.liggande = new JComboBox();
        this.liggandeO = new JComboBox();
        this.jPanel7 = new JPanel();
        this.list = new JCheckBox();
        this.kant = new JCheckBox();
        this.jPanel1.setLayout(new GridLayout(5, 3));
        this.buttonGroup1.add(this.f1);
        this.f1.setIcon(Fonster2011.buildIcon(Kategori.F1));
        this.f1.setText("F1");
        this.f1.setHorizontalTextPosition(0);
        this.f1.setVerticalTextPosition(3);
        this.f1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f1fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f1);
        this.buttonGroup1.add(this.f1a);
        this.f1a.setIcon(Fonster2011.buildIcon(Kategori.F1A));
        this.f1a.setText("F1a");
        this.f1a.setHorizontalTextPosition(0);
        this.f1a.setVerticalTextPosition(3);
        this.f1a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f1afonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f1a);
        this.buttonGroup1.add(this.f2);
        this.f2.setIcon(Fonster2011.buildIcon(Kategori.F2));
        this.f2.setText("F2");
        this.f2.setHorizontalTextPosition(0);
        this.f2.setVerticalTextPosition(3);
        this.f2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f2fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f2);
        this.buttonGroup1.add(this.f2a);
        this.f2a.setIcon(Fonster2011.buildIcon(Kategori.F2A));
        this.f2a.setText("F2a");
        this.f2a.setHorizontalTextPosition(0);
        this.f2a.setVerticalTextPosition(3);
        this.f2a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f2afonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f2a);
        this.buttonGroup1.add(this.f2b);
        this.f2b.setIcon(Fonster2011.buildIcon(Kategori.F2B));
        this.f2b.setText("F2b");
        this.f2b.setHorizontalTextPosition(0);
        this.f2b.setVerticalTextPosition(3);
        this.f2b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f2bfonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f2b);
        this.buttonGroup1.add(this.f3);
        this.f3.setIcon(Fonster2011.buildIcon(Kategori.F3));
        this.f3.setText("F3");
        this.f3.setHorizontalTextPosition(0);
        this.f3.setVerticalTextPosition(3);
        this.f3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f3fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f3);
        this.buttonGroup1.add(this.f3a);
        this.f3a.setIcon(Fonster2011.buildIcon(Kategori.F3A));
        this.f3a.setText("F3a");
        this.f3a.setHorizontalTextPosition(0);
        this.f3a.setVerticalTextPosition(3);
        this.f3a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f3afonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f3a);
        this.buttonGroup1.add(this.f4);
        this.f4.setIcon(Fonster2011.buildIcon(Kategori.F4));
        this.f4.setText("F4");
        this.f4.setHorizontalTextPosition(0);
        this.f4.setVerticalTextPosition(3);
        this.f4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f4fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f4);
        this.buttonGroup1.add(this.f4a);
        this.f4a.setIcon(Fonster2011.buildIcon(Kategori.F4A));
        this.f4a.setText("F4a");
        this.f4a.setHorizontalTextPosition(0);
        this.f4a.setVerticalTextPosition(3);
        this.f4a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f4afonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f4a);
        this.buttonGroup1.add(this.f6);
        this.f6.setIcon(Fonster2011.buildIcon(Kategori.F6));
        this.f6.setText("F6");
        this.f6.setHorizontalTextPosition(0);
        this.f6.setVerticalTextPosition(3);
        this.f6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.f6fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f6);
        this.buttonGroup1.add(this.fd1);
        this.fd1.setIcon(Fonster2011.buildIcon(Kategori.FD1));
        this.fd1.setText("FD1");
        this.fd1.setHorizontalTextPosition(0);
        this.fd1.setVerticalTextPosition(3);
        this.fd1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.fd1fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.fd1);
        this.buttonGroup1.add(this.fd2);
        this.fd2.setIcon(Fonster2011.buildIcon(Kategori.FD2));
        this.fd2.setText("FD2");
        this.fd2.setHorizontalTextPosition(0);
        this.fd2.setVerticalTextPosition(3);
        this.fd2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.fd2fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.fd2);
        this.buttonGroup1.add(this.id1);
        this.id1.setIcon(Fonster2011.buildIcon(Kategori.ID1));
        this.id1.setText("ID1");
        this.id1.setHorizontalTextPosition(0);
        this.id1.setVerticalTextPosition(3);
        this.id1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.id1fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.id1);
        this.buttonGroup1.add(this.id2);
        this.id2.setIcon(Fonster2011.buildIcon(Kategori.ID2));
        this.id2.setText("ID2");
        this.id2.setHorizontalTextPosition(0);
        this.id2.setVerticalTextPosition(3);
        this.id2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.id2fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.id2);
        this.buttonGroup1.add(this.yd1);
        this.yd1.setIcon(Fonster2011.buildIcon(Kategori.YD1));
        this.yd1.setText("YD1");
        this.yd1.setHorizontalTextPosition(0);
        this.yd1.setVerticalTextPosition(3);
        this.yd1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.yd1fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.yd1);
        this.jPanel2.setDoubleBuffered(false);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jPanel3.add(this.jComboBox1);
        this.jPanel2.add(this.jPanel3);
        this.jPanel5.setLayout(new GridLayout(3, 2));
        this.jLabel2.setText("Karmbredd");
        this.jPanel5.add(this.jLabel2);
        this.bredd.setText("1");
        this.bredd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Fonster2011.this.breddmarkeraText(evt);
            }
        });
        this.jPanel5.add(this.bredd);
        this.jLabel1.setText("Karmh\u00f6jd");
        this.jPanel5.add(this.jLabel1);
        this.hojd.setText("1");
        this.hojd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.hojdActionPerformed(evt);
            }
        });
        this.hojd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Fonster2011.this.hojdmarkeraText(evt);
            }
        });
        this.jPanel5.add(this.hojd);
        this.jLabel3.setText("Karmdjup med foder");
        this.jPanel5.add(this.jLabel3);
        this.djup.setText("0,30");
        this.djup.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Fonster2011.this.djupmarkeraText(evt);
            }
        });
        this.jPanel5.add(this.djup);
        this.jPanel2.add(this.jPanel5);
        this.jPanel10.setLayout(new GridLayout(2, 0));
        this.jPanel10.add(this.jLabel10);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Spr\u00f6jsar anges per b\u00e5ge");
        this.jLabel4.setOpaque(true);
        this.jPanel10.add(this.jLabel4);
        this.jPanel2.add(this.jPanel10);
        this.jPanel6.setLayout(new GridLayout(3, 3));
        this.jPanel6.add(this.jLabel9);
        this.jLabel5.setText("B\u00e5ge");
        this.jPanel6.add(this.jLabel5);
        this.jLabel6.setText("\u00d6vre b\u00e5ge");
        this.jPanel6.add(this.jLabel6);
        this.jLabel7.setText("Ant. st\u00e5ende");
        this.jPanel6.add(this.jLabel7);
        this.staende.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jPanel6.add(this.staende);
        this.staendeO.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jPanel6.add(this.staendeO);
        this.jLabel8.setText("Ant. liggande");
        this.jPanel6.add(this.jLabel8);
        this.liggande.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.liggande.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster2011.this.liggandeActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.liggande);
        this.liggandeO.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jPanel6.add(this.liggandeO);
        this.jPanel2.add(this.jPanel6);
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        this.list.setText("10cm list p\u00e5 f\u00f6nsterkarms utsida.");
        this.jPanel7.add(this.list);
        this.kant.setText("4:e b\u00e5gkant.");
        this.jPanel7.add(this.kant);
        this.jPanel2.add(this.jPanel7);
        this.jPanel8.add(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 758, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -2, 311, -2).addGap(0, 0, 0).addComponent(this.jPanel8, -2, 447, -2).addGap(0, 0, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 386, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 386, -2).addComponent(this.jPanel8, -2, 386, -2)).addGap(0, 0, Short.MAX_VALUE))));
    }

    public void setUtomhus(boolean b) {
        this.list.setEnabled(b);
        this.jLabel3.setEnabled(!b);
        this.djup.setEnabled(!b);
        this.defaultModel = b ? this.utsida : this.insida;
        if (!((Object)this.model.getList()).equals(this.dorrModel)) {
            this.model.setListData(this.defaultModel);
        }
        this.id1.setEnabled(!b);
        this.id2.setEnabled(!b);
    }

    private void setEnabledSprojs(boolean b) {
        this.liggande.setEnabled(b);
        this.liggandeO.setEnabled(b);
        this.staende.setEnabled(b);
        this.staendeO.setEnabled(b);
        this.jLabel4.setEnabled(b);
        this.jLabel5.setEnabled(b);
        this.jLabel6.setEnabled(b);
        this.jLabel7.setEnabled(b);
        this.jLabel8.setEnabled(b);
    }

    private void setEnabledOvre(boolean b) {
        this.jLabel6.setEnabled(b);
        this.staendeO.setEnabled(b);
        this.liggandeO.setEnabled(b);
    }

    private void setEnabledUndre(boolean b) {
    }

    private void setEnableFonster(boolean b) {
        if (b) {
            this.model.setListData(this.defaultModel);
        } else {
            this.model.setListData(this.dorrModel);
        }
    }

    private void foder(boolean b) {
        if (this.defaultModel == this.utsida) {
            this.jLabel3.setEnabled(b);
            this.djup.setEnabled(b);
        }
    }

    private void f1fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f1) {
            this.f\u00f6nsterTyp = Kategori.F1;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f1afonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f1a) {
            this.f\u00f6nsterTyp = Kategori.F1A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f2fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f2) {
            this.f\u00f6nsterTyp = Kategori.F2;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f2afonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f2a) {
            this.f\u00f6nsterTyp = Kategori.F2A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f2bfonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f2b) {
            this.f\u00f6nsterTyp = Kategori.F2B;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f3fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f3) {
            this.f\u00f6nsterTyp = Kategori.F3;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f3afonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f3a) {
            this.f\u00f6nsterTyp = Kategori.F3A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f4fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f4) {
            this.f\u00f6nsterTyp = Kategori.F4;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f4afonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f4a) {
            this.f\u00f6nsterTyp = Kategori.F4A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void f6fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f6) {
            this.f\u00f6nsterTyp = Kategori.F6;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        }
    }

    private void fd1fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.fd1) {
            this.f\u00f6nsterTyp = Kategori.FD1;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(false);
            this.foder(true);
        }
    }

    private void fd2fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.fd2) {
            this.f\u00f6nsterTyp = Kategori.FD2;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(false);
            this.foder(true);
        }
    }

    private void id1fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.id1) {
            this.f\u00f6nsterTyp = Kategori.ID1;
            this.setEnabledSprojs(false);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(false);
            this.kant.setEnabled(false);
        }
    }

    private void id2fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.id2) {
            this.f\u00f6nsterTyp = Kategori.ID2;
            this.setEnabledSprojs(false);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(false);
            this.kant.setEnabled(false);
        }
    }

    private void yd1fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.yd1) {
            this.f\u00f6nsterTyp = Kategori.YD1;
            this.setEnabledSprojs(false);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(false);
            this.kant.setEnabled(false);
        }
    }

    private void breddmarkeraText(FocusEvent evt) {
        try {
            JTextField field = (JTextField)evt.getSource();
            field.selectAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hojdActionPerformed(ActionEvent evt) {
    }

    private void hojdmarkeraText(FocusEvent evt) {
        try {
            JTextField field = (JTextField)evt.getSource();
            field.selectAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void djupmarkeraText(FocusEvent evt) {
        try {
            JTextField field = (JTextField)evt.getSource();
            field.selectAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void liggandeActionPerformed(ActionEvent evt) {
    }

    @Override
    public boolean closeOk() {
        if (this.buttonGroup1.getSelection() == null) {
            StaticHelpers.warn("Du m\u00e5ste v\u00e4lja en f\u00f6nstertyp!");
            return false;
        }
        try {
            this.setFormula();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private double parseDouble(JTextField f, double defaultVal) {
        double d = StaticHelpers.parseDouble(f.getText());
        if (Double.isNaN(d)) {
            StaticHelpers.warn("Felaktig inmatning: '" + f.getText() + "'");
            f.setText(Double.toString(defaultVal));
            d = defaultVal;
        }
        return d;
    }

    @Override
    public FormelDim getFormelDim() {
        FonsterDim2011 fd2011 = new FonsterDim2011("Formel", this.getFormula(), this.getEnhet(), "En genererad formel \u00e4r dimension", this.getAckYta(), this.getMatYta());
        fd2011.setFonsterTyp(this.f\u00f6nsterTyp.ordinal());
        int ordinal = 0;
        if (this.jComboBox1.getSelectedItem() instanceof INSIDA) {
            ordinal = ((INSIDA)this.jComboBox1.getSelectedItem()).ordinal();
        }
        if (this.jComboBox1.getSelectedItem() instanceof UTSIDA) {
            ordinal = ((UTSIDA)this.jComboBox1.getSelectedItem()).ordinal();
        }
        if (this.jComboBox1.getSelectedItem() instanceof D\u00d6RR) {
            ordinal = ((D\u00d6RR)this.jComboBox1.getSelectedItem()).ordinal();
        }
        fd2011.setFonsterSort(ordinal);
        fd2011.setStaendeSprojsar(Integer.valueOf(this.staende.getSelectedItem().toString()));
        fd2011.setLiggandeSprojsar(Integer.valueOf(this.liggande.getSelectedItem().toString()));
        fd2011.setOvreStaendeSprojsar(Integer.valueOf(this.staendeO.getSelectedItem().toString()));
        fd2011.setOvreLiggandeSprojsar(Integer.valueOf(this.liggandeO.getSelectedItem().toString()));
        fd2011.setList10cm(this.list.isSelected());
        fd2011.setFjardeBagkant(this.kant.isSelected());
        fd2011.setInomhus(this.djup.isEnabled());
        fd2011.setKarmBredd(StaticHelpers.parseDouble(this.bredd.getText()));
        fd2011.setKarmHojd(StaticHelpers.parseDouble(this.hojd.getText()));
        fd2011.setKarmDjup(StaticHelpers.parseDouble(this.djup.getText()));
        return fd2011;
    }

    @Override
    public void setState(FormelDim fd) {
        FonsterDim2011 formel = (FonsterDim2011)fd;
        this.setUtomhus(!formel.isInomhus());
        this.staende.setSelectedItem(Integer.toString(formel.getStaendeSprojsar()));
        this.staendeO.setSelectedItem(Integer.toString(formel.getOvreStaendeSprojsar()));
        this.liggande.setSelectedItem(Integer.toString(formel.getLiggandeSprojsar()));
        this.liggandeO.setSelectedItem(Integer.toString(formel.getOvreLiggandeSprojsar()));
        this.list.setSelected(formel.isList10cm());
        this.kant.setSelected(formel.isFjardeBagkant());
        this.bredd.setText(StaticHelpers.format2Dec(formel.getKarmBredd()));
        this.hojd.setText(StaticHelpers.format2Dec(formel.getKarmHojd()));
        this.djup.setText(StaticHelpers.format2Dec(formel.getKarmDjup()));
        try {
            this.f\u00f6nsterTyp = Kategori.values()[formel.getFonsterTyp()];
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        switch (this.f\u00f6nsterTyp) {
            case F1: {
                this.f1.doClick();
                break;
            }
            case F1A: {
                this.f1a.doClick();
                break;
            }
            case F2: {
                this.f2.doClick();
                break;
            }
            case F2A: {
                this.f2a.doClick();
                break;
            }
            case F2B: {
                this.f2b.doClick();
                break;
            }
            case F3: {
                this.f3.doClick();
                break;
            }
            case F4: {
                this.f4.doClick();
                break;
            }
            case F4A: {
                this.f4a.doClick();
                break;
            }
            case F6: {
                this.f6.doClick();
                break;
            }
            case FD1: {
                this.fd1.doClick();
                break;
            }
            case FD2: {
                this.fd2.doClick();
                break;
            }
            case ID1: {
                this.id1.doClick();
                break;
            }
            case ID2: {
                this.id2.doClick();
                break;
            }
            case F3A: {
                this.f3a.doClick();
            }
        }
        try {
            this.jComboBox1.setSelectedIndex(formel.getFonsterSort());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getEnhet() {
        return "st";
    }

    private String getFormula() {
        if (this.formula == null) {
            return "<Ingen formel>";
        }
        return this.formula;
    }

    private double getAckYta() {
        if (this.formula == null) {
            return 0.0;
        }
        return this.ackYta;
    }

    private double getMatYta() {
        if (this.formula == null) {
            return 0.0;
        }
        return this.matYta;
    }

    public static enum D\u00d6RR implements Ber\u00e4kna
    {
        KarmFoder1SidaD\u00f6rrblad{

            @Override
            public String f\u00f6rkortning() {
                return "KF1SD";
            }

            public String toString() {
                return "Karm + Foder (1 sida) + D\u00f6rrblad";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return kat.d\u00f6rrbladInv(h\u00f6jd, bredd) + D\u00d6RR.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.0 * kat.d\u00f6rrbladInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmFoder1SidaD\u00f6rrbladx2{

            @Override
            public String f\u00f6rkortning() {
                return "KF1SD2";
            }

            public String toString() {
                return "Karm + Foder (1 sida) + D\u00f6rrblad x2";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return kat.d\u00f6rrbladInv(h\u00f6jd, bredd) * 2.0 + D\u00d6RR.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.0 * kat.d\u00f6rrbladInv(h\u00f6jd, bredd) * 2.0 + djup * kat.karmInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmFoder1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "KF1S";
            }

            public String toString() {
                return "Karm + Foder (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return D\u00d6RR.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.0 * djup * kat.karmInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmFoder2SidorD\u00f6rrblad{

            @Override
            public String f\u00f6rkortning() {
                return "KF2SD";
            }

            public String toString() {
                return "Karm + Foder (2 sidor) + D\u00f6rrblad";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return kat.d\u00f6rrbladInv(h\u00f6jd, bredd) + 2.0 * D\u00d6RR.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.0 * kat.d\u00f6rrbladInv(h\u00f6jd, bredd) + 2.0 * djup * kat.karmInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmFoder2SidorD\u00f6rrbladx2{

            @Override
            public String f\u00f6rkortning() {
                return "KF2SD2";
            }

            public String toString() {
                return "Karm + Foder (2 sidor) + D\u00f6rrblad x2";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return kat.d\u00f6rrbladInv(h\u00f6jd, bredd) * 2.0 + D\u00d6RR.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) * 2.0;
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.0 * kat.d\u00f6rrbladInv(h\u00f6jd, bredd) * 2.0 + djup * kat.karmInv(h\u00f6jd, bredd) * 2.0;
            }
        }
        ,
        KarmFoder2Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KF2S";
            }

            public String toString() {
                return "Karm + Foder (2 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return D\u00d6RR.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) * 2.0;
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.0 * djup * kat.karmInv(h\u00f6jd, bredd) * 2.0;
            }
        };


        @Override
        public double get4eb\u00e5gkant(Kategori kat, double h\u00f6jd, double bredd) {
            return kat._4eb\u00e5gkant(h\u00f6jd, bredd) * 0.4;
        }

        private static double djupFaktor(double djup) {
            double djupFaktor = 0.4;
            if (djup >= 0.5) {
                djupFaktor = 1.0;
            }
            return djupFaktor;
        }
    }

    public static enum UTSIDA implements Ber\u00e4kna
    {
        KarmUtanFalsUtsidaB\u00e5ge{

            @Override
            public String f\u00f6rkortning() {
                return "KUFUB";
            }

            public String toString() {
                return "Karm utan fals + Utsida b\u00e5ge";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geUtv(h\u00f6jd, bredd) + 0.4 * kat.karmUtv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * (kat.b\u00e5geUtv(h\u00f6jd, bredd) + djup * kat.karmUtv(h\u00f6jd, bredd));
            }
        }
        ,
        KarmUtanFalsUtsidaB\u00e5geSpr\u00f6js{

            @Override
            public String f\u00f6rkortning() {
                return "KUFUBS";
            }

            public String toString() {
                return "Karm utan fals + Utsida b\u00e5ge + Spr\u00f6js";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geUtv(h\u00f6jd, bredd) + 0.4 * kat.karmUtv(h\u00f6jd, bredd) + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * kat.b\u00e5geUtv(h\u00f6jd, bredd) + djup * kat.karmUtv(h\u00f6jd, bredd) + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmMedFalsUtsidaB\u00e5ge{

            @Override
            public String f\u00f6rkortning() {
                return "KMFUB";
            }

            public String toString() {
                return "Karm med fals + Utsida b\u00e5ge";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geUtv(h\u00f6jd, bredd) + 0.6 * kat.karmUtv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * kat.b\u00e5geUtv(h\u00f6jd, bredd) + djup * kat.karmUtv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmMedFalsUtsidaB\u00e5geSpr\u00f6js{

            @Override
            public String f\u00f6rkortning() {
                return "KMFUBS";
            }

            public String toString() {
                return "Karm med fals + Utsida b\u00e5ge + Spr\u00f6js";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geUtv(h\u00f6jd, bredd) + 0.6 * kat.karmUtv(h\u00f6jd, bredd) + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * kat.b\u00e5geUtv(h\u00f6jd, bredd) + djup * kat.karmUtv(h\u00f6jd, bredd) + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        };


        @Override
        public double get4eb\u00e5gkant(Kategori kat, double h\u00f6jd, double bredd) {
            return kat._4eb\u00e5gkant(h\u00f6jd, bredd) * 0.4;
        }
    }

    public static enum INSIDA implements Ber\u00e4kna
    {
        KarmInsida{

            @Override
            public String f\u00f6rkortning() {
                return "KI";
            }

            public String toString() {
                return "Karm + Insida";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                double djupFaktor = 0.45;
                if (djup >= 0.5) {
                    djupFaktor = 1.0;
                }
                return kat.karmInv(h\u00f6jd, bredd) * djupFaktor + kat.b\u00e5geInv(h\u00f6jd, bredd) * 0.4;
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return djup * kat.karmInv(h\u00f6jd, bredd) + 0.1 * kat.b\u00e5geInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmInsidaSpr\u00f6js1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "KIS1S";
            }

            public String toString() {
                return "Karm + Insida + Spr\u00f6js (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                double djupFaktor = 0.45;
                if (djup >= 0.5) {
                    djupFaktor = 1.0;
                }
                return kat.karmInv(h\u00f6jd, bredd) * djupFaktor + kat.b\u00e5geInv(h\u00f6jd, bredd) * 0.4 + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return djup * kat.karmInv(h\u00f6jd, bredd) + 0.1 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaEnkel{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSE";
            }

            public String toString() {
                return "Karm + Insida + mellansida enkel";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.8 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.2 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmInsidaMellanSidaEnkelSpr\u00f6js1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSES1S";
            }

            public String toString() {
                return "Karm + Insida + mellansida enkel + Spr\u00f6js (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.8 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.2 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.1 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaEnkelSpr\u00f6js2Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSES2S";
            }

            public String toString() {
                return "Karm + Insida + mellansida enkel + Spr\u00f6js (2 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.8 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 0.8 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.2 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.1 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaDubbel{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSD";
            }

            public String toString() {
                return "Karm + Insida + mellansida dubbel";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.2000000000000002 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.30000000000000004 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmInsidaMellanSidaDubbelSpr\u00f6js1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSDS1S";
            }

            public String toString() {
                return "Karm + Insida + mellansida dubbel + Spr\u00f6js (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.2000000000000002 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.30000000000000004 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaDubbelSpr\u00f6js2Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSDS2S";
            }

            public String toString() {
                return "Karm + Insida + mellansida dubbel + Spr\u00f6js (2 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.2000000000000002 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 0.8 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.30000000000000004 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.1 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaDubbelSpr\u00f6js3Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSDS3S";
            }

            public String toString() {
                return "Karm + Insida + mellansida dubbel + Spr\u00f6js (3 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.2000000000000002 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 1.2000000000000002 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.30000000000000004 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.15000000000000002 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaKopplad{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSK";
            }

            public String toString() {
                return "Karm + Insida + mellansida kopplad";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 2.0 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.5 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd);
            }
        }
        ,
        KarmInsidaMellanSidaKoppladSpr\u00f6js1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSKS1S";
            }

            public String toString() {
                return "Karm + Insida + mellansida kopplad + Spr\u00f6js (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 2.0 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.5 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaKoppladSpr\u00f6js2Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSKS2S";
            }

            public String toString() {
                return "Karm + Insida + mellansida kopplad + Spr\u00f6js (2 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 2.0 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 0.8 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.5 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.1 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaKoppladSpr\u00f6js3Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSKS3S";
            }

            public String toString() {
                return "Karm + Insida + mellansida kopplad + Spr\u00f6js (3 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 2.0 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 1.2000000000000002 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.5 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.15000000000000002 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellanSidaKoppladSpr\u00f6js4Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSKS4S";
            }

            public String toString() {
                return "Karm + Insida + mellansida kopplad + Spr\u00f6js (4 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 2.0 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 1.6 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.5 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.2 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        KarmInsidaMellansidaKoppladSpr\u00f6js5Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "KIMSKS5S";
            }

            public String toString() {
                return "Karm + Insida + mellansida kopplad + Spr\u00f6js (5 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 2.0 * kat.b\u00e5geInv(h\u00f6jd, bredd) + INSIDA.djupFaktor(djup) * kat.karmInv(h\u00f6jd, bredd) + 2.0 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.5 * kat.b\u00e5geInv(h\u00f6jd, bredd) + djup * kat.karmInv(h\u00f6jd, bredd) + 0.25 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        MellanSidaEnkel{

            @Override
            public String f\u00f6rkortning() {
                return "MSE";
            }

            public String toString() {
                return "Mellansida enkel";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * kat.b\u00e5geInv(h\u00f6jd, bredd);
            }
        }
        ,
        MellanSidaEnkelSpr\u00f6js1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "MSES1S";
            }

            public String toString() {
                return "Mellansida enkel + Spr\u00f6js (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        MellanSidaDubbel{

            @Override
            public String f\u00f6rkortning() {
                return "MSD";
            }

            public String toString() {
                return "Mellansida dubbel";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) * 2.0;
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * (kat.b\u00e5geInv(h\u00f6jd, bredd) * 2.0);
            }
        }
        ,
        MellanSidaDubbelSpr\u00f6js1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "MSDS1S";
            }

            public String toString() {
                return "Mellansida dubbel + Spr\u00f6js (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) * 2.0 + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * kat.b\u00e5geInv(h\u00f6jd, bredd) * 2.0 + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        MellanSidaDubbelSpr\u00f6js2Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "MSDS2S";
            }

            public String toString() {
                return "Mellansida dubbel + Spr\u00f6js (2 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) * 2.0 + 0.8 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * kat.b\u00e5geInv(h\u00f6jd, bredd) * 2.0 + 0.1 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        MellanSidaDubbelKopplad{

            @Override
            public String f\u00f6rkortning() {
                return "MSDK";
            }

            public String toString() {
                return "Mellansida dubbelkopplad";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.6 * kat.b\u00e5geInv(h\u00f6jd, bredd);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.1 * (4.0 * kat.b\u00e5geInv(h\u00f6jd, bredd));
            }
        }
        ,
        MellanSidaDubbelKoppladSpr\u00f6js1Sida{

            @Override
            public String f\u00f6rkortning() {
                return "MSDKS1S";
            }

            public String toString() {
                return "Mellansida dubbelkopplad + Spr\u00f6js (1 sida)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.6 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.4 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.05 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        MellanSidaDubbelKoppladSpr\u00f6js2Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "MSDKS2S";
            }

            public String toString() {
                return "Mellansida dubbelkopplad + Spr\u00f6js (2 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.6 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.8 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.1 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        MellanSidaDubbelKoppladSpr\u00f6js3Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "MSDKS3S";
            }

            public String toString() {
                return "Mellansida dubbelkopplad + Spr\u00f6js (3 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.6 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 1.2000000000000002 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.15000000000000002 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        }
        ,
        MellanSidaDubbelKoppladSpr\u00f6js4Sidor{

            @Override
            public String f\u00f6rkortning() {
                return "MSDKS4S";
            }

            public String toString() {
                return "Mellansida dubbelkopplad + Spr\u00f6js (4 sidor)";
            }

            @Override
            public double getAckYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 1.6 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 1.6 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }

            @Override
            public double getMatYta(Kategori kat, double h\u00f6jd, double bredd, double djup, int SSN, int LSN, int SS\u00d6, int LS\u00d6) {
                return 0.4 * kat.b\u00e5geInv(h\u00f6jd, bredd) + 0.2 * kat.spr\u00f6jsTotal(h\u00f6jd, bredd, SSN, LSN, SS\u00d6, LS\u00d6);
            }
        };


        @Override
        public double get4eb\u00e5gkant(Kategori kat, double h\u00f6jd, double bredd) {
            return kat._4eb\u00e5gkant(h\u00f6jd, bredd) * 0.4;
        }

        private static double djupFaktor(double djup) {
            double djupFaktor = 0.45;
            if (djup >= 0.5) {
                djupFaktor = 1.0;
            }
            return djupFaktor;
        }
    }

    public static interface Ber\u00e4kna {
        public double getAckYta(Kategori var1, double var2, double var4, double var6, int var8, int var9, int var10, int var11);

        public double getMatYta(Kategori var1, double var2, double var4, double var6, int var8, int var9, int var10, int var11);

        public double get4eb\u00e5gkant(Kategori var1, double var2, double var4);

        public String f\u00f6rkortning();
    }

    public static enum Kategori {
        F1{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.0 * h + 2.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.0 * h + 2.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 2.0 * h + 2.0 * b - 0.4;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 2.0 * h + 2.0 * b - 0.4;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (2.0 * h + 2.0 * b - 0.4);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (2.0 * h + 2.0 * b - 0.4);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 2.0 * h + 2.0 * b - 0.4;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.1) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return h;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F1A{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return h * Math.PI;
            }

            @Override
            public double karmUtv(double h, double b) {
                return h * Math.PI;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return h * Math.PI - 0.4;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return h * Math.PI - 0.4;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (h * Math.PI - 0.4);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (h * Math.PI - 0.4);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return h * Math.PI - 0.4;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.1) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return h * 0.5;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F2{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 3.0 * h + 2.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 3.0 * h + 2.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 4.0 * h + 2.0 * b - 0.8;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 4.0 * h + 2.0 * b - 0.8;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (4.0 * h + 2.0 * b - 0.8);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (4.0 * h + 2.0 * b - 0.8);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 4.0 * h + 2.0 * b - 0.8;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * ssn * 2.0;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.2) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return h * 2.0;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F2A{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.0 * h + 3.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.0 * h + 3.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 2.0 * h + 4.0 * b - 0.8;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 2.0 * h + 4.0 * b - 0.8;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (2.0 * h + 4.0 * b - 0.8);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (2.0 * h + 4.0 * b - 0.8);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 2.0 * h + 4.0 * b - 0.8;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * 0.7 * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.1) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return (h - 0.1) * 0.3 * ss\u00f6;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return (b - 0.1) * ls\u00f6;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return h * 0.7 + b;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F2B{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return h * Math.PI + b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return h * Math.PI + b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return h * Math.PI + b * 2.0 - 0.8;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return h * Math.PI + b * 2.0 - 0.8;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (h * Math.PI + b * 2.0 - 0.8);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (h * Math.PI + b * 2.0 - 0.8);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return h * Math.PI + b * 2.0 - 0.8;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * 0.5 * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.1) * 0.5 * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return (h - 0.1) * 0.5 * ss\u00f6;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double lsn) {
                return (b - 0.1) * 0.5 * lsn;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 2.0 * b;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F3{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.7 * h + 3.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.7 * h + 3.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 3.4 * h + 4.0 * b - 1.2000000000000002;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 3.4 * h + 4.0 * b - 1.2000000000000002;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (3.4 * h + 4.0 * b - 1.2000000000000002);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (3.4 * h + 4.0 * b - 1.2000000000000002);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 3.4 * h + 4.0 * b - 1.2000000000000002;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * 1.4 * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.2) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return (h - 0.1) * 0.3 * ss\u00f6;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return (b - 0.1) * ls\u00f6;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 1.4 * h + b;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F3A{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 4.0 * h + 2.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 4.0 * h + 2.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 6.0 * h + 2.0 * b - 1.2000000000000002;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 6.0 * h + 2.0 * b - 1.2000000000000002;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (6.0 * h + 2.0 * b - 1.2000000000000002);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (6.0 * h + 2.0 * b - 1.2000000000000002);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 6.0 * h + 2.0 * b - 1.2000000000000002;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * ssn * 3.0;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.3) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return h * 3.0;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F4{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 3.0 * h + 3.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 3.0 * h + 3.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 4.0 * h + 4.0 * b - 1.6;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 4.0 * h + 4.0 * b - 1.6;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (4.0 * h + 4.0 * b - 1.6);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (4.0 * h + 4.0 * b - 1.6);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 4.0 * h + 4.0 * b - 1.6;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.1) * 1.4 * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.2) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return (h - 0.1) * 0.6 * ss\u00f6;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return (b - 0.2) * ls\u00f6;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 2.0 * h;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F4A{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 3.4 * h + 3.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 3.4 * h + 3.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 4.8 * h + 4.0 * b - 1.6;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 4.8 * h + 4.0 * b - 1.6;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (4.8 * h + 4.0 * b - 1.6);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (4.8 * h + 4.0 * b - 1.6);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 4.8 * h + 4.0 * b - 1.6;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return 2.1 * (h - 0.1) * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.3) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return 0.3 * (h - 0.1) * ss\u00f6;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return (b - 0.1) * ls\u00f6;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 2.1 * h + b;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        F6{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 4.0 * h + 3.0 * b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 4.0 * h + 3.0 * b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 6.0 * h + 4.0 * b - 2.4000000000000004;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 6.0 * h + 4.0 * b - 2.4000000000000004;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (6.0 * h + 4.0 * b - 2.4000000000000004);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (6.0 * h + 4.0 * b - 2.4000000000000004);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 6.0 * h + 4.0 * b - 2.4000000000000004;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return 2.1 * (h - 0.1) * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return (b - 0.3) * lsn;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return (h - 0.1) * 0.9 * ss\u00f6;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return (b - 0.3) * ls\u00f6;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 2.1 * h + b;
            }

            @Override
            public double karmlist(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        FD1{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.8) * ssn;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double lsn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ss\u00f6) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ls\u00f6) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmlist(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        FD2{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 4.0 * (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 2.0 * (h - 0.1) * (b - 0.1);
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return (h - 0.8) * ssn * 2.0;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmlist(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        ID1{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmlist(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        ID2{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmlist(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        }
        ,
        YD1{

            @Override
            public double d\u00f6rrbladInv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double d\u00f6rrbladUtv(double h, double b) {
                return (h - 0.1) * (b - 0.1);
            }

            @Override
            public double karmInv(double h, double b) {
                return 2.0 * h + b;
            }

            @Override
            public double karmUtv(double h, double b) {
                return 2.0 + h + b;
            }

            @Override
            public double b\u00e5geInv(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsEnkel(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsDubbel(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geMsKopplad(double h, double b) {
                return 0.0;
            }

            @Override
            public double b\u00e5geUtv(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5endeNedre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggandeNedre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsSt\u00e5ende\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsLiggande\u00d6vre(double h, double b, double ssn) {
                return 0.0;
            }

            @Override
            public double _4eb\u00e5gkant(double h, double b) {
                return 0.0;
            }

            @Override
            public double karmlist(double h, double b) {
                return 0.0;
            }

            @Override
            public double spr\u00f6jsTotal(double h, double b, double ssn, double lsn, double ss\u00f6, double ls\u00f6) {
                return this.spr\u00f6jsSt\u00e5endeNedre(h, b, ssn) + this.spr\u00f6jsLiggandeNedre(h, b, lsn) + this.spr\u00f6jsLiggande\u00d6vre(h, b, ls\u00f6) + this.spr\u00f6jsSt\u00e5ende\u00d6vre(h, b, ss\u00f6);
            }
        };


        public abstract double karmInv(double var1, double var3);

        public abstract double karmUtv(double var1, double var3);

        public abstract double b\u00e5geInv(double var1, double var3);

        public abstract double b\u00e5geMsEnkel(double var1, double var3);

        public abstract double b\u00e5geMsDubbel(double var1, double var3);

        public abstract double b\u00e5geMsKopplad(double var1, double var3);

        public abstract double b\u00e5geUtv(double var1, double var3);

        public abstract double spr\u00f6jsSt\u00e5endeNedre(double var1, double var3, double var5);

        public abstract double spr\u00f6jsLiggandeNedre(double var1, double var3, double var5);

        public abstract double spr\u00f6jsSt\u00e5ende\u00d6vre(double var1, double var3, double var5);

        public abstract double spr\u00f6jsLiggande\u00d6vre(double var1, double var3, double var5);

        public abstract double spr\u00f6jsTotal(double var1, double var3, double var5, double var7, double var9, double var11);

        public abstract double _4eb\u00e5gkant(double var1, double var3);

        public abstract double karmlist(double var1, double var3);

        public abstract double d\u00f6rrbladInv(double var1, double var3);

        public abstract double d\u00f6rrbladUtv(double var1, double var3);
    }
}

