/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import se.sjobeck.datastructures.FonsterDim;
import se.sjobeck.datastructures.FormelDim;
import se.sjobeck.datastructures.Tuple;
import se.sjobeck.gui.FormelProvider;
import se.sjobeck.gui.GenericComboBoxModel;
import se.sjobeck.gui.ShapeIcon;
import se.sjobeck.util.StaticHelpers;

public class Fonster
extends JPanel
implements FormelProvider {
    static final long serialVersionUID = 0L;
    private static final long serialVerisionUID = 0L;
    private String fonsterknapp;
    private String inut;
    private String formula;
    private double ackYta;
    private double matYta;
    private Kategori f\u00f6nsterTyp;
    private final int INSIDA = 1;
    private final int KOPPLAD = 2;
    private final int ENKEL = 4;
    private final int DUBBEL = 8;
    private final int UTSIDA = 16;
    private final int FALS = 32;
    private final int UTGAENDE = 64;
    private final int INGAENDE = 128;
    private final int DORR = 256;
    private final int SIDAx2 = 512;
    private final int BAGE = 1024;
    private final double lpmPerM2 = 0.3;
    private List<Tuple> insida;
    private List<Tuple> utsida;
    private List<Tuple> dorrModel;
    private List<Tuple> defaultModel;
    private GenericComboBoxModel<Tuple> model;
    private JTextField bredd;
    private ButtonGroup buttonGroup2;
    private JTextField djup;
    private JToggleButton f1;
    private JToggleButton f1a;
    private JToggleButton f2;
    private JToggleButton f2a;
    private JToggleButton f2b;
    private JToggleButton f3;
    private JToggleButton f3a;
    private JToggleButton f4;
    private JToggleButton f4a;
    private JToggleButton f6;
    private JToggleButton fd1;
    private JToggleButton fd2;
    private ButtonGroup f\u00f6nsterKategorier;
    private JTextField hojd;
    private JToggleButton id1;
    private JToggleButton id2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JToggleButton jToggleButton11;
    private JCheckBox kant;
    private JComboBox liggande;
    private JComboBox liggandeO;
    private JCheckBox list;
    private JTextField listbleck;
    private ButtonGroup nedre;
    private ButtonGroup ovre;
    private JComboBox staende;
    private JComboBox staendeO;
    private JToggleButton yd1;

    public Fonster() {
        this.initComponents();
        this.insida = Arrays.asList(new Tuple("Insida", new Integer(1025), true), new Tuple("Insida + mellansida kopplad", new Integer(1027), true), new Tuple("Insida + mellansida enkel", new Integer(1029), true), new Tuple("Insida + mellansida dubbel", new Integer(1033), true), new Tuple("Mellansida kopplad", new Integer(3), true), new Tuple("Mellansida enkel", new Integer(5), true), new Tuple("Mellansida dubbelkopplad", new Integer(9), true));
        this.utsida = Arrays.asList(new Tuple("Utsida med karmfals", new Integer(1136), true), new Tuple("Utsida utan karmfals", new Integer(1168), true));
        this.dorrModel = Arrays.asList(new Tuple("D\u00f6rrsida med karm och foder", new Integer(1281), true), new Tuple("D\u00f6rrsida x 2 med karm och foder", new Integer(1793), true), new Tuple("Karm med foder", new Integer(257), true));
        this.model = new GenericComboBoxModel(new ArrayList(), true);
        this.model.setListData(this.utsida);
        this.jComboBox1.setModel(this.model);
        this.jComboBox1.setSelectedIndex(0);
        this.ackYta = 0.0;
    }

    private void initComponents() {
        this.jToggleButton11 = new JToggleButton();
        this.f\u00f6nsterKategorier = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.nedre = new ButtonGroup();
        this.ovre = new ButtonGroup();
        this.jPanel9 = new JPanel();
        this.jPanel1 = new JPanel();
        this.f1 = new JToggleButton();
        this.f1a = new JToggleButton();
        this.f2 = new JToggleButton();
        this.f2a = new JToggleButton();
        this.f2b = new JToggleButton();
        this.f3 = new JToggleButton();
        this.f3a = new JToggleButton();
        this.f4 = new JToggleButton();
        this.f4a = new JToggleButton();
        this.f6 = new JToggleButton();
        this.fd1 = new JToggleButton();
        this.fd2 = new JToggleButton();
        this.id1 = new JToggleButton();
        this.id2 = new JToggleButton();
        this.yd1 = new JToggleButton();
        this.jPanel8 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.bredd = new JTextField();
        this.jLabel1 = new JLabel();
        this.hojd = new JTextField();
        this.jLabel3 = new JLabel();
        this.djup = new JTextField();
        this.jPanel10 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.staende = new JComboBox();
        this.staendeO = new JComboBox();
        this.jLabel8 = new JLabel();
        this.liggande = new JComboBox();
        this.liggandeO = new JComboBox();
        this.jPanel7 = new JPanel();
        this.list = new JCheckBox();
        this.kant = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel13 = new JLabel();
        this.listbleck = new JTextField();
        this.f\u00f6nsterKategorier.add(this.jToggleButton11);
        this.jToggleButton11.setText("jToggleButton11");
        this.setLayout(new BorderLayout());
        this.jPanel9.setLayout(new BoxLayout(this.jPanel9, 2));
        this.jPanel1.setLayout(new GridLayout(5, 3));
        this.f\u00f6nsterKategorier.add(this.f1);
        this.f1.setIcon(Fonster.buildIcon(Kategori.F1));
        this.f1.setText("F1");
        this.f1.setHorizontalTextPosition(0);
        this.f1.setVerticalTextPosition(3);
        this.f1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f1);
        this.f\u00f6nsterKategorier.add(this.f1a);
        this.f1a.setIcon(Fonster.buildIcon(Kategori.F1A));
        this.f1a.setText("F1a");
        this.f1a.setHorizontalTextPosition(0);
        this.f1a.setVerticalTextPosition(3);
        this.f1a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f1a);
        this.f\u00f6nsterKategorier.add(this.f2);
        this.f2.setIcon(Fonster.buildIcon(Kategori.F2));
        this.f2.setText("F2");
        this.f2.setHorizontalTextPosition(0);
        this.f2.setVerticalTextPosition(3);
        this.f2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f2);
        this.f\u00f6nsterKategorier.add(this.f2a);
        this.f2a.setIcon(Fonster.buildIcon(Kategori.F2A));
        this.f2a.setText("F2a");
        this.f2a.setHorizontalTextPosition(0);
        this.f2a.setVerticalTextPosition(3);
        this.f2a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f2a);
        this.f\u00f6nsterKategorier.add(this.f2b);
        this.f2b.setIcon(Fonster.buildIcon(Kategori.F2B));
        this.f2b.setText("F2b");
        this.f2b.setHorizontalTextPosition(0);
        this.f2b.setVerticalTextPosition(3);
        this.f2b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f2b);
        this.f\u00f6nsterKategorier.add(this.f3);
        this.f3.setIcon(Fonster.buildIcon(Kategori.F3));
        this.f3.setText("F3");
        this.f3.setHorizontalTextPosition(0);
        this.f3.setVerticalTextPosition(3);
        this.f3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f3);
        this.f\u00f6nsterKategorier.add(this.f3a);
        this.f3a.setIcon(Fonster.buildIcon(Kategori.F3A));
        this.f3a.setText("F3a");
        this.f3a.setHorizontalTextPosition(0);
        this.f3a.setVerticalTextPosition(3);
        this.f3a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f3a);
        this.f\u00f6nsterKategorier.add(this.f4);
        this.f4.setIcon(Fonster.buildIcon(Kategori.F4));
        this.f4.setText("F4");
        this.f4.setHorizontalTextPosition(0);
        this.f4.setVerticalTextPosition(3);
        this.f4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f4);
        this.f\u00f6nsterKategorier.add(this.f4a);
        this.f4a.setIcon(Fonster.buildIcon(Kategori.F4A));
        this.f4a.setText("F4a");
        this.f4a.setHorizontalTextPosition(0);
        this.f4a.setVerticalTextPosition(3);
        this.f4a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f4a);
        this.f\u00f6nsterKategorier.add(this.f6);
        this.f6.setIcon(Fonster.buildIcon(Kategori.F6));
        this.f6.setText("F6");
        this.f6.setHorizontalTextPosition(0);
        this.f6.setVerticalTextPosition(3);
        this.f6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.f6);
        this.f\u00f6nsterKategorier.add(this.fd1);
        this.fd1.setIcon(Fonster.buildIcon(Kategori.FD1));
        this.fd1.setText("FD1");
        this.fd1.setHorizontalTextPosition(0);
        this.fd1.setVerticalTextPosition(3);
        this.fd1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.fd1);
        this.f\u00f6nsterKategorier.add(this.fd2);
        this.fd2.setIcon(Fonster.buildIcon(Kategori.FD2));
        this.fd2.setText("FD2");
        this.fd2.setHorizontalTextPosition(0);
        this.fd2.setVerticalTextPosition(3);
        this.fd2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.fd2);
        this.f\u00f6nsterKategorier.add(this.id1);
        this.id1.setIcon(Fonster.buildIcon(Kategori.ID1));
        this.id1.setText("ID1");
        this.id1.setHorizontalTextPosition(0);
        this.id1.setVerticalTextPosition(3);
        this.id1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.id1);
        this.f\u00f6nsterKategorier.add(this.id2);
        this.id2.setIcon(Fonster.buildIcon(Kategori.ID2));
        this.id2.setText("ID2");
        this.id2.setHorizontalTextPosition(0);
        this.id2.setVerticalTextPosition(3);
        this.id2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.id2);
        this.f\u00f6nsterKategorier.add(this.yd1);
        this.yd1.setIcon(Fonster.buildIcon(Kategori.YD1));
        this.yd1.setText("YD1");
        this.yd1.setHorizontalTextPosition(0);
        this.yd1.setVerticalTextPosition(3);
        this.yd1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.fonsterEvent(evt);
            }
        });
        this.jPanel1.add(this.yd1);
        this.jPanel9.add(this.jPanel1);
        this.jPanel2.setDoubleBuffered(false);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jPanel3.add(this.jComboBox1);
        this.jPanel2.add(this.jPanel3);
        this.jPanel5.setLayout(new GridLayout(3, 2));
        this.jLabel2.setText("Karmbredd");
        this.jPanel5.add(this.jLabel2);
        this.bredd.setText("1");
        this.bredd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Fonster.this.markeraText(evt);
            }
        });
        this.jPanel5.add(this.bredd);
        this.jLabel1.setText("Karmh\u00f6jd");
        this.jPanel5.add(this.jLabel1);
        this.hojd.setText("1");
        this.hojd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.hojdActionPerformed(evt);
            }
        });
        this.hojd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Fonster.this.markeraText(evt);
            }
        });
        this.jPanel5.add(this.hojd);
        this.jLabel3.setText("Karmdjup med foder");
        this.jPanel5.add(this.jLabel3);
        this.djup.setText("0,30");
        this.djup.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Fonster.this.markeraText(evt);
            }
        });
        this.jPanel5.add(this.djup);
        this.jPanel2.add(this.jPanel5);
        this.jPanel10.setLayout(new GridLayout(2, 0));
        this.jPanel10.add(this.jLabel10);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Spr\u00f6jsar anges per b\u00e5ge");
        this.jLabel4.setOpaque(true);
        this.jPanel10.add(this.jLabel4);
        this.jPanel2.add(this.jPanel10);
        this.jPanel6.setLayout(new GridLayout(3, 3));
        this.jPanel6.add(this.jLabel9);
        this.jLabel5.setText("B\u00e5ge");
        this.jPanel6.add(this.jLabel5);
        this.jLabel6.setText("\u00d6vre b\u00e5ge");
        this.jPanel6.add(this.jLabel6);
        this.jLabel7.setText("Ant. st\u00e5ende");
        this.jPanel6.add(this.jLabel7);
        this.staende.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jPanel6.add(this.staende);
        this.staendeO.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jPanel6.add(this.staendeO);
        this.jLabel8.setText("Ant. liggande");
        this.jPanel6.add(this.jLabel8);
        this.liggande.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.liggande.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fonster.this.liggandeActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.liggande);
        this.liggandeO.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jPanel6.add(this.liggandeO);
        this.jPanel2.add(this.jPanel6);
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        this.list.setText("10cm list p\u00e5 f\u00f6nsterkarms utsida.");
        this.jPanel7.add(this.list);
        this.kant.setText("4:e b\u00e5gkant.");
        this.jPanel7.add(this.kant);
        this.jPanel2.add(this.jPanel7);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("T\u00e4ckning listbleck lpm");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.jLabel13, gridBagConstraints);
        this.listbleck.setText("0");
        this.listbleck.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Fonster.this.markeraText(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.listbleck, gridBagConstraints);
        this.jPanel2.add(this.jPanel4);
        this.jPanel8.add(this.jPanel2);
        this.jPanel9.add(this.jPanel8);
        this.add((Component)this.jPanel9, "Center");
    }

    private void markeraText(FocusEvent evt) {
        try {
            JTextField field = (JTextField)evt.getSource();
            field.selectAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setEnabledSprojs(boolean b) {
        this.liggande.setEnabled(b);
        this.liggandeO.setEnabled(b);
        this.staende.setEnabled(b);
        this.staendeO.setEnabled(b);
        this.jLabel4.setEnabled(b);
        this.jLabel5.setEnabled(b);
        this.jLabel6.setEnabled(b);
        this.jLabel7.setEnabled(b);
        this.jLabel8.setEnabled(b);
    }

    private void setEnabledOvre(boolean b) {
        this.jLabel6.setEnabled(b);
        this.staendeO.setEnabled(b);
        this.liggandeO.setEnabled(b);
    }

    private void setEnabledUndre(boolean b) {
    }

    private void setEnableFonster(boolean b) {
        if (b) {
            this.model.setListData(this.defaultModel);
        } else {
            this.model.setListData(this.dorrModel);
        }
    }

    private void foder(boolean b) {
        if (this.defaultModel == this.utsida) {
            this.jLabel3.setEnabled(b);
            this.djup.setEnabled(b);
        }
    }

    private void fonsterEvent(ActionEvent evt) {
        if (evt.getSource() == this.f1) {
            this.f\u00f6nsterTyp = Kategori.F1;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f1a) {
            this.f\u00f6nsterTyp = Kategori.F1A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f2) {
            this.f\u00f6nsterTyp = Kategori.F2;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f2a) {
            this.f\u00f6nsterTyp = Kategori.F2A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f2b) {
            this.f\u00f6nsterTyp = Kategori.F2B;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f3) {
            this.f\u00f6nsterTyp = Kategori.F3;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f3a) {
            this.f\u00f6nsterTyp = Kategori.F3A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f4) {
            this.f\u00f6nsterTyp = Kategori.F4;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f4a) {
            this.f\u00f6nsterTyp = Kategori.F4A;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.f6) {
            this.f\u00f6nsterTyp = Kategori.F6;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(true);
            this.setEnabledOvre(true);
            this.setEnableFonster(true);
            this.kant.setEnabled(true);
            this.foder(false);
        } else if (evt.getSource() == this.fd1) {
            this.f\u00f6nsterTyp = Kategori.FD1;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(false);
            this.foder(true);
        } else if (evt.getSource() == this.fd2) {
            this.f\u00f6nsterTyp = Kategori.FD2;
            this.setEnabledSprojs(true);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(true);
            this.kant.setEnabled(false);
            this.foder(true);
        } else if (evt.getSource() == this.id1) {
            this.f\u00f6nsterTyp = Kategori.ID1;
            this.setEnabledSprojs(false);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(false);
            this.kant.setEnabled(false);
        } else if (evt.getSource() == this.id2) {
            this.f\u00f6nsterTyp = Kategori.ID2;
            this.setEnabledSprojs(false);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(false);
            this.kant.setEnabled(false);
        } else if (evt.getSource() == this.yd1) {
            this.f\u00f6nsterTyp = Kategori.YD1;
            this.setEnabledSprojs(false);
            this.setEnabledUndre(false);
            this.setEnabledOvre(false);
            this.setEnableFonster(false);
            this.kant.setEnabled(false);
        }
    }

    public void setUtomhus(boolean b) {
        this.list.setEnabled(b);
        this.jLabel3.setEnabled(!b);
        this.djup.setEnabled(!b);
        this.defaultModel = b ? this.utsida : this.insida;
        if (!((Object)this.model.getList()).equals(this.dorrModel)) {
            this.model.setListData(this.defaultModel);
        }
        this.id1.setEnabled(!b);
        this.id2.setEnabled(!b);
    }

    private void setFormula() {
        double ackPct;
        int sta = 0;
        int stao = 0;
        int lig = 0;
        int ligo = 0;
        double d = 0.0;
        double b = 0.0;
        double h = 0.0;
        d = StaticHelpers.parseDouble(this.djup.getText());
        if (Double.isNaN(d)) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.djup.getText().toString() + "'");
            this.djup.setText("1");
            d = 1.0;
        }
        if (Double.isNaN(b = StaticHelpers.parseDouble(this.bredd.getText()))) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.bredd.getText().toString() + "'");
            this.bredd.setText("1");
            b = 1.0;
        }
        if (Double.isNaN(h = StaticHelpers.parseDouble(this.hojd.getText()))) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.hojd.getText().toString() + "'");
            this.hojd.setText("1");
            h = 1.0;
        }
        try {
            sta = Integer.valueOf(this.staende.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.staende.getSelectedItem().toString() + "'");
            this.staende.setSelectedItem("1");
            sta = 100;
        }
        try {
            stao = Integer.valueOf(this.staendeO.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.staendeO.getSelectedItem().toString() + "'");
            this.staendeO.setSelectedItem("1");
            stao = 100;
        }
        try {
            lig = Integer.valueOf(this.liggande.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.liggande.getSelectedItem().toString() + "'");
            this.liggande.setSelectedItem("1");
            lig = 100;
        }
        try {
            ligo = Integer.valueOf(this.liggandeO.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.liggandeO.getSelectedItem().toString() + "'");
            this.liggandeO.setSelectedItem("1");
            ligo = 100;
        }
        int sort = (Integer)((Tuple)this.jComboBox1.getSelectedItem()).snd;
        double mtrlResult = 0.0;
        double ackResult = 0.0;
        if ((sort & 1) > 0) {
            double mtrlPct;
            ackResult += this.getKarmL\u00e4ngdInsida(b, h) * this.karmBredd();
            mtrlResult += this.getKarmL\u00e4ngdInsida(b, h) * this.karmBreddMtrl();
            switch (this.f\u00f6nsterTyp) {
                case ID1: 
                case ID2: {
                    ackPct = 1.0;
                    mtrlPct = 1.0;
                    break;
                }
                case FD1: 
                case FD2: {
                    ackPct = 1.0;
                    mtrlPct = 0.5;
                    break;
                }
                default: {
                    ackPct = 0.3;
                    mtrlPct = 0.1;
                }
            }
            if ((sort & 0x400) > 0) {
                ackResult += this.getB\u00e5gL\u00e4ngdInomhus(b, h) * ackPct;
                mtrlResult += this.getB\u00e5gL\u00e4ngdInomhus(b, h) * mtrlPct;
                if ((sort & 0x200) > 0) {
                    ackResult += this.getB\u00e5gL\u00e4ngdInomhus(b, h) * ackPct;
                    mtrlResult += this.getB\u00e5gL\u00e4ngdInomhus(b, h) * mtrlPct;
                }
            }
            int sprojsMul = 1;
            double extra = 0.0;
            if ((sort & 2) > 0) {
                sprojsMul = 2;
                extra = this.getKopplingsL\u00e4ngd(b, h) * (double)sprojsMul;
            } else if ((sort & 4) > 0) {
                sprojsMul = 1;
                extra = this.getKopplingsL\u00e4ngd(b, h) * (double)sprojsMul;
            } else if ((sort & 8) > 0) {
                sprojsMul = 4;
                extra = this.getKopplingsL\u00e4ngd(b, h) * (double)sprojsMul;
            }
            ackResult += extra * ackPct;
            mtrlResult += extra * mtrlPct;
            if (sta > 0) {
                ackResult += this.getSt\u00e5endeSpr\u00f6jsar(b, h, sta) * 0.3 * (double)sprojsMul;
                mtrlResult += this.getSt\u00e5endeSpr\u00f6jsar(b, h, sta) * 0.05 * (double)sprojsMul;
            }
            if (stao > 0) {
                ackResult += this.get\u00d6vreSt\u00e5endeSpr\u00f6jsar(b, h, stao) * 0.3 * (double)sprojsMul;
                mtrlResult += this.get\u00d6vreSt\u00e5endeSpr\u00f6jsar(b, h, stao) * 0.05 * (double)sprojsMul;
            }
            if (lig > 0) {
                ackResult += this.getLiggandeSpr\u00f6jsar(b, h, lig) * 0.3 * (double)sprojsMul;
                mtrlResult += this.getLiggandeSpr\u00f6jsar(b, h, lig) * 0.05 * (double)sprojsMul;
            }
            if (ligo > 0) {
                ackResult += this.get\u00d6vreLiggandeSpr\u00f6jsar(b, h, ligo) * 0.3 * (double)sprojsMul;
                mtrlResult += this.get\u00d6vreLiggandeSpr\u00f6jsar(b, h, ligo) * 0.05 * (double)sprojsMul;
            }
            if (this.kant.isSelected()) {
                ackResult += this.getFj\u00e4rdeB\u00e5gkant(b, h);
            }
        } else if ((sort & 0x10) > 0) {
            double mtrlPct;
            ackResult = (sort & 0x20) > 0 ? (ackResult += this.getKarmL\u00e4ngdUtsida(b, h) * 0.6) : (ackResult += this.getKarmL\u00e4ngdUtsida(b, h) * 0.4);
            mtrlResult += this.getKarmL\u00e4ngdUtsida(b, h) * 0.1;
            switch (this.f\u00f6nsterTyp) {
                case ID1: 
                case ID2: {
                    ackPct = 1.0;
                    mtrlPct = 1.0;
                    break;
                }
                case FD1: 
                case FD2: {
                    ackPct = 1.0;
                    mtrlPct = 0.5;
                    break;
                }
                default: {
                    ackPct = 0.4;
                    mtrlPct = 0.1;
                }
            }
            if ((sort & 0x400) > 0) {
                ackResult += this.getB\u00e5gL\u00e4ngdUtomhus(b, h) * ackPct;
                mtrlResult += this.getB\u00e5gL\u00e4ngdUtomhus(b, h) * mtrlPct;
                if ((sort & 0x200) > 0) {
                    ackResult += this.getB\u00e5gL\u00e4ngdUtomhus(b, h) * ackPct;
                    mtrlResult += this.getB\u00e5gL\u00e4ngdUtomhus(b, h) * mtrlPct;
                }
            }
            int sprojsMul = 1;
            double extra = 0.0;
            if ((sort & 2) > 0) {
                sprojsMul = 2;
                extra = this.getKopplingsL\u00e4ngd(b, h) * (double)sprojsMul;
            } else if ((sort & 4) > 0) {
                sprojsMul = 1;
                extra = this.getKopplingsL\u00e4ngd(b, h) * (double)sprojsMul;
            } else if ((sort & 8) > 0) {
                sprojsMul = 4;
                extra = this.getKopplingsL\u00e4ngd(b, h) * (double)sprojsMul;
            }
            ackResult += extra * ackPct;
            mtrlResult += extra * mtrlPct;
            if (sta > 0) {
                ackResult += this.getSt\u00e5endeSpr\u00f6jsar(b, h, sta) * 0.4 * (double)sprojsMul;
                mtrlResult += this.getSt\u00e5endeSpr\u00f6jsar(b, h, sta) * 0.05 * (double)sprojsMul;
            }
            if (stao > 0) {
                ackResult += this.get\u00d6vreSt\u00e5endeSpr\u00f6jsar(b, h, stao) * 0.4 * (double)sprojsMul;
                mtrlResult += this.get\u00d6vreSt\u00e5endeSpr\u00f6jsar(b, h, stao) * 0.05 * (double)sprojsMul;
            }
            if (lig > 0) {
                ackResult += this.getLiggandeSpr\u00f6jsar(b, h, lig) * 0.4 * (double)sprojsMul;
                mtrlResult += this.getLiggandeSpr\u00f6jsar(b, h, lig) * 0.05 * (double)sprojsMul;
            }
            if (ligo > 0) {
                ackResult += this.get\u00d6vreLiggandeSpr\u00f6jsar(b, h, ligo) * 0.4 * (double)sprojsMul;
                mtrlResult += this.get\u00d6vreLiggandeSpr\u00f6jsar(b, h, ligo) * 0.05 * (double)sprojsMul;
            }
            if (this.kant.isSelected()) {
                ackResult += this.getFj\u00e4rdeB\u00e5gkant(b, h) * 0.4;
            }
            if (this.list.isSelected()) {
                ackResult += this.getKarmList(b, h) * 0.3;
                mtrlResult += this.getKarmList(b, h) * 0.1;
            }
        }
        this.inut = (sort & 1) > 0 ? "I" : ((sort & 0x10) > 0 ? "U" : "");
        if ((sort & 2) > 0) {
            this.inut = this.inut + "K";
        } else if ((sort & 4) > 0) {
            this.inut = this.inut + "E";
        } else if ((sort & 8) > 0) {
            this.inut = this.inut + "D";
        }
        System.out.println("Sort " + sort + " " + this.jComboBox1.getSelectedItem());
        this.formula = sort == 1281 ? (Object)((Object)this.f\u00f6nsterTyp) + " " + "DKF" + " " + this.inut + " " + b + " x " + h + " x " + d : (sort == 1793 ? (Object)((Object)this.f\u00f6nsterTyp) + " " + "D2KF" + " " + this.inut + " " + b + " x " + h + " x " + d : (sort == 257 ? (Object)((Object)this.f\u00f6nsterTyp) + " " + "KF" + " " + this.inut + " " + b + " x " + h + " x " + d : (Object)((Object)this.f\u00f6nsterTyp) + " " + this.inut + " " + b + " x " + h + " x " + d));
        String bStr = "";
        if (this.staende.isEnabled()) {
            bStr = bStr + ", " + sta;
        }
        if (this.staendeO.isEnabled()) {
            bStr = bStr + ", " + stao;
        }
        if (this.liggande.isEnabled()) {
            bStr = bStr + ", " + lig;
        }
        if (this.liggandeO.isEnabled()) {
            bStr = bStr + ", " + ligo;
        }
        if (!bStr.equals("")) {
            this.formula = this.formula + " - " + bStr.substring(2);
        }
        this.ackYta = ackResult;
        this.matYta = mtrlResult;
    }

    private double sprojs(double hojd, double bredd, int nedre, int ovre, int staende, int staendeOver, int liggande, int liggandeOver, boolean delad) {
        if (delad) {
            return (hojd * 0.7 - 0.2) * (double)staende + (bredd / (double)nedre - 0.2) * (double)liggande * (double)nedre + (ovre > 0 ? (hojd * 0.3 - 0.2) * (double)staendeOver + (bredd / (double)ovre - 0.2) * (double)liggandeOver * (double)ovre : 0.0);
        }
        return (hojd - 0.2) * (double)staende + (bredd / (double)nedre - 0.2) * (double)liggande * (double)nedre + (ovre > 0 ? (hojd - 0.2) * (double)staendeOver + (bredd / (double)ovre - 0.2) * (double)liggandeOver * (double)ovre : 0.0);
    }

    private double bage(double hojd, double bredd, int vertikalaBagar, int horisontellaBagar, boolean delad, double bagMinus) {
        if (delad) {
            return hojd * 2.0 + bredd * 2.0 + 0.7 * hojd * (double)vertikalaBagar * 2.0 + bredd * (double)horisontellaBagar * 2.0 - bagMinus;
        }
        return hojd * 2.0 + bredd * 2.0 + hojd * (double)vertikalaBagar * 2.0 + bredd * (double)horisontellaBagar * 2.0 - bagMinus;
    }

    private double karm(double hojd, double bredd, int vertikalaBagar, int horisontellaBagar, boolean delad) {
        if (delad) {
            return hojd * (double)(2 + vertikalaBagar) + bredd * 2.0 + 0.7 * bredd * (double)horisontellaBagar;
        }
        return hojd * (double)(2 + vertikalaBagar) + bredd * (double)(2 + horisontellaBagar);
    }

    private double dorrYta(double hojd, double bredd) {
        return bredd * hojd;
    }

    private double dorrKarm(double hojd, double bredd) {
        return 2.0 * hojd + bredd;
    }

    private double karmBredd() {
        double d = 0.0;
        d = StaticHelpers.parseDouble(this.djup.getText());
        if (Double.isNaN(d)) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.djup.getText().toString() + "'");
            this.djup.setText("1");
            d = 1.0;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d <= 0.5) {
            return 0.45;
        }
        return d;
    }

    private double karmBreddMtrl() {
        double d = 0.0;
        d = StaticHelpers.parseDouble(this.djup.getText());
        if (Double.isNaN(d)) {
            StaticHelpers.warn("Felaktig inmatning: '" + this.djup.getText().toString() + "'");
            this.djup.setText("1");
            d = 1.0;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d <= 0.1) {
            return 0.1;
        }
        if (d <= 0.3) {
            return 0.3;
        }
        if (d <= 0.5) {
            return 0.5;
        }
        return d;
    }

    private double omkrets(double hojd, double bredd) {
        return bredd * 2.0 + hojd * 2.0;
    }

    private double ellipsOmkrets(double hojd, double bredd) {
        return 0.0;
    }

    public String getFormula() {
        if (this.formula == null) {
            return "<Ingen formel>";
        }
        return this.formula;
    }

    public double getAckYta() {
        if (this.formula == null) {
            return 0.0;
        }
        return this.ackYta;
    }

    public double getMatYta() {
        if (this.formula == null) {
            return 0.0;
        }
        return this.matYta;
    }

    private void liggandeActionPerformed(ActionEvent evt) {
    }

    private void hojdActionPerformed(ActionEvent evt) {
    }

    @Override
    public boolean closeOk() {
        if (this.f\u00f6nsterKategorier.getSelection() == null) {
            StaticHelpers.warn("Du m\u00e5ste v\u00e4lja en f\u00f6nstertyp!");
            return false;
        }
        try {
            this.setFormula();
            System.out.println("formula " + this.formula);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getEnhet() {
        return "st";
    }

    private double parseDouble(JTextField f, double defaultVal) {
        double d = StaticHelpers.parseDouble(f.getText());
        if (Double.isNaN(d)) {
            StaticHelpers.warn("Felaktig inmatning: '" + f.getText() + "'");
            f.setText(Double.toString(defaultVal));
            d = defaultVal;
        }
        return d;
    }

    public double getMisc() {
        double l = this.parseDouble(this.listbleck, 0.0);
        return l * 1.5;
    }

    @Override
    public FormelDim getFormelDim() {
        FonsterDim formel = new FonsterDim("Formel", this.getFormula(), this.getEnhet(), "En genererad formel \u00e4r dimension", this.getAckYta(), this.getMatYta());
        formel.setMisc(this.getMisc());
        formel.setFonsterTyp(this.f\u00f6nsterTyp.ordinal());
        formel.setFonsterSort((Integer)((Tuple)this.jComboBox1.getSelectedItem()).snd);
        formel.setStaendeSprojsar(Integer.valueOf(this.staende.getSelectedItem().toString()));
        formel.setLiggandeSprojsar(Integer.valueOf(this.liggande.getSelectedItem().toString()));
        formel.setOvreStaendeSprojsar(Integer.valueOf(this.staendeO.getSelectedItem().toString()));
        formel.setOvreLiggandeSprojsar(Integer.valueOf(this.liggandeO.getSelectedItem().toString()));
        formel.setList10cm(this.list.isSelected());
        formel.setFjardeBagkant(this.kant.isSelected());
        formel.setInomhus(this.djup.isEnabled());
        formel.setKarmBredd(StaticHelpers.parseDouble(this.bredd.getText()));
        formel.setKarmHojd(StaticHelpers.parseDouble(this.hojd.getText()));
        formel.setKarmDjup(StaticHelpers.parseDouble(this.djup.getText()));
        formel.setTackningListbleck(StaticHelpers.parseDouble(this.listbleck.getText()));
        return formel;
    }

    @Override
    public void setState(FormelDim fd) {
        FonsterDim formel = (FonsterDim)fd;
        this.setUtomhus(!formel.isInomhus());
        this.staende.setSelectedItem(Integer.toString(formel.getStaendeSprojsar()));
        this.staendeO.setSelectedItem(Integer.toString(formel.getOvreStaendeSprojsar()));
        this.liggande.setSelectedItem(Integer.toString(formel.getLiggandeSprojsar()));
        this.liggandeO.setSelectedItem(Integer.toString(formel.getOvreLiggandeSprojsar()));
        this.list.setSelected(formel.isList10cm());
        this.kant.setSelected(formel.isFjardeBagkant());
        this.bredd.setText(StaticHelpers.format2Dec(formel.getKarmBredd()));
        this.hojd.setText(StaticHelpers.format2Dec(formel.getKarmHojd()));
        this.djup.setText(StaticHelpers.format2Dec(formel.getKarmDjup()));
        this.listbleck.setText(StaticHelpers.format2Dec(formel.getTackningListbleck()));
        try {
            this.f\u00f6nsterTyp = Kategori.values()[formel.getFonsterTyp()];
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        switch (this.f\u00f6nsterTyp) {
            case F1: {
                this.f1.doClick();
                break;
            }
            case F1A: {
                this.f1a.doClick();
                break;
            }
            case F2: {
                this.f2.doClick();
                break;
            }
            case F2A: {
                this.f2b.doClick();
                break;
            }
            case F2B: {
                this.f2a.doClick();
                break;
            }
            case F3: {
                this.f3.doClick();
                break;
            }
            case F4: {
                this.f4.doClick();
                break;
            }
            case F4A: {
                this.f4a.doClick();
                break;
            }
            case F6: {
                this.f6.doClick();
                break;
            }
            case FD1: {
                this.fd1.doClick();
                break;
            }
            case FD2: {
                this.fd2.doClick();
                break;
            }
            case ID1: {
                this.id1.doClick();
                break;
            }
            case ID2: {
                this.id2.doClick();
                break;
            }
            case F3A: {
                this.f3a.doClick();
            }
        }
        for (int i = 0; i < this.jComboBox1.getModel().getSize(); ++i) {
            if (!((Tuple)this.jComboBox1.getModel().getElementAt((int)i)).snd.equals(formel.getFonsterSort())) continue;
            this.jComboBox1.setSelectedIndex(i);
        }
    }

    private static Icon buildIcon(Kategori kat) {
        switch (kat) {
            case F1: {
                return new ShapeIcon(new Rectangle(0, 0, 4, 6), 50, 50, false);
            }
            case F1A: {
                return new ShapeIcon(new Ellipse2D.Float(0.0f, 0.0f, 1.0f, 1.0f), 50, 50, false);
            }
            case F2: {
                GeneralPath f2 = new GeneralPath();
                f2.append(new Rectangle(0, 0, 4, 6), true);
                f2.moveTo(2.0f, 0.0f);
                f2.lineTo(2.0f, 6.0f);
                return new ShapeIcon(f2, 50, 50, false);
            }
            case F2A: {
                GeneralPath f2a = new GeneralPath();
                f2a.append(new Rectangle(0, 0, 4, 6), true);
                f2a.moveTo(0.0f, 2.0f);
                f2a.lineTo(4.0f, 2.0f);
                return new ShapeIcon(f2a, 50, 50, false);
            }
            case F2B: {
                GeneralPath f2b = new GeneralPath();
                f2b.append(new Ellipse2D.Float(0.0f, 0.0f, 2.0f, 2.0f), true);
                f2b.moveTo(0.0f, 1.0f);
                f2b.lineTo(2.0f, 1.0f);
                return new ShapeIcon(f2b, 50, 50, false);
            }
            case F3: {
                GeneralPath f3 = new GeneralPath();
                f3.append(new Rectangle(0, 0, 4, 6), true);
                f3.moveTo(0.0f, 2.0f);
                f3.lineTo(4.0f, 2.0f);
                f3.moveTo(2.0f, 2.0f);
                f3.lineTo(2.0f, 6.0f);
                return new ShapeIcon(f3, 50, 50, false);
            }
            case F3A: {
                GeneralPath f3a = new GeneralPath();
                f3a.append(new Rectangle(0, 0, 4, 6), true);
                f3a.append(new Rectangle(4, 0, 4, 6), true);
                f3a.append(new Rectangle(8, 0, 4, 6), true);
                return new ShapeIcon(f3a, 50, 50, false);
            }
            case F4: {
                GeneralPath f4 = new GeneralPath();
                f4.append(new Rectangle(0, 0, 4, 6), true);
                f4.moveTo(2.0f, 0.0f);
                f4.lineTo(2.0f, 6.0f);
                f4.moveTo(0.0f, 2.0f);
                f4.lineTo(4.0f, 2.0f);
                return new ShapeIcon(f4, 50, 50, false);
            }
            case F4A: {
                GeneralPath f4a = new GeneralPath();
                f4a.append(new Rectangle(0, 0, 12, 6), true);
                f4a.moveTo(0.0f, 2.0f);
                f4a.lineTo(12.0f, 2.0f);
                f4a.moveTo(4.0f, 2.0f);
                f4a.lineTo(4.0f, 6.0f);
                f4a.moveTo(8.0f, 2.0f);
                f4a.lineTo(8.0f, 6.0f);
                return new ShapeIcon(f4a, 50, 50, false);
            }
            case F6: {
                GeneralPath f6 = new GeneralPath();
                f6.append(new Rectangle(0, 0, 4, 6), true);
                f6.append(new Rectangle(4, 0, 4, 6), true);
                f6.append(new Rectangle(8, 0, 4, 6), true);
                f6.moveTo(0.0f, 2.0f);
                f6.lineTo(12.0f, 2.0f);
                return new ShapeIcon(f6, 50, 50, false);
            }
            case FD1: {
                GeneralPath fd1 = new GeneralPath();
                fd1.append(new Rectangle(0, 0, 90, 210), true);
                fd1.append(new Rectangle(10, 10, 70, 120), false);
                return new ShapeIcon(fd1, 50, 50, false);
            }
            case FD2: {
                GeneralPath fd2 = new GeneralPath();
                fd2.append(new Rectangle(0, 0, 90, 210), true);
                fd2.append(new Rectangle(10, 10, 70, 120), false);
                fd2.append(new Rectangle(90, 0, 90, 210), false);
                fd2.append(new Rectangle(100, 10, 70, 120), false);
                return new ShapeIcon(fd2, 50, 50, false);
            }
            case ID1: 
            case YD1: {
                GeneralPath id1 = new GeneralPath();
                id1.append(new Rectangle(0, 0, 90, 210), true);
                id1.append(new Rectangle(8, 10, 74, 200), false);
                return new ShapeIcon(id1, 50, 50, false);
            }
            case ID2: {
                GeneralPath id2 = new GeneralPath();
                id2.append(new Rectangle(0, 0, 180, 210), true);
                id2.append(new Rectangle(8, 10, 164, 200), false);
                id2.moveTo(90.0f, 10.0f);
                id2.lineTo(90.0f, 210.0f);
                return new ShapeIcon(id2, 50, 50, false);
            }
        }
        throw new IllegalArgumentException("Fel kategori");
    }

    private double getKarmL\u00e4ngdInsida(double b, double h) {
        switch (this.f\u00f6nsterTyp) {
            case F1: {
                return h * 2.0 + 2.0 * b;
            }
            case F1A: {
                return h * Math.PI;
            }
            case F2: {
                return h * 3.0 + b * 2.0;
            }
            case F2A: {
                return h * 2.0 + b * 3.0;
            }
            case F2B: {
                return h * Math.PI + b;
            }
            case F3: {
                return h * 2.0 + b * 3.0 + h * 0.7;
            }
            case F3A: {
                return h * 4.0 + b * 2.0;
            }
            case F4: {
                return 3.0 * (h + b);
            }
            case F4A: {
                return h * 2.0 * 1.7 + b * 3.0;
            }
            case F6: {
                return h * 4.0 + b * 3.0;
            }
            case ID1: 
            case ID2: 
            case FD1: 
            case FD2: 
            case YD1: {
                return h * 2.0 + b;
            }
        }
        return 0.0;
    }

    private double getKarmL\u00e4ngdUtsida(double bredd, double h\u00f6jd) {
        switch (this.f\u00f6nsterTyp) {
            case ID1: 
            case ID2: {
                return 0.0;
            }
        }
        return this.getKarmL\u00e4ngdInsida(bredd, h\u00f6jd);
    }

    private double getKopplingsL\u00e4ngd(double b, double h) {
        switch (this.f\u00f6nsterTyp) {
            case F1: {
                return h * 2.0 + b * 2.0 - 0.4;
            }
            case F1A: {
                return h * Math.PI - 0.4;
            }
            case F2: {
                return h * 4.0 + b * 2.0 - 0.8;
            }
            case F2A: {
                return h * 2.0 + b * 4.0 - 0.8;
            }
            case F2B: {
                return h * Math.PI + b * 2.0 - 0.8;
            }
            case F3: {
                return h * 2.0 + b * 4.0 + h * 2.0 * 0.7 - 1.2;
            }
            case F3A: {
                return h * 6.0 + b * 2.0 - 1.2;
            }
            case F4: {
                return h * 4.0 + b * 4.0 - 1.6;
            }
            case F4A: {
                return h * 2.0 + b * 4.0 + h * 4.0 * 0.7 - 1.6;
            }
            case F6: {
                return h * 6.0 - b * 4.0 - 2.4;
            }
            case FD1: 
            case FD2: {
                return (h - 0.1) * (b - 0.1);
            }
        }
        return 0.0;
    }

    private double getSt\u00e5endeSpr\u00f6jsar(double bredd, double h\u00f6jd, double antal) {
        switch (this.f\u00f6nsterTyp) {
            case F1: 
            case F1A: {
                return (h\u00f6jd - 0.1) * antal;
            }
            case F2: {
                return (h\u00f6jd - 0.1) * antal * 2.0;
            }
            case F2A: {
                return (h\u00f6jd - 0.1) * 0.7 * antal;
            }
            case F2B: {
                return (h\u00f6jd - 0.1) * 0.5 * antal;
            }
            case F3: 
            case F4: {
                return (h\u00f6jd - 0.1) * 1.4 * antal;
            }
            case F3A: {
                return (h\u00f6jd - 0.1) * antal * 3.0;
            }
            case F4A: 
            case F6: {
                return (h\u00f6jd - 0.1) * 2.1 * antal;
            }
            case FD1: {
                return (h\u00f6jd - 0.8) * antal;
            }
            case FD2: {
                return (h\u00f6jd - 0.8) * antal * 2.0;
            }
        }
        return 0.0;
    }

    private double get\u00d6vreSt\u00e5endeSpr\u00f6jsar(double bredd, double h\u00f6jd, double antal) {
        switch (this.f\u00f6nsterTyp) {
            case ID1: 
            case ID2: 
            case FD1: 
            case FD2: 
            case F1: 
            case F1A: 
            case F2: 
            case F3A: 
            case YD1: {
                return 0.0;
            }
            case F2A: 
            case F3: 
            case F4A: {
                return (h\u00f6jd - 0.1) * 0.3 * antal;
            }
            case F2B: {
                return (h\u00f6jd - 0.1) * 0.5 * antal;
            }
            case F4: {
                return (h\u00f6jd - 0.1) * 0.6 * antal;
            }
            case F6: {
                return (h\u00f6jd - 0.1) * 0.9 * antal;
            }
        }
        return 0.0;
    }

    private double getLiggandeSpr\u00f6jsar(double bredd, double h\u00f6jd, double antal) {
        switch (this.f\u00f6nsterTyp) {
            case F1: 
            case F1A: 
            case F2A: {
                return (bredd - 0.1) * antal;
            }
            case FD1: 
            case F2: 
            case F3: 
            case F4: {
                return (bredd - 0.2) * antal;
            }
            case F2B: {
                return (bredd - 0.1) * 0.5 * antal;
            }
            case F4A: 
            case F6: 
            case F3A: {
                return (bredd - 0.3) * antal;
            }
            case FD2: {
                return (bredd - 0.2) * 2.0 * antal;
            }
        }
        return 0.0;
    }

    private double get\u00d6vreLiggandeSpr\u00f6jsar(double bredd, double h\u00f6jd, double antal) {
        switch (this.f\u00f6nsterTyp) {
            case ID1: 
            case ID2: 
            case FD1: 
            case FD2: 
            case F1: 
            case F1A: 
            case F2: 
            case F3A: 
            case YD1: {
                return 0.0;
            }
            case F2A: 
            case F3: 
            case F4A: {
                return (bredd - 0.1) * antal;
            }
            case F2B: {
                return (bredd - 0.1) * 0.5 * antal;
            }
            case F4: {
                return (bredd - 0.2) * antal;
            }
            case F6: {
                return (bredd - 0.3) * antal;
            }
        }
        return 0.0;
    }

    private double getB\u00e5gL\u00e4ngdInomhus(double b, double h) {
        switch (this.f\u00f6nsterTyp) {
            case F1: {
                return h * 2.0 + b * 2.0 - 0.4;
            }
            case F1A: {
                return h * Math.PI - 0.4;
            }
            case F2: {
                return h * 4.0 + b * 2.0 - 0.8;
            }
            case F2A: {
                return h * 2.0 + b * 4.0 - 0.8;
            }
            case F2B: {
                return h * Math.PI + b * 2.0 - 0.8;
            }
            case F3: {
                return h * 2.0 * 1.7 + b * 4.0 - 1.2;
            }
            case F3A: {
                return h * 6.0 + b * 2.0 - 1.2;
            }
            case F4: {
                return 4.0 * (h + b) - 1.6;
            }
            case F4A: {
                return h * 2.0 + b * 4.0 + h * 4.0 * 0.7 - 1.6;
            }
            case F6: {
                return h * 6.0 + b * 4.0 - 2.4;
            }
            case ID1: 
            case ID2: 
            case FD1: 
            case FD2: 
            case YD1: {
                return (h - 0.1) * (b - 0.1);
            }
        }
        return 0.0;
    }

    private double getB\u00e5gL\u00e4ngdUtomhus(double b, double h) {
        switch (this.f\u00f6nsterTyp) {
            case ID1: 
            case ID2: {
                return 0.0;
            }
        }
        return this.getB\u00e5gL\u00e4ngdInomhus(b, h);
    }

    private double getFj\u00e4rdeB\u00e5gkant(double b, double h) {
        switch (this.f\u00f6nsterTyp) {
            case F1: {
                return h;
            }
            case F1A: {
                return h * 0.5;
            }
            case F2: {
                return h * 2.0;
            }
            case F2A: {
                return h * 0.7 + b;
            }
            case F2B: {
                return b * 2.0;
            }
            case F3: {
                return h * 1.4 + b;
            }
            case F3A: {
                return h * 3.0;
            }
            case F4: {
                return h * 2.0;
            }
            case F4A: 
            case F6: {
                return h * 2.1 + b;
            }
        }
        return 0.0;
    }

    private double getKarmList(double bredd, double h\u00f6jd) {
        switch (this.f\u00f6nsterTyp) {
            case F1: 
            case F1A: 
            case F2: 
            case F2A: 
            case F2B: 
            case F3: 
            case F4: 
            case F4A: 
            case F6: 
            case F3A: {
                return h\u00f6jd * 2.0 + bredd;
            }
        }
        return 0.0;
    }

    private static enum Kategori {
        F1,
        F1A,
        F2,
        F2A,
        F2B,
        F3,
        F3A,
        F4,
        F4A,
        F6,
        FD1,
        FD2,
        ID1,
        ID2,
        YD1;

    }
}

