/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.image.JBIG2Bitmap;

public class JBIG2ImageReader
extends ImageReader {
    private static final Logger logger = Logger.getLogger(JBIG2ImageReader.class.toString());
    private JBIG2Decoder decoder;
    private ImageInputStream stream;
    private boolean readFile;

    protected JBIG2ImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            this.stream = null;
            return;
        }
        if (!(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("ImageInputStream expected!");
        }
        this.stream = (ImageInputStream)input;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        BufferedImage dst = null;
        try {
            int width = this.getWidth(imageIndex);
            int height = this.getHeight(imageIndex);
            Rectangle sourceRegion = JBIG2ImageReader.getSourceRegion(param, width, height);
            int sourceXSubsampling = 1;
            int sourceYSubsampling = 1;
            Point destinationOffset = new Point(0, 0);
            if (param != null) {
                sourceXSubsampling = param.getSourceXSubsampling();
                sourceYSubsampling = param.getSourceYSubsampling();
                destinationOffset = param.getDestinationOffset();
            }
            dst = JBIG2ImageReader.getDestination(param, this.getImageTypes(0), width, height);
            WritableRaster wrDst = dst.getRaster();
            JBIG2Bitmap bitmap = this.decoder.getPageAsJBIG2Bitmap(imageIndex).getSlice(sourceRegion.x, sourceRegion.y, sourceRegion.width, sourceRegion.height);
            BufferedImage image = bitmap.getBufferedImage();
            int newWidth = (int)((double)image.getWidth() * (1.0 / (double)sourceXSubsampling));
            int newHeight = (int)((double)image.getHeight() * (1.0 / (double)sourceYSubsampling));
            BufferedImage scaledImage = JBIG2ImageReader.scaleImage(image.getRaster(), newWidth, newHeight, 1, 1);
            WritableRaster raster = null;
            raster = scaledImage != null ? scaledImage.getRaster() : image.getRaster();
            wrDst.setRect(destinationOffset.x, destinationOffset.y, raster);
        }
        catch (RuntimeException e) {
            logger.log(Level.FINE, "Error reading JBIG2 image data", e);
        }
        return dst;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.readFile();
        this.checkIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        l.add(ImageTypeSpecifier.createFromBufferedImageType(12));
        return l.iterator();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.readFile();
        return this.decoder.getNumberOfPages();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readFile();
        this.checkIndex(imageIndex);
        return this.decoder.getPageAsJBIG2Bitmap(imageIndex).getHeight();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readFile();
        this.checkIndex(imageIndex);
        return this.decoder.getPageAsJBIG2Bitmap(imageIndex).getWidth();
    }

    private void checkIndex(int imageIndex) {
        int noOfPages = this.decoder.getNumberOfPages();
        if (imageIndex < 0 || imageIndex > noOfPages) {
            throw new IndexOutOfBoundsException("Bad index!");
        }
    }

    private static BufferedImage scaleImage(Raster ras, int pX, int pY, int comp, int d) {
        int sampling;
        byte[] data;
        int h;
        int w;
        block26: {
            int scaleY;
            int newH;
            w = ras.getWidth();
            h = ras.getHeight();
            data = ((DataBufferByte)ras.getDataBuffer()).getData();
            int newW = w;
            sampling = 1;
            int smallestH = pY << 2;
            int smallestW = pX << 2;
            for (newH = h; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                sampling <<= 1;
            }
            int scaleX = w / pX;
            if (scaleX < 1) {
                scaleX = 1;
            }
            if ((scaleY = h / pY) < 1) {
                scaleY = 1;
            }
            if ((sampling = scaleX) > scaleY) {
                sampling = scaleY;
            }
            if (sampling > 1) {
                newW = w / sampling;
                newH = h / sampling;
                if (d == 1) {
                    int size = newW * newH;
                    byte[] newData = new byte[size];
                    int[] flag = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                    int origLineLength = w + 7 >> 3;
                    for (int y = 0; y < newH; ++y) {
                        for (int x = 0; x < newW; ++x) {
                            int bytes = 0;
                            int count = 0;
                            int wCount = sampling;
                            int hCount = sampling;
                            int wGapLeft = w - x;
                            int hGapLeft = h - y;
                            if (wCount > wGapLeft) {
                                wCount = wGapLeft;
                            }
                            if (hCount > hGapLeft) {
                                hCount = hGapLeft;
                            }
                            for (int yy = 0; yy < hCount; ++yy) {
                                for (int xx = 0; xx < wCount; ++xx) {
                                    byte currentByte = data[(yy + y * sampling) * origLineLength + (x * sampling + xx >> 3)];
                                    int bit = currentByte & flag[7 - (x * sampling + xx & 7)];
                                    if (bit != 0) {
                                        ++bytes;
                                    }
                                    ++count;
                                }
                            }
                            int offset = x + newW * y;
                            newData[offset] = count > 0 ? (int)(255 * bytes / count) : -1;
                        }
                    }
                    data = newData;
                    h = newH;
                    w = newW;
                    d = 8;
                } else if (d == 8) {
                    int x = 0;
                    int y = 0;
                    int xx = 0;
                    int yy = 0;
                    int jj = 0;
                    int origLineLength = 0;
                    try {
                        if (w * h == data.length) {
                            comp = 1;
                        }
                        byte[] newData = new byte[newW * newH * comp];
                        origLineLength = w * comp;
                        for (y = 0; y < newH; ++y) {
                            for (x = 0; x < newW; ++x) {
                                int wCount = sampling;
                                int hCount = sampling;
                                int wGapLeft = w - x;
                                int hGapLeft = h - y;
                                if (wCount > wGapLeft) {
                                    wCount = wGapLeft;
                                }
                                if (hCount > hGapLeft) {
                                    hCount = hGapLeft;
                                }
                                for (jj = 0; jj < comp; ++jj) {
                                    int byteTotal = 0;
                                    int count = 0;
                                    for (yy = 0; yy < hCount; ++yy) {
                                        for (xx = 0; xx < wCount; ++xx) {
                                            byteTotal += data[(yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj)] & 0xFF;
                                            ++count;
                                        }
                                    }
                                    if (count <= 0) continue;
                                    newData[jj + x * comp + newW * y * comp] = (byte)(byteTotal / count);
                                }
                            }
                        }
                        data = newData;
                        h = newH;
                        w = newW;
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINE)) break block26;
                        logger.fine("xx=" + xx + " yy=" + yy + " jj=" + jj + " ptr=" + (yy + y * sampling) * origLineLength + (x * sampling + xx * comp + jj) + '/' + data.length);
                        logger.fine((yy + y * sampling) * origLineLength + " " + (x * sampling + xx * comp + jj));
                        logger.fine("w=" + w + " h=" + h + " sampling=" + sampling + " x=" + x + " y=" + y);
                        logger.log(Level.FINE, "Error scaling image", e);
                    }
                }
            }
        }
        if (sampling > 1) {
            int[] bands = new int[]{0};
            WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(data, data.length), w, h, w, 1, bands, null);
            BufferedImage image = new BufferedImage(w, h, 10);
            image.setData(raster);
            return image;
        }
        return null;
    }

    private void readFile() {
        if (this.readFile) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("No input stream!");
        }
        this.decoder = new JBIG2Decoder();
        try {
            byte[] data;
            int size = (int)this.stream.length();
            if (size == -1) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] temp = new byte[8192];
                int len = 0;
                while ((len = this.stream.read(temp)) > 0) {
                    bos.write(temp, 0, len);
                }
                bos.close();
                data = bos.toByteArray();
            } else {
                data = new byte[size];
                this.stream.readFully(data);
            }
            this.decoder.decodeJBIG2(data);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error reading JBIG2 image data", e);
        }
        catch (JBIG2Exception e) {
            logger.log(Level.FINE, "Error reading JBIG2 image data", e);
        }
        this.readFile = true;
    }
}

