/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.viewer;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.util.FontPropertiesManager;
import org.icepdf.ri.util.PropertiesManager;
import org.icepdf.ri.util.URLAccess;
import org.icepdf.ri.viewer.WindowManager;

public class Launcher {
    private static final Logger logger = Logger.getLogger(Launcher.class.toString());
    public static WindowManager windowManager;
    private static PropertiesManager propertiesManager;

    public static void main(String[] argv) {
        boolean brokenUsage = false;
        String contentURL = "";
        String contentFile = "";
        String contentProperties = null;
        for (int i = 0; i < argv.length; ++i) {
            if (i == argv.length - 1) {
                brokenUsage = true;
                break;
            }
            String arg = argv[i];
            if (arg.equals("-loadfile")) {
                contentFile = argv[++i].trim();
                continue;
            }
            if (arg.equals("-loadurl")) {
                contentURL = argv[++i].trim();
                continue;
            }
            if (arg.equals("-loadproperties")) {
                contentProperties = argv[++i].trim();
                continue;
            }
            brokenUsage = true;
            break;
        }
        ResourceBundle messageBundle = ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle");
        if (brokenUsage) {
            System.out.println(messageBundle.getString("viewer.commandLin.error"));
            System.exit(1);
        }
        Launcher.run(contentFile, contentURL, contentProperties, messageBundle);
    }

    private static void run(String contentFile, String contentURL, String contentProperties, ResourceBundle messageBundle) {
        Properties sysProps = System.getProperties();
        propertiesManager = new PropertiesManager(sysProps, contentProperties, messageBundle);
        new FontPropertiesManager(propertiesManager, sysProps, messageBundle);
        System.setProperties(sysProps);
        Launcher.setupLookAndFeel(messageBundle);
        ViewModel.setDefaultFilePath(propertiesManager.getDefaultFilePath());
        ViewModel.setDefaultURL(propertiesManager.getDefaultURL());
        windowManager = new WindowManager(propertiesManager, messageBundle);
        if (contentFile != null && contentFile.length() > 0) {
            windowManager.newWindow(contentFile);
            ViewModel.setDefaultFilePath(contentFile);
        }
        if (contentURL != null && contentURL.length() > 0) {
            URLAccess urlAccess = URLAccess.doURLAccess(contentURL);
            urlAccess.closeConnection();
            if (urlAccess.errorMessage != null) {
                Object[] messageArguments = new Object[]{urlAccess.errorMessage, urlAccess.urlLocation};
                MessageFormat formatter = new MessageFormat(messageBundle.getString("viewer.launcher.URLError.dialog.message"));
                JOptionPane.showMessageDialog(null, formatter.format(messageArguments), messageBundle.getString("viewer.launcher.URLError.dialog.title"), 1);
            } else {
                windowManager.newWindow(urlAccess.url);
            }
            ViewModel.setDefaultURL(urlAccess.urlLocation);
            urlAccess.dispose();
        }
        if ((contentFile == null || contentFile.length() == 0) && (contentURL == null || contentURL.length() == 0) || windowManager.getNumberOfWindows() == 0L) {
            windowManager.newWindow("");
        }
    }

    private static void setupLookAndFeel(ResourceBundle messageBundle) {
        String className;
        if (Defs.sysProperty("mrj.version") != null) {
            Defs.setSystemProperty("apple.laf.useScreenMenuBar", "true");
            String appName = messageBundle.getString("viewer.window.title.default");
            Defs.setSystemProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        }
        if ((className = propertiesManager.getLookAndFeel("application.lookandfeel", null)) != null) {
            try {
                UIManager.setLookAndFeel(className);
                return;
            }
            catch (Exception e) {
                Object[] messageArguments = new Object[]{propertiesManager.getString("application.lookandfeel")};
                MessageFormat formatter = new MessageFormat(messageBundle.getString("viewer.launcher.URLError.dialog.message"));
                JOptionPane.showMessageDialog(null, formatter.format(messageArguments), messageBundle.getString("viewer.launcher.lookAndFeel.error.message"), 0);
            }
        }
        try {
            String defaultLF = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(defaultLF);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error setting Swing Look and Feel.", e);
        }
    }
}

