/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.SwingWorker;

public class TextExtractionTask {
    private static final Logger logger = Logger.getLogger(TextExtractionTask.class.toString());
    private int lengthOfTask;
    private int current = 0;
    private String dialogMessage;
    private boolean done = false;
    private boolean canceled = false;
    private ResourceBundle messageBundle;
    private Document document = null;
    private File file = null;

    public TextExtractionTask(Document document, File file, ResourceBundle messageBundle) {
        this.document = document;
        this.file = file;
        this.lengthOfTask = document.getNumberOfPages();
        this.messageBundle = messageBundle;
    }

    public void go() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                TextExtractionTask.this.current = 0;
                TextExtractionTask.this.done = false;
                TextExtractionTask.this.canceled = false;
                TextExtractionTask.this.dialogMessage = null;
                return new ActualTask();
            }
        };
        worker.setThreadPriority(1);
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
        this.dialogMessage = null;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return this.dialogMessage;
    }

    class ActualTask {
        ActualTask() {
            try {
                BufferedWriter fileOutputStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(TextExtractionTask.this.file), "UTF8"));
                String pageNumber = TextExtractionTask.this.messageBundle.getString("viewer.exportText.fileStamp.msg");
                fileOutputStream.write(pageNumber);
                fileOutputStream.write(10);
                for (int i = 0; i < TextExtractionTask.this.document.getNumberOfPages() && !TextExtractionTask.this.canceled && !TextExtractionTask.this.done; ++i) {
                    TextExtractionTask.this.current = i;
                    MessageFormat messageForm = new MessageFormat(TextExtractionTask.this.messageBundle.getString("viewer.exportText.fileStamp.progress.msg"));
                    double[] fileLimits = new double[]{0.0, 1.0, 2.0};
                    String[] fileStrings = new String[]{TextExtractionTask.this.messageBundle.getString("viewer.exportText.fileStamp.progress.moreFile.msg"), TextExtractionTask.this.messageBundle.getString("viewer.exportText.fileStamp.progress.oneFile.msg"), TextExtractionTask.this.messageBundle.getString("viewer.exportText.fileStamp.progress.moreFile.msg")};
                    ChoiceFormat choiceForm = new ChoiceFormat(fileLimits, fileStrings);
                    Format[] formats = new Format[]{null, choiceForm, null};
                    messageForm.setFormats(formats);
                    Object[] messageArguments = new Object[]{String.valueOf(TextExtractionTask.this.current + 1), TextExtractionTask.this.lengthOfTask, TextExtractionTask.this.lengthOfTask};
                    TextExtractionTask.this.dialogMessage = messageForm.format(messageArguments);
                    messageForm = new MessageFormat(TextExtractionTask.this.messageBundle.getString("viewer.exportText.pageStamp.msg"));
                    messageArguments = new Object[]{String.valueOf(TextExtractionTask.this.current + 1)};
                    pageNumber = messageForm.format(messageArguments);
                    fileOutputStream.write(pageNumber);
                    fileOutputStream.write(10);
                    String pageText = TextExtractionTask.this.document.getPageText(i).toString();
                    fileOutputStream.write(pageText);
                    Thread.yield();
                }
                TextExtractionTask.this.done = true;
                TextExtractionTask.this.current = 0;
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (Throwable e) {
                logger.log(Level.FINE, "Malformed URL Exception ", e);
            }
        }
    }
}

