/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.awt.Container;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingWorker;
import org.icepdf.ri.common.utility.search.SearchPanel;

public class SearchTextTask {
    private int lengthOfTask;
    private int current = 0;
    private String dialogMessage;
    private MessageFormat searchingMessageForm;
    private MessageFormat searchResultMessageForm;
    private MessageFormat searchCompletionMessageForm;
    private boolean done = false;
    private boolean canceled = false;
    private int totalHitCount = 0;
    private String pattern = "";
    private boolean wholeWord;
    private boolean caseSensitive;
    private boolean cumulative;
    private boolean showPages;
    private boolean r2L;
    SwingController controller;
    private SearchPanel searchPanel;
    private ResourceBundle messageBundle;
    private boolean currentlySearching;
    private Container viewContainer;

    public SearchTextTask(SearchPanel searchPanel, SwingController controller, String pattern, boolean wholeWord, boolean caseSensitive, boolean cumulative, boolean showPages, boolean r2L, ResourceBundle messageBundle) {
        this.controller = controller;
        this.pattern = pattern;
        this.searchPanel = searchPanel;
        this.lengthOfTask = controller.getDocument().getNumberOfPages();
        this.messageBundle = messageBundle;
        this.viewContainer = controller.getDocumentViewController().getViewContainer();
        this.wholeWord = wholeWord;
        this.caseSensitive = caseSensitive;
        this.cumulative = cumulative;
        this.showPages = showPages;
        this.r2L = r2L;
        if (searchPanel != null) {
            this.searchingMessageForm = searchPanel.setupSearchingMessageForm();
            this.searchResultMessageForm = searchPanel.setupSearchResultMessageForm();
            this.searchCompletionMessageForm = searchPanel.setupSearchCompletionMessageForm();
        }
    }

    public void go() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                SearchTextTask.this.current = 0;
                SearchTextTask.this.done = false;
                SearchTextTask.this.canceled = false;
                SearchTextTask.this.dialogMessage = null;
                return new ActualTask();
            }
        };
        worker.setThreadPriority(5);
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
        this.dialogMessage = null;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isCurrentlySearching() {
        return this.currentlySearching;
    }

    public String getMessage() {
        return this.dialogMessage;
    }

    public String getFinalMessage() {
        this.setDialogMessage();
        return this.dialogMessage;
    }

    private void setDialogMessage() {
        Object[] messageArguments = new Object[]{String.valueOf(this.current + 1), this.current + 1, this.totalHitCount};
        this.dialogMessage = this.searchCompletionMessageForm.format(messageArguments);
    }

    class ActualTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ActualTask() {
            if ("".equals(SearchTextTask.this.pattern) || " ".equals(SearchTextTask.this.pattern)) {
                return;
            }
            try {
                SearchTextTask.this.currentlySearching = true;
                SearchTextTask.this.totalHitCount = 0;
                SearchTextTask.this.current = 0;
                DocumentSearchController searchController = SearchTextTask.this.controller.getDocumentSearchController();
                if (!SearchTextTask.this.cumulative) {
                    searchController.clearAllSearchHighlight();
                }
                searchController.addSearchTerm(SearchTextTask.this.pattern, SearchTextTask.this.caseSensitive, SearchTextTask.this.wholeWord);
                Document document = SearchTextTask.this.controller.getDocument();
                for (int i = 0; i < document.getNumberOfPages(); ++i) {
                    if (SearchTextTask.this.canceled || SearchTextTask.this.done) {
                        SearchTextTask.this.setDialogMessage();
                        break;
                    }
                    SearchTextTask.this.current = i;
                    Object[] messageArguments = new Object[]{String.valueOf(SearchTextTask.this.current + 1), SearchTextTask.this.lengthOfTask, SearchTextTask.this.lengthOfTask};
                    SearchTextTask.this.dialogMessage = SearchTextTask.this.searchingMessageForm.format(messageArguments);
                    final List<LineText> lineItems = searchController.searchHighlightPage(SearchTextTask.this.current, 6);
                    int hitCount = lineItems.size();
                    SearchTextTask.this.totalHitCount += hitCount;
                    if (hitCount > 0) {
                        messageArguments = new Object[]{String.valueOf(SearchTextTask.this.current + 1), hitCount, hitCount};
                        final String nodeText = SearchTextTask.this.searchResultMessageForm.format(messageArguments);
                        final int currentPage = i;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchTextTask.this.searchPanel.addFoundEntry(nodeText, currentPage, lineItems, SearchTextTask.this.showPages);
                                SearchTextTask.this.viewContainer.repaint();
                            }
                        });
                    }
                    Thread.yield();
                }
                SearchTextTask.this.setDialogMessage();
                SearchTextTask.this.done = true;
            }
            finally {
                SearchTextTask.this.currentlySearching = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchTextTask.this.viewContainer.validate();
                }
            });
        }
    }
}

