/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.icepdf.ri.util.Resources;

final class Parse {
    private static final String[] booleanNames = new String[]{"yes", "no", "true", "false"};
    private static final boolean[] booleans = new boolean[]{true, false, true, false};

    Parse() {
    }

    public static Integer parseInteger(String s, ResourceBundle messageBundle) {
        s = s.trim();
        try {
            return new Integer(s);
        }
        catch (NumberFormatException ex) {
            if (messageBundle != null) {
                Resources.showMessageDialog(null, 1, messageBundle, "parse.title", "parse.integer", s);
            }
            return null;
        }
    }

    public static Long parseLong(String s, ResourceBundle messageBundle) {
        s = s.trim();
        try {
            return new Long(s);
        }
        catch (NumberFormatException ex) {
            if (messageBundle != null) {
                Resources.showMessageDialog(null, 1, messageBundle, "parse.title", "parse.float", s);
            }
            return null;
        }
    }

    public static Float parseFloat(String s, ResourceBundle messageBundle) {
        s = s.trim();
        try {
            return new Float(s);
        }
        catch (NumberFormatException ex) {
            if (messageBundle != null) {
                Resources.showMessageDialog(null, 1, messageBundle, "parse.title", "parse.float", s);
            }
            return null;
        }
    }

    public static Double parseDouble(String s, ResourceBundle messageBundle) {
        s = s.trim();
        try {
            return new Double(s);
        }
        catch (NumberFormatException ex) {
            if (messageBundle != null) {
                Resources.showMessageDialog(null, 1, messageBundle, "parse.title", "parse.double", s);
            }
            return null;
        }
    }

    public static Boolean parseBoolean(String s, ResourceBundle messageBundle) {
        s = s.trim();
        for (int i = 0; i < booleanNames.length; ++i) {
            if (!s.equalsIgnoreCase(booleanNames[i])) continue;
            return booleans[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (messageBundle != null) {
            Resources.showMessageDialog(null, 1, messageBundle, "parse.title", "parse.choice", s);
        }
        return null;
    }

    public static String parseLookAndFeel(String s, ResourceBundle messageBundle) {
        UIManager.LookAndFeelInfo[] looks;
        s = s.trim();
        for (UIManager.LookAndFeelInfo look : looks = UIManager.getInstalledLookAndFeels()) {
            if (!s.equalsIgnoreCase(look.getName())) continue;
            return look.getClassName();
        }
        if (messageBundle != null) {
            Resources.showMessageDialog(null, 1, messageBundle, "parse.title", "parse.laf", s);
        }
        return null;
    }
}

