/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.ResizableBorder;
import org.icepdf.ri.common.views.annotations.AnnotationState;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public abstract class AbstractAnnotationComponent
extends JComponent
implements FocusListener,
MouseInputListener,
AnnotationComponent {
    protected static final Logger logger;
    protected static boolean isInteractiveAnnotationsEnabled;
    protected static Color annotationHighlightColor;
    protected static float annotationHighlightAlpha;
    public static final int resizeBoxSize = 4;
    protected static ResizableBorder resizableBorder;
    protected AbstractPageViewComponent pageViewComponent;
    protected DocumentViewController documentViewController;
    protected DocumentViewModel documentViewModel;
    protected float currentZoom;
    protected float currentRotation;
    protected Annotation annotation;
    protected boolean isMousePressed;
    protected boolean resized;
    protected boolean wasResized;
    protected boolean isEditable;
    protected boolean isRollover;
    protected boolean isMovable;
    protected boolean isResizable;
    protected boolean isShowInvisibleBorder;
    protected boolean isSelected;
    protected int cursor;
    protected Point startPos;
    protected AnnotationState previousAnnotationState;
    protected Point startOfMousePress;
    protected Point endOfMousePress;
    protected ResourceBundle messageBundle;

    public AbstractAnnotationComponent(Annotation annotation, DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        this.pageViewComponent = pageViewComponent;
        this.documentViewModel = documentViewModel;
        this.documentViewController = documentViewController;
        this.annotation = annotation;
        this.messageBundle = documentViewController.getParentController().getMessageBundle();
        this.isEditable = !annotation.getFlagReadOnly();
        this.isRollover = false;
        this.isMovable = !annotation.getFlagReadOnly() && !annotation.getFlagLocked();
        this.isResizable = !annotation.getFlagReadOnly() && !annotation.getFlagLocked();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(resizableBorder);
        Page currentPage = pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        final Rectangle location = at.createTransformedShape(annotation.getUserSpaceRectangle()).getBounds();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractAnnotationComponent.this.setBounds(location);
            }
        });
        this.currentRotation = documentViewModel.getViewRotation();
        this.currentZoom = documentViewModel.getViewZoom();
        resizableBorder.setZoom(this.currentZoom);
    }

    @Override
    public Document getDocument() {
        return this.documentViewModel.getDocument();
    }

    @Override
    public int getPageIndex() {
        return this.pageViewComponent.getPageIndex();
    }

    @Override
    public PageViewComponent getParentPageView() {
        return this.pageViewComponent;
    }

    @Override
    public AbstractPageViewComponent getPageViewComponent() {
        return this.pageViewComponent;
    }

    public void removeMouseListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
        this.isSelected = true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
        this.isSelected = false;
    }

    protected void resize() {
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.resized = true;
    }

    @Override
    public void refreshDirtyBounds() {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        this.setBounds(this.commonBoundsNormalization(new GeneralPath(this.annotation.getUserSpaceRectangle()), at));
    }

    @Override
    public void refreshAnnotationRect() {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error refreshing annotation rectangle", e);
        }
        Rectangle2D rect = this.annotation.getUserSpaceRectangle();
        rect = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        Rectangle bounds = this.getBounds();
        rect.setRect(this.commonBoundsNormalization(new GeneralPath(bounds), at));
        this.annotation.syncBBoxToUserSpaceRectangle(rect);
    }

    protected Rectangle commonBoundsNormalization(GeneralPath shapePath, AffineTransform at) {
        shapePath.transform(at);
        Rectangle2D pageSpaceBound = shapePath.getBounds2D();
        return new Rectangle((int)Math.round(pageSpaceBound.getX()), (int)Math.round(pageSpaceBound.getY()), (int)Math.round(pageSpaceBound.getWidth()), (int)Math.round(pageSpaceBound.getHeight()));
    }

    @Override
    public void validate() {
        if (this.currentZoom != this.documentViewModel.getViewZoom() || this.currentRotation != this.documentViewModel.getViewRotation()) {
            this.refreshDirtyBounds();
            this.currentRotation = this.documentViewModel.getViewRotation();
            this.currentZoom = this.documentViewModel.getViewZoom();
            resizableBorder.setZoom(this.currentZoom);
        }
        if (this.resized) {
            this.refreshAnnotationRect();
            if (this.getParent() != null) {
                this.getParent().validate();
                this.getParent().repaint();
            }
            this.resized = false;
            this.wasResized = true;
        }
    }

    @Override
    public abstract void paintComponent(Graphics var1);

    @Override
    public abstract void resetAppearanceShapes();

    @Override
    public void mouseMoved(MouseEvent me) {
        int toolMode = this.documentViewModel.getViewToolMode();
        if (toolMode == 6 && !this.annotation.getFlagLocked() && !this.annotation.getFlagReadOnly()) {
            ResizableBorder border = (ResizableBorder)this.getBorder();
            this.setCursor(Cursor.getPredefinedCursor(border.getCursor(me)));
        } else {
            this.setCursor(this.documentViewController.getViewCursor(9));
        }
    }

    @Override
    public void dispose() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeFocusListener(this);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
        this.isRollover = false;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
        if (!AbstractPageViewComponent.isAnnotationTool(this.documentViewModel.getViewToolMode()) && isInteractiveAnnotationsEnabled && this.documentViewController.getAnnotationCallback() != null) {
            this.documentViewController.getAnnotationCallback().processAnnotationAction(this.annotation);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isRollover = this.documentViewModel.getViewToolMode() == 6 || this instanceof PopupAnnotationComponent;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isMousePressed = true;
        this.startOfMousePress = e.getPoint();
        this.endOfMousePress = e.getPoint();
        if (this.documentViewModel.getViewToolMode() == 6 && isInteractiveAnnotationsEnabled && !this.annotation.getFlagReadOnly()) {
            this.initiateMouseMoved(e);
        }
        this.repaint();
    }

    protected void initiateMouseMoved(MouseEvent e) {
        ResizableBorder border = (ResizableBorder)this.getBorder();
        this.cursor = border.getCursor(e);
        this.startPos = e.getPoint();
        this.previousAnnotationState = new AnnotationState(this);
        this.documentViewController.assignSelectedAnnotation(this);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.startPos != null && this.isMovable && !this.annotation.getFlagLocked() && !this.annotation.getFlagReadOnly()) {
            int x = this.getX();
            int y = this.getY();
            int w = this.getWidth();
            int h = this.getHeight();
            int dx = me.getX() - this.startPos.x;
            int dy = me.getY() - this.startPos.y;
            if (this.endOfMousePress != null) {
                this.endOfMousePress.setLocation(this.endOfMousePress.x + dx, this.endOfMousePress.y + dy);
            }
            switch (this.cursor) {
                case 8: {
                    if (!this.isResizable || h - dy < 12) break;
                    this.setBounds(x, y + dy, w, h - dy);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 9: {
                    if (!this.isResizable || h + dy < 12) break;
                    this.setBounds(x, y, w, h + dy);
                    this.startPos = me.getPoint();
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 10: {
                    if (!this.isResizable || w - dx < 18) break;
                    this.setBounds(x + dx, y, w - dx, h);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 11: {
                    if (!this.isResizable || w + dx < 18) break;
                    this.setBounds(x, y, w + dx, h);
                    this.startPos = me.getPoint();
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 6: {
                    if (!this.isResizable || w - dx < 18 || h - dy < 18) break;
                    this.setBounds(x + dx, y + dy, w - dx, h - dy);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 7: {
                    if (!this.isResizable || w + dx < 18 || h - dy < 18) break;
                    this.setBounds(x, y + dy, w + dx, h - dy);
                    this.startPos = new Point(me.getX(), this.startPos.y);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 4: {
                    if (!this.isResizable || w - dx < 18 || h + dy < 18) break;
                    this.setBounds(x + dx, y, w - dx, h + dy);
                    this.startPos = new Point(this.startPos.x, me.getY());
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 5: {
                    if (!this.isResizable || w + dx < 18 || h + dy < 18) break;
                    this.setBounds(x, y, w + dx, h + dy);
                    this.startPos = me.getPoint();
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                    break;
                }
                case 13: {
                    if (!this.isMovable) break;
                    Rectangle bounds = this.getBounds();
                    bounds.translate(dx, dy);
                    this.setBounds(bounds);
                    this.resize();
                    this.setCursor(Cursor.getPredefinedCursor(this.cursor));
                }
            }
            this.validate();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.startPos = null;
        this.isMousePressed = false;
        if (this.wasResized) {
            this.wasResized = false;
            this.refreshAnnotationRect();
            double dx = 0.0;
            double dy = 0.0;
            if (this.startOfMousePress != null && this.endOfMousePress != null) {
                dx = this.endOfMousePress.getX() - this.startOfMousePress.getX();
                dy = this.endOfMousePress.getY() - this.startOfMousePress.getY();
            }
            this.annotation.resetAppearanceStream(dx, -dy, this.getPageTransform());
            this.documentViewController.firePropertyChange("annotationBounds", this.previousAnnotationState, new AnnotationState(this));
        }
        this.repaint();
    }

    protected Rectangle convertToPageSpace(Rectangle rect) {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error converting to page space.", e);
        }
        Rectangle tBbox = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        tBbox = at.createTransformedShape(tBbox).getBounds();
        return tBbox;
    }

    protected AffineTransform getPageTransform() {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error getting page transform.", e);
        }
        return at;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isRollover() {
        return this.isRollover;
    }

    @Override
    public boolean isBorderStyle() {
        return this.annotation.isBorder();
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    @Override
    public boolean isMovable() {
        return this.isMovable;
    }

    @Override
    public boolean isResizable() {
        return this.isResizable;
    }

    @Override
    public boolean isShowInvisibleBorder() {
        return this.isShowInvisibleBorder;
    }

    static {
        block5: {
            logger = Logger.getLogger(AbstractAnnotationComponent.class.toString());
            isInteractiveAnnotationsEnabled = Defs.sysPropertyBoolean("org.icepdf.core.annotations.interactive.enabled", true);
            try {
                String color = Defs.sysProperty("org.icepdf.core.views.page.annotation.highlight.color", "#000000");
                int colorValue = ColorUtil.convertColor(color);
                annotationHighlightColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("000000", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading page annotation highlight colour");
            }
        }
        try {
            String alpha = Defs.sysProperty("org.icepdf.core.views.page.annotation.highlight.alpha", "0.4");
            annotationHighlightAlpha = Float.parseFloat(alpha);
        }
        catch (NumberFormatException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Error reading page annotation highlight alpha");
            }
            annotationHighlightAlpha = 0.4f;
        }
        resizableBorder = new ResizableBorder(4);
    }
}

