/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.CurrentPageChanger;
import org.icepdf.ri.common.KeyListenerPageChanger;
import org.icepdf.ri.common.MouseWheelListenerPageChanger;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModelImpl;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewDecorator;

public class TwoPageView
extends AbstractDocumentView {
    protected JScrollPane documentScrollpane;
    protected boolean disposing;
    protected int viewAlignment;
    protected JPanel pagesPanel;
    protected Object pageChangerListener;
    protected KeyListenerPageChanger keyListenerPageChanger;
    protected CurrentPageChanger currentPageChanger;

    public TwoPageView(DocumentViewController documentDocumentViewController, JScrollPane documentScrollpane, DocumentViewModelImpl documentViewModel, int viewAlignment) {
        super(documentDocumentViewController, documentScrollpane, documentViewModel);
        this.documentScrollpane = documentScrollpane;
        this.viewAlignment = viewAlignment;
        this.buildGUI();
        if (this.documentViewController.getParentController() instanceof SwingController) {
            this.pageChangerListener = MouseWheelListenerPageChanger.install((SwingController)this.documentViewController.getParentController(), this.documentScrollpane, this);
            this.keyListenerPageChanger = KeyListenerPageChanger.install((SwingController)this.documentViewController.getParentController(), this.documentScrollpane, this);
        }
        this.currentPageChanger = new CurrentPageChanger(documentScrollpane, this, documentViewModel.getPageComponents(), false);
    }

    private void buildGUI() {
        this.pagesPanel = new JPanel();
        this.pagesPanel.setBackground(backgroundColor);
        GridLayout gridLayout = new GridLayout(0, 2, horizontalSpace, verticalSpace);
        this.pagesPanel.setLayout(gridLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(layoutInserts, layoutInserts, layoutInserts, layoutInserts);
        gbc.gridwidth = 0;
        this.updateDocumentView();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pagesPanel, gbc);
    }

    @Override
    public void updateDocumentView() {
        List<AbstractPageViewComponent> pageComponents = this.documentViewModel.getPageComponents();
        if (pageComponents != null) {
            this.pagesPanel.removeAll();
            this.pagesPanel.validate();
            int count = 0;
            int index = this.documentViewModel.getViewCurrentPageIndex();
            int docLength = pageComponents.size();
            if (this.viewAlignment == 1 && (index > 0 && index % 2 == 0 || index > 0 && docLength == 2)) {
                --index;
            }
            for (int i = index; i < docLength && count < 2; ++i) {
                PageViewComponent pageViewComponent;
                if (i == 0 && docLength > 2 && this.viewAlignment == 1) {
                    this.pagesPanel.add(new JLabel());
                    ++count;
                }
                if ((pageViewComponent = (PageViewComponent)pageComponents.get(i)) == null) continue;
                pageViewComponent.setDocumentViewCallback(this);
                this.pagesPanel.add(new PageViewDecorator((JComponent)((Object)pageViewComponent)));
                pageViewComponent.invalidate();
                ++count;
            }
            this.documentScrollpane.validate();
            for (AbstractPageViewComponent pageViewCom : pageComponents) {
                if (pageViewCom == null) continue;
                pageViewCom.setDocumentViewCallback(this);
            }
        }
    }

    @Override
    public int getNextPageIncrement() {
        return 2;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 2;
    }

    @Override
    public void dispose() {
        this.disposing = true;
        if (this.pageChangerListener != null) {
            MouseWheelListenerPageChanger.uninstall(this.documentScrollpane, this.pageChangerListener);
        }
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        this.pagesPanel.removeAll();
        this.pagesPanel.invalidate();
        super.dispose();
    }

    @Override
    public Dimension getDocumentSize() {
        float pageViewWidth = 0.0f;
        float pageViewHeight = 0.0f;
        if (this.pagesPanel != null) {
            int count = this.pagesPanel.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component comp = this.pagesPanel.getComponent(i);
                if (!(comp instanceof PageViewDecorator)) continue;
                PageViewDecorator pvd = (PageViewDecorator)comp;
                Dimension dim = pvd.getPreferredSize();
                pageViewWidth = dim.width;
                pageViewHeight = dim.height;
                break;
            }
        }
        float currentZoom = this.documentViewModel.getViewZoom();
        pageViewWidth = Math.abs(pageViewWidth / currentZoom);
        pageViewHeight = Math.abs(pageViewHeight / currentZoom);
        pageViewWidth *= 2.0f;
        return new Dimension((int)(pageViewWidth += (float)(AbstractDocumentView.horizontalSpace * 4)), (int)(pageViewHeight += (float)(AbstractDocumentView.verticalSpace * 2)));
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(backgroundColor);
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        super.paintComponent(g);
    }
}

