/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.views.PageViewComponent;

public class PageViewDecorator
extends JComponent {
    private static final Logger log;
    protected JComponent pageViewComponent;
    protected static final int SHADOW_SIZE = 3;
    protected Dimension preferredSize = new Dimension();
    private static Color pageBorderColor;
    private static Color pageShadowColor;
    private static Color pageColor;

    public PageViewDecorator(JComponent pageViewComponent) {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.pageViewComponent = pageViewComponent;
        Dimension size = pageViewComponent.getPreferredSize();
        this.preferredSize.setSize(size.width + 3, size.height + 3);
        this.add(pageViewComponent);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.pageViewComponent.getPreferredSize();
        this.preferredSize.setSize(size.width + 3, size.height + 3);
        return this.preferredSize;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Point location = this.pageViewComponent.getLocation();
        Dimension size = this.pageViewComponent.getPreferredSize();
        g2d.setColor(pageColor);
        g2d.fillRect(location.x, location.y, size.width, size.height);
        g2d.setColor(pageShadowColor);
        g2d.fillRect(location.x + 3, location.y + size.height, size.width - 3, 3);
        g2d.fillRect(location.x + size.width, location.y + 3, 3, size.height);
        super.paint(g);
        g2d.setColor(pageBorderColor);
        g2d.drawRect(location.x, location.y, size.width, size.height);
    }

    public PageViewComponent getPageViewComponent() {
        return (PageViewComponent)((Object)this.pageViewComponent);
    }

    static {
        block8: {
            int colorValue;
            String color;
            block7: {
                block6: {
                    log = Logger.getLogger(PageViewDecorator.class.toString());
                    try {
                        color = Defs.sysProperty("org.icepdf.core.views.page.shadow.color", "#333333");
                        colorValue = ColorUtil.convertColor(color);
                        pageShadowColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("333333", 16));
                    }
                    catch (NumberFormatException e) {
                        if (!log.isLoggable(Level.WARNING)) break block6;
                        log.warning("Error reading page shadow colour");
                    }
                }
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.paper.color", "#FFFFFF");
                    colorValue = ColorUtil.convertColor(color);
                    pageColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("FFFFFF", 16));
                }
                catch (NumberFormatException e) {
                    if (!log.isLoggable(Level.WARNING)) break block7;
                    log.warning("Error reading page paper color.");
                }
            }
            try {
                color = Defs.sysProperty("org.icepdf.core.views.page.border.color", "#000000");
                colorValue = ColorUtil.convertColor(color);
                pageBorderColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("000000", 16));
            }
            catch (NumberFormatException e) {
                if (!log.isLoggable(Level.WARNING)) break block8;
                log.warning("Error reading page paper color.");
            }
        }
    }
}

