/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.Memento;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.UndoCaretaker;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewModel;

public abstract class AbstractDocumentViewModel
implements DocumentViewModel {
    private static final Logger log = Logger.getLogger(AbstractDocumentViewModel.class.toString());
    protected Document currentDocument;
    private ArrayList<WeakReference<AbstractPageViewComponent>> selectedPageText;
    private boolean selectAll;
    protected List<AbstractPageViewComponent> pageComponents;
    protected UndoCaretaker undoCaretaker;
    protected AnnotationComponent currentAnnotation;
    protected float userZoom = 1.0f;
    protected float oldUserZoom = 1.0f;
    protected float userRotation;
    protected float oldUserRotation;
    protected int currentPageIndex;
    protected int oldPageIndex;
    protected int pageBoundary = 2;
    protected int userToolModeFlag;
    protected int oldUserToolModeFlag;
    protected static final int MAX_PAGE_SIZE_READ_AHEAD = 10;

    public AbstractDocumentViewModel(Document currentDocument) {
        this.currentDocument = currentDocument;
        this.undoCaretaker = new UndoCaretaker();
    }

    @Override
    public Document getDocument() {
        return this.currentDocument;
    }

    @Override
    public List<AbstractPageViewComponent> getPageComponents() {
        return this.pageComponents;
    }

    @Override
    public boolean setViewCurrentPageIndex(int pageIndex) {
        boolean changed = pageIndex != this.currentPageIndex;
        this.oldPageIndex = this.currentPageIndex;
        this.currentPageIndex = pageIndex;
        return changed;
    }

    @Override
    public int getViewCurrentPageIndex() {
        return this.currentPageIndex;
    }

    @Override
    public ArrayList<WeakReference<AbstractPageViewComponent>> getSelectedPageText() {
        return this.selectedPageText;
    }

    @Override
    public boolean isSelectAll() {
        return this.selectAll;
    }

    @Override
    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    @Override
    public void addSelectedPageText(AbstractPageViewComponent pageViewComponent) {
        if (this.selectedPageText == null) {
            this.selectedPageText = new ArrayList();
        }
        this.selectedPageText.add(new WeakReference<AbstractPageViewComponent>(pageViewComponent));
    }

    @Override
    public void clearSelectedPageText() {
        if (this.selectedPageText != null) {
            this.selectedPageText.clear();
        }
        this.selectAll = false;
    }

    @Override
    public boolean setViewZoom(float viewZoom) {
        boolean changed;
        boolean bl = changed = this.userZoom != viewZoom;
        if (changed) {
            this.oldUserZoom = this.userZoom;
            this.userZoom = viewZoom;
            for (AbstractPageViewComponent pageViewComponent : this.pageComponents) {
                if (pageViewComponent == null) continue;
                pageViewComponent.invalidate();
            }
        }
        return changed;
    }

    @Override
    public void invalidate() {
        for (AbstractPageViewComponent pageViewComponent : this.pageComponents) {
            pageViewComponent.invalidatePage();
        }
    }

    @Override
    public float getViewZoom() {
        return this.userZoom;
    }

    @Override
    public boolean setViewRotation(float viewRotation) {
        boolean changed;
        boolean bl = changed = this.userRotation != viewRotation;
        if (changed) {
            this.oldUserRotation = this.userRotation;
            this.userRotation = viewRotation;
            for (AbstractPageViewComponent pageViewComponent : this.pageComponents) {
                if (pageViewComponent == null) continue;
                pageViewComponent.invalidate();
            }
        }
        return changed;
    }

    @Override
    public float getViewRotation() {
        return this.userRotation;
    }

    @Override
    public boolean setViewToolMode(int viewToolMode) {
        boolean changed;
        boolean bl = changed = viewToolMode != this.userToolModeFlag;
        if (changed) {
            this.oldUserToolModeFlag = this.userToolModeFlag;
            this.userToolModeFlag = viewToolMode;
        }
        return changed;
    }

    @Override
    public int getViewToolMode() {
        return this.userToolModeFlag;
    }

    @Override
    public boolean isViewToolModeSelected(int viewToolMode) {
        return this.userToolModeFlag == viewToolMode;
    }

    @Override
    public void setPageBoundary(int pageBoundary) {
        this.pageBoundary = pageBoundary;
    }

    @Override
    public int getPageBoundary() {
        return this.pageBoundary;
    }

    @Override
    public Rectangle getPageBounds(int pageIndex) {
        AbstractPageViewComponent tmp;
        Rectangle pageBounds = new Rectangle();
        if (this.pageComponents != null && pageIndex < this.pageComponents.size() && (tmp = this.pageComponents.get(pageIndex)) != null && tmp instanceof Component) {
            Component pageViewComponentImpl;
            Dimension size = pageViewComponentImpl.getPreferredSize();
            pageBounds.setSize(size.width, size.height);
            for (Component parentComponent = pageViewComponentImpl = (Component)tmp; parentComponent != null && !(parentComponent instanceof DocumentView); parentComponent = parentComponent.getParent()) {
                pageBounds.x += parentComponent.getBounds().x;
                pageBounds.y += parentComponent.getBounds().y;
            }
        }
        return pageBounds;
    }

    @Override
    public void dispose() {
        if (this.pageComponents != null) {
            for (AbstractPageViewComponent pageViewComponent : this.pageComponents) {
                if (pageViewComponent == null) continue;
                pageViewComponent.dispose();
            }
            this.pageComponents.clear();
        }
    }

    @Override
    public AnnotationComponent getCurrentAnnotation() {
        return this.currentAnnotation;
    }

    @Override
    public void setCurrentAnnotation(AnnotationComponent currentAnnotation) {
        if (this.currentAnnotation != null) {
            this.currentAnnotation.setSelected(false);
            this.currentAnnotation.repaint();
        }
        this.currentAnnotation = currentAnnotation;
        if (this.currentAnnotation != null) {
            this.currentAnnotation.setSelected(true);
        }
    }

    public UndoCaretaker getAnnotationCareTaker() {
        return this.undoCaretaker;
    }

    @Override
    public void addMemento(Memento oldMementoState, Memento newMementoState) {
        this.undoCaretaker.addState(oldMementoState, newMementoState);
    }
}

