/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.tools.AnnotationSelectionHandler;
import org.icepdf.ri.common.tools.DynamicZoomHandler;
import org.icepdf.ri.common.tools.MouseWheelZoom;
import org.icepdf.ri.common.tools.PanningHandler;
import org.icepdf.ri.common.tools.TextSelectionViewHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.ZoomInViewHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public abstract class AbstractDocumentView
extends JComponent
implements DocumentView,
PropertyChangeListener,
MouseListener {
    private static final Logger logger;
    public static Color backgroundColor;
    public static int verticalSpace;
    public static int horizontalSpace;
    public static int layoutInserts;
    protected DocumentViewController documentViewController;
    protected JScrollPane documentScrollpane;
    protected Document currentDocument;
    protected DocumentViewModel documentViewModel;
    protected ToolHandler currentTool;
    protected MouseWheelZoom mouseWheelZoom;

    public AbstractDocumentView(DocumentViewController documentViewController, JScrollPane documentScrollpane, DocumentViewModel documentViewModel) {
        this.documentViewController = documentViewController;
        this.documentScrollpane = documentScrollpane;
        this.documentViewModel = documentViewModel;
        this.currentDocument = this.documentViewModel.getDocument();
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.mouseWheelZoom = new MouseWheelZoom(documentViewController, documentScrollpane);
        documentScrollpane.addMouseWheelListener(this.mouseWheelZoom);
        documentViewController.getHorizontalScrollBar().addAdjustmentListener(this);
        documentViewController.getVerticalScrollBar().addAdjustmentListener(this);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if ("focusOwner".equals(prop) && newValue instanceof AnnotationComponent) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Selected Annotation " + newValue);
            }
            DocumentViewController documentViewController = this.getParentViewController();
            documentViewController.firePropertyChange("annotationFocusGained", evt.getOldValue(), evt.getNewValue());
        } else if ("focusOwner".equals(prop) && oldValue instanceof AnnotationComponent) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deselected Annotation " + oldValue);
            }
            DocumentViewController documentViewController = this.getParentViewController();
            documentViewController.firePropertyChange("annotationFocusLost", evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public DocumentViewController getParentViewController() {
        return this.documentViewController;
    }

    @Override
    public DocumentViewModel getViewModel() {
        return this.documentViewModel;
    }

    @Override
    public void dispose() {
        this.currentDocument = null;
        this.documentViewController.getHorizontalScrollBar().removeAdjustmentListener(this);
        this.documentViewController.getVerticalScrollBar().removeAdjustmentListener(this);
        if (this.currentTool != null) {
            this.removeMouseListener(this.currentTool);
            this.removeMouseMotionListener(this.currentTool);
        }
        this.documentScrollpane.removeMouseWheelListener(this.mouseWheelZoom);
        this.removeMouseListener(this);
        this.removeFocusListener(this);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this);
    }

    @Override
    public abstract void updateDocumentView();

    public ToolHandler uninstallCurrentTool() {
        if (this.currentTool != null) {
            this.currentTool.uninstallTool();
            this.removeMouseListener(this.currentTool);
            this.removeMouseMotionListener(this.currentTool);
        }
        return this.currentTool;
    }

    public void installCurrentTool(ToolHandler currentTool) {
        if (currentTool != null) {
            currentTool.installTool();
            this.addMouseListener(currentTool);
            this.addMouseMotionListener(currentTool);
            this.currentTool = currentTool;
        }
    }

    public ToolHandler getCurrentToolHandler() {
        return this.currentTool;
    }

    @Override
    public void setToolMode(int viewToolMode) {
        this.uninstallCurrentTool();
        switch (viewToolMode) {
            case 1: {
                this.currentTool = new PanningHandler(this.documentViewController, this.documentViewModel, this);
                break;
            }
            case 2: {
                this.currentTool = new ZoomInViewHandler(this.documentViewController, this.documentViewModel, this);
                break;
            }
            case 4: {
                this.currentTool = new DynamicZoomHandler(this.documentViewController, this.documentScrollpane);
                break;
            }
            case 5: {
                this.currentTool = new TextSelectionViewHandler(this.documentViewController, this.documentViewModel, this);
                break;
            }
            case 6: {
                this.currentTool = new AnnotationSelectionHandler(this.documentViewController, null, this.documentViewModel);
                break;
            }
            default: {
                this.currentTool = null;
            }
        }
        if (this.currentTool != null) {
            this.currentTool.installTool();
            this.addMouseListener(this.currentTool);
            this.addMouseMotionListener(this.currentTool);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.currentTool != null) {
            this.currentTool.paintTool(g);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private AbstractPageViewComponent isOverPageComponent(MouseEvent e) {
        Component comp = this.findComponentAt(e.getPoint());
        if (comp instanceof AbstractPageViewComponent) {
            return (AbstractPageViewComponent)comp;
        }
        return null;
    }

    public JScrollPane getDocumentScrollpane() {
        return this.documentScrollpane;
    }

    static {
        block2: {
            logger = Logger.getLogger(AbstractDocumentView.class.toString());
            try {
                String color = Defs.sysProperty("org.icepdf.core.views.background.color", "#808080");
                int colorValue = ColorUtil.convertColor(color);
                backgroundColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("808080", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading page shadow colour");
            }
        }
        verticalSpace = 2;
        horizontalSpace = 1;
        layoutInserts = 0;
    }
}

