/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.outline;

import javax.swing.tree.DefaultMutableTreeNode;
import org.icepdf.core.pobjects.OutlineItem;

public class OutlineItemTreeNode
extends DefaultMutableTreeNode {
    private OutlineItem item;
    private boolean loadedChildren;

    public OutlineItemTreeNode(OutlineItem item) {
        this.item = item;
        this.loadedChildren = false;
        this.setUserObject(item.getTitle());
    }

    public OutlineItem getOutlineItem() {
        return this.item;
    }

    public void recursivelyClearOutlineItems() {
        this.item = null;
        if (this.loadedChildren) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                OutlineItemTreeNode node = (OutlineItemTreeNode)this.getChildAt(i);
                node.recursivelyClearOutlineItems();
            }
        }
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenLoaded();
        return super.getChildCount();
    }

    private void ensureChildrenLoaded() {
        if (!this.loadedChildren) {
            this.loadedChildren = true;
            int count = this.item.getSubItemCount();
            for (int i = 0; i < count; ++i) {
                OutlineItem child = this.item.getSubItem(i);
                OutlineItemTreeNode childTreeNode = new OutlineItemTreeNode(child);
                this.add(childTreeNode);
            }
        }
    }
}

