/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class SquareAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_LINE_THICKNESS = 0;
    private static final int DEFAULT_LINE_STYLE = 0;
    private static final int DEFAULT_STROKE_TYPE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.RED;
    private static final int DEFAULT_FILL_TYPE = 1;
    private static final Color DEFAULT_INTERIOR_COLOR = new Color(1, 1, 1);
    private final ValueLabelItem[] PAINT_TYPE_LIST = new ValueLabelItem[]{new ValueLabelItem(Boolean.TRUE, "Visible"), new ValueLabelItem(Boolean.FALSE, "Invisible")};
    private JComboBox lineThicknessBox;
    private JComboBox lineStyleBox;
    private JComboBox fillTypeBox;
    private JButton colorFillButton;
    private JButton colorBorderButton;
    private SquareAnnotation annotation;

    public SquareAnnotationPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(5, 2, 5, 2));
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent newAnnotation) {
        if (newAnnotation == null || newAnnotation.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = newAnnotation;
        this.annotation = (SquareAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.lineThicknessBox, Float.valueOf(this.annotation.getLineThickness()));
        this.applySelectedValue(this.lineStyleBox, this.annotation.getLineStyle());
        this.applySelectedValue(this.fillTypeBox, this.annotation.isFillColor());
        this.colorBorderButton.setBackground(this.annotation.getColor());
        this.colorFillButton.setBackground(this.annotation.getFillColor());
        this.safeEnable(this.lineThicknessBox, true);
        this.safeEnable(this.lineStyleBox, true);
        this.safeEnable(this.colorFillButton, true);
        this.safeEnable(this.fillTypeBox, true);
        this.safeEnable(this.colorBorderButton, true);
        this.setStrokeFillColorButtons();
    }

    private void setStrokeFillColorButtons() {
        SquareAnnotation squareAnnotation = (SquareAnnotation)this.currentAnnotationComponent.getAnnotation();
        if (this.annotation.isFillColor()) {
            this.colorFillButton.setBackground(squareAnnotation.getFillColor());
            this.safeEnable(this.colorFillButton, true);
        } else {
            this.safeEnable(this.colorFillButton, false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ValueLabelItem item = (ValueLabelItem)e.getItem();
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.lineThicknessBox) {
                this.annotation.getBorderStyle().setStrokeWidth(((Float)item.getValue()).floatValue());
            } else if (e.getSource() == this.lineStyleBox) {
                this.annotation.getBorderStyle().setBorderStyle((Name)item.getValue());
            } else if (e.getSource() == this.fillTypeBox) {
                this.annotation.setFillColor((Boolean)item.getValue());
                this.setStrokeFillColorButtons();
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color chosenColor;
        if (e.getSource() == this.colorBorderButton) {
            Color chosenColor2 = JColorChooser.showDialog(this.colorBorderButton, this.messageBundle.getString("viewer.utilityPane.annotation.square.colorBorderChooserTitle"), this.colorBorderButton.getBackground());
            if (chosenColor2 != null) {
                this.colorBorderButton.setBackground(chosenColor2);
                this.annotation.setColor(chosenColor2);
                this.updateCurrentAnnotation();
                this.currentAnnotationComponent.resetAppearanceShapes();
                this.currentAnnotationComponent.repaint();
            }
        } else if (e.getSource() == this.colorFillButton && (chosenColor = JColorChooser.showDialog(this.colorFillButton, this.messageBundle.getString("viewer.utilityPane.annotation.square.colorInteriorChooserTitle"), this.colorFillButton.getBackground())) != null) {
            this.colorFillButton.setBackground(chosenColor);
            this.annotation.setFillColor(chosenColor);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    private void createGUI() {
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.square.appearance.title"), 1, 0));
        this.lineThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.lineThicknessBox.setSelectedIndex(0);
        this.lineThicknessBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.square.lineThickness")));
        this.add(this.lineThicknessBox);
        this.lineStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.lineStyleBox.setSelectedIndex(0);
        this.lineStyleBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.square.lineStyle")));
        this.add(this.lineStyleBox);
        this.colorBorderButton = new JButton();
        this.colorBorderButton.addActionListener(this);
        this.colorBorderButton.setOpaque(true);
        this.colorBorderButton.setBackground(DEFAULT_BORDER_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.square.colorBorderLabel")));
        this.add(this.colorBorderButton);
        this.fillTypeBox = new JComboBox<ValueLabelItem>(this.PAINT_TYPE_LIST);
        this.fillTypeBox.setSelectedIndex(1);
        this.fillTypeBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.square.fillTypeLabel")));
        this.add(this.fillTypeBox);
        this.colorFillButton = new JButton();
        this.colorFillButton.addActionListener(this);
        this.colorFillButton.setOpaque(true);
        this.colorFillButton.setBackground(DEFAULT_INTERIOR_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.square.colorInteriorLabel")));
        this.add(this.colorFillButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.safeEnable(this.lineThicknessBox, enabled);
        this.safeEnable(this.lineStyleBox, enabled);
        this.safeEnable(this.fillTypeBox, enabled);
        this.safeEnable(this.colorBorderButton, enabled);
        this.safeEnable(this.colorFillButton, enabled);
    }

    protected boolean safeEnable(JComponent comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

