/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class InkAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_LINE_THICKNESS = 0;
    private static final int DEFAULT_LINE_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.RED;
    private JComboBox lineThicknessBox;
    private JComboBox lineStyleBox;
    private JButton colorBorderButton;
    private InkAnnotation annotation;

    public InkAnnotationPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(3, 2, 5, 2));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent newAnnotation) {
        if (newAnnotation == null || newAnnotation.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = newAnnotation;
        this.annotation = (InkAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.lineThicknessBox, Float.valueOf(this.annotation.getLineThickness()));
        this.applySelectedValue(this.lineStyleBox, this.annotation.getLineStyle());
        this.colorBorderButton.setBackground(this.annotation.getColor());
        this.safeEnable(this.lineThicknessBox, true);
        this.safeEnable(this.lineStyleBox, true);
        this.safeEnable(this.colorBorderButton, true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ValueLabelItem item = (ValueLabelItem)e.getItem();
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.lineThicknessBox) {
                this.annotation.getBorderStyle().setStrokeWidth(((Float)item.getValue()).floatValue());
            } else if (e.getSource() == this.lineStyleBox) {
                this.annotation.getBorderStyle().setBorderStyle((Name)item.getValue());
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color chosenColor;
        if (e.getSource() == this.colorBorderButton && (chosenColor = JColorChooser.showDialog(this.colorBorderButton, this.messageBundle.getString("viewer.utilityPane.annotation.ink.colorBorderChooserTitle"), this.colorBorderButton.getBackground())) != null) {
            this.colorBorderButton.setBackground(chosenColor);
            this.annotation.setColor(chosenColor);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    private void createGUI() {
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.ink.appearance.title"), 1, 0));
        this.lineThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.lineThicknessBox.setSelectedIndex(0);
        this.lineThicknessBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.ink.lineThickness")));
        this.add(this.lineThicknessBox);
        this.lineStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.lineStyleBox.setSelectedIndex(0);
        this.lineStyleBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.ink.lineStyle")));
        this.add(this.lineStyleBox);
        this.colorBorderButton = new JButton();
        this.colorBorderButton.addActionListener(this);
        this.colorBorderButton.setOpaque(true);
        this.colorBorderButton.setBackground(DEFAULT_BORDER_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.ink.colorBorderLabel")));
        this.add(this.colorBorderButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.safeEnable(this.lineThicknessBox, enabled);
        this.safeEnable(this.lineStyleBox, enabled);
        this.safeEnable(this.colorBorderButton, enabled);
    }

    protected boolean safeEnable(JComponent comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

