/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.ZoomInPageHandler;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class ZoomInViewHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(ZoomInPageHandler.class.toString());
    private AbstractDocumentView parentComponent;

    public ZoomInViewHandler(DocumentViewController documentViewController, DocumentViewModel documentViewModel, AbstractDocumentView parentComponent) {
        super(documentViewController, null, documentViewModel);
        this.parentComponent = parentComponent;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(e, this.parentComponent);
            if (this.documentViewModel != null) {
                List<AbstractPageViewComponent> pages = this.documentViewModel.getPageComponents();
                for (AbstractPageViewComponent page : pages) {
                    Rectangle tmp = SwingUtilities.convertRectangle(this.parentComponent, this.getRectToDraw(), page);
                    if (!page.getBounds().intersects(tmp)) continue;
                    Rectangle selectRec = SwingUtilities.convertRectangle(this.parentComponent, this.rectToDraw, page);
                    page.setSelectionRectangle(SwingUtilities.convertPoint(this.parentComponent, e.getPoint(), page), selectRec);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x1F5) != 0 && (e.getModifiers() & 0x10) != 0) {
            this.documentViewController.setZoomIn(e.getPoint());
        }
        if (this.parentComponent != null) {
            this.parentComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.documentViewController != null) {
            this.resetRectangle(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(e, this.parentComponent);
            if (this.documentViewController.getViewPort() != null && this.rectToDraw.getWidth() > 0.0 && this.rectToDraw.getHeight() > 0.0) {
                float zoom = ZoomInPageHandler.calculateZoom(this.documentViewController, this.rectToDraw, this.documentViewModel);
                Point center = new Point((int)this.rectToDraw.getCenterX(), (int)this.rectToDraw.getCenterY());
                this.documentViewController.setZoomCentered(zoom, center, true);
            }
            this.clearRectangle(this.parentComponent);
            List<AbstractPageViewComponent> selectedPages = this.documentViewModel.getPageComponents();
            if (selectedPages != null && selectedPages.size() > 0) {
                for (AbstractPageViewComponent pageComp : selectedPages) {
                    if (pageComp == null || !pageComp.isVisible()) continue;
                    pageComp.clearSelectionRectangle();
                }
            }
        }
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
    }

    @Override
    public void paintTool(Graphics g) {
        ZoomInViewHandler.paintSelectionBox(g, this.rectToDraw);
    }
}

