/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class CommonToolHandler {
    private static final Logger logger = Logger.getLogger(CommonToolHandler.class.toString());
    protected AbstractPageViewComponent pageViewComponent;
    protected DocumentViewController documentViewController;
    protected DocumentViewModel documentViewModel;

    public CommonToolHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        this.pageViewComponent = pageViewComponent;
        this.documentViewController = documentViewController;
        this.documentViewModel = documentViewModel;
    }

    protected AffineTransform getPageTransform() {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error page space transform", e);
        }
        return at;
    }

    protected Shape convertToPageSpace(Shape shape) {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error converting to page space", e);
        }
        shape = at.createTransformedShape(shape);
        return shape;
    }
}

