/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.search;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.search.SearchTerm;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.search.DocumentSearchModelImpl;

public class DocumentSearchControllerImpl
implements DocumentSearchController {
    private static final Logger logger = Logger.getLogger(DocumentSearchControllerImpl.class.toString());
    protected DocumentSearchModelImpl searchModel;
    protected SwingController viewerController;
    protected Document document;

    public DocumentSearchControllerImpl(SwingController viewerController) {
        this.viewerController = viewerController;
        this.searchModel = new DocumentSearchModelImpl();
    }

    public DocumentSearchControllerImpl(Document document) {
        this.searchModel = new DocumentSearchModelImpl();
        this.document = document;
    }

    @Override
    public int searchHighlightPage(int pageIndex, String term, boolean caseSensitive, boolean wholeWord) {
        this.clearSearchHighlight(pageIndex);
        this.addSearchTerm(term, caseSensitive, wholeWord);
        return this.searchHighlightPage(pageIndex);
    }

    @Override
    public int searchHighlightPage(int pageIndex) {
        ArrayList<SearchTerm> terms = this.searchModel.getSearchTerms();
        int hitCount = 0;
        PageText pageText = null;
        if (this.viewerController != null) {
            try {
                pageText = this.viewerController.getDocument().getPageText(pageIndex);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Page text extraction thread interrupted.", e);
            }
        } else if (this.document != null) {
            pageText = this.document.getPageViewText(pageIndex);
        }
        if (pageText == null) {
            return 0;
        }
        for (SearchTerm term : terms) {
            int searchPhraseHitCount = 0;
            int searchPhraseFoundCount = term.getTerms().size();
            ArrayList<WordText> searchPhraseHits = new ArrayList<WordText>(searchPhraseFoundCount);
            ArrayList<LineText> pageLines = pageText.getPageLines();
            for (LineText pageLine : pageLines) {
                List<WordText> lineWords = pageLine.getWords();
                for (WordText word : lineWords) {
                    String wordString;
                    String string = wordString = term.isCaseSensitive() ? word.toString() : word.toString().toLowerCase();
                    if (term.isWholeWord()) {
                        if (wordString.equals(term.getTerms().get(searchPhraseHitCount))) {
                            searchPhraseHits.add(word);
                            ++searchPhraseHitCount;
                        } else {
                            searchPhraseHits.clear();
                            searchPhraseHitCount = 0;
                        }
                    } else if (wordString.indexOf(term.getTerms().get(searchPhraseHitCount)) >= 0) {
                        searchPhraseHits.add(word);
                        ++searchPhraseHitCount;
                    } else {
                        searchPhraseHits.clear();
                        searchPhraseHitCount = 0;
                    }
                    if (searchPhraseHitCount != searchPhraseFoundCount) continue;
                    for (WordText wordHit : searchPhraseHits) {
                        wordHit.setHighlighted(true);
                        wordHit.setHasHighlight(true);
                    }
                    ++hitCount;
                    searchPhraseHits.clear();
                    searchPhraseHitCount = 0;
                }
            }
        }
        if (hitCount > 0) {
            this.searchModel.addPageSearchHit(pageIndex, pageText);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found search hits on page " + pageIndex + " hit count " + hitCount);
            }
        }
        return hitCount;
    }

    public ArrayList<LineText> searchHighlightPage(int pageIndex, int wordPadding) {
        ArrayList<SearchTerm> terms = this.searchModel.getSearchTerms();
        ArrayList<LineText> searchHits = new ArrayList<LineText>();
        PageText pageText = null;
        if (this.viewerController != null) {
            try {
                pageText = this.viewerController.getDocument().getPageText(pageIndex);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Page text extraction thread interrupted.", e);
            }
        } else if (this.document != null) {
            pageText = this.document.getPageViewText(pageIndex);
        }
        if (pageText == null) {
            return searchHits;
        }
        for (SearchTerm term : terms) {
            int searchPhraseHitCount = 0;
            int searchPhraseFoundCount = term.getTerms().size();
            ArrayList<WordText> searchPhraseHits = new ArrayList<WordText>(searchPhraseFoundCount);
            ArrayList<LineText> pageLines = pageText.getPageLines();
            for (LineText pageLine : pageLines) {
                List<WordText> lineWords = pageLine.getWords();
                int max = lineWords.size();
                for (int i = 0; i < max; ++i) {
                    int p;
                    String wordString;
                    WordText word = lineWords.get(i);
                    String string = wordString = term.isCaseSensitive() ? word.toString() : word.toString().toLowerCase();
                    if (term.isWholeWord()) {
                        if (wordString.equals(term.getTerms().get(searchPhraseHitCount))) {
                            searchPhraseHits.add(word);
                            ++searchPhraseHitCount;
                        } else {
                            searchPhraseHits.clear();
                            searchPhraseHitCount = 0;
                        }
                    } else if (wordString.indexOf(term.getTerms().get(searchPhraseHitCount)) >= 0) {
                        searchPhraseHits.add(word);
                        ++searchPhraseHitCount;
                    } else {
                        searchPhraseHits.clear();
                        searchPhraseHitCount = 0;
                    }
                    if (searchPhraseHitCount != searchPhraseFoundCount) continue;
                    LineText lineText = new LineText();
                    int lineWordsSize = lineWords.size();
                    List<WordText> hitWords = lineText.getWords();
                    int start = i - searchPhraseHitCount - wordPadding + 1;
                    start = start < 0 ? 0 : start;
                    int end = i - searchPhraseHitCount + 1;
                    end = end < 0 ? 0 : end;
                    for (p = start; p < end; ++p) {
                        hitWords.add(lineWords.get(p));
                    }
                    for (WordText wordHit : searchPhraseHits) {
                        wordHit.setHighlighted(true);
                        wordHit.setHasHighlight(true);
                    }
                    hitWords.addAll(searchPhraseHits);
                    start = i + 1;
                    start = start > lineWordsSize ? lineWordsSize : start;
                    end = start + wordPadding;
                    end = end > lineWordsSize ? lineWordsSize : end;
                    for (p = start; p < end; ++p) {
                        hitWords.add(lineWords.get(p));
                    }
                    searchHits.add(lineText);
                    searchPhraseHits.clear();
                    searchPhraseHitCount = 0;
                }
            }
        }
        if (searchHits.size() > 0) {
            this.searchModel.addPageSearchHit(pageIndex, pageText);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found search hits on page " + pageIndex + " hit count " + searchHits.size());
            }
        }
        return searchHits;
    }

    @Override
    public ArrayList<WordText> searchPage(int pageIndex) {
        PageText searchText;
        int hits = this.searchHighlightPage(pageIndex);
        if (hits > 0 && (searchText = this.searchModel.getPageTextHit(pageIndex)) != null) {
            ArrayList<WordText> words = new ArrayList<WordText>(hits);
            ArrayList<LineText> pageLines = searchText.getPageLines();
            for (LineText pageLine : pageLines) {
                List<WordText> lineWords = pageLine.getWords();
                for (WordText word : lineWords) {
                    if (!word.isHighlighted()) continue;
                    words.add(word);
                }
            }
            return words;
        }
        return null;
    }

    @Override
    public SearchTerm addSearchTerm(String term, boolean caseSensitive, boolean wholeWord) {
        String origionalTerm = String.valueOf(term);
        if (!caseSensitive) {
            term = term.toLowerCase();
        }
        ArrayList<String> searchPhrase = this.searchPhraseParser(term);
        SearchTerm searchTerm = new SearchTerm(origionalTerm, searchPhrase, caseSensitive, wholeWord);
        this.searchModel.addSearchTerm(searchTerm);
        return searchTerm;
    }

    @Override
    public void removeSearchTerm(SearchTerm searchTerm) {
        this.searchModel.removeSearchTerm(searchTerm);
    }

    @Override
    public void clearSearchHighlight(int pageIndex) {
        this.searchModel.clearSearchResults(pageIndex);
    }

    @Override
    public void clearAllSearchHighlight() {
        this.searchModel.clearSearchResults();
    }

    @Override
    public boolean isSearchHighlightRefreshNeeded(int pageIndex, PageText pageText) {
        return this.searchModel.isPageTextMatch(pageIndex, pageText);
    }

    @Override
    public void dispose() {
        this.searchModel.clearSearchResults();
    }

    protected ArrayList<String> searchPhraseParser(String phrase) {
        phrase = phrase.trim();
        ArrayList<String> words = new ArrayList<String>();
        char prevC = ' ';
        int start = 0;
        int max = phrase.length();
        for (int curs = 0; curs < max; ++curs) {
            char c = phrase.charAt(curs);
            if (!WordText.isDigit(prevC) && (WordText.isWhiteSpace(c) || WordText.isPunctuation(c))) {
                if (start != curs) {
                    words.add(phrase.substring(start, curs));
                }
                words.add(phrase.substring(curs, curs + 1));
                start = curs + 1 < max ? curs + 1 : start;
            } else if (curs + 1 == max) {
                words.add(phrase.substring(start, curs + 1));
            }
            prevC = c;
        }
        return words;
    }
}

