/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.actions.GoToRAction;
import org.icepdf.core.pobjects.actions.LaunchAction;
import org.icepdf.core.pobjects.actions.URIAction;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.util.BareBonesBrowserLaunch;

public class MyAnnotationCallback
implements AnnotationCallback {
    private static final Logger logger = Logger.getLogger(MyAnnotationCallback.class.toString());
    private DocumentViewController documentViewController;

    public MyAnnotationCallback(DocumentViewController documentViewController) {
        this.documentViewController = documentViewController;
    }

    @Override
    public void processAnnotationAction(Annotation annotation) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Annotation " + annotation.toString());
            if (annotation.getAction() != null) {
                logger.fine("   Action: " + annotation.getAction().toString());
            }
        }
        if (annotation instanceof LinkAnnotation) {
            LinkAnnotation linkAnnotation = (LinkAnnotation)annotation;
            if (linkAnnotation.getAction() != null) {
                Action action = linkAnnotation.getAction();
                if (action instanceof GoToAction && this.documentViewController != null) {
                    this.documentViewController.setDestinationTarget(((GoToAction)action).getDestination());
                } else if (action instanceof URIAction) {
                    BareBonesBrowserLaunch.openURL(((URIAction)action).getURI());
                } else if (!(action instanceof GoToRAction) && action instanceof LaunchAction) {
                    LaunchAction launchAction = (LaunchAction)action;
                    String file = launchAction.getExternalFile();
                    String location = this.documentViewController.getDocument().getDocumentLocation();
                    location = location.substring(0, location.lastIndexOf(File.separator) + 1);
                    BareBonesBrowserLaunch.openFile(location + file);
                }
            } else if (linkAnnotation.getDestination() != null && this.documentViewController != null) {
                this.documentViewController.setDestinationTarget(linkAnnotation.getDestination());
            }
        } else if (annotation.getAction() != null) {
            Action action = annotation.getAction();
            if (action instanceof GoToAction) {
                this.documentViewController.setDestinationTarget(((GoToAction)action).getDestination());
            } else if (action instanceof URIAction) {
                BareBonesBrowserLaunch.openURL(((URIAction)action).getURI());
            }
        }
    }

    @Override
    public void pageAnnotationsInitialized(Page page) {
    }

    @Override
    public void newAnnotation(PageViewComponent pageComponent, AnnotationComponent annotationComponent) {
        Document document = this.documentViewController.getDocument();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(pageComponent.getPageIndex());
        page.addAnnotation(annotationComponent.getAnnotation());
        pageComponent.addAnnotation(annotationComponent);
    }

    @Override
    public void updateAnnotation(AnnotationComponent annotationComponent) {
        Document document = this.documentViewController.getDocument();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(annotationComponent.getPageIndex());
        page.updateAnnotation(annotationComponent.getAnnotation());
    }

    @Override
    public void removeAnnotation(PageViewComponent pageComponent, AnnotationComponent annotationComponent) {
        MarkupAnnotation markupAnnotation;
        Document document = this.documentViewController.getDocument();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(pageComponent.getPageIndex());
        page.deleteAnnotation(annotationComponent.getAnnotation());
        pageComponent.removeAnnotation(annotationComponent);
        if (annotationComponent.getAnnotation() instanceof MarkupAnnotation && (markupAnnotation = (MarkupAnnotation)annotationComponent.getAnnotation()).getPopupAnnotation() != null) {
            page.deleteAnnotation(markupAnnotation.getPopupAnnotation());
            ArrayList<AnnotationComponent> annotationComponents = ((AbstractPageViewComponent)pageComponent).getAnnotationComponents();
            Reference popupReference = markupAnnotation.getPopupAnnotation().getPObjectReference();
            int max = annotationComponents.size();
            for (int i = 0; i < max; ++i) {
                AnnotationComponent annotationComp = annotationComponents.get(i);
                Reference compReference = annotationComp.getAnnotation().getPObjectReference();
                if (!compReference.equals(popupReference) || !(annotationComp instanceof PopupAnnotationComponent)) continue;
                PopupAnnotationComponent popupComponent = (PopupAnnotationComponent)annotationComp;
                pageComponent.removeAnnotation(popupComponent);
            }
        }
    }
}

