/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.commands;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FillDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.GraphicsStateCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TextSpriteDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TextTransformDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TransformDrawCmd;
import org.icepdf.core.pobjects.graphics.text.GlyphText;

public class PostScriptEncoder {
    private static final Logger logger = Logger.getLogger(PostScriptEncoder.class.toString());
    private static final String SPACE = " ";
    private static final String NEWLINE = "\r\n";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NAME = "/";
    private static final String BEGIN_ARRAY = "[";
    private static final String END_ARRAY = "]";
    private static final String BEGIN_STRING = "(";
    private static final String END_STRING = ")";

    private PostScriptEncoder() {
    }

    public static byte[] generatePostScript(ArrayList<DrawCmd> drawCmds) {
        StringBuilder postScript = new StringBuilder();
        Color color = null;
        Shape currentShape = null;
        if (logger.isLoggable(Level.FINEST)) {
            if (drawCmds != null) {
                logger.finest("PostScriptEncoder processing: " + drawCmds.size() + " commands.");
            } else {
                logger.finest("PostScriptEncoder does not have any shapes to process. ");
            }
        }
        try {
            for (DrawCmd drawCmd : drawCmds) {
                float[] colors;
                AffineTransform af;
                if (drawCmd instanceof TransformDrawCmd) {
                    af = ((TransformDrawCmd)drawCmd).getAffineTransform();
                    postScript.append(af.getScaleX()).append(SPACE).append(af.getShearX()).append(SPACE).append(af.getShearY()).append(SPACE).append(af.getScaleY()).append(SPACE).append(af.getTranslateX()).append(SPACE).append(af.getTranslateY()).append(SPACE).append("cm").append(NEWLINE);
                    continue;
                }
                if (drawCmd instanceof TextTransformDrawCmd) {
                    af = ((TransformDrawCmd)drawCmd).getAffineTransform();
                    postScript.append(af.getScaleX()).append(SPACE).append(af.getShearX()).append(SPACE).append(af.getShearY()).append(SPACE).append(af.getScaleY()).append(SPACE).append(af.getTranslateX()).append(SPACE).append(af.getTranslateY()).append(SPACE).append("Tm").append(NEWLINE);
                    continue;
                }
                if (drawCmd instanceof ColorDrawCmd) {
                    color = ((ColorDrawCmd)drawCmd).getColor();
                    continue;
                }
                if (drawCmd instanceof DrawDrawCmd) {
                    colors = color.getRGBColorComponents(null);
                    postScript.append(colors[0]).append(SPACE).append(colors[1]).append(SPACE).append(colors[2]).append(SPACE).append("RG").append(NEWLINE);
                    PostScriptEncoder.generateShapePostScript(currentShape, postScript);
                    postScript.append("S").append(NEWLINE);
                    continue;
                }
                if (drawCmd instanceof FillDrawCmd) {
                    colors = color.getRGBColorComponents(null);
                    postScript.append(colors[0]).append(SPACE).append(colors[1]).append(SPACE).append(colors[2]).append(SPACE).append("rg").append(NEWLINE);
                    PostScriptEncoder.generateShapePostScript(currentShape, postScript);
                    postScript.append("f").append(SPACE);
                    continue;
                }
                if (drawCmd instanceof ShapeDrawCmd) {
                    currentShape = ((ShapeDrawCmd)drawCmd).getShape();
                    continue;
                }
                if (drawCmd instanceof StrokeDrawCmd) {
                    BasicStroke stroke = (BasicStroke)((StrokeDrawCmd)drawCmd).getStroke();
                    postScript.append(stroke.getLineWidth()).append(SPACE).append("w").append(SPACE);
                    float[] dashes = stroke.getDashArray();
                    postScript.append(BEGIN_ARRAY);
                    if (dashes != null) {
                        int max = dashes.length;
                        for (int i = 0; i < max; ++i) {
                            postScript.append(dashes[i]);
                            if (i >= max - 1) continue;
                            postScript.append(SPACE);
                        }
                    }
                    postScript.append(END_ARRAY).append(SPACE);
                    postScript.append(stroke.getDashPhase()).append(SPACE).append("d").append(SPACE);
                    if (stroke.getEndCap() == 0) {
                        postScript.append(0).append(SPACE).append("J").append(SPACE);
                    } else if (stroke.getEndCap() == 1) {
                        postScript.append(1).append(SPACE).append("J").append(SPACE);
                    } else if (stroke.getEndCap() == 2) {
                        postScript.append(2).append(SPACE).append("J").append(SPACE);
                    }
                    if (stroke.getMiterLimit() == 0.0f) {
                        postScript.append(0).append(SPACE).append("j").append(SPACE);
                    } else if (stroke.getMiterLimit() == 1.0f) {
                        postScript.append(1).append(SPACE).append("j").append(SPACE);
                    } else if (stroke.getMiterLimit() == 2.0f) {
                        postScript.append(2).append(SPACE).append("j").append(SPACE);
                    }
                    postScript.append(NEWLINE);
                    continue;
                }
                if (drawCmd instanceof GraphicsStateCmd) {
                    postScript.append('/').append(((GraphicsStateCmd)drawCmd).getGraphicStateName()).append(SPACE).append("gs").append(SPACE);
                    continue;
                }
                if (!(drawCmd instanceof TextSpriteDrawCmd)) continue;
                postScript.append("BT").append(NEWLINE);
                TextSpriteDrawCmd textSpriteDrawCmd = (TextSpriteDrawCmd)drawCmd;
                TextSprite textSprite = textSpriteDrawCmd.getTextSprite();
                ArrayList<GlyphText> glyphTexts = textSprite.getGlyphSprites();
                if (glyphTexts.size() <= 0) continue;
                postScript.append("1 0 0 -1 ").append(glyphTexts.get(0).getX()).append(SPACE).append(glyphTexts.get(0).getY()).append(SPACE).append("Tm").append(NEWLINE);
                postScript.append(NAME).append(textSprite.getFontName()).append(SPACE).append(textSprite.getFontSize()).append(SPACE).append("Tf").append(NEWLINE);
                float[] colors2 = textSprite.getStrokeColor().getRGBColorComponents(null);
                postScript.append(colors2[0]).append(SPACE).append(colors2[1]).append(SPACE).append(colors2[2]).append(SPACE).append("rg").append(NEWLINE);
                float y = glyphTexts.get(0).getY();
                StringBuilder line = new StringBuilder();
                int max = glyphTexts.size();
                for (int i = 0; i < max; ++i) {
                    GlyphText glyphText = glyphTexts.get(i);
                    if (y != glyphText.getY() || i == max - 1) {
                        if (i == max - 1) {
                            line.append(glyphText.getUnicode());
                        }
                        postScript.append(BEGIN_ARRAY).append(BEGIN_STRING).append(new LiteralStringObject(line.toString()).toString()).append(END_STRING).append(END_ARRAY).append(SPACE).append("TJ").append(NEWLINE);
                        postScript.append(0).append(SPACE).append(y - glyphText.getY()).append(SPACE).append("Td").append(NEWLINE);
                        y = glyphText.getY();
                        line = new StringBuilder();
                    }
                    line.append(glyphText.getUnicode());
                }
                postScript.append("ET").append(NEWLINE);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Error encoding PostScript notation ", e);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("PostEncoding: " + postScript.toString());
        }
        return postScript.toString().getBytes();
    }

    private static void generateShapePostScript(Shape currentShape, StringBuilder postScript) {
        PathIterator pathIterator = currentShape.getPathIterator(null);
        float[] segment = new float[6];
        while (!pathIterator.isDone()) {
            int segmentType = pathIterator.currentSegment(segment);
            switch (segmentType) {
                case 0: {
                    postScript.append(segment[0]).append(SPACE).append(segment[1]).append(SPACE).append("m").append(NEWLINE);
                    break;
                }
                case 1: {
                    postScript.append(segment[0]).append(SPACE).append(segment[1]).append(SPACE).append("l").append(NEWLINE);
                    break;
                }
                case 2: {
                    postScript.append(segment[0]).append(SPACE).append(segment[1]).append(SPACE).append(segment[2]).append(SPACE).append(segment[3]).append(SPACE).append("v").append(NEWLINE);
                    break;
                }
                case 3: {
                    postScript.append(segment[0]).append(SPACE).append(segment[1]).append(SPACE).append(segment[2]).append(SPACE).append(segment[3]).append(SPACE).append(segment[4]).append(SPACE).append(segment[5]).append(SPACE).append("c").append(NEWLINE);
                    break;
                }
                case 4: {
                    postScript.append("h").append(SPACE);
                }
            }
            pathIterator.next();
        }
    }
}

