/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Defs;

public class ImagePool {
    private static final Logger log = Logger.getLogger(ImagePool.class.toString());
    private final LinkedHashMap<Reference, BufferedImage> fCache;
    private static int defaultSize = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 4L);
    private static boolean enabled;

    public ImagePool() {
        this(defaultSize * 1024 * 1024);
    }

    public ImagePool(long maxCacheSize) {
        this.fCache = new MemoryImageCache(maxCacheSize);
    }

    public void put(Reference ref, BufferedImage image) {
        if (enabled) {
            this.fCache.put(new Reference(ref.getObjectNumber(), ref.getGenerationNumber()), image);
        }
    }

    public BufferedImage get(Reference ref) {
        if (enabled) {
            return this.fCache.get(ref);
        }
        return null;
    }

    static {
        defaultSize = Defs.intProperty("org.icepdf.core.views.imagePoolSize", defaultSize);
        enabled = Defs.booleanProperty("org.icepdf.core.views.imagePoolEnabled", true);
    }

    private static class MemoryImageCache
    extends LinkedHashMap<Reference, BufferedImage> {
        private final long maxCacheSize;
        private long currentCacheSize;

        public MemoryImageCache(long maxCacheSize) {
            super(16, 0.75f, true);
            this.maxCacheSize = maxCacheSize;
        }

        @Override
        public BufferedImage put(Reference key, BufferedImage value) {
            if (this.containsKey(key)) {
                BufferedImage removed = (BufferedImage)this.remove(key);
                this.currentCacheSize = this.currentCacheSize - this.sizeOf(removed) + this.sizeOf(value);
                super.put(key, value);
                return removed;
            }
            this.currentCacheSize += this.sizeOf(value);
            return super.put(key, value);
        }

        private long sizeOf(BufferedImage image) {
            int dataTypeSize;
            if (image == null) {
                return 0L;
            }
            DataBuffer dataBuffer = image.getRaster().getDataBuffer();
            switch (dataBuffer.getDataType()) {
                case 0: {
                    dataTypeSize = 1;
                    break;
                }
                case 1: 
                case 2: {
                    dataTypeSize = 2;
                    break;
                }
                case 3: 
                case 4: {
                    dataTypeSize = 4;
                    break;
                }
                default: {
                    dataTypeSize = 8;
                }
            }
            return dataBuffer.getSize() * dataTypeSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Reference, BufferedImage> eldest) {
            boolean remove;
            boolean bl = remove = this.currentCacheSize > this.maxCacheSize;
            if (remove) {
                long size = this.sizeOf(eldest.getValue());
                this.currentCacheSize -= size;
            }
            return remove;
        }
    }
}

