/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.ContentParserFactory;

public class Form
extends Stream {
    private static final Logger logger = Logger.getLogger(Form.class.toString());
    public static final Name TYPE_VALUE = new Name("XObject");
    public static final Name SUB_TYPE_VALUE = new Name("Form");
    public static final Name GROUP_KEY = new Name("Group");
    public static final Name I_KEY = new Name("I");
    public static final Name K_KEY = new Name("K");
    public static final Name MATRIX_KEY = new Name("Matrix");
    public static final Name BBOX_KEY = new Name("BBox");
    public static final Name RESOURCES_KEY = new Name("Resources");
    private AffineTransform matrix = new AffineTransform();
    private Rectangle2D bbox;
    private Shapes shapes;
    private GraphicsState graphicsState;
    private Resources resources;
    private Resources parentResource;
    private boolean transparencyGroup;
    private boolean isolated;
    private boolean knockOut;
    private boolean inited = false;

    public Form(Library l, HashMap h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
        HashMap group = this.library.getDictionary(this.entries, GROUP_KEY);
        if (group != null) {
            this.transparencyGroup = true;
            this.isolated = this.library.getBoolean(group, I_KEY);
            this.knockOut = this.library.getBoolean(group, K_KEY);
        }
    }

    public void setAppearance(Shapes shapes, AffineTransform matrix, Rectangle2D bbox) {
        this.shapes = shapes;
        this.matrix = matrix;
        this.bbox = bbox;
        this.entries.put(BBOX_KEY, PRectangle.getPRectangleVector(bbox));
        this.entries.put(MATRIX_KEY, matrix);
    }

    public void setGraphicsState(GraphicsState graphicsState) {
        if (graphicsState != null) {
            this.graphicsState = graphicsState;
        }
    }

    private static AffineTransform getAffineTransform(List v) {
        float[] f = new float[6];
        for (int i = 0; i < 6; ++i) {
            f[i] = ((Number)v.get(i)).floatValue();
        }
        return new AffineTransform(f);
    }

    public void setParentResources(Resources parentResource) {
        this.parentResource = parentResource;
    }

    @Override
    public synchronized void init() {
        if (this.inited) {
            return;
        }
        Object v = this.library.getObject(this.entries, MATRIX_KEY);
        if (v != null && v instanceof List) {
            this.matrix = Form.getAffineTransform((List)v);
        } else if (v != null && v instanceof AffineTransform) {
            this.matrix = (AffineTransform)v;
        }
        this.bbox = this.library.getRectangle(this.entries, BBOX_KEY);
        Resources leafResources = this.library.getResources(this.entries, RESOURCES_KEY);
        if (leafResources != null) {
            this.resources = leafResources;
        } else {
            leafResources = this.parentResource;
        }
        ContentParser cp = ContentParserFactory.getInstance().getContentParser(this.library, leafResources);
        cp.setGraphicsState(this.graphicsState);
        byte[] in = this.getDecodedStreamBytes();
        if (in != null) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Parsing form " + this.getPObjectReference());
                }
                this.shapes = cp.parse(new byte[][]{in}).getShapes();
            }
            catch (Throwable e) {
                this.shapes = new Shapes();
                logger.log(Level.FINE, "Error parsing Form content stream.", e);
            }
        }
        this.inited = true;
    }

    public Resources getResources() {
        Resources leafResources = this.library.getResources(this.entries, RESOURCES_KEY);
        if (this.resources == null) {
            leafResources = new Resources(this.library, new HashMap());
        }
        return leafResources;
    }

    public void setResources(Resources resources) {
        this.entries.put(RESOURCES_KEY, resources.getEntries());
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public boolean isTransparencyGroup() {
        return this.transparencyGroup;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public boolean isKnockOut() {
        return this.knockOut;
    }
}

