#!/bin/bash

# Function to display usage
usage() {
    echo "Usage: $0 -v <version_to_restore>"
    exit 1
}

# Parse command line arguments
while getopts ":v:" opt; do
  case $opt in
    v) version_to_restore="$OPTARG"
    ;;
    \?) echo "Invalid option -$OPTARG" >&2
       usage
    ;;
  esac
done

# Check if version to restore is provided
if [ -z "$version_to_restore" ]; then
    echo "Version to restore not provided."
    usage
fi

# Define directories
TARGET_DIR="/var/www/html/app"
BACKUP_DIR="/var/www/html/App-Backup"
BACKUP_FILE="$BACKUP_DIR/app-bak-v$version_to_restore.tar.gz"

# Check if the backup file exists
if [ ! -f "$BACKUP_FILE" ]; then
    echo "Backup file $BACKUP_FILE does not exist."
    exit 1
fi

# Restore from the backup
echo "Restoring from $BACKUP_FILE..."
tar -xzf "$BACKUP_FILE" -C "$TARGET_DIR"

# Update the version.txt file
echo "$version_to_restore" > "$TARGET_DIR/version.txt"

echo "Restore complete. Version is now set to $version_to_restore."
