#!/bin/bash

# Function to display usage
usage() {
    echo "Usage: $0 -v <new_version>"
    exit 1
}

# Parse command line arguments
while getopts ":v:" opt; do
  case $opt in
    v) new_version="$OPTARG"
    ;;
    \?) echo "Invalid option -$OPTARG" >&2
       usage
    ;;
  esac
done

# Check if new version is provided
if [ -z "$new_version" ]; then
    echo "New version not provided."
    usage
fi

# Define directories
SOURCE_DIR="/home/ubuntu/ekalkyl-release-prep"
TARGET_DIR="/var/www/html/app"
BACKUP_DIR="/var/www/html/App-Backup"

# Read the current version
if [ -f "$TARGET_DIR/version.txt" ]; then
    current_version=$(cat "$TARGET_DIR/version.txt")
else
    echo "version.txt not found in $TARGET_DIR"
    exit 1
fi

# Create a backup of the current version
tar -czf "$BACKUP_DIR/app-bak-v$current_version.tar.gz" -C "$TARGET_DIR" .

# Copy new content to the target directory
cp -r "$SOURCE_DIR/"* "$TARGET_DIR/"

# Update the version.txt file
echo "$new_version" > "$TARGET_DIR/version.txt"

echo "Update complete. Current version is now $new_version."
