/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeSelectListener
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
        JTree tree = (JTree)e.getComponent();
        int row = tree.getClosestRowForLocation(e.getX(), e.getY());
        Logger.getLogger("se.sjobeck").finest("Closest row: " + row);
        if ((e.getModifiersEx() & 0x80) == 128) {
            tree.addSelectionRow(row);
        } else {
            tree.setSelectionRow(row);
        }
        if ((e.getModifiers() & 2) > 0) {
            TreePath path;
            TreeSelectListener.expandAll(tree, path, !tree.isExpanded(path = tree.getSelectionPath()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JTree tree = (JTree)e.getComponent();
        int row = tree.getClosestRowForLocation(e.getX(), e.getY());
        if ((e.getModifiersEx() & 0x80) == 128) {
            tree.addSelectionRow(row);
        } else {
            tree.setSelectionRow(row);
        }
    }

    public static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreeSelectListener.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }
}

