/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.JTextFieldWithArrow;
import se.sjobeck.gui.PopupEditorPanel;
import se.sjobeck.gui.SelectingEditor;

public class PopupEditor
extends SelectingEditor {
    private JWindow poppy;
    private PopupEditorPanel popupPanel;

    PopupEditor(JFrame parent, PopupEditorPanel panel) {
        this(parent, panel, true);
    }

    PopupEditor(JFrame parent, PopupEditorPanel panel, boolean editable) {
        super(new JTextFieldWithArrow(true));
        this.popupPanel = panel;
        this.editorComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getX() >= ((PopupEditor)PopupEditor.this).editorComponent.getSize().width - 22) {
                    e.consume();
                    PopupEditor.this.showDialog();
                }
            }
        });
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupEditor.this.showDialog();
            }
        };
        this.editorComponent.getInputMap().put(KeyStroke.getKeyStroke("pressed F2"), "openDialog");
        this.editorComponent.getActionMap().put("openDialog", a);
        this.poppy = new JWindow(parent);
        this.poppy.add(this.popupPanel.getComponent());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex) {
        RadStruct row = (RadStruct)value;
        this.popupPanel.init(row, (JTextFieldWithArrow)this.editorComponent, this);
        Logger.getLogger("se.sjobeck.gui.PopupEditor").finest("editor value sets to: '" + this.popupPanel.getValue(row) + "'");
        return super.getTableCellEditorComponent(table, this.popupPanel.getValue(row), isSelected, rowIndex, columnIndex);
    }

    public void showDialog() {
        this.poppy.setVisible(false);
        this.popupPanel.willShowDialog();
        this.poppy.pack();
        Point absoluteCoord = new Point(0, this.editorComponent.getSize().height);
        SwingUtilities.convertPointToScreen(absoluteCoord, this.editorComponent);
        Rectangle screenBounds = this.editorComponent.getGraphicsConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.editorComponent.getGraphicsConfiguration());
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        if (absoluteCoord.x + this.popupPanel.getComponent().getSize().width > screenBounds.x + screenBounds.width) {
            absoluteCoord.x = screenBounds.x + screenBounds.width - this.popupPanel.getComponent().getSize().width;
        } else if (absoluteCoord.x < screenBounds.x) {
            absoluteCoord.x = screenBounds.x;
        }
        if (absoluteCoord.y + this.popupPanel.getComponent().getSize().height > screenBounds.y + screenBounds.height) {
            absoluteCoord.y = screenBounds.y + screenBounds.height - this.popupPanel.getComponent().getSize().height;
        } else if (absoluteCoord.y < screenBounds.y) {
            absoluteCoord.y = screenBounds.y;
        }
        this.poppy.setLocation(absoluteCoord);
        this.poppy.setVisible(true);
    }

    @Override
    public boolean stopCellEditing() {
        Logger.getLogger("se.sjobeck").entering("PopupEditor", "stopCellEditing");
        if (this.popupPanel.stopCellEditing() && super.stopCellEditing()) {
            this.popupPanel.uninit();
            this.poppy.setVisible(false);
            Logger.getLogger("se.sjobeck").exiting("PopupEditor", "stopCellEditing", Boolean.TRUE);
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        Logger.getLogger("se.sjobeck").exiting("PopupEditor", "stopCellEditing", Boolean.FALSE);
        return false;
    }

    @Override
    public void cancelCellEditing() {
        Logger.getLogger("se.sjobeck").info("Entering PopupEditor.cancelCellEditing()!");
        Logger.getLogger("se.sjobeck").entering("PopupEditor", "cancelCellEditing");
        this.popupPanel.uninit();
        this.poppy.setVisible(false);
        super.cancelCellEditing();
        Logger.getLogger("se.sjobeck").exiting("PopupEditor", "cancelCellEditing");
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        return this.popupPanel.getCellEditorValue();
    }
}

