/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTextField;

public class JTextFieldWithArrow
extends JTextField {
    private boolean mouseOver;

    JTextFieldWithArrow() {
        this(true);
    }

    JTextFieldWithArrow(boolean isEditable) {
        super.setEditable(isEditable);
        this.setMargin(new Insets(0, 0, 0, 22));
        super.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTextFieldWithArrow.this.mouseOver = e.getX() >= JTextFieldWithArrow.super.getSize().width - 22;
                JTextFieldWithArrow.this.repaint();
            }
        });
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                JTextFieldWithArrow.this.mouseOver = false;
                JTextFieldWithArrow.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JTextFieldWithArrow.this.mouseOver = e.getX() >= JTextFieldWithArrow.super.getSize().width - 22;
                JTextFieldWithArrow.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mouseOver) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        Dimension d = super.getSize();
        int[] xs = new int[]{d.width - 20, d.width - 11, d.width - 2};
        int[] ys = new int[]{(d.height - 9) / 2, 9 + (d.height - 9) / 2, (d.height - 9) / 2};
        g.fillPolygon(xs, ys, 3);
    }
}

