/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import se.sjobeck.gui.FileTransferable;

public class FileDragNDrop
implements DragGestureListener,
DropTargetListener {
    protected static DataFlavor FileTransferFlavor = new DataFlavor(FileTransferable.class, "FileTransfer");
    private JTree fileTree;

    public static void register(JTree fileTree) {
        FileDragNDrop fileDrop = new FileDragNDrop(fileTree);
        DragGestureRecognizer dgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(fileTree, 2, fileDrop);
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        DropTarget dropTarget = new DropTarget(fileTree, fileDrop);
    }

    private FileDragNDrop(JTree fileTree) {
        this.fileTree = fileTree;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point origin = e.getDragOrigin();
        TreePath selectedPath = this.fileTree.getClosestPathForLocation(origin.x, origin.y);
        FileTransferable t = new FileTransferable((File)((DefaultMutableTreeNode)selectedPath.getLastPathComponent()).getUserObject());
        DragSource.getDefaultDragSource().startDrag(e, null, t, null);
    }

    @Override
    public void drop(DropTargetDropEvent ev) {
        try {
            Point targetLocation = ev.getLocation();
            TreePath destinationTreePath = this.fileTree.getPathForLocation(targetLocation.x, targetLocation.y);
            File targetPath = (File)((DefaultMutableTreeNode)destinationTreePath.getLastPathComponent()).getUserObject();
            File sourcePath = (File)ev.getTransferable().getTransferData(FileTransferFlavor);
            if (this.testDropTarget(targetPath, sourcePath)) {
                File newFile = new File(targetPath, sourcePath.getName());
                sourcePath.renameTo(newFile);
            } else {
                ev.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException ex) {
            ev.rejectDrop();
        }
        catch (IOException ex) {
            ev.rejectDrop();
        }
        catch (NullPointerException ex) {
            ev.rejectDrop();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.dragOver(e);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent ev) {
        Logger.getLogger("se.sjobeck.gui.FileDragNDrop").entering("FileDragNDrop", "dragOver", ev);
        try {
            Point targetLocation = ev.getLocation();
            TreePath destinationTreePath = this.fileTree.getPathForLocation(targetLocation.x, targetLocation.y);
            File targetPath = (File)((DefaultMutableTreeNode)destinationTreePath.getLastPathComponent()).getUserObject();
            File sourcePath = (File)ev.getTransferable().getTransferData(FileTransferFlavor);
            if (this.testDropTarget(targetPath, sourcePath)) {
                ev.acceptDrag(2);
            } else {
                ev.rejectDrag();
            }
        }
        catch (UnsupportedFlavorException ex) {
            ev.rejectDrag();
        }
        catch (IOException ex) {
            ev.rejectDrag();
        }
        catch (NullPointerException ex) {
            ev.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private boolean testDropTarget(File targetPath, File sourcePath) {
        if (!targetPath.isDirectory()) {
            return false;
        }
        if (targetPath.equals(sourcePath)) {
            return false;
        }
        if (targetPath.equals(sourcePath.getParentFile())) {
            return false;
        }
        return !this.isDescendant(targetPath, sourcePath);
    }

    private boolean isDescendant(File target, File source) {
        if (target == null) {
            return false;
        }
        if (target.equals(source)) {
            return true;
        }
        return this.isDescendant(target.getParentFile(), source);
    }
}

