/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures.drawings;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.struct.GeometraShape;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;

public class EkalkylSquareDrawing
extends SquareDrawing {
    public EkalkylSquareDrawing() {
    }

    public EkalkylSquareDrawing(SquareDrawing sqd) {
        List<HoleDrawing> children = sqd.getChildren();
        for (HoleDrawing hd : children) {
            try {
                super.addChild((GeometraDrawing)hd.clone());
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(EkalkylSquareDrawing.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setAngle(sqd.getAngle());
        this.setAreaMod(sqd.getAreaMod());
        this.setColor(sqd.getColor());
        this.setDescription(sqd.getDescription());
        this.setHeight(sqd.getHeight());
        this.setClosed(sqd.isClosed());
        this.setFilled(sqd.isFilled());
        this.setLengthMod(this.getDistanceMod());
        List<Point2D> points1 = sqd.getPoints();
        for (Point2D p2d : points1) {
            this.points.add((Point2D)p2d.clone());
        }
        this.setTwoDimensionsVisible(sqd.isTwoDimensionsVisible());
        this.setThreeDimensionsVisible(sqd.isThreeDimensionsVisible());
        this.setSmartDrawingColor(sqd.getSmartDrawingColor());
        this.setVolumeMod(sqd.getVolumeMod());
        this.setWallSurfaceMod(sqd.getWallSurfaceMod());
        this.setVisible(true);
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        super.paintDrawing(g, base, clip);
        this.paintWall(g, base);
    }

    private void drawFormel(Point2D first, Point2D second, BlueprintPage base, int nr, FontMetrics metrics, Graphics2D g) {
        Point2D.Double center = new Point2D.Double((first.getX() + second.getX()) * 0.5, (first.getY() + second.getY()) * 0.5);
        base.getAffineTransform().transform(center, center);
        String formelName = "V" + nr;
        Rectangle2D stringBounds = metrics.getStringBounds(formelName, g);
        GeometraShape shape = this.getGeometraShape(stringBounds, this.drawingFont.getSize(), center);
        g.drawString(formelName, (float)shape.getX(), (float)shape.getY());
    }

    private void paintWall(Graphics2D g, BlueprintPage base) {
        if (this.points.size() > 1) {
            g.setRenderingHints(GEOMETRA_RENDER_HINTS);
            FontMetrics metrics = g.getFontMetrics();
            Font font = g.getFont();
            g.setColor(Color.BLACK);
            int originalSize = GeometraConfiguration.getFontSize();
            this.drawingFont = new Font(font.getName(), 1, (int)((double)originalSize + this.getScaleFactor(base.getAffineTransform()) * 1.0));
            g.setFont(this.drawingFont);
            Iterator iterator = this.points.iterator();
            Point2D first = (Point2D)iterator.next();
            int nr = 0;
            while (iterator.hasNext()) {
                Point2D second = (Point2D)iterator.next();
                this.drawFormel(first, second, base, ++nr, metrics, g);
                first = second;
            }
            this.drawFormel((Point2D)this.points.get(this.points.size() - 1), (Point2D)this.points.get(0), base, ++nr, metrics, g);
        }
    }
}

