/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.RadStruct;

public class TillaggFactory {
    public static TlgStruct[] parseTillagg(String str, RadStruct struct, Projekt proj) {
        str = str.replaceAll(",", " ");
        Vector<TlgStruct> tillagg = new Vector<TlgStruct>();
        for (String tlg : str.split(" ")) {
            try {
                tillagg.add(TillaggFactory.parseTlg(tlg.toUpperCase(), struct, proj));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return tillagg.toArray(new TlgStruct[tillagg.size()]);
    }

    private static TlgStruct parseTlg(String tlg, RadStruct struct, Projekt proj) {
        Map<String, List<TlgStruct>> mapping = proj.getDatabaseInstance().getTill\u00e4ggsTabell();
        for (List<TlgStruct> list : mapping.values()) {
            for (TlgStruct t : list) {
                if (!t.getAckpunkt().equals(tlg) || !TillaggFactory.isValid(t, struct, proj)) continue;
                return t;
            }
        }
        throw new IllegalArgumentException("Ogiligt till\u00e4gg");
    }

    public static boolean isValid(TlgStruct tg, RadStruct rad, Projekt proj) {
        if (rad.getInomhus() && !tg.isInomhus()) {
            return false;
        }
        if (!rad.getInomhus() && !tg.isUtomhus()) {
            return false;
        }
        if (rad.getYtmaterialID() == null || rad.getByggdel() == null) {
            return false;
        }
        List<List<TlgStruct>> ytmaterial = rad.getInomhus() ? proj.getDatabaseInstance().getInomhusTabell().get(rad.getYtmaterialID()) : proj.getDatabaseInstance().getUtomhusTabell().get(rad.getYtmaterialID());
        List<List<TlgStruct>> byggdel = proj.getDatabaseInstance().getByggdelsTabell().get(rad.getByggdel().getId());
        if (byggdel != null) {
            for (List<TlgStruct> list : byggdel) {
                if (list == null || !ytmaterial.contains(list)) continue;
                for (TlgStruct struct : list) {
                    if (!struct.equals(tg)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

