/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.io.File;
import java.io.Serializable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Logger;
import se.sjobeck.database.Database;
import se.sjobeck.datastructures.ConstantsNode;
import se.sjobeck.datastructures.CustomAMA;
import se.sjobeck.datastructures.CustomAMANod;
import se.sjobeck.datastructures.GrenNod;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.RemarksNod;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.Fabrikat;
import se.sjobeck.datastructures.kalkylering.ProjektInfo;
import se.sjobeck.datastructures.kalkylering.RadHanterare;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.TimprisStruct;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;
import se.sjobeck.parser2.Function;

public class Projekt
extends ProjektInfo
implements Serializable {
    public static final long serialVersionUID = 0L;
    private KalkylNod rader = null;
    private Vector<Function> konstanter = null;
    private Vector<CustomAMA> egnaKoder;
    private RadStruct defaultRow;
    private transient File fileReference;
    private transient KalkylNod rootNode;
    private long today;
    private transient long databaseDate;
    private transient Vector<Observer> treeObserver;

    public Projekt() {
        this.radHanterare = null;
        this.rootNode = null;
        this.today = System.currentTimeMillis();
        this.checkLatestDatabaseDate();
        this.today = this.databaseDate + 1L;
    }

    private Object readResolve() {
        this.radHanterare = null;
        this.rootNode = null;
        if (this.today == 0L) {
            this.today = System.currentTimeMillis();
        }
        this.checkLatestDatabaseDate();
        if (this.timpris != null) {
            this.timpris.setOwner(this);
        }
        return this;
    }

    public double getAckgrundl\u00f6nInklTill\u00e4gg(RadStruct struct) {
        TlgStruct[] globala_tlg;
        RadHanterare radHanterare = this.getRadHanterare();
        Behandling behandling = this.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, struct);
        double pris = radHanterare.raknaUtBehandling(behandling, struct);
        behandling = this.getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, struct);
        pris += radHanterare.raknaUtBehandling(behandling, struct);
        behandling = this.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, struct);
        pris += radHanterare.raknaUtBehandling(behandling, struct);
        double t_procent = 1.0;
        for (TlgStruct ts : globala_tlg = this.getGlobalaTillagg()) {
            if (!ts.isProcent()) continue;
            t_procent *= 1.0 + ts.getPris() * 0.01;
        }
        TlgStruct[] ts = struct.getTillagg();
        double t212_213_214 = 0.0;
        for (int i = 0; i < ts.length; ++i) {
            if (!ts[i].isProcent()) {
                t212_213_214 += ts[i].getPris();
                continue;
            }
            if (!ts[i].getSieve().isEmpty()) continue;
            t_procent *= 1.0 + ts[i].getPris() * 0.01;
        }
        return pris += t212_213_214 * t_procent;
    }

    public void checkLatestDatabaseDate() {
        Logger.getLogger(this.getClass().getCanonicalName()).finer("Projekt: today = " + this.today);
        this.databaseDate = ((FromServerMessage)ClientThread.sendMessage(Message.LookupDatabaseDate, this.today)).getLong();
        Logger.getLogger(this.getClass().getCanonicalName()).finer("Projekt: databaseDate = " + this.databaseDate);
    }

    public void recalculate(KalkylNod nod) {
        this.recursiveRecalculate(nod);
    }

    private void recursiveRecalculate(KalkylNod nod) {
        if (nod instanceof RumNod) {
            for (RadStruct r : nod.getRader()) {
                r.setAntalEnh(Function.getValue(r.getAntalFormel(), ((RumNod)nod).getVariabler(), this.getKonstanter()));
            }
            ((RumNod)nod).invalidate();
            this.updateNode(nod);
        } else if (nod instanceof GrenNod) {
            for (int i = 0; i < nod.getChildCount(); ++i) {
                this.recursiveRecalculate((KalkylNod)nod.getChildAt(i));
            }
        }
    }

    public Vector<Function> getKonstanter() {
        if (this.konstanter == null) {
            this.konstanter = new Vector();
            this.konstanter.add(new Function("VH", "2.4", "Normal rumsh\u00f6jd"));
        }
        return this.konstanter;
    }

    @Override
    public double getEgenTid(RadStruct struct) {
        Double d = this.getEgenTid().get(struct);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public void putEgenTid(RadStruct struct, double value) {
        this.getEgenTid().put(struct, value);
    }

    @Override
    public void removeEgenTid(RadStruct struct) {
        this.getEgenTid().remove(struct);
    }

    @Override
    public TimprisStruct getTimprisStruct() {
        if (this.timpris == null) {
            this.timpris = new TimprisStruct(this);
        }
        return this.timpris;
    }

    @Override
    public void setGlobalaTillagg(TlgStruct[] ny) {
        Logger.getLogger("se.sjobeck").entering("Projekt", "setGlobalaTillagg");
        this.globalaTillagg = ny;
        this.getRadHanterare().conditionsChanged();
    }

    @Override
    public TlgStruct[] getGlobalaTillagg() {
        return this.globalaTillagg;
    }

    public KalkylNod getRader() {
        if (this.rader == null) {
            this.rader = new GrenNod(){

                @Override
                public boolean deletable() {
                    return false;
                }

                @Override
                public KalkylNod copy() {
                    return null;
                }

                @Override
                public void setUserObject(Object obj) {
                }

                @Override
                public double getAntal() {
                    return 1.0;
                }
            };
            this.rader.beskrivning = "Total";
        }
        return this.rader;
    }

    public KalkylNod getRootNode() {
        if (this.rootNode == null) {
            Logger.getLogger("se.sjobeck").entering("Projekt", "getRootNode()");
            this.rootNode = new GrenNod(){

                @Override
                public boolean deletable() {
                    return false;
                }

                @Override
                public void setUserObject(Object obj) {
                }

                @Override
                public void update(KalkylNod nod) {
                    Projekt.this.updateNode(nod);
                }

                public Vector<Function> getKonstanter() {
                    return Projekt.this.getKonstanter();
                }

                @Override
                public String getBeskrivning() {
                    return Projekt.this.getFileReference().getName();
                }

                @Override
                public Projekt getProject() {
                    return Projekt.this;
                }
            };
            this.rootNode.add(new CustomAMANod());
            this.rootNode.add(new ConstantsNode());
            this.rootNode.add(new RemarksNod());
            this.rootNode.add(this.getRader());
        }
        return this.rootNode;
    }

    private Vector<Observer> getTreeObserver() {
        if (this.treeObserver == null) {
            this.treeObserver = new Vector();
        }
        return this.treeObserver;
    }

    public void addTreeObserver(Observer o) {
        this.getTreeObserver().add(o);
    }

    public void setTreeObserver(Observer newObserver) {
        for (Observer current : this.getTreeObserver()) {
            if (!current.equals(newObserver)) continue;
            return;
        }
        this.addTreeObserver(newObserver);
    }

    public void removeTreeObserver(Observer o) {
        this.getTreeObserver().remove(o);
    }

    public synchronized void updateNode(KalkylNod nod) {
        Logger.getLogger("se.sjobeck").entering("Projekt", "updateNode", nod);
        for (Observer o : this.getTreeObserver()) {
            o.update(null, nod);
        }
    }

    public CustomAMA getCustomAMA(String behKod) {
        for (CustomAMA cust : this.getCustomAmaVector()) {
            if (!cust.getName().equals(behKod)) continue;
            return cust;
        }
        return null;
    }

    public String getCustomEnhet(String behKod) {
        for (CustomAMA cust : this.getCustomAmaVector()) {
            if (!cust.getName().equals(behKod)) continue;
            return cust.getEnhet();
        }
        return "st";
    }

    @Override
    public double getCustomAckpris(String behKod) {
        for (CustomAMA cust : this.getCustomAmaVector()) {
            if (!cust.getName().equals(behKod)) continue;
            try {
                return cust.getAckTid() * this.getTimprisStruct().getTimlon();
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getCustomMatpris(String behKod) {
        for (CustomAMA cust : this.getCustomAmaVector()) {
            if (!cust.getName().equals(behKod)) continue;
            try {
                return cust.getMatPris();
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public boolean invalidCustomAma(String behKod) {
        for (CustomAMA cust : this.getCustomAmaVector()) {
            if (!cust.getName().equals(behKod)) continue;
            return !(cust.getAckTid() > 0.0);
        }
        return true;
    }

    public int getCustomAmaCount() {
        return this.getCustomAmaVector().size();
    }

    public void removeCustomAmaRow(int row) {
        try {
            this.getCustomAmaVector().remove(row);
            this.getRadHanterare().pricesChanged();
            this.updateNode(null);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setCustomAmaMaterialPris(int row, String s) {
        this.getCustomAmaVector().get(row).setMatPris(s);
        this.getRadHanterare().pricesChanged();
        this.updateNode(null);
    }

    public void setCustomAmaAckTid(int row, String s) {
        this.getCustomAmaVector().get(row).setAckTid(s);
        this.getRadHanterare().pricesChanged();
        this.updateNode(null);
    }

    public void setCustomAmaEnhet(int row, String s) {
        this.getCustomAmaVector().get(row).setEnhet(s);
    }

    public void setCustomAmaBeskrivning(int row, String s) {
        this.getCustomAmaVector().get(row).setBeskrivning(s);
    }

    public String getCustomAmaAckTidFunction(int row) {
        try {
            return this.getCustomAmaVector().get(row).getAckTidFunction();
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public double getCustomAmaAckTid(int row) {
        return this.getCustomAmaVector().get(row).getAckTid();
    }

    public String getCustomAmaMaterialPrisFunction(int row) {
        try {
            return this.getCustomAmaVector().get(row).getMatPrisFunction();
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public double getCustomAmaMaterialPris(int row) {
        try {
            return this.getCustomAmaVector().get(row).getMatPris();
        }
        catch (IndexOutOfBoundsException e) {
            return Double.NaN;
        }
    }

    public String getCustomAmaName(int row) {
        try {
            return this.getCustomAmaVector().get(row).getName();
        }
        catch (IndexOutOfBoundsException e) {
            return "<Fel>";
        }
    }

    public String getCustomAmaEnhet(int row) {
        try {
            return this.getCustomAmaVector().get(row).getEnhet();
        }
        catch (IndexOutOfBoundsException e) {
            return "<Fel>";
        }
    }

    public String getCustomAmaBeskrivning(int row) {
        return this.getCustomAmaVector().get(row).getBeskrivning();
    }

    private Vector<CustomAMA> getCustomAmaVector() {
        if (this.egnaKoder == null) {
            this.egnaKoder = new Vector();
        }
        return this.egnaKoder;
    }

    public void addCustomAMA(String behKod) {
        for (CustomAMA cust : this.getCustomAmaVector()) {
            if (!cust.getName().equals(behKod)) continue;
            return;
        }
        CustomAMA newAMA = new CustomAMA(behKod, "", "0", "0", "");
        this.getCustomAmaVector().add(newAMA);
    }

    @Override
    public Fabrikat getFabrikat() {
        if (this.fabrikat == null) {
            return Fabrikat.Nordsj\u00f6;
        }
        return this.fabrikat;
    }

    @Override
    public void setFabrikat(Fabrikat f) {
        this.fabrikat = f;
        this.getRadHanterare().conditionsChanged();
    }

    public void setDefaultRow(RadStruct bs) {
        this.defaultRow = bs;
    }

    public RadStruct getDefaultRow() {
        if (this.defaultRow == null) {
            RadStruct b = new RadStruct();
            RadHanterare.setDefaults(b);
            return b;
        }
        return this.defaultRow;
    }

    public File getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(File fileReference) {
        this.fileReference = fileReference;
    }

    @Override
    public RadHanterare getRadHanterare() {
        if (this.radHanterare == null) {
            this.radHanterare = new RadHanterare(this);
        }
        return this.radHanterare;
    }

    public long getToday() {
        return this.today;
    }

    public void setToday(long value) {
        this.today = ++value;
    }

    @Override
    public Database getDatabaseInstance() {
        return Database.getInstance(this.databaseDate);
    }
}

