/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.nfont.CMap;
import org.icepdf.core.pobjects.fonts.nfont.Encoding;
import org.icepdf.core.pobjects.fonts.nfont.NFont;
import org.icepdf.core.pobjects.fonts.nfont.k;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.TextState;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.ContentParserFactory;

public class NFontType3
extends k
implements Cloneable {
    private static final Logger logger = Logger.getLogger(NFontType3.class.toString());
    public static final Name FONT_BBOX_KEY = new Name("FontBBox");
    public static final Name FONT_MATRIX_KEY = new Name("FontMatrix");
    public static final Name CHAR_PROCS_KEY = new Name("CharProcs");
    public static final Name RESOURCES_KEY = new Name("Resources");
    private Library library;
    private HashMap charProcedures;
    private HashMap charShapesCache;
    private HashMap charBBoxes;
    private HashMap charWidths;
    private Resources resources;
    protected HashMap entries;
    private AffineTransform glyph2user;
    private PRectangle bBox;
    private Resources parentResource;

    public NFontType3(Library library, HashMap hashMap) {
        super(null);
        List list;
        this.library = library;
        this.glyph2user = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.entries = hashMap;
        Object object = library.getObject(hashMap, FONT_BBOX_KEY);
        if (object instanceof List) {
            list = (List)object;
            this.bBox = new PRectangle(list);
            this.bbox_.setRect(this.bBox.getX(), this.bBox.getY(), this.bBox.getWidth(), this.bBox.getHeight());
        }
        if ((object = library.getObject(hashMap, FONT_MATRIX_KEY)) instanceof List) {
            list = (List)object;
            this.m_ = new AffineTransform(((Number)list.get(0)).floatValue(), ((Number)list.get(1)).floatValue(), ((Number)list.get(2)).floatValue(), ((Number)list.get(3)).floatValue(), ((Number)list.get(4)).floatValue(), ((Number)list.get(5)).floatValue());
        } else {
            this.m_ = new AffineTransform(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        }
        this.touni_ = CMap.IDENTITY;
        object = library.getObject(hashMap, CHAR_PROCS_KEY);
        if (object instanceof HashMap) {
            this.charProcedures = (HashMap)object;
            int n2 = this.charProcedures.size();
            this.charShapesCache = new HashMap(n2);
            this.charBBoxes = new HashMap(n2);
            this.charWidths = new HashMap(n2);
        }
    }

    public NFont deriveFont(float f2) {
        NFontType3 nFontType3 = null;
        try {
            nFontType3 = (NFontType3)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.log(Level.FINE, "Could not derive Type3 font ", cloneNotSupportedException);
        }
        if (nFontType3 != null) {
            nFontType3.size_ = f2;
            nFontType3.max_ = null;
            nFontType3.setGlyph2User(this.at_);
        }
        return nFontType3;
    }

    public k deriveFont(Encoding encoding, CMap cMap) {
        return super.deriveFont(encoding, cMap == null ? CMap.IDENTITY : cMap);
    }

    public NFont deriveFont(AffineTransform affineTransform) {
        NFontType3 nFontType3 = (NFontType3)super.deriveFont(affineTransform);
        nFontType3.setGlyph2User(affineTransform);
        return nFontType3;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.m_);
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f2, float f3, long l2, int n2, Color color) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        affineTransform2.concatenate(this.getTransform());
        graphics2D.setTransform(affineTransform2);
        graphics2D.translate((double)f2 / this.m_.getScaleX(), (double)f3 / this.m_.getScaleY());
        graphics2D.scale(this.size_, -this.size_);
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            Shapes shapes = this.getGlyph(c2, color);
            if (shapes == null) continue;
            shapes.paint(graphics2D);
        }
        graphics2D.setTransform(affineTransform);
    }

    public Point2D echarAdvance(char c2) {
        Object v2;
        String string = this.encoding_.getName(c2);
        float f2 = 0.0f;
        if (string != null && c2 >= this.firstch_ && c2 <= this.lastch_) {
            f2 = (float)((double)this.newwidths_[c2 - this.firstch_] * this.m_.getScaleX());
        }
        if (f2 == 0.0f && this.charWidths.size() > 0 && (v2 = this.charWidths.get(string)) != null) {
            f2 = (float)((double)((Point2D.Float)v2).x * this.m_.getScaleX());
        }
        return new Point2D.Float((float)((double)(f2 * this.size_) * this.at_.getScaleX()), (float)((double)(f2 * this.size_) * this.at_.getShearY()));
    }

    public void setBBox(Name name, PRectangle pRectangle) {
        this.charBBoxes.put(name, pRectangle);
    }

    public Rectangle2D getMaxCharBounds() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(this.size_, -this.size_);
        affineTransform.concatenate(this.m_);
        affineTransform.concatenate(this.at_);
        return affineTransform.createTransformedShape(this.bBox.toJava2dCoordinates()).getBounds2D();
    }

    public Rectangle2D getCharBounds(char c2) {
        Rectangle2D rectangle2D = this.getMaxCharBounds();
        String string = this.encoding_.getName(c2);
        float f2 = 0.0f;
        if (string != null && c2 >= this.firstch_ && c2 <= this.lastch_) {
            f2 = this.newwidths_[c2 - this.firstch_];
        }
        if (f2 == 0.0f) {
            f2 = ((Point2D.Float)this.charWidths.get((Object)string)).x;
        }
        PRectangle pRectangle = (PRectangle)this.charBBoxes.get(string);
        rectangle2D.setRect(0.0, rectangle2D.getY(), f2 * this.size_, pRectangle.getHeight() * (double)this.size_);
        return rectangle2D;
    }

    public void setHorDisplacement(Name name, Point2D.Float float_) {
        this.charWidths.put(name, float_);
    }

    public String getFormat() {
        return "Type3";
    }

    public String getName() {
        return "Type 3";
    }

    public String getFamily() {
        return "Type 3";
    }

    public int getNumGlyphs() {
        return this.charProcedures.size();
    }

    public char getSpaceEchar() {
        return ' ';
    }

    public boolean isOneByteEncoding() {
        return false;
    }

    public boolean canDisplay(char c2) {
        return this.canDisplayEchar(c2);
    }

    public boolean canDisplayEchar(char c2) {
        return this.getGlyph(c2, Color.black) != null;
    }

    public boolean isHinted() {
        return false;
    }

    private void setGlyph2User(AffineTransform affineTransform) {
        float f2 = this.getSize();
        this.glyph2user = new AffineTransform(this.m_);
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX() * (double)f2, affineTransform.getShearY(), affineTransform.getShearX(), -affineTransform.getScaleY() * (double)f2, 0.0, 0.0);
        this.glyph2user.concatenate(affineTransform2);
    }

    private Shapes getGlyph(int n2, Color color) {
        Name name = new Name(this.encoding_.getName((char)n2));
        Name name2 = new Name(this.encoding_.getName((char)n2) + color.getRGB());
        SoftReference softReference = (SoftReference)this.charShapesCache.get(name2);
        if (softReference == null || softReference.get() == null) {
            Object object = this.library.getObject(this.charProcedures.get(name));
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                if (this.resources == null) {
                    this.resources = this.library.getResources(this.entries, RESOURCES_KEY);
                }
                if (this.resources == null) {
                    this.resources = this.parentResource;
                }
                ContentParser contentParser = ContentParserFactory.getInstance().getContentParser(this.library, this.resources);
                try {
                    GraphicsState graphicsState = new GraphicsState(new Shapes());
                    graphicsState.setFillColor(color);
                    contentParser.setGraphicsState(graphicsState);
                    contentParser.setGlyph2UserSpaceScale((float)this.glyph2user.getScaleX());
                    Shapes shapes = contentParser.parse((byte[][])new byte[][]{stream.getDecodedStreamBytes()}).getShapes();
                    TextState textState = contentParser.getGraphicsState().getTextState();
                    this.setBBox(name, textState.getType3BBox());
                    this.setHorDisplacement(name, textState.getType3HorizontalDisplacement());
                    this.charShapesCache.put(name2, new SoftReference<Shapes>(shapes));
                    return shapes;
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Error loading Type3 stream data.", iOException);
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.FINE, "Thread Interrupted while parsing Type3 stream data.", interruptedException);
                }
            }
        } else {
            return (Shapes)softReference.get();
        }
        return null;
    }

    public Shape getEstringOutline(String string, float f2, float f3) {
        return new Area();
    }

    public Resources getParentResource() {
        return this.parentResource;
    }

    public void setParentResource(Resources resources) {
        this.parentResource = resources;
    }
}

