/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.AFM;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.core.pobjects.fonts.nfont.CMap;
import org.icepdf.core.pobjects.fonts.nfont.Encoding;
import org.icepdf.core.pobjects.fonts.nfont.NFont;
import org.icepdf.core.pobjects.fonts.nfont.NFontOpenType;
import org.icepdf.core.pobjects.fonts.nfont.NFontTrueType;
import org.icepdf.core.pobjects.fonts.nfont.NFontType0;
import org.icepdf.core.pobjects.fonts.nfont.NFontType3;
import org.icepdf.core.pobjects.fonts.nfont.a;
import org.icepdf.core.pobjects.fonts.nfont.c;
import org.icepdf.core.pobjects.fonts.nfont.k;
import org.icepdf.core.pro.application.ProductInfo;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.FontUtil;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class Font
extends org.icepdf.core.pobjects.fonts.Font {
    private static final Logger logger;
    public static final Name FONT_DESCRIPTOR_KEY;
    public static final Name TO_UNICODE_KEY;
    public static final Name DESCENDANT_FONTS_KEY;
    public static final Name ENCODING_KEY;
    public static final Name BASEENCODING_KEY;
    public static final Name CID_SYSTEM_INFO_KEY;
    public static final Name CID_TO_GID_MAP_KEY;
    public static final Name DW_KEY;
    public static final Name W_KEY;
    public static final Name WIDTHS_KEY;
    public static final Name FIRST_CHAR_KEY;
    public static final Name DIFFERENCES_KEY;
    private CMap toUnicodeCMap;
    private CMap cMap;
    protected float[] widths;
    private Encoding encoding;
    private static List hintingEnabledNames;
    private static boolean isGlobalHinting;
    private static boolean allFontsHinted;

    public Font(Library library, HashMap hashMap) {
        super(library, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        block89: {
            Object object4;
            Object object5;
            Object v2;
            if (this.inited) {
                return;
            }
            bl2 = false;
            Object object6 = this.library.getObject(this.entries, FONT_DESCRIPTOR_KEY);
            if (object6 instanceof FontDescriptor) {
                this.fontDescriptor = (FontDescriptor)object6;
            } else if (object6 instanceof HashMap) {
                this.fontDescriptor = new FontDescriptor(this.library, (HashMap)object6);
            }
            if (this.fontDescriptor != null) {
                this.fontDescriptor.init();
                if (this.fontDescriptor.getEmbeddedFont() != null) {
                    this.font = this.fontDescriptor.getEmbeddedFont();
                    bl2 = true;
                    this.isFontSubstitution = false;
                }
            }
            if (this.fontDescriptor == null && this.basefont != null && (v2 = AFM.AFMs.get(this.basefont.toLowerCase())) != null && v2 instanceof AFM) {
                object5 = (AFM)v2;
                this.fontDescriptor = FontDescriptor.createDescriptor((Library)this.library, (AFM)object5);
                this.fontDescriptor.init();
            }
            int n2 = 0;
            if (this.fontDescriptor != null) {
                n2 = this.fontDescriptor.getFlags();
            }
            if ((object5 = this.library.getObject(this.entries, TO_UNICODE_KEY)) != null && object5 instanceof Stream && (object3 = (Stream)object5) != null) {
                object2 = object3.getDecodedByteArrayInputStream();
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        if (object2 instanceof SeekableInput) {
                            object = Utils.getContentFromSeekableInput((SeekableInput)((SeekableInput)object2), (boolean)false);
                        } else {
                            object4 = new InputStream[]{object2};
                            object = Utils.getContentAndReplaceInputStream((InputStream[])object4, (boolean)false);
                            object2 = object4[0];
                        }
                        logger.finest("ToUnicode CMAP = " + (String)object);
                    }
                    this.toUnicodeCMap = new CMap((InputStream)object2);
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Error reading cmap file.", throwable);
                }
                finally {
                    try {
                        if (object2 != null) {
                            ((InputStream)object2).close();
                        }
                    }
                    catch (IOException iOException) {
                        logger.log(Level.FINE, "CMap Reading/Parsing Error.", iOException);
                    }
                }
            }
            if (object5 != null && object5 instanceof Name) {
                object3 = (Name)object5;
                if (a.a.a((Name)object3)) {
                    this.toUnicodeCMap = CMap.IDENTITY;
                } else if (a.c.a((Name)object3)) {
                    this.toUnicodeCMap = CMap.IDENTITY_V;
                } else if (a.b.a((Name)object3)) {
                    this.toUnicodeCMap = CMap.IDENTITY_H;
                }
            }
            if (this.subtype.equals("Type0")) {
                if (this.entries.containsKey(DESCENDANT_FONTS_KEY) && (object3 = this.library.getObject(this.entries, DESCENDANT_FONTS_KEY)) != null && object3 instanceof List) {
                    object2 = (List)object3;
                    object = null;
                    object4 = object2.get(0);
                    if (object4 instanceof Reference) {
                        Reference reference = (Reference)object4;
                        object = (Font)((Object)this.library.getObject(reference));
                    } else if (object4 instanceof Font) {
                        object = (Font)((Object)object4);
                    }
                    if (object != null) {
                        if (this.toUnicodeCMap != null) {
                            ((Font)((Object)object)).toUnicodeCMap = this.toUnicodeCMap;
                        }
                        ((Font)((Object)object)).init();
                        this.font = ((Font)((Object)object)).font;
                        if (!((Font)((Object)object)).isFontSubstitution) {
                            bl2 = true;
                        }
                    }
                }
                if (this.entries.containsKey(ENCODING_KEY)) {
                    object3 = this.library.getObject(this.entries, ENCODING_KEY);
                    if (object3 != null && object3 instanceof Name) {
                        this.cMap = CMap.getInstance(object3.toString());
                        if (this.cMap != null && this.cMap.equals(CMap.IDENTITY_V)) {
                            this.isVerticalWriting = true;
                        }
                        if (logger.isLoggable(Level.WARNING) && this.cMap == null) {
                            logger.warning("CMAP resource error, could not find file: " + object3.toString());
                        }
                    } else if (object3 != null && object3 instanceof Stream) {
                        try {
                            object2 = ((Stream)object3).getDecodedByteArrayInputStream();
                            this.cMap = new CMap((InputStream)object2);
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            logger.log(Level.FINE, "Error parsing cmap.", throwable);
                        }
                    }
                    if (this.toUnicodeCMap == null && object3 instanceof Name) {
                        object2 = object3.toString();
                        if (((String)object2).equals("Identity-H") || ((String)object2).equals("Identity-V") || ((String)object2).equals("Identity")) {
                            this.toUnicodeCMap = this.cMap;
                        } else if (((String)object2).indexOf("UCS2") > 0) {
                            this.toUnicodeCMap = CMap.IDENTITY_H;
                        } else if (((String)object2).indexOf("UTF16") > 0) {
                            this.toUnicodeCMap = CMap.IDENTITY_UTF16BE;
                        } else {
                            object = TO_UNICODE;
                            int n3 = ((Object)object).length;
                            block17: for (int i2 = 0; i2 < n3; ++i2) {
                                Object object7;
                                for (Object object8 : object7 = object[i2]) {
                                    if (!((String)object2).equals(object8)) continue;
                                    this.toUnicodeCMap = CMap.getInstance((String)object2);
                                    continue block17;
                                }
                            }
                        }
                    }
                }
                if (this.toUnicodeCMap == null) {
                    this.toUnicodeCMap = this.cMap;
                }
                if (!bl2 && this.toUnicodeCMap != null) {
                    this.cMap = this.toUnicodeCMap != null ? this.toUnicodeCMap : (this.toUnicodeCMap = CMap.IDENTITY_H);
                }
                object3 = new FontFile[]{this.font};
                object2 = new NFontType0(this.basefont, (FontFile[])object3);
                this.font = ((NFontType0)object2).deriveFont(this.cMap, this.toUnicodeCMap);
            } else if (this.subtype.equals("Type3")) {
                this.font = new NFontType3(this.library, this.entries);
                ((NFontType3)this.font).setParentResource(this.parentResource);
            }
            if (this.font == null && (this.subtype.equals("CIDFontType0") || this.subtype.equals("CIDFontType2")) && (object3 = this.library.getObject(this.entries, CID_SYSTEM_INFO_KEY)) instanceof HashMap && (object2 = (StringObject)((HashMap)object3).get("Ordering")) != null) {
                object = object2.getLiteralString();
                FontManager fontManager = FontManager.getInstance();
                this.isFontSubstitution = true;
                this.font = ((String)object).startsWith("GB") ? fontManager.getChineseSimplifiedInstance(this.basefont, n2) : (((String)object).startsWith("Korea") ? fontManager.getKoreanInstance(this.basefont, n2) : (((String)object).startsWith("Japan") ? fontManager.getJapaneseInstance(this.basefont, n2) : (((String)object).startsWith("Identity") ? fontManager.getInstance(this.basefont, n2) : fontManager.getChineseTraditionalInstance(this.basefont, n2))));
            }
            if (this.font == null) {
                try {
                    this.font = FontManager.getInstance().getInstance(this.basefont, n2);
                    this.isFontSubstitution = true;
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Level.SEVERE)) break block89;
                    logger.log(Level.SEVERE, "Font loading failure, no font available to substitute: " + this.basefont);
                }
            }
        }
        if (this.subtype.equals("Type1") || this.subtype.equals("MMType1") || this.subtype.equals("Type3") || this.subtype.equals("TrueType")) {
            object3 = (k)this.font;
            object3 = this.setEncoding((k)object3, this.toUnicodeCMap, bl2);
            object3 = this.setWidth((k)object3, ((k)object3).getEncoding());
            this.font = object3;
        } else if ((this.subtype.equals("CIDFontType0") || this.subtype.equals("CIDFontType2")) && this.subtype.equals("CIDFontType2")) {
            object3 = this.library.getObject(this.entries, CID_TO_GID_MAP_KEY);
            Object object9 = object2 = this.toUnicodeCMap != null ? this.toUnicodeCMap : CMap.IDENTITY;
            if (object3 == null || object3 instanceof Name) {
                object = null;
                if (object3 != null) {
                    object = object3.toString();
                }
                if (this.toUnicodeCMap instanceof c) {
                    object = this.toUnicodeCMap.toString();
                }
                if (object == null || ((String)object).equals("Identity")) {
                    this.font = ((NFontTrueType)this.font).deriveFont(CMap.IDENTITY, (CMap)object2);
                }
            } else if (object3 != null && object3 instanceof Stream) {
                try {
                    object = ((Stream)object3).getDecodedByteArrayInputStream();
                    int n4 = 0;
                    int n5 = ((ByteArrayInputStream)object).available() / 2;
                    Object object10 = new char[n5];
                    for (int i3 = 0; n4 != -1 && i3 < n5; ++i3) {
                        n4 = ((ByteArrayInputStream)object).read();
                        n4 = (char)(n4 << 8 | ((ByteArrayInputStream)object).read());
                        object10[i3] = (char)n4;
                    }
                    ((ByteArrayInputStream)object).close();
                    this.font = ((NFontTrueType)this.font).deriveFont(new CMap((char[])object10).reverse(), CMap.IDENTITY);
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Error reading CIDToGIDMap Stream.", iOException);
                }
            }
            float f2 = -1.0f;
            ArrayList arrayList = null;
            if (this.library.getObject(this.entries, W_KEY) != null) {
                arrayList = (ArrayList)this.library.getObject(this.entries, W_KEY);
            }
            if (this.library.getObject(this.entries, DW_KEY) != null) {
                f2 = ((Number)this.library.getObject(this.entries, DW_KEY)).floatValue();
            }
            if (arrayList != null || f2 > -1.0f) {
                this.font = ((NFontTrueType)this.font).deriveFont(f2, arrayList);
            }
        }
        if (isGlobalHinting && this.font instanceof NFontTrueType) {
            boolean bl3 = false;
            if (allFontsHinted) {
                ((NFontTrueType)this.font).setHinting(true);
                bl3 = true;
            }
            if (!bl3 && this.font != null) {
                object2 = this.font.getName().toLowerCase();
                object2 = FontUtil.removeBaseFontSubset((String)object2);
                String string = this.font.getFamily().toLowerCase();
                for (String string2 : hintingEnabledNames) {
                    if (!((String)object2).contains(string2) && !string.contains(string2)) continue;
                    ((NFontTrueType)this.font).setHinting(true);
                    bl3 = true;
                    break;
                }
            }
            if (!bl3 && this.fontDescriptor != null) {
                object2 = this.fontDescriptor.getFontName();
                if ((object2 = FontUtil.removeBaseFontSubset((String)object2)) != null) {
                    object2 = FontUtil.guessFamily((String)object2);
                    object2 = ((String)object2).toLowerCase();
                }
                String string = this.fontDescriptor.getFontFamily().toLowerCase();
                for (String string3 : hintingEnabledNames) {
                    if (object2 == null || !((String)object2).contains(string3) && !string.contains(string3)) continue;
                    ((NFontTrueType)this.font).setHinting(true);
                    bl3 = true;
                    break;
                }
            }
            if (!bl3) {
                object2 = this.basefont;
                if ((object2 = FontUtil.removeBaseFontSubset((String)object2)) != null) {
                    object2 = ((String)object2).toLowerCase();
                }
                for (String string : hintingEnabledNames) {
                    if (object2 == null || !((String)object2).contains(string)) continue;
                    ((NFontTrueType)this.font).setHinting(true);
                    break;
                }
            }
        }
        this.inited = true;
    }

    private k setWidth(k k2, Encoding encoding) {
        int n2 = 100;
        int n3 = 100;
        int n4 = -1;
        Rectangle2D.Float float_ = null;
        List list = (List)this.library.getObject(this.entries, WIDTHS_KEY);
        if (list != null) {
            this.widths = new float[list.size()];
            int n5 = list.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                this.widths[i2] = ((Number)list.get(i2)).floatValue();
            }
        }
        if (this.widths != null) {
            Object object;
            if (this.fontDescriptor != null) {
                n2 = (int)this.fontDescriptor.getAscent();
                n3 = (int)this.fontDescriptor.getDescent();
                n4 = (int)this.fontDescriptor.getMissingWidth();
                PRectangle pRectangle = this.fontDescriptor.getFontBBox();
                if (pRectangle != null) {
                    float_ = pRectangle.getOriginalPoints();
                    ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX(), ((RectangularShape)float_).getY(), ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
                }
            }
            if ((object = this.library.getObject(this.entries, FIRST_CHAR_KEY)) != null) {
                this.firstchar = ((Number)object).intValue();
            }
        } else {
            this.firstchar = 32;
            String string = this.getCanonicalName(this.basefont);
            if (string != null) {
                this.widths = ((AFM)AFM.AFMs.get(string.toLowerCase())).getWidths();
            }
            if (this.widths != null) {
                this.isAFMFont = true;
            }
            if (!(this.widths == null || encoding != null && encoding.equals(Encoding.ADOBE_STANDARD) || encoding == null)) {
                float[] fArray = new float[256 - this.firstchar];
                int n6 = fArray.length;
                for (int i3 = 0; i3 < n6; ++i3) {
                    String string2 = encoding.getName((char)(i3 + this.firstchar));
                    int n7 = Encoding.ADOBE_STANDARD.getChar(string2) - this.firstchar;
                    if (n7 < 0 || n7 >= this.widths.length) continue;
                    fArray[i3] = this.widths[n7];
                }
                this.widths = fArray;
                n4 = ((AFM)AFM.AFMs.get(this.getCanonicalName(this.basefont).toLowerCase())).getAvgWidth();
            }
        }
        if (this.widths != null && !this.isAFMFont && !(k2 instanceof NFontOpenType)) {
            k2 = k2.deriveFont(this.widths, this.firstchar, n4, n2, n3, float_);
            return k2;
        }
        return k2;
    }

    private k setEncoding(k k2, CMap cMap, boolean bl2) {
        this.encoding = null;
        Object object = null;
        if (this.entries.containsKey(ENCODING_KEY)) {
            object = this.library.getObject(this.entries, ENCODING_KEY);
        }
        if (object == null) {
            if (this.isCore14(this.basefont)) {
                this.encoding = this.basefont.startsWith("ZapfD") ? Encoding.ZAPF_DINGBATS : (this.basefont.startsWith("Symbol") ? Encoding.SYMBOL : Encoding.ADOBE_STANDARD);
            }
        } else if (object instanceof Name) {
            this.encoding = this.basefont.equals("ZapfDingbats") ? Encoding.ZAPF_DINGBATS : (this.basefont.equals("Symbol") ? Encoding.SYMBOL : Encoding.getInstance(object.toString()));
        } else {
            HashMap hashMap = (HashMap)object;
            String string = null;
            if (hashMap.containsKey(BASEENCODING_KEY)) {
                string = hashMap.get(BASEENCODING_KEY).toString();
            }
            this.encoding = string != null ? Encoding.getInstance(string) : (bl2 ? k2.getEncoding() : (this.basefont == null ? Encoding.ADOBE_STANDARD : (this.basefont.startsWith("ZapfD") ? Encoding.ZAPF_DINGBATS : (this.basefont.startsWith("Symbol") ? Encoding.SYMBOL : Encoding.ADOBE_STANDARD))));
            Object[] objectArray = null;
            if (hashMap.containsKey(DIFFERENCES_KEY)) {
                Object object2 = hashMap.get(DIFFERENCES_KEY);
                if (object2 instanceof Reference) {
                    object2 = this.library.getObject((Reference)object2);
                }
                if (object2 instanceof List) {
                    List list = (List)object2;
                    int n2 = list.size();
                    objectArray = new Object[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Object e2 = list.get(i2);
                        if (e2 instanceof Number) {
                            objectArray[i2] = e2;
                            continue;
                        }
                        if (!(e2 instanceof Name)) continue;
                        objectArray[i2] = e2.toString();
                    }
                }
            }
            this.encoding = new Encoding(this.encoding, objectArray);
        }
        k2 = k2.deriveFont(this.encoding, cMap);
        return k2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getWidth(int n2, float f2) {
        n2 -= this.firstchar;
        if (this.widths != null) {
            if (n2 < 0 || n2 >= this.widths.length) return this.fontDescriptor.getAverageWidth() / 1000.0f;
            if (this.font.getFamily().equals("Type 3") || !(this.widths[n2] >= 0.0f)) return f2;
            return this.widths[n2] / 1000.0f;
        }
        if (this.fontDescriptor == null) return f2;
        if (this.fontDescriptor.getAverageWidth() > 0.0f) {
            return this.fontDescriptor.getAverageWidth() / 1000.0f;
        }
        if (!(this.fontDescriptor.getMissingWidth() > 0.0f)) return f2;
        return this.fontDescriptor.getMissingWidth() / 1000.0f;
    }

    public static String getLibraryVersion() {
        return ProductInfo.c + "." + ProductInfo.d + "." + ProductInfo.e + " " + ProductInfo.f;
    }

    static {
        Object object;
        String string;
        logger = Logger.getLogger(Font.class.toString());
        FONT_DESCRIPTOR_KEY = new Name("FontDescriptor");
        TO_UNICODE_KEY = new Name("ToUnicode");
        DESCENDANT_FONTS_KEY = new Name("DescendantFonts");
        ENCODING_KEY = new Name("Encoding");
        BASEENCODING_KEY = new Name("BaseEncoding");
        CID_SYSTEM_INFO_KEY = new Name("CIDSystemInfo");
        CID_TO_GID_MAP_KEY = new Name("CIDToGIDMap");
        DW_KEY = new Name("DW");
        W_KEY = new Name("W");
        WIDTHS_KEY = new Name("Widths");
        FIRST_CHAR_KEY = new Name("FirstChar");
        DIFFERENCES_KEY = new Name("Differences");
        NFont.setUseBitmaps(false);
        isGlobalHinting = Defs.sysPropertyBoolean((String)"org.icepdf.core.nfont.truetype.hinting", (boolean)false);
        String string2 = Defs.property((String)"org.icepdf.core.nfont.truetype.eraseHintingDefaults", (String)"false");
        hintingEnabledNames = new ArrayList();
        if (!Boolean.valueOf(string2).booleanValue()) {
            hintingEnabledNames.add("mingli");
            hintingEnabledNames.add("kai");
            hintingEnabledNames.add("tcid");
        }
        if ((string = Defs.property((String)"org.icepdf.core.nfont.truetype.hintingNames")) != null) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                hintingEnabledNames.add(string3.toLowerCase().trim());
            }
        }
        object = Defs.property((String)"org.icepdf.core.nfont.truetype.hinting.alwayson", (String)"false");
        allFontsHinted = Boolean.valueOf((String)object);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("ICEsoft ICEpdf Pro " + Font.getLibraryVersion());
        }
    }
}

