/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.viewer;

import java.awt.Frame;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.WindowManagementCallback;
import org.icepdf.ri.util.PropertiesManager;

public class WindowManager
implements WindowManagementCallback {
    private PropertiesManager properties;
    private ArrayList<SwingController> controllers;
    private long newWindowInvokationCounter = 0L;
    private ResourceBundle messageBundle = null;

    public WindowManager(PropertiesManager properties) {
        this(properties, null);
    }

    public WindowManager(PropertiesManager properties, ResourceBundle messageBundle) {
        this.properties = properties;
        this.controllers = new ArrayList();
        this.messageBundle = messageBundle != null ? messageBundle : ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle");
        if (Defs.booleanProperty("org.icepdf.core.verbose", true)) {
            System.out.println("\nICEsoft ICEpdf Viewer " + Document.getLibraryVersion());
            System.out.println("Copyright ICEsoft Technologies, Inc.\n");
        }
    }

    @Override
    public PropertiesManager getProperties() {
        return this.properties;
    }

    public long getNumberOfWindows() {
        return this.newWindowInvokationCounter;
    }

    @Override
    public void newWindow(String location) {
        SwingController controller = this.commonWindowCreation();
        controller.openDocument(location);
    }

    @Override
    public void newWindow(URL location) {
        SwingController controller = this.commonWindowCreation();
        controller.openDocument(location);
    }

    protected SwingController commonWindowCreation() {
        SwingController controller = new SwingController(this.messageBundle);
        controller.setWindowManagementCallback(this);
        controller.setPropertiesManager(this.properties);
        controller.getDocumentViewController().setAnnotationCallback(new MyAnnotationCallback(controller.getDocumentViewController()));
        this.controllers.add(controller);
        int viewType = 1;
        int pageFit = 4;
        try {
            viewType = this.getProperties().getInt("document.viewtype", 1);
            pageFit = this.getProperties().getInt("document.pagefitMode", 4);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        SwingViewBuilder factory = new SwingViewBuilder(controller, viewType, pageFit);
        JFrame frame = factory.buildViewerFrame();
        if (frame != null) {
            int width = this.getProperties().getInt("application.width", 800);
            int height = this.getProperties().getInt("application.height", 600);
            frame.setSize(width, height);
            int x = this.getProperties().getInt("application.x", 1);
            int y = this.getProperties().getInt("application.y", 1);
            frame.setLocation((int)((long)x + this.newWindowInvokationCounter * 10L), (int)((long)y + this.newWindowInvokationCounter * 10L));
            ++this.newWindowInvokationCounter;
            frame.setVisible(true);
        }
        return controller;
    }

    @Override
    public void disposeWindow(SwingController controller, JFrame viewer, Properties properties) {
        if (this.controllers.size() <= 1) {
            this.quit(controller, viewer, properties);
            return;
        }
        int index = this.controllers.indexOf(controller);
        if (index >= 0) {
            this.controllers.remove(index);
            --this.newWindowInvokationCounter;
            if (viewer != null) {
                viewer.setVisible(false);
                viewer.dispose();
            }
        }
    }

    @Override
    public void quit(SwingController controller, JFrame viewer, Properties properties) {
        if (controller != null && viewer != null) {
            Rectangle sz = viewer.getBounds();
            this.getProperties().setInt("application.x", sz.x);
            this.getProperties().setInt("application.y", sz.y);
            this.getProperties().setInt("application.height", sz.height);
            this.getProperties().setInt("application.width", sz.width);
            if (properties != null) {
                this.getProperties().set("document.pagefitMode", properties.getProperty("document.pagefitMode"));
                this.getProperties().set("document.viewtype", properties.getProperty("document.viewtype"));
            }
            this.getProperties().setDefaultFilePath(ViewModel.getDefaultFilePath());
            this.getProperties().setDefaultURL(ViewModel.getDefaultURL());
        }
        this.getProperties().saveAndEnd();
        for (int i = 0; i < this.controllers.size(); ++i) {
            SwingController c = this.controllers.get(i);
            if (c == null) continue;
            c.dispose();
        }
        System.exit(0);
    }

    @Override
    public void minimiseAllWindows() {
        for (int i = 0; i < this.controllers.size(); ++i) {
            SwingController controller = this.controllers.get(i);
            JFrame frame = controller.getViewerFrame();
            if (frame == null) continue;
            frame.setState(1);
        }
    }

    @Override
    public void bringAllWindowsToFront(SwingController frontMost) {
        Frame frontMostFrame = null;
        for (int i = 0; i < this.controllers.size(); ++i) {
            SwingController controller = this.controllers.get(i);
            JFrame frame = controller.getViewerFrame();
            if (frame == null) continue;
            if (frontMost == controller) {
                frontMostFrame = frame;
                continue;
            }
            frame.setState(0);
            frame.toFront();
        }
        if (frontMostFrame != null) {
            frontMostFrame.setState(0);
            frontMostFrame.toFront();
        }
    }

    @Override
    public void bringWindowToFront(int index) {
        SwingController controller;
        JFrame frame;
        if (index >= 0 && index < this.controllers.size() && (frame = (controller = this.controllers.get(index)).getViewerFrame()) != null) {
            frame.setState(0);
            frame.toFront();
        }
    }

    @Override
    public List getWindowDocumentOriginList(SwingController giveIndex) {
        Integer foundIndex = null;
        int count = this.controllers.size();
        ArrayList<Object> list = new ArrayList<Object>(count + 1);
        for (int i = 0; i < count; ++i) {
            Document document;
            String toAdd = null;
            SwingController controller = this.controllers.get(i);
            if (giveIndex == controller) {
                foundIndex = new Integer(i);
            }
            if ((document = controller.getDocument()) != null) {
                toAdd = document.getDocumentOrigin();
            }
            list.add(toAdd);
        }
        if (foundIndex != null) {
            list.add(foundIndex);
        }
        return list;
    }

    void updateUI() {
        for (int i = 0; i < this.controllers.size(); ++i) {
            SwingController controller = this.controllers.get(i);
            JFrame frame = controller.getViewerFrame();
            if (frame == null) continue;
            SwingUtilities.updateComponentTreeUI(frame);
        }
    }
}

